/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.papertemplate.filterchain.filter;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.fi.bcm.business.innertrade.report.IntrTemplateHelper;
import kd.fi.bcm.business.papertemplate.filterchain.AbstractPaperFilter;
import kd.fi.bcm.business.papertemplate.filterchain.PaperFilterParam;

public class VersionFilter
extends AbstractPaperFilter {
    private Long yearId;
    private Long periodId;
    private boolean isFilter = false;

    public VersionFilter(Long yearId, Long periodId) {
        this.yearId = yearId;
        this.periodId = periodId;
    }

    public VersionFilter(Long yearId, Long periodId, boolean isFilter) {
        this.yearId = yearId;
        this.periodId = periodId;
        this.isFilter = isFilter;
    }

    @Override
    public Set<Long> doFilter(Set<Long> tmplIds) {
        PaperFilterParam commonParam = this.getCommonParam();
        Map<Long, Long> soure2version = IntrTemplateHelper.getRightTplIdByVersioned(commonParam.getModelId(), this.getYearId(), this.getPeriodId(), tmplIds);
        Collection<Long> versionIds = soure2version.values();
        if (!this.isFilter) {
            return new HashSet<Long>(versionIds);
        }
        tmplIds.removeIf(e -> !versionIds.contains(e));
        return tmplIds;
    }

    public Long getYearId() {
        return this.yearId;
    }

    public Long getPeriodId() {
        return this.periodId;
    }
}

