/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.period;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.period.PeriodConstant;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class PeriodSettingHelper {
    private static final String COL_MODEL = "model";
    private static final String COL_SCENE = "scenario";
    private static final String COL_YEAR = "year";
    private static final String COL_PERIOD = "period";

    public static DynamicObjectCollection getOrgChildren(boolean isAll, Long modelId, long pid, String longnumber, boolean inInclude) {
        QFilter qcs = new QFilter(COL_MODEL, "=", (Object)ConvertUtil.convertObjToLong(modelId));
        if (isAll) {
            QFilter qf = new QFilter("longnumber", "like", (Object)(longnumber + "!%"));
            if (inInclude) {
                qf.or("longnumber", "=", (Object)longnumber);
            }
            qcs.and(qf);
        } else {
            qcs.and("parent.id", "=", (Object)pid);
        }
        qcs.and("cslscheme.isenable", "=", (Object)"1");
        long orgDimId = DimensionServiceHelper.getIdByNum("bcm_dimension", modelId, DimEntityNumEnum.ENTITY.getNumber());
        qcs.and(PermissionServiceImpl.getInstance(modelId).getReadOrWritePermFilter(orgDimId, "bcm_entitymembertree", "id"));
        return QueryServiceHelper.query((String)"bcm_entitymembertree", (String)PeriodConstant.getOrgSelectStr(), (QFilter[])qcs.toArray(), (String)"dseq");
    }

    public static DynamicObjectCollection getHasPermOrgListByIds(Long modelId, Set<Long> orgIds) {
        QFilter qf = new QFilter(COL_MODEL, "=", (Object)modelId);
        qf.and("id", "in", orgIds);
        qf.and("cslscheme.isenable", "=", (Object)"1");
        Set<Long> noPermMembers = PermissionServiceImpl.getInstance(modelId).matchNoPermMembers(MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity"), "bcm_entitymembertree", orgIds);
        Set orgSet = orgIds.stream().filter(r -> !noPermMembers.contains(r)).collect(Collectors.toSet());
        if (orgSet.size() > 0) {
            return QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,id as memberid,name,number,longnumber,isleaf,level,currency,currency.number as currencynumber,currency.name currencyname,parent,parent.number,dseq,copyfrom,share,storagetype,isexchangerate", (QFilter[])qf.toArray(), (String)"dseq");
        }
        return new DynamicObjectCollection();
    }

    public static boolean checkPeriodStatus(long modelId, String orgNumber, long scenarioId, long yearId, long periodId, String statusField) {
        if (!ConfigServiceHelper.getBoolParam(modelId, "CM012")) {
            return true;
        }
        String key = String.format("%s_%s_%s_%s_%s_%s", modelId, orgNumber, scenarioId, yearId, periodId, statusField);
        return (Boolean)ThreadCache.get((Object)key, () -> {
            QFBuilder qf = new QFBuilder(COL_MODEL, "=", (Object)modelId);
            qf.add("orgnumber", "=", (Object)orgNumber);
            qf.add(COL_SCENE, "=", (Object)scenarioId);
            qf.add(COL_YEAR, "=", (Object)yearId);
            qf.add(COL_PERIOD, "=", (Object)periodId);
            DynamicObject periodSettingDy = QueryServiceHelper.queryOne((String)"bcm_periodmanageentity", (String)statusField, (QFilter[])qf.toArray());
            if (periodSettingDy != null) {
                return "A".equals(periodSettingDy.getString(statusField));
            }
            return ConfigServiceHelper.getCM012InitPeriodStatus(modelId);
        });
    }

    private static List<String> descartes(String split, List<String> ... lists) {
        List<String> tempList = new ArrayList<String>(16);
        for (List<String> list : lists) {
            tempList = tempList.isEmpty() ? list : tempList.stream().flatMap(item -> list.stream().map(item2 -> item + split + item2)).collect(Collectors.toList());
        }
        return tempList;
    }

    public static Map<String, Boolean> batchCheckPeriodStatus(long model, Set<String> orgNumbers, Set<Long> sceneIds, Set<Long> yearIds, Set<Long> periodIds, String statusField) {
        QFBuilder qf = new QFBuilder();
        qf.add(COL_MODEL, "=", (Object)model);
        qf.add("orgnumber", "in", orgNumbers);
        qf.add(COL_SCENE, "in", sceneIds);
        qf.add(COL_YEAR, "in", yearIds);
        qf.add(COL_PERIOD, "in", periodIds);
        HashMap statusMap = new HashMap(16);
        QueryServiceHelper.query((String)"bcm_periodmanageentity", (String)("orgnumber, scenario, year, period," + statusField), (QFilter[])qf.toArray()).forEach(d -> statusMap.put(String.format("%s_%s_%s_%s", d.getString("orgnumber"), d.getLong(COL_SCENE), d.getLong(COL_YEAR), d.getLong(COL_PERIOD)), d.getString(statusField)));
        HashMap<String, Boolean> allResult = new HashMap<String, Boolean>(16);
        for (Map.Entry entry : statusMap.entrySet()) {
            allResult.put((String)entry.getKey(), "A".equals(entry.getValue()));
        }
        List sceneIdStrList = sceneIds.stream().map(String::valueOf).collect(Collectors.toList());
        List yearIdStrList = yearIds.stream().map(String::valueOf).collect(Collectors.toList());
        List periodIdStrList = periodIds.stream().map(String::valueOf).collect(Collectors.toList());
        List<String> allGroup = PeriodSettingHelper.descartes("_", new ArrayList<String>(orgNumbers), sceneIdStrList, yearIdStrList, periodIdStrList);
        boolean defaultInitPeriod = ConfigServiceHelper.getCM012InitPeriodStatus(model);
        for (String key : allGroup) {
            if (allResult.containsKey(key)) continue;
            allResult.put(key, defaultInitPeriod);
        }
        return allResult;
    }

    public static Map<String, Boolean> batchCheckPeriodStatusOnVersion(long modelId, Set<Long> orgIds, Set<Long> sceneIds, Set<Long> yearIds, Set<Long> periodIds, String statusField) {
        DynamicObjectCollection orgList = OrgServiceHelper.getOrgList(modelId, new ArrayList<Long>(orgIds));
        Set orgNumbers = orgList.stream().map(r -> r.getString("number")).collect(Collectors.toSet());
        QFBuilder qf = new QFBuilder();
        qf.add(COL_MODEL, "=", (Object)modelId);
        qf.add("orgnumber", "in", orgNumbers);
        qf.add(COL_SCENE, "in", sceneIds);
        qf.add(COL_YEAR, "in", yearIds);
        qf.add(COL_PERIOD, "in", periodIds);
        HashMap statusMap = new HashMap(16);
        QueryServiceHelper.query((String)"bcm_periodmanageentity", (String)("orgnumber, scenario, year, period," + statusField), (QFilter[])qf.toArray()).forEach(d -> statusMap.put(String.format("%s_%s_%s_%s", d.getString("orgnumber"), d.getLong(COL_SCENE), d.getLong(COL_YEAR), d.getLong(COL_PERIOD)), d.getString(statusField)));
        HashMap allResult = new HashMap(16);
        for (Map.Entry entry : statusMap.entrySet()) {
            allResult.put(entry.getKey(), "A".equals(entry.getValue()));
        }
        HashMap<String, Boolean> versionResult = new HashMap<String, Boolean>(allResult.size());
        boolean defaultInitPeriod = ConfigServiceHelper.getCM012InitPeriodStatus(modelId);
        for (Long sceneId : sceneIds) {
            for (Long yearId : yearIds) {
                IDNumberTreeNode yearNode = MemberReader.findFyMemberById((Long)modelId, (Long)yearId);
                if (yearNode.getId() <= 0L) continue;
                for (Long periodId : periodIds) {
                    FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam(modelId, (long)sceneId, yearNode.getNumber(), (long)periodId);
                    DynamicObjectCollection orgTempList = PeriodSettingHelper.batchCopyOrgDynamicObjectCollection(orgList);
                    EntityVersioningUtil.filterOrgsByMergeStruct(filterOrgStructParam, (List<DynamicObject>)orgTempList);
                    for (DynamicObject orgDy : orgTempList) {
                        String key = String.format("%s_%s_%s_%s", orgDy.getString("number"), sceneId, yearId, periodId);
                        Boolean status = (Boolean)allResult.get(key);
                        if (status == null) {
                            status = defaultInitPeriod;
                        }
                        versionResult.put(key, status);
                    }
                }
            }
        }
        return versionResult;
    }

    private static DynamicObjectCollection batchCopyOrgDynamicObjectCollection(DynamicObjectCollection orgList) {
        DynamicObjectCollection orgCopyList = new DynamicObjectCollection();
        for (DynamicObject org : orgList) {
            orgCopyList.add((Object)((DynamicObject)OrmUtils.clone((Object)org, (IDataEntityType)org.getDataEntityType(), (boolean)false, (boolean)false)));
        }
        return orgCopyList;
    }

    private static Map<String, Boolean> batchQueryOrgPeriodStatusOnlyOpen(long modelId, Set<String> orgNumbers, Long sceneId, Long yearId, Long periodId, String statusField) {
        QFBuilder qf = new QFBuilder();
        qf.add(COL_MODEL, "=", (Object)modelId);
        qf.add("orgnumber", "in", orgNumbers);
        qf.add(COL_SCENE, "=", (Object)sceneId);
        qf.add(COL_YEAR, "=", (Object)yearId);
        qf.add(COL_PERIOD, "=", (Object)periodId);
        HashMap statusMap = new HashMap(16);
        QueryServiceHelper.query((String)"bcm_periodmanageentity", (String)("orgnumber," + statusField), (QFilter[])qf.toArray()).forEach(d -> statusMap.put(d.getString("orgnumber"), d.getString(statusField)));
        HashMap allResult = new HashMap(16);
        for (Map.Entry entry : statusMap.entrySet()) {
            allResult.put(entry.getKey(), "A".equals(entry.getValue()));
        }
        boolean defaultInitPeriod = ConfigServiceHelper.getCM012InitPeriodStatus(modelId);
        for (String orgNumber : orgNumbers) {
            if (allResult.containsKey(orgNumber)) continue;
            allResult.put(orgNumber, defaultInitPeriod);
        }
        return allResult.entrySet().stream().filter(Map.Entry::getValue).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map<String, Boolean> batchQueryOrgPeriodStatusOnlyClose(long modelId, Set<String> orgNumbers, Long sceneId, Long yearId, Long periodId, String statusField) {
        QFBuilder qf = new QFBuilder();
        qf.add(COL_MODEL, "=", (Object)modelId);
        qf.add("orgnumber", "in", orgNumbers);
        qf.add(COL_SCENE, "=", (Object)sceneId);
        qf.add(COL_YEAR, "=", (Object)yearId);
        qf.add(COL_PERIOD, "=", (Object)periodId);
        HashMap statusMap = new HashMap(16);
        QueryServiceHelper.query((String)"bcm_periodmanageentity", (String)("orgnumber," + statusField), (QFilter[])qf.toArray()).forEach(d -> statusMap.put(d.getString("orgnumber"), d.getString(statusField)));
        HashMap<String, Boolean> allResult = new HashMap<String, Boolean>(16);
        for (Map.Entry entry : statusMap.entrySet()) {
            if (!"B".equals(entry.getValue())) continue;
            allResult.put((String)entry.getKey(), true);
        }
        return allResult;
    }

    public static Set<String> batchSelectPeriodStatusOpen(Long model, Set<String> orgNumbers, Long scenario, Long year, Long period, String statusField) {
        Map<String, Boolean> openStatusMap = PeriodSettingHelper.batchQueryOrgPeriodStatusOnlyOpen(model, orgNumbers, scenario, year, period, statusField);
        return openStatusMap.keySet();
    }

    public static Pair<Boolean, Boolean> batchSelectPeriodStatusOpenbyUntreated(long modelId, String orgNumber, long scenarioId, long yearId, long periodId) {
        QFBuilder qf = new QFBuilder();
        qf.add(COL_MODEL, "=", (Object)modelId);
        qf.add("orgnumber", "=", (Object)orgNumber);
        qf.add(COL_SCENE, "=", (Object)scenarioId);
        qf.add(COL_YEAR, "=", (Object)yearId);
        qf.add(COL_PERIOD, "=", (Object)periodId);
        DynamicObject periodSettingDy = QueryServiceHelper.queryOne((String)"bcm_periodmanageentity", (String)"datastatus,entrystatus", (QFilter[])qf.toArray());
        if (periodSettingDy != null) {
            return Pair.onePair((Object)"A".equals(periodSettingDy.getString("datastatus")), (Object)"A".equals(periodSettingDy.getString("entrystatus")));
        }
        boolean defaultInitPeriod = ConfigServiceHelper.getCM012InitPeriodStatus(modelId);
        return Pair.onePair((Object)defaultInitPeriod, (Object)defaultInitPeriod);
    }

    public static String genKey(String orgNumber, long sceneId, long yearId, long periodId) {
        return String.format("%s_%s_%s_%s", orgNumber, sceneId, yearId, periodId);
    }

    public static void intelDispatchPeriodManage(long modelId, Set<String> orgNumbers, long scenarioId, long yearId, long periodId, String optype) {
        QFBuilder qf = new QFBuilder();
        qf.add(COL_SCENE, "=", (Object)scenarioId);
        qf.add(COL_YEAR, "=", (Object)yearId);
        qf.add(COL_PERIOD, "=", (Object)periodId);
        qf.add(COL_MODEL, "=", (Object)modelId);
        DynamicObject[] docs = BusinessDataServiceHelper.load((String)"bcm_periodmanageentity", (String)"id,datastatus,entrystatus,executeaction,operator,optime,org.id,org.number,orgnumber", (QFilter[])qf.toArray());
        HashMap<String, DynamicObject> mcMap = new HashMap<String, DynamicObject>(docs.length);
        for (DynamicObject dmc : docs) {
            mcMap.put(dmc.getString("orgnumber"), dmc);
        }
        Date time = TimeServiceHelper.now();
        ArrayList<DynamicObject> dynamicUpdateList = new ArrayList<DynamicObject>(orgNumbers.size());
        ArrayList<DynamicObject> dynamicSaveList = new ArrayList<DynamicObject>(orgNumbers.size());
        for (String orgNumber : orgNumbers) {
            DynamicObject dyo;
            if (!mcMap.containsKey(orgNumber)) {
                dyo = BusinessDataServiceHelper.newDynamicObject((String)"bcm_periodmanageentity");
                dyo.set(COL_MODEL, (Object)modelId);
                dyo.set(COL_SCENE, (Object)scenarioId);
                dyo.set(COL_YEAR, (Object)yearId);
                dyo.set(COL_PERIOD, (Object)periodId);
                dyo.set("orgnumber", (Object)orgNumber);
            } else {
                dyo = (DynamicObject)mcMap.get(orgNumber);
            }
            String status = "";
            status = "1".equals(optype) ? "A" : "B";
            dyo.set("datastatus", (Object)status);
            dyo.set("entrystatus", (Object)status);
            dyo.set("executeaction", (Object)status);
            dyo.set("optime", (Object)time);
            dyo.set("operator", (Object)RequestContext.get().getCurrUserId());
            if (mcMap.containsKey(orgNumber)) {
                dynamicUpdateList.add(dyo);
                continue;
            }
            dynamicSaveList.add(dyo);
        }
        if (!dynamicSaveList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])dynamicSaveList.toArray(new DynamicObject[0]));
        }
        if (!dynamicUpdateList.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])dynamicUpdateList.toArray(new DynamicObject[0]));
        }
    }

    public static Map<String, Boolean> batchCheckPeriodStatus2(long model, Set<String> orgNumbers, Set<Long> sceneIds, Set<Long> yearIds, Set<Long> periodIds, String statusField) {
        QFBuilder qf = new QFBuilder();
        qf.add(COL_MODEL, "=", (Object)model);
        qf.add("orgnumber", "in", orgNumbers);
        qf.add(COL_SCENE, "in", sceneIds);
        qf.add(COL_YEAR, "in", yearIds);
        qf.add(COL_PERIOD, "in", periodIds);
        HashMap statusMap = new HashMap(16);
        QueryServiceHelper.query((String)"bcm_periodmanageentity", (String)("orgnumber, scenario, year, period," + statusField), (QFilter[])qf.toArray()).forEach(d -> statusMap.put(String.format("%s;%s;%s;%s", d.getString("orgnumber"), d.getLong(COL_SCENE), d.getLong(COL_YEAR), d.getLong(COL_PERIOD)), d.getString(statusField)));
        HashMap<String, Boolean> allResult = new HashMap<String, Boolean>(16);
        for (Map.Entry entry : statusMap.entrySet()) {
            allResult.put((String)entry.getKey(), "A".equals(entry.getValue()));
        }
        List sceneIdStrList = sceneIds.stream().map(String::valueOf).collect(Collectors.toList());
        List yearIdStrList = yearIds.stream().map(String::valueOf).collect(Collectors.toList());
        List periodIdStrList = periodIds.stream().map(String::valueOf).collect(Collectors.toList());
        List<String> allGroup = PeriodSettingHelper.descartes(";", new ArrayList<String>(orgNumbers), sceneIdStrList, yearIdStrList, periodIdStrList);
        boolean defaultInitPeriod = ConfigServiceHelper.getCM012InitPeriodStatus(model);
        for (String key : allGroup) {
            if (allResult.containsKey(key)) continue;
            allResult.put(key, defaultInitPeriod);
        }
        return allResult;
    }

    public static Set<String> batchCheckPeriodStatusForHBL(long modelId, Set<String> orgNumbers, Set<Long> sceneIds, Set<Long> yearIds, Set<Long> periodIds) {
        QFBuilder qf = new QFBuilder();
        qf.add(COL_MODEL, "=", (Object)modelId);
        qf.add("orgnumber", "in", orgNumbers);
        qf.add(COL_SCENE, "in", sceneIds);
        qf.add(COL_YEAR, "in", yearIds);
        qf.add(COL_PERIOD, "in", periodIds);
        HashMap statusMap = new HashMap(16);
        QueryServiceHelper.query((String)"bcm_periodmanageentity", (String)"orgnumber, scenario.number, year.number, period.number,datastatus", (QFilter[])qf.toArray()).forEach(d -> statusMap.put(String.format("%s,%s,%s,%s", d.getString("orgnumber"), d.getString("scenario.number"), d.getString("year.number"), d.getString("period.number")), d.getString("datastatus")));
        HashMap allResult = new HashMap(16);
        for (Map.Entry entry : statusMap.entrySet()) {
            allResult.put(entry.getKey(), "A".equals(entry.getValue()));
        }
        QFilter sceneFilter = new QFilter("id", "in", sceneIds);
        List sceneNumberList = Arrays.stream(BusinessDataServiceHelper.load((String)"bcm_scenemembertree", (String)"id,number,name", (QFilter[])sceneFilter.toArray())).map(r -> r.getString("number")).collect(Collectors.toList());
        QFilter yearFilter = new QFilter("id", "in", yearIds);
        List yearNumberList = Arrays.stream(BusinessDataServiceHelper.load((String)"bcm_fymembertree", (String)"id,number,name", (QFilter[])yearFilter.toArray())).map(r -> r.getString("number")).collect(Collectors.toList());
        QFilter periodFilter = new QFilter("id", "in", periodIds);
        List periodNumberList = Arrays.stream(BusinessDataServiceHelper.load((String)"bcm_periodmembertree", (String)"id,number,name", (QFilter[])periodFilter.toArray())).map(r -> r.getString("number")).collect(Collectors.toList());
        List<String> allGroup = PeriodSettingHelper.descartes(",", new ArrayList<String>(orgNumbers), sceneNumberList, yearNumberList, periodNumberList);
        boolean defaultInitPeriod = ConfigServiceHelper.getCM012InitPeriodStatus(modelId);
        for (String key : allGroup) {
            if (allResult.containsKey(key)) continue;
            allResult.put(key, defaultInitPeriod);
        }
        return allResult.entrySet().stream().filter(Map.Entry::getValue).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).keySet();
    }
}

