/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.permission;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.helper.ModelServiceHelper;
import kd.fi.bcm.business.permission.cache.BcmPermSingleModel;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.BcmDMLServiceHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.ModelStatusEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections.CollectionUtils;

public class BcmFunPermissionHelper {
    private static final String RPT_ADT_VSB_CTR = "34EB6C1I3ULI";
    private static final String DIM_DM_MODEL = "DIM_DM_MODEL";
    private static final String FIDM_MODEL = "fidm_model";
    private static final String DIM_TYPE = "dimtype";
    private static final String ID = "id";
    private static final String STATUS = "status";
    private static final String REPORT_TYPE = "ReportType";
    public static final Map<ApplicationTypeEnum, String> APP2ADMINROLEID = ImmutableMap.of((Object)ApplicationTypeEnum.CM, (Object)"3=NR/T2I93RU", (Object)ApplicationTypeEnum.RPT, (Object)"3ACVTHN6T4DQ", (Object)ApplicationTypeEnum.FAR, (Object)"3ACVQ9=T0JR3", (Object)ApplicationTypeEnum.FIDM, (Object)"3ACV=1/D72Q7", (Object)ApplicationTypeEnum.DI, (Object)"3=NR/T2I93RU");
    public static boolean ISNEWPLATFORM = false;
    public static String USERFIELD = "user.id";
    private static final String USERLD = "user.id";
    private static ThreadLocal<Map<String, Set<Long>>> modelRoleLocal;

    public static boolean addPermByModel(String modelId, Map<String, List<String>> entityPermItemMap, String userId) {
        DynamicObjectCollection old = QueryServiceHelper.query((String)"perm_userperm", (String)ID, (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)Long.valueOf(modelId)), new QFilter("user", "=", (Object)Long.valueOf(userId))});
        DynamicObject userPermObj = null;
        if (old != null && old.size() > 0) {
            String id = ((DynamicObject)old.get(0)).getString(ID);
            userPermObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"perm_userperm");
        } else {
            userPermObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_userperm");
            userPermObj.set("org", (Object)modelId);
            userPermObj.set("user", (Object)userId);
        }
        DynamicObjectCollection userPermEntry = userPermObj.getDynamicObjectCollection("entryentity");
        for (Map.Entry<String, List<String>> entry : entityPermItemMap.entrySet()) {
            ArrayList pitems = new ArrayList(entry.getValue());
            for (int i = 0; i < userPermEntry.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)userPermEntry.get(i);
                if (!entry.getKey().equals(dynamicObject.getString("entitytype.id")) || !pitems.contains(dynamicObject.getString("permitem.id"))) continue;
                pitems.remove(pitems.indexOf(dynamicObject.getString("permitem.id")));
                if (pitems.size() == 0) break;
            }
            for (String permitemId : pitems) {
                DynamicObject newRow = new DynamicObject(userPermEntry.getDynamicObjectType());
                newRow.set("entitytype", (Object)entry.getKey());
                newRow.set("permitem", (Object)permitemId);
                newRow.set("controlmode", (Object)"10");
                userPermEntry.add((Object)newRow);
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userPermObj});
        return true;
    }

    public static void addRootPermByUser(String modelId, String userId) {
        ApplicationTypeEnum app = ModelServiceHelper.getModelApp(Long.parseLong(modelId));
        BcmFunPermissionHelper.addAllRootPermByUser(modelId, userId, app);
    }

    public static void addAllRootPermByUser(String modelId, String userId, ApplicationTypeEnum app) {
        BcmFunPermissionHelper.addAllRootPermByUser(modelId, userId, app, "DIM_BCM_MODEL");
    }

    public static void addAllRootPermByUser(String modelId, String userId, ApplicationTypeEnum app, String permType) {
        ImmutableMap assignInfo = ImmutableMap.of((Object)ConvertUtil.convertStrToLong(userId), (Object)Lists.newArrayList((Object[])new Long[]{ConvertUtil.convertStrToLong(modelId)}));
        BcmFunPermissionHelper.adminRoleAssignUserOrg((Map<Long, List<Long>>)assignInfo, app, permType, Boolean.TRUE);
    }

    public static void addAllRootPermByUser(Long modelId, Long userId, ApplicationTypeEnum app, String permType) {
        ImmutableMap assignInfo = ImmutableMap.of((Object)userId, (Object)Lists.newArrayList((Object[])new Long[]{modelId}));
        BcmFunPermissionHelper.adminRoleAssignUserOrg((Map<Long, List<Long>>)assignInfo, app, permType, Boolean.TRUE);
    }

    public static void adminRoleAssignUserOrg(Map<Long, List<Long>> assignInfo, ApplicationTypeEnum app, String permType, boolean ifAdd) {
        PermissionServiceHelper.roleAssignUserOrg((String)APP2ADMINROLEID.get(app), (String)permType, assignInfo, null, (boolean)ifAdd);
        if (ApplicationTypeEnum.CM == app) {
            BcmFunPermissionHelper.adminRoleAssignUserOrg(assignInfo, ApplicationTypeEnum.RPT, permType, Boolean.TRUE);
        }
    }

    public static void addQueryRootPermByUser(String modelId, ApplicationTypeEnum app) {
        Map<String, List<String>> map;
        Set userIds = PermissionServiceHelper.getAppUser((String)AppMetadataCache.getAppInfo((String)"rpt").getId());
        if (userIds == null || userIds.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u7528\u6237\u5b58\u5728\u4e2a\u522b\u62a5\u8868\u6743\u9650\uff0c\u65b0\u589e\u516c\u6709\u4f53\u7cfb\u5931\u8d25\u3002", (String)"BcmFunPermissionHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        Map<String, List<String>> permQueryMap = map = BcmPermSingleModel.getInstance().getPermbyentity();
        String[] entities = new String[permQueryMap.size()];
        map.keySet().toArray(entities);
        HashMap appEntityPermItemMap = Maps.newHashMapWithExpectedSize((int)8);
        appEntityPermItemMap.put(AppMetadataCache.getAppInfo((String)app.getAppnum()).getId(), permQueryMap);
        for (Long userId : userIds) {
            PermissionServiceHelper.userDirectAssignPerm((Long)userId, (String)"DIM_BCM_MODEL", (Long)Long.valueOf(modelId), (Map)appEntityPermItemMap, (boolean)true);
        }
    }

    @Deprecated
    public static boolean isHasPermByUserPageModel(Object modelId, String memberModel) {
        QFilter filter1 = new QFilter(USERLD, "=", (Object)LongUtil.toLong((Object)RequestContext.get().getUserId()));
        QFilter filter2 = new QFilter("org.id", "=", modelId);
        QFilter filter3 = new QFilter("entryentity.entitytype", "=", (Object)memberModel);
        return QueryServiceHelper.exists((String)"perm_userperm", (QFilter[])new QFilter[]{filter1, filter2, filter3});
    }

    public static boolean isHasModelFuncPermToPage(long modelId, String formId) {
        String appid = AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.CM.getAppnum()).getId();
        HasPermDimObjResult hasPermDimObjs = PermissionServiceHelper.getHasPermDimObjs((long)LongUtil.toLong((Object)RequestContext.get().getUserId()), (String)appid, (String)formId, (String)"47150e89000000ac");
        if (hasPermDimObjs.hasAllDimObjPerm()) {
            return true;
        }
        return !CollectionUtils.isEmpty((Collection)hasPermDimObjs.getHasPermDimObjs()) && hasPermDimObjs.getHasPermDimObjs().contains(modelId);
    }

    public static int delPermBymodelId(Long modelId) {
        QFilter qcf = new QFilter("org", "=", (Object)modelId);
        QFilter[] qFilters = new QFilter[]{qcf};
        return DeleteServiceHelper.delete((String)"perm_userperm", (QFilter[])qFilters);
    }

    public static void dmDeletePermByModelId(Long modelId, String apptype) {
        List allColuns = DB.getColumnNames((DBRoute)DBRoute.basedata, (String)"t_perm_userpermdetail");
        String appid = "2IFNVZ0SS0W4";
        if (ApplicationTypeEnum.FAR.getAppnum().equals(apptype)) {
            appid = "2K++OWYYMS5J";
        }
        if (allColuns.contains("fdimid") || allColuns.contains("FDIMID")) {
            String deleteSQL = "delete from t_perm_userpermdetail where fdimid =" + modelId + " and fbizappid = '" + appid + "'";
            DB.execute((DBRoute)DBRoute.basedata, (String)deleteSQL);
        } else {
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add(new QFilter("org", "=", (Object)modelId));
            qfBuilder.add(new QFilter(DIM_TYPE, "=", (Object)DIM_DM_MODEL).or(new QFilter(DIM_TYPE, "=", (Object)FIDM_MODEL)));
            String selectField = ID;
            DynamicObject userPerm = QueryServiceHelper.queryOne((String)"perm_userperm", (String)selectField, (QFilter[])qfBuilder.toArray());
            if (Objects.isNull(userPerm)) {
                return;
            }
            String permId = userPerm.getString(ID);
            String deleSQL = "delete from t_perm_userpermdetail where fid ='" + permId + "' and fbizappid = '" + appid + "'";
            DB.execute((DBRoute)DBRoute.basedata, (String)deleSQL);
        }
    }

    public static int delPermUserRoleByModelId(Long modelId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)modelId);
        QFilter dimtypeFilter = new QFilter(DIM_TYPE, "=", (Object)"bcm_model");
        QFilter[] qFilters = new QFilter[]{orgFilter, dimtypeFilter};
        return DeleteServiceHelper.delete((String)"perm_userrole", (QFilter[])qFilters);
    }

    public static int delDmPermUserRoleByModelId(Long modelId, String bizAppId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)modelId);
        QFilter dimtypeFilter = new QFilter(DIM_TYPE, "=", (Object)FIDM_MODEL);
        QFilter bizFilter = new QFilter("role.bizdomain", "=", (Object)bizAppId);
        QFilter[] qFilters = new QFilter[]{orgFilter, dimtypeFilter, bizFilter};
        return DeleteServiceHelper.delete((String)"perm_userrole", (QFilter[])qFilters);
    }

    public static int delPermUserByModelId(Long modelId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)modelId);
        QFilter dimtypeFilter = new QFilter(DIM_TYPE, "=", (Object)"DIM_BCM_MODEL");
        QFilter[] qFilters = new QFilter[]{orgFilter, dimtypeFilter};
        return DeleteServiceHelper.delete((String)"perm_userperm", (QFilter[])qFilters);
    }

    public static int delDmPermUserByModelId(Long modelId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)modelId);
        QFilter dimtypeFilter = new QFilter(DIM_TYPE, "=", (Object)DIM_DM_MODEL).or(DIM_TYPE, "=", (Object)FIDM_MODEL);
        QFilter[] qFilters = new QFilter[]{orgFilter, dimtypeFilter};
        return DeleteServiceHelper.delete((String)"perm_userperm", (QFilter[])qFilters);
    }

    public static void delPermByUser(Long modelId, List<Long> userids, String permType, String bizAppId) {
        QFilter[] qFilters;
        QFilter qcf = new QFilter("org", "=", (Object)modelId);
        QFilter qcf2 = new QFilter("user", "in", userids);
        if (!Objects.isNull(permType)) {
            QFilter qcf3 = new QFilter(DIM_TYPE, "=", (Object)permType);
            qFilters = new QFilter[]{qcf, qcf2, qcf3};
        } else {
            qFilters = new QFilter[]{qcf, qcf2};
        }
        DynamicObject[] permUserperms = BusinessDataServiceHelper.load((String)"perm_userperm", (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"perm_userperm").getAllFields().keySet()), (QFilter[])qFilters);
        ArrayList deleteFids = Lists.newArrayListWithCapacity((int)16);
        ArrayList dys = Lists.newArrayListWithCapacity((int)16);
        for (DynamicObject dy : permUserperms) {
            DynamicObjectCollection permEntrys = dy.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)permEntrys)) {
                deleteFids.add(dy.get(ID));
                continue;
            }
            if (permEntrys.stream().allMatch(t -> Objects.equals(t.getString("bizapp.id"), bizAppId))) {
                deleteFids.add(dy.get(ID));
                continue;
            }
            Iterator iterator = permEntrys.iterator();
            while (iterator.hasNext()) {
                DynamicObject e = (DynamicObject)iterator.next();
                if (!Objects.equals(e.getString("bizapp.id"), bizAppId)) continue;
                iterator.remove();
            }
            dys.add(dy);
        }
        if (CollectionUtils.isNotEmpty((Collection)deleteFids)) {
            BcmDMLServiceHelper.batchDelete("perm_userperm", deleteFids, ID);
        }
        if (CollectionUtils.isNotEmpty((Collection)dys)) {
            BcmDMLServiceHelper.batchSave(dys);
        }
        if (Objects.equals(AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.CM.getAppnum()).getId(), bizAppId)) {
            BcmFunPermissionHelper.delPermByUser(modelId, userids, permType, AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.RPT.getAppnum()).getId());
        }
    }

    public static Set<Long> getAllHasPermModel(QFilter[] filters) {
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"perm_userperm", (String)"org", (QFilter[])filters);
        HashSet sets = Sets.newHashSetWithExpectedSize((int)dynamicObjectCollection.size());
        if (Objects.nonNull(dynamicObjectCollection) && dynamicObjectCollection.size() > 0) {
            for (DynamicObject dy : dynamicObjectCollection) {
                Long orgId = dy.getLong("org");
                sets.add(orgId);
            }
        }
        return sets;
    }

    private static QFilter[] getEntityQF(String entity, ApplicationTypeEnum application, String[] permType) {
        entity = BcmFunPermissionHelper.getConnectPermEntity(entity);
        QFilter filter = new QFilter(USERFIELD, "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        QFilter filter2 = new QFilter("entryentity.entitytype", "=", (Object)entity);
        if ("bcm_card_myvalue".equals(entity) || "report_card_myvalue".equals(entity) || "report_card_financialdata".equals(entity)) {
            filter2 = new QFilter("1", "=", (Object)1);
        }
        QFilter permTypeFilter = new QFilter(DIM_TYPE, "in", (Object)permType);
        Set<Long> set = BcmFunPermissionHelper.getAllHasPermModel(new QFilter[]{filter, filter2, permTypeFilter});
        QFilter filter1 = new QFilter(ID, "in", set);
        filter1.and(STATUS, "=", (Object)ModelStatusEnum.AUDIT.getValue());
        QFilter qcf = new QFilter(REPORT_TYPE, "!=", (Object)"-1");
        switch (application) {
            case CM: {
                qcf = new QFilter(REPORT_TYPE, "=", (Object)"1");
                break;
            }
            case RPT: {
                qcf = BcmFunPermissionHelper.getRptAdminModelQFilter();
                break;
            }
            case EB: {
                qcf = new QFilter(REPORT_TYPE, "=", (Object)"4");
                break;
            }
            case BGMD: 
            case BGM: {
                qcf = new QFilter(REPORT_TYPE, "=", (Object)"7");
                break;
            }
            case BGBD: {
                qcf = new QFilter(REPORT_TYPE, "=", (Object)"9");
                qcf.or(REPORT_TYPE, "=", (Object)"4").or(REPORT_TYPE, "=", (Object)"7");
                break;
            }
            case FIDM: {
                qcf = null;
                break;
            }
        }
        return new QFilter[]{filter1, qcf};
    }

    private static QFilter getEntityQF(String entity) {
        entity = BcmFunPermissionHelper.getConnectPermEntity(entity);
        Long currentUserId = Long.valueOf(RequestContext.get().getUserId());
        QFilter filter = new QFilter(USERFIELD, "=", (Object)currentUserId);
        QFilter filter2 = new QFilter("entryentity.entitytype", "=", (Object)entity);
        if ("bcm_card_myvalue".equals(entity) || "report_card_myvalue".equals(entity) || "report_card_financialdata".equals(entity)) {
            filter = new QFilter(USERLD, "=", (Object)currentUserId);
            filter2 = new QFilter("1", "=", (Object)1);
        }
        Set<Long> set = BcmFunPermissionHelper.getAllHasPermModel(new QFilter[]{filter, filter2});
        QFilter filter1 = new QFilter(ID, "in", set);
        filter1.and(STATUS, "=", (Object)ModelStatusEnum.AUDIT.getValue());
        return filter1;
    }

    @Deprecated
    public static Set<Long> getEffectiveByPermModel(String entity, ApplicationTypeEnum application) {
        if (ApplicationTypeEnum.isFIDM((ApplicationTypeEnum)application)) {
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)FIDM_MODEL, (String)ID, (QFilter[])BcmFunPermissionHelper.getEntityQF(entity, application, new String[]{FIDM_MODEL, DIM_DM_MODEL}));
            return dynamicObjectCollection.stream().map(e -> e.getLong(ID)).collect(Collectors.toSet());
        }
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bcm_model", (String)ID, (QFilter[])BcmFunPermissionHelper.getEntityQF(entity, application, new String[]{"DIM_BCM_MODEL", "bcm_model"}));
        return dynamicObjectCollection.stream().map(e -> e.getLong(ID)).collect(Collectors.toSet());
    }

    public static Map<ApplicationTypeEnum, Set<Long>> getEffectiveByPermModel(String entity) {
        QFilter permModelFilter = BcmFunPermissionHelper.getEntityQF(entity);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bcm_model", (String)"id,reporttype", (QFilter[])new QFilter[]{permModelFilter});
        HashMap<ApplicationTypeEnum, Set<Long>> app2Sets = new HashMap<ApplicationTypeEnum, Set<Long>>(16);
        app2Sets.put(ApplicationTypeEnum.CM, new HashSet(16));
        app2Sets.put(ApplicationTypeEnum.RPT, new HashSet(16));
        app2Sets.put(ApplicationTypeEnum.PUB, new HashSet(16));
        for (DynamicObject dy : dynamicObjectCollection) {
            String reportType = dy.getString("reporttype");
            Long modelId = dy.getLong(ID);
            if (ApplicationTypeEnum.CM.getOIndex().equals(reportType)) {
                ((Set)app2Sets.get(ApplicationTypeEnum.CM)).add(modelId);
                continue;
            }
            if (ApplicationTypeEnum.RPT.getOIndex().equals(reportType)) {
                ((Set)app2Sets.get(ApplicationTypeEnum.RPT)).add(modelId);
                continue;
            }
            if (!ApplicationTypeEnum.PUB.getOIndex().equals(reportType)) continue;
            ((Set)app2Sets.get(ApplicationTypeEnum.PUB)).add(modelId);
        }
        return app2Sets;
    }

    public static Set<Long> getSuperUserByPermModel(ApplicationTypeEnum application) {
        QFilter filter = new QFilter(USERLD, "=", (Object)RequestContext.get().getCurrUserId());
        Set<Long> set = BcmFunPermissionHelper.getAllHasPermModel(new QFilter[]{filter});
        set.retainAll(MemberPermHelper.getLimitedModelListByUser());
        QFilter filter1 = new QFilter(ID, "in", set);
        QFilter qcf = new QFilter(REPORT_TYPE, "=", (Object)application.getOIndex());
        switch (application) {
            case RPT: {
                qcf = BcmFunPermissionHelper.getRptAdminModelQFilter();
                break;
            }
            case BGM: {
                qcf = new QFilter(REPORT_TYPE, "=", (Object)ApplicationTypeEnum.BGMD.getOIndex());
                break;
            }
            case BGBD: {
                qcf = new QFilter(REPORT_TYPE, "=", (Object)ApplicationTypeEnum.EB.index).or(REPORT_TYPE, "=", (Object)ApplicationTypeEnum.BGMD.index);
                break;
            }
        }
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bcm_model", (String)ID, (QFilter[])new QFilter[]{filter1, qcf});
        set.clear();
        for (DynamicObject dy : dynamicObjectCollection) {
            set.add(dy.getLong(ID));
        }
        return set;
    }

    @Deprecated
    public static Set<Long> getRoleModel(long userId, String perType, ApplicationTypeEnum application, String entityNum, String permItemId) {
        return BcmFunPermissionHelper.getFuncAuthModel(userId, perType, application, entityNum, permItemId, Boolean.TRUE, Boolean.FALSE);
    }

    @Deprecated
    public static Set<Long> getRoleModel(long UserID, String perType, ApplicationTypeEnum application) {
        return BcmFunPermissionHelper.getRoleModel(UserID, perType, application, null, null);
    }

    public static Set<Long> getFuncAuthModel(long userId, String perType, ApplicationTypeEnum application, String entityNum, String permItemId, boolean isOldDiffFilter, boolean isRPTAndIncludeCMModel) {
        if (Objects.nonNull(entityNum)) {
            entityNum = BcmFunPermissionHelper.getConnectPermEntity(entityNum);
        }
        QFBuilder qcf = new QFBuilder(STATUS, "=", (Object)ModelStatusEnum.AUDIT.getValue());
        HasPermDimObjResult perResult = Objects.isNull(entityNum) || Objects.equals("bcm_card_myvalue", entityNum) || Objects.equals("report_card_myvalue", entityNum) || Objects.equals("report_card_financialdata", entityNum) ? PermissionServiceHelper.getUserHasPermDimObjs((long)userId, (String)perType) : PermissionServiceHelper.getHasPermDimObjs((long)userId, (String)AppMetadataCache.getAppInfo((String)application.getAppnum()).getId(), (String)entityNum, (String)permItemId);
        boolean isOldVer = isOldDiffFilter && perResult.hasAllDimObjPerm() || !isOldDiffFilter && !isRPTAndIncludeCMModel;
        StringBuilder append = new StringBuilder().append(userId).append(perType).append(application.getName());
        if (!isOldVer) {
            append.append("#getFuncAuthModel");
        }
        String key = append.toString();
        Map<String, Set<Long>> map = modelRoleLocal.get();
        if (map.containsKey(key)) {
            return map.get(key);
        }
        if (!perResult.hasAllDimObjPerm()) {
            qcf.and(new QFilter(ID, "in", (Object)perResult.getHasPermDimObjs()));
        }
        String entity = "bcm_model";
        switch (application) {
            case RPT: {
                qcf.and(isOldVer ? BcmFunPermissionHelper.getRptAdminModelQFilter() : BcmFunPermissionHelper.getAllRptAdminModelQFilter());
                break;
            }
            case FIDM: {
                entity = FIDM_MODEL;
                break;
            }
            case DI: {
                qcf.and(new QFilter("reporttype", "=", (Object)ApplicationTypeEnum.CM.index));
                break;
            }
            default: {
                qcf.and(new QFilter(REPORT_TYPE, "=", (Object)application.index));
            }
        }
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)entity, (String)ID, (QFilter[])qcf.toArray());
        Set<Long> publicModelIds = CollectionUtils.isEmpty((Collection)dynamicObjectCollection) ? Collections.EMPTY_SET : dynamicObjectCollection.stream().map(t -> t.getLong(ID)).collect(Collectors.toSet());
        map.put(key, publicModelIds);
        return publicModelIds;
    }

    public static Set<Long> getFuncAuthModel(long userId, String perType, ApplicationTypeEnum application, boolean isOldDiffFilter, boolean isRPTAndIncludeCMModel) {
        return BcmFunPermissionHelper.getFuncAuthModel(userId, perType, application, null, null, isOldDiffFilter, isRPTAndIncludeCMModel);
    }

    public static QFilter getRptAdminModelQFilter() {
        return new QFilter(REPORT_TYPE, "in", Arrays.asList(ApplicationTypeEnum.RPT.getOIndex(), ApplicationTypeEnum.PUB.getOIndex()));
    }

    public static QFilter getAllRptAdminModelQFilter() {
        return new QFilter(REPORT_TYPE, "in", Arrays.asList(ApplicationTypeEnum.RPT.getOIndex(), ApplicationTypeEnum.PUB.getOIndex(), ApplicationTypeEnum.CM.getOIndex()));
    }

    private static String getConnectPermEntity(String entity) {
        String newentity = entity;
        switch (entity) {
            case "bcm_datacollectlog_list": {
                newentity = "bcm_datacollection";
                break;
            }
            case "bcm_tpl_treelist": {
                newentity = "bcm_cslscheme";
                break;
            }
            case "bcm_unionperm": {
                newentity = "bcm_auth";
                break;
            }
        }
        return newentity;
    }

    public static void checkPerm(String opkey, String entityNumber, Long modelId, Long userId, String bizAppId) {
        int is;
        if (StringUtils.isEmpty((String)opkey) || StringUtils.isEmpty((String)entityNumber) || modelId == null || userId == null || StringUtils.isEmpty((String)bizAppId)) {
            return;
        }
        Map<String, Map<String, String>> permitem = BcmPermSingleModel.getInstance().getPermitem();
        Map<String, String> map = permitem.get(entityNumber);
        if (map == null || map.get(opkey) == null) {
            return;
        }
        String[] perm = map.get(opkey).split("@");
        if (perm.length < 2) {
            return;
        }
        if (ApplicationTypeEnum.BGMD.appnum.equalsIgnoreCase(bizAppId)) {
            bizAppId = ApplicationTypeEnum.EB.appnum;
        }
        if ((is = BcmFunPermissionHelper.checkPermission(userId, modelId, AppMetadataCache.getAppInfo((String)bizAppId).getId(), perm[0], perm[1])) == 0) {
            if (MemberPermHelper.ifUserHasRootPermByModel(userId, String.valueOf(modelId))) {
                return;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\uff01", (String)"MemberPermHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    private static int checkPermission(long userId, long dimObjId, String appId, String entityNum, String permItemId) {
        String isGalaxySystem = System.getProperty("isGalaxySystem");
        int is = isGalaxySystem != null && isGalaxySystem.equalsIgnoreCase("true") ? PermissionServiceHelper.checkPermission((long)userId, (String)"bos_org", (long)0L, (String)appId, (String)entityNum, (String)permItemId) : PermissionServiceHelper.checkPermission((long)userId, (String)"bcm_model", (long)dimObjId, (String)appId, (String)entityNum, (String)permItemId);
        return is;
    }

    public static void addFidmAdminPermission(Long modelId, Long userId) {
        BcmFunPermissionHelper.addAllRootPermByUser(modelId, userId, ApplicationTypeEnum.FIDM, FIDM_MODEL);
    }

    public static void addFarAdminPermission(Long modelId, Long userId) {
        BcmFunPermissionHelper.addAllRootPermByUser(modelId, userId, ApplicationTypeEnum.FAR, FIDM_MODEL);
    }

    public static String getAppID(String apptype) {
        String appid = "2IFNVZ0SS0W4";
        if (ApplicationTypeEnum.FAR.getAppnum().equals(apptype)) {
            appid = "2K++OWYYMS5J";
        }
        return appid;
    }

    public static Boolean needCheckMGStatus(long userId, long modelId) {
        boolean isAdmin = MemberPermHelper.ifUserHasRootPermByModel(userId, String.valueOf(modelId));
        if (isAdmin) {
            return false;
        }
        boolean superUser = (Boolean)ThreadCache.get((Object)Joiner.on((char)'-').join((Object)modelId, (Object)userId, new Object[]{"check_SuperUser"}), () -> PermissionServiceHelper.isSuperUser((long)userId));
        if (superUser) {
            return false;
        }
        return MemberPermHelper.getRolesByUIdMId(userId, modelId).contains(RPT_ADT_VSB_CTR);
    }

    static {
        StringBuilder existSql = new StringBuilder();
        existSql.append("SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 't_perm_userpermdetail' AND KSQL_COL_NAME IN ('fuserid')");
        ISNEWPLATFORM = (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)existSql.toString(), (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                return rs.next();
            }
        });
        if (ISNEWPLATFORM) {
            USERFIELD = "entryentity.userfield";
        }
        modelRoleLocal = ThreadLocal.withInitial(HashMap::new);
    }
}

