/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.permission;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class UserDistributeSpreadLogic {
    private static final String USER = "user.id";
    private static final String USER_GROUP_ID = "usergroup.id";

    DynamicObjectCollection queryAllTaskByCatalogId(long userId) {
        List<Long> taskCatalogIdList = this.queryFromUserDistribute(userId);
        QFilter filter1 = new QFilter("taskcatalog", "in", taskCatalogIdList);
        String selectFields = "id,name,parent";
        return QueryServiceHelper.query((String)"bcm_taskconfig", (String)selectFields, (QFilter[])new QFilter[]{filter1});
    }

    List<Long> queryFromUserDistribute(long userId) {
        Set<Long> usergroupIdList = this.queryAllGroupByUserId(userId);
        usergroupIdList.add(userId);
        QFilter filter1 = new QFilter("userdisentry.eusers", "in", usergroupIdList);
        ArrayList taskcatalogIdList = Lists.newArrayListWithExpectedSize((int)10);
        QueryServiceHelper.query((String)"bcm_userdistribute", (String)"id, taskcatalog ", (QFilter[])new QFilter[]{filter1}).forEach(p -> taskcatalogIdList.add(p.getLong("taskcatalog")));
        return taskcatalogIdList;
    }

    Set<Long> queryAllGroupByUserId(long userId) {
        if (ThreadCache.exists((Object)("usergroup" + userId))) {
            return (Set)ThreadCache.get((Object)("usergroup" + userId));
        }
        HashSet usergroupIdList = Sets.newHashSetWithExpectedSize((int)8);
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        BusinessDataServiceHelper.loadFromCache((String)"bos_usergroupstaff", (String)USER_GROUP_ID, (QFilter[])new QFilter[]{userFilter}).values().forEach(e -> usergroupIdList.add(e.getLong(USER_GROUP_ID)));
        ThreadCache.put((Object)"usergroup", (Object)usergroupIdList);
        return usergroupIdList;
    }

    Set<Long> queryAllGroupByUserId(Set<Long> userGrpIds) {
        HashSet userGroupIdList = Sets.newHashSetWithExpectedSize((int)userGrpIds.size());
        QFBuilder userQFBuilder = new QFBuilder(USER_GROUP_ID, "in", userGrpIds);
        BusinessDataServiceHelper.loadFromCache((String)"bos_usergroupstaff", (String)USER, (QFilter[])userQFBuilder.toArray()).values().forEach(e -> userGroupIdList.add(e.getLong(USER)));
        return userGroupIdList;
    }

    DynamicObjectCollection queryAllUsersByGroupId(Object userGroupId) {
        QFilter userGroupFilter = new QFilter("usergroup", "=", (Object)LongUtil.toLong((Object)userGroupId));
        return QueryServiceHelper.query((String)"bos_usergroupstaff", (String)"user,user.name as name,user.phone as phone,user.email as email,user.number as number", (QFilter[])new QFilter[]{userGroupFilter});
    }

    DynamicObjectCollection queryAllUsersByGroupIds(List<Long> userGroupIds) {
        QFilter userGroupFilter = new QFilter("usergroup", "in", userGroupIds);
        return QueryServiceHelper.query((String)"bos_usergroupstaff", (String)"user,user.name as name,user.phone as phone,user.email as email,user.number as number", (QFilter[])new QFilter[]{userGroupFilter});
    }
}

