/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.permission.cache;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.util.ThrowableHelper;
import org.apache.poi.xssf.usermodel.XSSFCell;

public class BcmPermSingleModel {
    private Map<String, Map<String, String>> permitem;
    private Map<String, List<String>> permbyentity;

    private BcmPermSingleModel() {
        this.setPermitem(this.getPermItem());
        this.setPermbyentity(this.getPermByEntity());
    }

    public Map<String, Map<String, String>> getPermitem() {
        return this.permitem;
    }

    private void setPermitem(Map<String, Map<String, String>> permitem) {
        this.permitem = permitem;
    }

    public Map<String, List<String>> getPermbyentity() {
        return this.permbyentity;
    }

    private void setPermbyentity(Map<String, List<String>> permbyentity) {
        this.permbyentity = permbyentity;
    }

    public static BcmPermSingleModel getInstance() {
        return BcmPermSingleModelHolder.INSTANCE;
    }

    private Map<String, List<String>> getPermByEntity() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("perm/permitemlist.csv");
             BufferedReader br = new BufferedReader(new InputStreamReader(in));){
            String DELIMITER = ",";
            String line = br.readLine();
            while ((line = br.readLine()) != null) {
                String[] columns = line.split(DELIMITER);
                if (columns.length == 0 || columns.length == 1 && StringUtils.isEmpty((String)columns[0])) continue;
                String entity = columns[2];
                List list = (List)map.get(entity);
                if (list == null) {
                    list = Lists.newArrayListWithExpectedSize((int)10);
                }
                String permitem = columns[3];
                list.add(permitem);
                map.put(entity, list);
            }
        }
        catch (Exception e) {
            throw new KDBizException(ThrowableHelper.toString((Exception)e));
        }
        return map;
    }

    private Map<String, Map<String, String>> getPermItem() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("perm/permitemlist.csv");
             BufferedReader br = new BufferedReader(new InputStreamReader(in));){
            String DELIMITER = ",";
            String line = br.readLine();
            while ((line = br.readLine()) != null) {
                String form;
                String[] columns = line.split(DELIMITER);
                if (columns.length == 0 || StringUtils.isEmpty((String)(form = columns[0]))) continue;
                Map itemmap = (Map)map.get(form);
                if (itemmap == null) {
                    itemmap = Maps.newHashMapWithExpectedSize((int)16);
                }
                String opsign = columns[1];
                String entity = columns[2];
                String permitem = columns[3];
                String value = entity + "@" + permitem;
                itemmap.put(opsign, value);
                map.put(form, itemmap);
            }
        }
        catch (Exception e) {
            throw new KDBizException(ThrowableHelper.toString((Exception)e));
        }
        return map;
    }

    private String getCellValue(XSSFCell c) {
        if (c == null) {
            return "";
        }
        return c.getStringCellValue();
    }

    private static class BcmPermSingleModelHolder {
        private static final BcmPermSingleModel INSTANCE = new BcmPermSingleModel();

        private BcmPermSingleModelHolder() {
        }
    }
}

