/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.permission.cache;

import com.google.common.collect.ArrayListMultimap;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.common.util.DataEntityUtils;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections.CollectionUtils;

public class MemPermClassCacheManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, ArrayListMultimap<String, String>> cache;
    private static final Integer MAX_COUNT = 2000;
    private Object modelId;

    public MemPermClassCacheManager(Object modelId) {
        this.modelId = modelId;
        this.cache = new ConcurrentHashMap<String, ArrayListMultimap<String, String>>();
    }

    public PermEnum getMemPermClassType(String dimNum, String mNum) {
        ArrayListMultimap<String, String> map;
        PermEnum permEnum = null;
        if (!this.cache.containsKey(dimNum)) {
            this.initMemPermClassCache(dimNum);
        }
        if ((map = this.cache.get(dimNum)).get((Object)"1").contains(mNum)) {
            permEnum = PermEnum.NOPERM;
        } else if (map.get((Object)"2").contains(mNum)) {
            permEnum = PermEnum.READONLY;
        } else if (map.get((Object)"3").contains(mNum)) {
            permEnum = PermEnum.READWRITE;
        }
        return permEnum;
    }

    private void initMemPermClassCache(String dimNum) {
        String modelNumber = MemberReader.findModelNumberById((Object)this.modelId);
        String entityName = MemberReader.getEntityNumberByDim((String)modelNumber, (String)dimNum);
        ArrayListMultimap tempMap = ArrayListMultimap.create();
        if (!DataEntityUtils.isIncludeShareField((String)entityName)) {
            this.cache.put(dimNum, (ArrayListMultimap<String, String>)tempMap);
            return;
        }
        ArrayListMultimap<String, Long> map = PermClassEntityHelper.getPermissionMapBatch(entityName, String.valueOf(this.modelId), RequestContext.get().getUserId());
        for (String key : map.keySet()) {
            List ids = map.get((Object)key);
            if (CollectionUtils.isEmpty((Collection)ids)) continue;
            for (Long id : ids) {
                IDNumberTreeNode member = MemberReader.findMemberById((String)modelNumber, (String)entityName, (Long)id);
                if (Objects.isNull(member) || Objects.equals(member, IDNumberTreeNode.NotFoundTreeNode) || member.isShare()) continue;
                tempMap.put((Object)key, (Object)member.getNumber());
            }
        }
        this.cache.put(dimNum, (ArrayListMultimap<String, String>)tempMap);
    }

    public String getEntityName(String dimNum) {
        QFBuilder range = new QFBuilder("model", "=", this.modelId);
        range.add("number", "=", (Object)dimNum);
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_dimension", (String)"membermodel", (QFilter[])range.toArray());
        return object == null ? "" : object.getString("membermodel");
    }
}

