/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.permission.cache;

import java.io.Serializable;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.permission.strategy.PermControlStrategy;
import kd.fi.bcm.business.serviceHelper.ICVersionServiceHelper;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.RangeEnum;

public class MembBaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long mId;
    private String mLongNumber;
    private RangeEnum range;
    private int rangeId;
    private String number;
    private String entityNum;
    private boolean isCustom = false;
    private Object modelId;
    private long schemeId;

    public MembBaseItem(String entityNum, Long mId, String mLongNumber, String mnumber, RangeEnum range, boolean isCustom, Object modelId) {
        this.mId = mId;
        this.mLongNumber = mLongNumber;
        this.range = range;
        this.number = mnumber;
        this.entityNum = entityNum;
        this.isCustom = isCustom;
        this.modelId = modelId;
    }

    public MembBaseItem(String entityNum, Long mId, String mLongNumber, String mnumber, int rangeId, boolean isCustom, Object modelId) {
        this.mId = mId;
        this.mLongNumber = mLongNumber;
        this.range = rangeId >= RangeEnum.VALUE_20000.getValue() ? RangeEnum.VALUE_20000 : (rangeId >= RangeEnum.VALUE_10000.getValue() ? RangeEnum.VALUE_10000 : RangeEnum.getRangeByVal((int)rangeId));
        this.rangeId = rangeId;
        this.number = mnumber;
        this.entityNum = entityNum;
        this.isCustom = isCustom;
        this.modelId = modelId;
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    public Long getmId() {
        return this.mId;
    }

    public String getmLongNumber() {
        return this.mLongNumber;
    }

    public void setLongNumber(String longNumber) {
        this.mLongNumber = longNumber;
    }

    public RangeEnum getRange() {
        return this.range;
    }

    public String getNumber() {
        if (StringUtils.isNotEmpty((CharSequence)this.number)) {
            return this.number;
        }
        this.number = MemberReader.findMemberById((long)Long.parseLong(this.modelId.toString()), (String)(this.isCustom ? "bcm_definedpropertyvalue" : this.entityNum), (Long)this.mId).getNumber();
        return this.number;
    }

    public String getEntityNum() {
        return this.entityNum;
    }

    public Object getModelId() {
        return this.modelId;
    }

    public void setModelId(Object modelId) {
        this.modelId = modelId;
    }

    public boolean isMatched(Object cpId) {
        return PermControlStrategy.getStrategy(this.range).isMatchPermission(this, cpId);
    }

    @SDKMark
    public void matchItems(Consumer<SimpleItem> c) {
        PermControlStrategy.getStrategy(this.range).matchItems(this, c);
    }

    public Set<String> matchItem4UnmodifiableSet() {
        return PermControlStrategy.getStrategy(this.range).matchItem4UnmodifiableSet(this);
    }

    public QFilter buildFilterByScope() {
        return PermControlStrategy.getStrategy(this.range).buildFilterByScope(this);
    }

    public long getParentId() {
        String parent;
        DynamicObject dyna = QueryServiceHelper.queryOne((String)(this.isCustom ? "bcm_definedpropertyvalue" : this.entityNum), (String)(parent = this.isCustom ? "parentid" : "parent"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.mId)});
        Object obj = dyna.get(parent);
        if (obj instanceof DynamicObject) {
            return ((DynamicObject)obj).getLong("id");
        }
        return (Long)obj;
    }

    public String genKey(Object cpId) {
        return "" + this.modelId + this.mId + this.range + this.isCustom + cpId;
    }

    public String toString() {
        return String.format("mId:%s, mLongNumber:%s, range:%s,, rangeId:%s number:%s, entityNum:%s, isCustom:%s, modelId:%s", this.mId, this.mLongNumber, this.range, this.rangeId, this.number, this.entityNum, this.isCustom, this.modelId);
    }

    public int getRangeId() {
        return this.rangeId;
    }

    public void setRangeId(int rangeId) {
        this.rangeId = rangeId;
    }

    public long getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(long schemeId) {
        this.schemeId = schemeId;
    }

    public QFilter buildFilterByScope4Ic(VersionParam param) {
        QFilter filter = this.buildFilterByScope();
        param.setParentId(this.getmId());
        Set<Long> ids = ICVersionServiceHelper.getInvalidIdByParent(param);
        if (!ids.isEmpty()) {
            filter.and(new QFilter("id", "not in", ids));
        }
        return filter;
    }

    public void matchItem4Ic(VersionParam param, Consumer<SimpleItem> consumer) {
        param.setParentId(this.getmId());
        PermControlStrategy.getStrategy(this.range).matchItem4Ic(this, consumer, param);
    }

    public Set<Long> getInvalidIC(VersionParam param) {
        param.setParentId(this.getmId());
        return ICVersionServiceHelper.getInvalidIdByParent(param);
    }
}

