/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.permission.cache;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.permission.cache.MembPermItem;
import kd.fi.bcm.business.permission.cache.MembPermItemList;
import kd.fi.bcm.business.permission.strategy.PermControlStrategy;
import kd.fi.bcm.business.serviceHelper.MemberPermSpreadLogic;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;

public class MembPermCacheItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DIM_PERM_CACHE_FREFIX = "dimperm_";
    private Map<String, PermInfo<String>> cache = Maps.newHashMapWithExpectedSize((int)16);
    private MembPermItemList perms = new MembPermItemList();
    private PermEnum dimDefaultPermType;
    private static ThreadLocal<Map<String, Long>> memberCache = ThreadLocal.withInitial(WeakHashMap::new);

    public MembPermCacheItem(Object modelId, Object dimId) {
        this(modelId, dimId, Long.parseLong(RequestContext.get().getUserId()));
    }

    public MembPermCacheItem(Object modelId, Object dimId, long userId) {
        this.autowireHasDispPerm(modelId, dimId, userId);
    }

    private void autowireHasDispPerm(Object modelId, Object dimId, long userId) {
        MemberPermSpreadLogic logic = new MemberPermSpreadLogic();
        DynamicObject[] disp = null;
        List ps = (List)ThreadCache.get((Object)(DIM_PERM_CACHE_FREFIX + dimId));
        if (ps != null) {
            disp = ps.toArray(new DynamicObject[0]);
        }
        if (disp == null) {
            disp = logic.getUserDispPerms(dimId, userId);
        }
        Arrays.asList(disp).forEach(p -> {
            boolean isCus = p.getBoolean("iscustomprop");
            this.perms.add(new MembPermItem(p.getString("membertype"), p.getLong("member.id"), isCus ? p.getString("member.longnumber") : null, p.getString("member.number"), RangeEnum.getRangeByVal((int)p.getInt("range")), PermEnum.getPermTypeByVal((int)p.getInt("permission")), isCus, modelId));
        });
        this.initLongNumber();
        this.dimDefaultPermType = PermEnum.getPermTypeByVal((int)logic.getDefaultPermValue(Long.parseLong(modelId.toString()), Long.parseLong(dimId.toString())));
    }

    private void initLongNumber() {
        ArrayList mIds = Lists.newArrayListWithCapacity((int)this.perms.size());
        this.perms.iterator().forEachRemaining(p -> {
            if (!p.isCustom()) {
                mIds.add(p.getmId());
            }
        });
        if (!mIds.isEmpty()) {
            Map collMap = BusinessDataServiceHelper.loadFromCache((String)((MembPermItem)this.perms.first()).getEntityNum(), (String)"id,longnumber", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)mIds.toArray())});
            HashMap map = new HashMap();
            collMap.forEach((k, v) -> map.put(v.get("id"), v.getString("longnumber")));
            this.perms.iterator().forEachRemaining(p -> p.setLongNumber((String)map.get(p.getmId())));
        }
    }

    public PermEnum getDimDefaultPermType() {
        return this.dimDefaultPermType;
    }

    public PermEnum getMembPermControlType(String dimNum, String mNum) {
        PermInfo<String> permInfo = this.cache.get(mNum);
        if (null != permInfo) {
            return ((PermInfo)permInfo).permType;
        }
        PermEnum type = this.handlePermControl(dimNum, mNum, PermEnum.NOPERM, PermEnum.READONLY, PermEnum.READWRITE);
        if (type == null) {
            type = this.dimDefaultPermType;
        }
        this.cache.put(mNum, new PermInfo<String>(mNum, type));
        return type;
    }

    public PermEnum getMemPermControlTypeAllowNull(String dimNum, String mNum) {
        PermInfo<String> permInfo = this.cache.get(mNum);
        if (null != permInfo) {
            return ((PermInfo)permInfo).permType;
        }
        PermEnum type = this.handlePermControl(dimNum, mNum, PermEnum.NOPERM, PermEnum.READONLY, PermEnum.READWRITE);
        if (type != null) {
            this.cache.put(mNum, new PermInfo<String>(mNum, type));
        }
        return type;
    }

    private PermEnum handlePermControl(String dimnum, String mNum, PermEnum ... permTypes) {
        for (PermEnum type : permTypes) {
            for (MembPermItem item : this.perms.searchPermItemByPermType(type)) {
                if (!PermControlStrategy.getStrategy(item.getRange()).isMatchPermission(item, this.getIdByNumber(dimnum, mNum, item))) continue;
                return item.getPermType();
            }
        }
        return null;
    }

    private Long getIdByNumber(String dimnum, String number, MembPermItem item) {
        return memberCache.get().computeIfAbsent(item.getEntityNum() + number, key -> {
            try {
                if (item.isCustom()) {
                    long dimId = MemberReader.getDimensionIdByNum((long)((Long)item.getModelId()), (String)dimnum);
                    QFBuilder qf = new QFBuilder().add("number", "=", (Object)number).add("dimension.id", "=", (Object)dimId);
                    return BusinessDataServiceHelper.loadSingleFromCache((String)item.getEntityNum(), (String)"id", (QFilter[])qf.toArray()).getLong("id");
                }
                return MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)item.getModelId()), (String)dimnum, (String)number).getId();
            }
            catch (Throwable t) {
                throw new RuntimeException(String.format("item:%s\n%s", item.toString(), ThrowableHelper.toString((Throwable)t)));
            }
        });
    }

    public MembPermItemList getPerms() {
        return this.perms;
    }

    static class PermInfo<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private T key;
        private PermEnum permType = PermEnum.READWRITE;

        PermInfo(T key, PermEnum permType) {
            this.key = key;
            this.permType = permType;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object t) {
            if (t == null) {
                return false;
            }
            PermInfo p = (PermInfo)t;
            return this.key.equals(p.key);
        }
    }
}

