/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.permission.cache;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.fi.bcm.business.permission.cache.MembPermCacheItem;
import kd.fi.bcm.business.permission.cache.MembPermItem;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.PermEnum;

public class MembPermCacheManager
implements Serializable {
    public static final String DIM_NUMBER_PREFIX = "dimnum_";
    private static final long serialVersionUID = 1L;
    private Map<String, MembPermCacheItem> cache;
    private Object modelId;

    public MembPermCacheManager(Object modelId) {
        this.modelId = modelId;
        this.cache = new ConcurrentHashMap<String, MembPermCacheItem>();
    }

    public PermEnum getMembPermControlType(String dimNum, String mNum) {
        if (!this.cache.containsKey(dimNum)) {
            this.initMembPermCache(dimNum);
        }
        return this.cache.get(dimNum).getMembPermControlType(dimNum, mNum);
    }

    public PermEnum getMemPermControlTypeAllowNull(String dimNum, String mNum) {
        if (!this.cache.containsKey(dimNum)) {
            this.initMembPermCache(dimNum);
        }
        return this.cache.get(dimNum).getMemPermControlTypeAllowNull(dimNum, mNum);
    }

    public PermEnum getMemDefaultPermType(String dimNum, String mNum) {
        return this.cache.get(dimNum).getDimDefaultPermType();
    }

    private void initMembPermCache(String dimNum) {
        MembPermCacheItem ref = new MembPermCacheItem(this.modelId, this.getDimId(dimNum));
        this.cache.put(dimNum, ref);
    }

    private Object getDimId(String dimNum) {
        return MemberReader.getDimensionIdByNum((long)Long.parseLong(this.modelId.toString()), (String)dimNum);
    }

    public Map<String, MembPermCacheItem> getCache() {
        return this.cache;
    }

    public Object getModelId() {
        return this.modelId;
    }

    public Pair<Integer, Set<Long>> getMembPermInfo(String dimMem) {
        this.initMembPermCache(dimMem);
        PermEnum dimDefaultPermType = this.cache.get(dimMem).getDimDefaultPermType();
        HashSet hasPermIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet noPermIds = Sets.newHashSetWithExpectedSize((int)16);
        List<MembPermItem> membHasPermItems = this.cache.get(dimMem).getPerms().searchPermItemByPermType(PermEnum.READONLY);
        membHasPermItems.addAll(this.cache.get(dimMem).getPerms().searchPermItemByPermType(PermEnum.READWRITE));
        List<MembPermItem> membNoPermItems = this.cache.get(dimMem).getPerms().searchPermItemByPermType(PermEnum.NOPERM);
        if (PermEnum.NOPERM == dimDefaultPermType) {
            this.collectRangeMemb(hasPermIds, membHasPermItems);
        }
        this.collectRangeMemb(noPermIds, membNoPermItems);
        if (PermEnum.NOPERM == dimDefaultPermType) {
            hasPermIds.removeAll(noPermIds);
            return Pair.onePair((Object)0, (Object)hasPermIds);
        }
        return Pair.onePair((Object)1, (Object)noPermIds);
    }

    private void collectRangeMemb(Set<Long> contain, List<MembPermItem> MembPermItemList2) {
        MembPermItemList2.forEach(e -> e.matchItems(item -> contain.add(Long.valueOf(item.id.toString()))));
    }
}

