/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.permission.perm;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.fi.bcm.business.permission.perm.PermPackage;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.common.util.LongUtil;

public class PermPackageList
implements Serializable {
    private static final long serialVersionUID = 7332746277293967558L;
    private Long modelId;
    private PermEnum defaultPerm;
    private List<PermPackage> list = Lists.newArrayListWithCapacity((int)2);

    public PermPackageList() {
    }

    public PermPackageList(long modelId) {
        this.modelId = modelId;
    }

    public PermEnum getDefaultPerm() {
        return this.defaultPerm;
    }

    public void setDefaultPerm(PermEnum defaultPerm) {
        this.defaultPerm = defaultPerm;
    }

    public List<PermPackage> getList() {
        return this.list;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public PermEnum getPermEnum(long memberId, long userId) {
        if (MemberPermHelper.ifUserHasRootPermByModel(userId, String.valueOf(this.modelId))) {
            return PermEnum.READWRITE;
        }
        for (PermPackage permPackage : this.getList()) {
            if (!permPackage.getPermSet().contains(memberId)) continue;
            return permPackage.getPerm();
        }
        return this.getDefaultPerm();
    }

    public PermEnum getPermEnum(long memberId) {
        return this.getPermEnum(memberId, RequestContext.get().getCurrUserId());
    }

    public PermEnum getPermEnum(String memberId) {
        return this.getPermEnum(LongUtil.toLong((Object)memberId));
    }
}

