/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.permission.perm;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.UserDistributeServiceHelper;
import kd.fi.bcm.business.permission.perm.PermCacheKey;
import kd.fi.bcm.business.permission.perm.PermPackage;
import kd.fi.bcm.business.permission.perm.PermPackageList;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.strategy.IPermHandler;
import kd.fi.bcm.business.permission.perm.strategy.PermHandlerStrategy;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermSpreadLogic;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.fel.common.StringUtils;

public class PermissionServiceImpl
implements PermissionService {
    private static final Log log = LogFactory.getLog(PermissionService.class);
    private static final Integer MAX_SELECT_IN_COUNT = 5000;
    private Long modelId;

    public static PermissionService getInstance(Long modelId) {
        return (PermissionService)ThreadCache.get((Object)(PermCacheKey.PERM_HANDLER_SERVICE + modelId), () -> new PermissionServiceImpl(modelId));
    }

    private PermissionServiceImpl(Long modelId) {
        this.modelId = modelId;
    }

    @Override
    public boolean isAllNoPerm(Long dimensionId, String entityName, Collection<Long> memberIds) {
        long startTime = System.currentTimeMillis();
        boolean returnValue = this.matchPerm(this.modelId, dimensionId, entityName, memberIds, Sets.newHashSet((Object[])new PermEnum[]{PermEnum.NOPERM}));
        PermissionServiceImpl.printLog(startTime, "isAllNoPerm", returnValue, startTime, this.modelId, dimensionId, memberIds);
        return returnValue;
    }

    @Override
    public boolean isAllReadPerm(Long dimensionId, String entityName, Collection<Long> memberIds) {
        long startTime = System.currentTimeMillis();
        boolean returnValue = this.matchPerm(this.modelId, dimensionId, entityName, memberIds, Sets.newHashSet((Object[])new PermEnum[]{PermEnum.READONLY}));
        PermissionServiceImpl.printLog(startTime, "isAllReadPerm", returnValue, this.modelId, dimensionId, memberIds);
        return returnValue;
    }

    @Override
    public boolean isAllWritePerm(Long dimensionId, String entityName, Collection<Long> memberIds) {
        long startTime = System.currentTimeMillis();
        boolean returnValue = this.matchPerm(this.modelId, dimensionId, entityName, memberIds, Sets.newHashSet((Object[])new PermEnum[]{PermEnum.READWRITE}));
        PermissionServiceImpl.printLog(startTime, "isAllWritePerm", returnValue, this.modelId, dimensionId, memberIds);
        return returnValue;
    }

    private boolean hasExpectPerm(Long dimensionId, Long memberId, Set<PermEnum> permList) {
        Boolean specialPerm;
        DynamicObject dim = MemberReader.getDimensionDynById((long)dimensionId);
        if (Objects.isNull(dim)) {
            return false;
        }
        if (this.isAdmin() || "Extends".equals(dim.getString("number"))) {
            return permList.contains(PermEnum.READWRITE);
        }
        String entityName = dim.getString("membermodel");
        IDNumberTreeNode node = MemberReader.findMemberById((long)this.modelId, (String)entityName, (Long)memberId);
        if (Objects.equals(IDNumberTreeNode.NotFoundTreeNode, node)) {
            return false;
        }
        boolean isAccount = Objects.equals(DimEntityNumEnum.ACCOUNT.getEntityNum(), entityName);
        if (isAccount && Objects.nonNull(specialPerm = this.getSpecialAccountPerm(entityName, node, permList))) {
            return specialPerm;
        }
        Long id = node.isShare() ? node.getCopyfromId() : node.getId();
        Integer perm = this.getRecords(dimensionId).getOrDefault(id, this.getDefaultPerm(dimensionId));
        return permList.stream().anyMatch(t -> Objects.equals(t.getValue(), perm));
    }

    private Boolean getSpecialAccountPerm(String entityName, IDNumberTreeNode node, Set<PermEnum> permList) {
        if (node.isShare()) {
            IDNumberTreeNode copyFromNode = MemberReader.findMemberById((long)this.modelId, (String)entityName, (Long)node.getCopyfromId());
            if (Objects.equals(IDNumberTreeNode.NotFoundTreeNode, copyFromNode)) {
                return false;
            }
            if (this.isRate(copyFromNode)) {
                return permList.contains(PermEnum.READWRITE);
            }
        } else if (this.isRate(node)) {
            return permList.contains(PermEnum.READWRITE);
        }
        return null;
    }

    @Override
    public boolean hasWritePerm(Long dimensionId, Long memberId) {
        long startTime = System.currentTimeMillis();
        boolean returnValue = this.hasExpectPerm(dimensionId, memberId, Sets.newHashSet((Object[])new PermEnum[]{PermEnum.READWRITE}));
        PermissionServiceImpl.printLog(startTime, "hasWritePerm", returnValue, this.modelId, dimensionId, memberId);
        return returnValue;
    }

    @Override
    public boolean hasReadPerm(Long dimensionId, Long memberId) {
        long startTime = System.currentTimeMillis();
        boolean returnValue = this.hasExpectPerm(dimensionId, memberId, Sets.newHashSet((Object[])new PermEnum[]{PermEnum.READONLY}));
        PermissionServiceImpl.printLog(startTime, "hasReadPerm", returnValue, this.modelId, dimensionId, memberId);
        return returnValue;
    }

    @Override
    public boolean hasNoPerm(Long dimensionId, Long memberId) {
        long startTime = System.currentTimeMillis();
        boolean returnValue = this.hasExpectPerm(dimensionId, memberId, Sets.newHashSet((Object[])new PermEnum[]{PermEnum.NOPERM}));
        PermissionServiceImpl.printLog(startTime, "hasNoPerm", returnValue, this.modelId, dimensionId, memberId);
        return returnValue;
    }

    @Override
    public boolean hasNoOrReadPerm(Long dimensionId, Long memberId) {
        long startTime = System.currentTimeMillis();
        boolean returnValue = this.hasExpectPerm(dimensionId, memberId, Sets.newHashSet((Object[])new PermEnum[]{PermEnum.READONLY, PermEnum.NOPERM}));
        PermissionServiceImpl.printLog(startTime, "hasNoOrReadPerm", returnValue, this.modelId, dimensionId, memberId);
        return returnValue;
    }

    @Override
    public boolean hasWriteOrReadPerm(Long dimensionId, Long memberId) {
        long startTime = System.currentTimeMillis();
        boolean returnValue = this.hasExpectPerm(dimensionId, memberId, Sets.newHashSet((Object[])new PermEnum[]{PermEnum.READONLY, PermEnum.READWRITE}));
        PermissionServiceImpl.printLog(startTime, "hasWriteOrReadPerm", returnValue, this.modelId, dimensionId, memberId);
        return returnValue;
    }

    @Override
    public PermPackageList getDimPermSet(Long dimensionId) {
        long startTime = System.currentTimeMillis();
        PermPackageList returnValue = (PermPackageList)ThreadCache.get((Object)Joiner.on((String)"#").join((Object)PermCacheKey.GET_DIM_PERM_SET, (Object)this.modelId, new Object[]{dimensionId}), () -> this.getDimPermSetFromLocal(dimensionId));
        PermissionServiceImpl.printLog(startTime, "getDimPermSet", returnValue, this.modelId, dimensionId);
        return returnValue;
    }

    private PermPackageList getDimPermSetFromLocal(Long dimensionId) {
        Map<Long, Integer> records = this.getRecords(dimensionId);
        int defaultPerm = this.getDefaultPerm(dimensionId);
        DynamicObject dim = MemberReader.getDimensionDynById((long)dimensionId);
        String entityName = "";
        if (Objects.nonNull(dim)) {
            entityName = dim.getString("membermodel");
        }
        PermPackageList returnValue = new PermPackageList(this.modelId);
        returnValue.setDefaultPerm(PermEnum.getPermTypeByVal((int)defaultPerm));
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        for (PermEnum value : PermEnum.values()) {
            if (value.getValue() == defaultPerm) continue;
            map.put(value.getValue(), Sets.newHashSetWithExpectedSize((int)16));
        }
        for (Map.Entry entry : records.entrySet()) {
            Set ids = (Set)map.get(entry.getValue());
            if (Objects.isNull(ids)) continue;
            ids.add(entry.getKey());
            this.addShareMember(this.modelId, entityName, ids, (Long)entry.getKey());
        }
        for (Map.Entry entry : map.entrySet()) {
            PermPackage permPackage = new PermPackage();
            permPackage.setPerm(PermEnum.getPermTypeByVal((int)((Integer)entry.getKey())));
            permPackage.setPermSet((Set)entry.getValue());
            returnValue.getList().add(permPackage);
        }
        this.addSpecialAccount(returnValue, entityName, this.modelId, dimensionId);
        return returnValue;
    }

    private void addSpecialAccount(PermPackageList returnValue, String entityName, Long modelId, Long dimensionId) {
        String dimNum;
        boolean isAccount = Objects.equals(DimEntityNumEnum.ACCOUNT.getEntityNum(), entityName);
        if (!isAccount) {
            return;
        }
        if (Objects.equals(returnValue.getDefaultPerm(), PermEnum.READWRITE)) {
            return;
        }
        Optional<PermPackage> readWriteOpt = returnValue.getList().stream().filter(t -> Objects.equals(t.perm, PermEnum.READWRITE)).findFirst();
        if (!readWriteOpt.isPresent()) {
            return;
        }
        PermPackage permPackage = readWriteOpt.get();
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode memberByNumber = MemberReader.findMemberByNumber((String)modelNumber, (String)(dimNum = MemberReader.getDimensionNumById((long)dimensionId)), (String)"ExchangeRate");
        if (Objects.equals(memberByNumber, IDNumberTreeNode.NotFoundTreeNode)) {
            return;
        }
        Set<Long> permSet = permPackage.getPermSet();
        permSet.add(memberByNumber.getId());
        permSet.addAll(memberByNumber.getShareNodes().stream().map(IDNumberTreeNode::getId).collect(Collectors.toSet()));
        List allChildren = memberByNumber.getAllChildren(2);
        for (IDNumberTreeNode allChild : allChildren) {
            if (allChild.isShare()) continue;
            permSet.add(allChild.getId());
            permSet.addAll(allChild.getShareNodes().stream().map(IDNumberTreeNode::getId).collect(Collectors.toSet()));
        }
    }

    private Map<Long, Integer> getRecords(Long dimensionId) {
        return (Map)ThreadCache.get((Object)Joiner.on((String)"#").join((Object)PermCacheKey.PERM_RECORD, (Object)this.modelId, new Object[]{dimensionId}), () -> {
            DynamicObject dim = MemberReader.getDimensionDynById((long)dimensionId);
            if (Objects.isNull(dim)) {
                return Collections.emptyMap();
            }
            String entityName = dim.getString("membermodel");
            Map<Long, Integer> memberPerm = this.getMemberPerm(this.modelId, dimensionId, entityName);
            Map<Long, Integer> permClass = this.getPermClass(this.modelId, entityName);
            HashMap permRecords = Maps.newHashMapWithExpectedSize((int)(memberPerm.size() + permClass.size()));
            this.buildPerm(permClass, (Map<Long, Integer>)permRecords, this.modelId, entityName);
            this.buildPerm(memberPerm, (Map<Long, Integer>)permRecords, this.modelId, entityName);
            return permRecords;
        });
    }

    @Override
    public boolean isAllReadOrWritePerm(Long dimensionId, String entityName, Collection<Long> memberIds) {
        long startTime = System.currentTimeMillis();
        boolean returnValue = this.matchPerm(this.modelId, dimensionId, entityName, memberIds, Sets.newHashSet((Object[])new PermEnum[]{PermEnum.READONLY, PermEnum.READWRITE}));
        PermissionServiceImpl.printLog(startTime, "isAllReadOrWritePerm", returnValue, this.modelId, dimensionId, memberIds);
        return returnValue;
    }

    @Override
    public boolean isAllNoOrReadPerm(Long dimensionId, String entityName, Collection<Long> memberIds) {
        long startTime = System.currentTimeMillis();
        boolean returnValue = this.matchPerm(this.modelId, dimensionId, entityName, memberIds, Sets.newHashSet((Object[])new PermEnum[]{PermEnum.READONLY, PermEnum.NOPERM}));
        PermissionServiceImpl.printLog(startTime, "isAllNoOrReadPerm", returnValue, this.modelId, dimensionId, memberIds);
        return returnValue;
    }

    @Override
    public Set<Long> matchNoPermMembers(Long dimensionId, String entityName, Collection<Long> memberIds) {
        long startTime = System.currentTimeMillis();
        Set<Long> returnValue = this.getMatchMembers(this.modelId, dimensionId, entityName, memberIds, Collections.singletonList(PermEnum.NOPERM));
        PermissionServiceImpl.printLog(startTime, "matchNoPermMembers", returnValue, this.modelId, dimensionId, memberIds);
        return returnValue;
    }

    @Override
    public Set<Long> matchReadPermMembers(Long dimensionId, String entityName, Collection<Long> memberIds) {
        long startTime = System.currentTimeMillis();
        Set<Long> returnValue = this.getMatchMembers(this.modelId, dimensionId, entityName, memberIds, Collections.singletonList(PermEnum.READONLY));
        PermissionServiceImpl.printLog(startTime, "matchReadPermMembers", returnValue, this.modelId, dimensionId, memberIds);
        return returnValue;
    }

    @Override
    public Set<Long> matchWritePermMembers(Long dimensionId, String entityName, Collection<Long> memberIds) {
        long startTime = System.currentTimeMillis();
        Set<Long> returnValue = this.getMatchMembers(this.modelId, dimensionId, entityName, memberIds, Collections.singletonList(PermEnum.READWRITE));
        PermissionServiceImpl.printLog(startTime, "matchWritePermMembers", returnValue, this.modelId, dimensionId, memberIds);
        return returnValue;
    }

    @Override
    public Set<Long> matchReadOrWritePermMembers(Long dimensionId, String entityName, Collection<Long> memberIds) {
        long startTime = System.currentTimeMillis();
        Set<Long> returnValue = this.getMatchMembers(this.modelId, dimensionId, entityName, memberIds, Lists.newArrayList((Object[])new PermEnum[]{PermEnum.READONLY, PermEnum.READWRITE}));
        PermissionServiceImpl.printLog(startTime, "matchReadOrWritePermMembers", returnValue, this.modelId, dimensionId, memberIds);
        return returnValue;
    }

    @Override
    public Set<Long> matchNoOrReadPermMembers(Long dimensionId, String entityName, Collection<Long> memberIds) {
        long startTime = System.currentTimeMillis();
        Set<Long> returnValue = this.getMatchMembers(this.modelId, dimensionId, entityName, memberIds, Lists.newArrayList((Object[])new PermEnum[]{PermEnum.READONLY, PermEnum.NOPERM}));
        PermissionServiceImpl.printLog(startTime, "matchNoOrReadPermMembers", returnValue, this.modelId, dimensionId, memberIds);
        return returnValue;
    }

    @Override
    public QFilter getNoPermFilter(Long dimensionId, String entityName, String filterKey) {
        long startTime = System.currentTimeMillis();
        QFilter returnValue = this.getFilters(this.modelId, dimensionId, entityName, filterKey, Collections.singletonList(PermEnum.NOPERM));
        returnValue.and("status", "!=", (Object)"A");
        PermissionServiceImpl.printLog(startTime, "getNoPermFilter", returnValue, this.modelId, dimensionId);
        return returnValue;
    }

    @Override
    public QFilter getReadPermFilter(Long dimensionId, String entityName, String filterKey) {
        long startTime = System.currentTimeMillis();
        QFilter returnValue = this.getFilters(this.modelId, dimensionId, entityName, filterKey, Collections.singletonList(PermEnum.READONLY));
        PermissionServiceImpl.printLog(startTime, "getReadPermFilter", returnValue, this.modelId, dimensionId);
        return returnValue;
    }

    @Override
    public QFilter getWritePermFilter(Long dimensionId, String entityName, String filterKey) {
        long startTime = System.currentTimeMillis();
        QFilter returnValue = this.getFilters(this.modelId, dimensionId, entityName, filterKey, Collections.singletonList(PermEnum.READWRITE));
        PermissionServiceImpl.printLog(startTime, "getWritePermFilter", returnValue, this.modelId, dimensionId);
        return returnValue;
    }

    @Override
    public QFilter getReadOrWritePermFilter(Long dimensionId, String entityName, String filterKey) {
        long startTime = System.currentTimeMillis();
        QFilter returnValue = this.getFilters(this.modelId, dimensionId, entityName, filterKey, Lists.newArrayList((Object[])new PermEnum[]{PermEnum.READONLY, PermEnum.READWRITE}));
        PermissionServiceImpl.printLog(startTime, "getReadOrWritePermFilter", returnValue, this.modelId, dimensionId);
        return returnValue;
    }

    @Override
    public QFilter getHasPermFilterIncludeIds(Long dimensionId, String filterKey, Set<Long> includeIds) {
        long startTime = System.currentTimeMillis();
        QFilter returnValue = this.getHasPermFilterIncludeIdsFromCache(dimensionId, filterKey, includeIds);
        PermissionServiceImpl.printLog(startTime, "getHasPermFilterIncludeIds", returnValue, this.modelId, dimensionId, filterKey, includeIds);
        return returnValue;
    }

    public QFilter getHasPermFilterIncludeIdsFromCache(Long dimensionId, String filterKey, Set<Long> includeIds) {
        String longKey = Joiner.on((String)"#").join((Object)PermCacheKey.GET_FILTERS_INCLUDE_IDS, (Object)this.modelId, new Object[]{dimensionId, includeIds});
        String md5Key = StringUtils.stringToMD5((String)longKey);
        Object value = ThreadCache.get((Object)md5Key, () -> this.getHasPermIncludeIdsFromCache(dimensionId, includeIds));
        if (value instanceof QFilter) {
            return (QFilter)value;
        }
        Pair newPair = (Pair)value;
        return new QFilter(filterKey, (String)newPair.p1, newPair.p2);
    }

    private Object getHasPermIncludeIdsFromCache(Long dimensionId, Set<Long> includeIds) {
        String qcp;
        if (this.isAdmin()) {
            return this.getAllMemberFilter();
        }
        DynamicObject dim = MemberReader.getDimensionDynById((long)dimensionId);
        if (Objects.isNull(dim)) {
            return this.getNoneMemberFilter();
        }
        String entityName = dim.getString("membermodel");
        HashSet ids = Sets.newHashSet();
        int defaultPerm = this.getDefaultPerm(dimensionId);
        Map<Long, Integer> records = this.getRecords(dimensionId);
        if (Objects.equals(defaultPerm, PermEnum.NOPERM.getValue())) {
            for (Map.Entry<Long, Integer> entry : records.entrySet()) {
                if (entry.getValue().intValue() == PermEnum.NOPERM.getValue()) continue;
                ids.add(entry.getKey());
                this.addShareMember(this.modelId, entityName, ids, entry.getKey());
            }
            this.addSpecialAccount(ids, dimensionId);
            ids.addAll(includeIds);
            qcp = "in";
        } else {
            for (Map.Entry<Long, Integer> entry : records.entrySet()) {
                if (entry.getValue().intValue() != PermEnum.NOPERM.getValue()) continue;
                ids.add(entry.getKey());
                this.addShareMember(this.modelId, entityName, ids, entry.getKey());
            }
            ids.removeAll(includeIds);
            qcp = "not in";
        }
        return new Pair((Object)qcp, (Object)ids);
    }

    private void addSpecialAccount(Set<Long> ids, Long dimensionId) {
        String dimNum;
        DynamicObject dim = MemberReader.getDimensionDynById((long)dimensionId);
        if (Objects.isNull(dim)) {
            return;
        }
        String entityName = dim.getString("membermodel");
        boolean isAccount = Objects.equals(DimEntityNumEnum.ACCOUNT.getEntityNum(), entityName);
        if (!isAccount) {
            return;
        }
        String modelNumber = MemberReader.findModelNumberById((Object)this.modelId);
        IDNumberTreeNode memberByNumber = MemberReader.findMemberByNumber((String)modelNumber, (String)(dimNum = dim.getString("number")), (String)"ExchangeRate");
        if (Objects.equals(memberByNumber, IDNumberTreeNode.NotFoundTreeNode)) {
            return;
        }
        ids.add(memberByNumber.getId());
        ids.addAll(memberByNumber.getShareNodes().stream().map(IDNumberTreeNode::getId).collect(Collectors.toSet()));
        List allChildren = memberByNumber.getAllChildren(2);
        for (IDNumberTreeNode allChild : allChildren) {
            if (allChild.isShare()) continue;
            ids.add(allChild.getId());
            ids.addAll(allChild.getShareNodes().stream().map(IDNumberTreeNode::getId).collect(Collectors.toSet()));
        }
    }

    @Override
    public QFilter getNoOrReadPermFilter(Long dimensionId, String entityName, String filterKey) {
        long startTime = System.currentTimeMillis();
        QFilter returnValue = this.getFilters(this.modelId, dimensionId, entityName, filterKey, Lists.newArrayList((Object[])new PermEnum[]{PermEnum.READONLY, PermEnum.NOPERM}));
        PermissionServiceImpl.printLog(startTime, "getNoOrReadPermFilter", returnValue, this.modelId, dimensionId);
        return returnValue;
    }

    @Override
    public Set<String> matchNoPermMembersByNum(Long dimensionId, String entityName, Collection<String> memberNums) {
        long startTime = System.currentTimeMillis();
        Set<String> returnValue = this.getMatchMembersByNum(this.modelId, dimensionId, entityName, memberNums, Collections.singletonList(PermEnum.NOPERM));
        PermissionServiceImpl.printLog(startTime, "matchNoPermMembersByNum", returnValue, this.modelId, dimensionId, memberNums);
        return returnValue;
    }

    @Override
    public Set<String> matchReadPermMembersByNum(Long dimensionId, String entityName, Collection<String> memberNums) {
        long startTime = System.currentTimeMillis();
        Set<String> returnValue = this.getMatchMembersByNum(this.modelId, dimensionId, entityName, memberNums, Collections.singletonList(PermEnum.READONLY));
        PermissionServiceImpl.printLog(startTime, "matchReadPermMembersByNum", returnValue, this.modelId, dimensionId, memberNums);
        return returnValue;
    }

    @Override
    public Set<String> matchWritePermMembersByNum(Long dimensionId, String entityName, Collection<String> memberNums) {
        long startTime = System.currentTimeMillis();
        Set<String> returnValue = this.getMatchMembersByNum(this.modelId, dimensionId, entityName, memberNums, Collections.singletonList(PermEnum.READWRITE));
        PermissionServiceImpl.printLog(startTime, "matchWritePermMembersByNum", returnValue, this.modelId, dimensionId, memberNums);
        return returnValue;
    }

    @Override
    public Set<String> matchReadOrWritePermMembersByNum(Long dimensionId, String entityName, Collection<String> memberNums) {
        long startTime = System.currentTimeMillis();
        Set<String> returnValue = this.getMatchMembersByNum(this.modelId, dimensionId, entityName, memberNums, Lists.newArrayList((Object[])new PermEnum[]{PermEnum.READONLY, PermEnum.READWRITE}));
        PermissionServiceImpl.printLog(startTime, "matchReadOrWritePermMembersByNum", returnValue, this.modelId, dimensionId, memberNums);
        return returnValue;
    }

    @Override
    public Set<String> matchNoOrReadPermMembersByNum(Long dimensionId, String entityName, Collection<String> memberNums) {
        long startTime = System.currentTimeMillis();
        Set<String> returnValue = this.getMatchMembersByNum(this.modelId, dimensionId, entityName, memberNums, Lists.newArrayList((Object[])new PermEnum[]{PermEnum.READONLY, PermEnum.NOPERM}));
        PermissionServiceImpl.printLog(startTime, "matchNoOrReadPermMembersByNum", returnValue, this.modelId, dimensionId, memberNums);
        return returnValue;
    }

    @Override
    public boolean existsNoPermMember(Long dimensionId) {
        long startTime = System.currentTimeMillis();
        boolean returnValue = (Boolean)ThreadCache.get((Object)Joiner.on((String)"#").join((Object)PermCacheKey.EXISTS_NO_PERM_MEMBER, (Object)this.modelId, new Object[]{dimensionId}), () -> this.existsNoPermMemberFormCache(dimensionId));
        PermissionServiceImpl.printLog(startTime, "existsNoPermMember", returnValue, this.modelId, dimensionId);
        return returnValue;
    }

    private boolean existsNoPermMemberFormCache(Long dimensionId) {
        if (this.isAdmin()) {
            return false;
        }
        int defaultPerm = this.getDefaultPerm(dimensionId);
        if (Objects.equals(PermEnum.NOPERM.getValue(), defaultPerm)) {
            return true;
        }
        String entityName = DimEntityNumEnum.getEntieyNumByNumber((String)MemberReader.getDimensionNumById((long)dimensionId));
        Map<Long, Integer> memberPerm = this.getMemberPerm(this.modelId, dimensionId, entityName);
        if (memberPerm.containsValue(PermEnum.NOPERM.getValue())) {
            return true;
        }
        Map<Long, Integer> permClass = this.getPermClass(this.modelId, entityName);
        return permClass.containsValue(PermEnum.NOPERM.getValue());
    }

    private boolean matchPerm(Long modelId, Long dimensionId, String entityName, Collection<Long> memberIds, Set<PermEnum> permEnum) {
        String longKey = Joiner.on((String)"#").join((Object)PermCacheKey.MATCH_PERM, permEnum.stream().map(PermEnum::getName).collect(Collectors.toList()), new Object[]{modelId, dimensionId, entityName, memberIds});
        String md5Key = StringUtils.stringToMD5((String)longKey);
        return (Boolean)ThreadCache.get((Object)md5Key, () -> this.matchPermFromLocal(modelId, dimensionId, entityName, memberIds, permEnum));
    }

    private Collection<Long> getBaseMemberIds(Long modelId, String entityName, Collection<Long> memberIds) {
        HashSet returnIds = Sets.newHashSetWithExpectedSize((int)memberIds.size());
        for (Long memberId : memberIds) {
            IDNumberTreeNode member = MemberReader.findMemberById((long)modelId, (String)entityName, (Long)memberId);
            if (Objects.equals(IDNumberTreeNode.NotFoundTreeNode, member)) continue;
            Long storageId = member.isShare() ? member.getCopyfromId() : memberId;
            returnIds.add(storageId);
        }
        return returnIds;
    }

    private boolean matchPermFromLocal(Long modelId, Long dimensionId, String entityName, Collection<Long> memberIds, Set<PermEnum> permEnum) {
        if (this.isAdmin()) {
            return permEnum.contains(PermEnum.READWRITE);
        }
        HashMap permRecords = Maps.newHashMapWithExpectedSize((int)memberIds.size());
        Map<Long, Integer> memberPerm = this.getMemberPerm(modelId, dimensionId, entityName);
        Map<Long, Integer> permClass = memberIds.size() > MAX_SELECT_IN_COUNT ? this.getPermClass(modelId, entityName) : this.getPermClass(modelId, entityName, this.getBaseMemberIds(modelId, entityName, memberIds));
        boolean isAccount = Objects.equals(DimEntityNumEnum.ACCOUNT.getEntityNum(), entityName);
        for (Long memberId : memberIds) {
            Boolean specialPerm;
            IDNumberTreeNode member = MemberReader.findMemberById((long)modelId, (String)entityName, (Long)memberId);
            if (Objects.equals(IDNumberTreeNode.NotFoundTreeNode, member)) {
                return false;
            }
            if (isAccount && Objects.nonNull(specialPerm = this.getSpecialAccountPerm(entityName, member, permEnum))) {
                return specialPerm;
            }
            Long storageId = member.isShare() ? member.getCopyfromId() : memberId;
            this.buildPerm((Map<Long, Integer>)permRecords, memberPerm, storageId, memberId);
            this.buildPerm((Map<Long, Integer>)permRecords, permClass, storageId, memberId);
        }
        if (!permEnum.stream().map(PermEnum::getValue).collect(Collectors.toSet()).containsAll(permRecords.values())) {
            return false;
        }
        if (Objects.equals(permRecords.size(), memberIds.size())) {
            return true;
        }
        int defaultPerm = this.getDefaultPerm(dimensionId);
        return permEnum.stream().anyMatch(perm -> Objects.equals(perm.getValue(), defaultPerm));
    }

    private static void printLog(Object ... params) {
        if (!ConfigServiceHelper.getGlobalBoolParam("isPEnablePermTime")) {
            return;
        }
        if (Objects.isNull(params) || params.length < 3) {
            return;
        }
        long endTime = System.currentTimeMillis();
        long startTime = (Long)params[0];
        StringJoiner stringJoiner = new StringJoiner(" # ");
        stringJoiner.add(String.valueOf(endTime - startTime));
        for (int i = 1; i < params.length; ++i) {
            stringJoiner.add(JSON.toJSONString((Object)params[i]));
        }
        String logStr = stringJoiner.toString();
        if (logStr.length() > 5000) {
            logStr = logStr.substring(0, 5000);
        }
        log.info(logStr);
    }

    private void buildPerm(Map<Long, Integer> permRecords, Map<Long, Integer> memberPerm, Long storageId, Long id) {
        Integer perm = memberPerm.get(storageId);
        if (Objects.isNull(perm)) {
            return;
        }
        permRecords.compute(id, (k, v) -> {
            if (v == null) {
                return perm;
            }
            return Math.max(perm, v);
        });
    }

    private void buildPermByNumber(Map<String, Integer> permRecords, Map<Long, Integer> memberPerm, Long storageId, String number) {
        Integer perm = memberPerm.get(storageId);
        if (Objects.isNull(perm)) {
            return;
        }
        permRecords.compute(number, (k, v) -> {
            if (v == null) {
                return perm;
            }
            return Math.max(perm, v);
        });
    }

    private void buildPerm(Map<Long, Integer> perms, Map<Long, Integer> permRecords, Long modelId, String entityName) {
        boolean isAccount = Objects.equals(DimEntityNumEnum.ACCOUNT.getEntityNum(), entityName);
        for (Map.Entry<Long, Integer> entry : perms.entrySet()) {
            IDNumberTreeNode member = MemberReader.findMemberById((long)modelId, (String)entityName, (Long)entry.getKey());
            if (Objects.equals(IDNumberTreeNode.NotFoundTreeNode, member)) continue;
            if (isAccount && this.isRate(member)) {
                permRecords.put(entry.getKey(), PermEnum.READWRITE.getValue());
                continue;
            }
            permRecords.compute(entry.getKey(), (k, v) -> {
                if (v == null) {
                    return (Integer)entry.getValue();
                }
                return Math.max((Integer)entry.getValue(), v);
            });
        }
    }

    private QFilter getFilters(Long modelId, Long dimensionId, String entityName, String filterKey, List<PermEnum> permEnum) {
        String longKey = Joiner.on((String)"#").join((Object)PermCacheKey.GET_FILTERS, permEnum.stream().map(PermEnum::getName).collect(Collectors.toList()), new Object[]{modelId, dimensionId, entityName});
        String md5Key = StringUtils.stringToMD5((String)longKey);
        Object value = ThreadCache.get((Object)md5Key, () -> this.getFiltersFromLocal(modelId, dimensionId, entityName, permEnum));
        if (value instanceof QFilter) {
            return (QFilter)value;
        }
        Pair newPair = (Pair)value;
        return new QFilter(filterKey, (String)newPair.p1, newPair.p2);
    }

    private Object getFiltersFromLocal(Long modelId, Long dimensionId, String entityName, List<PermEnum> permEnum) {
        if (this.isAdmin()) {
            if (permEnum.contains(PermEnum.READWRITE)) {
                return this.getAllMemberFilter();
            }
            return this.getNoneMemberFilter();
        }
        int defaultPerm = this.getDefaultPerm(dimensionId);
        HashMap permRecords = Maps.newHashMap();
        Map<Long, Integer> memberPerm = this.getMemberPerm(modelId, dimensionId, entityName);
        Map<Long, Integer> permClass = this.getPermClass(modelId, entityName);
        if (CollectionUtils.isEmpty(memberPerm) && CollectionUtils.isEmpty(permClass)) {
            if (permEnum.stream().anyMatch(perm -> Objects.equals(perm.getValue(), defaultPerm))) {
                return this.getAllMemberFilter();
            }
            return this.getNoneMemberFilter();
        }
        this.buildPerm(memberPerm, (Map<Long, Integer>)permRecords, modelId, entityName);
        this.buildPerm(permClass, (Map<Long, Integer>)permRecords, modelId, entityName);
        HashSet returnSet = Sets.newHashSet();
        if (permEnum.stream().anyMatch(perm -> Objects.equals(perm.getValue(), defaultPerm))) {
            Set needPerms = permEnum.stream().map(PermEnum::getValue).collect(Collectors.toSet());
            if (needPerms.containsAll(permRecords.values())) {
                return this.getAllMemberFilter();
            }
            for (Map.Entry entry : permRecords.entrySet()) {
                if (!permEnum.stream().noneMatch(perm -> Objects.equals(perm.getValue(), entry.getValue()))) continue;
                returnSet.add(entry.getKey());
                this.addShareMember(modelId, entityName, returnSet, (Long)entry.getKey());
            }
            return new Pair((Object)"not in", (Object)returnSet);
        }
        for (Map.Entry entry : permRecords.entrySet()) {
            if (!permEnum.stream().anyMatch(perm -> Objects.equals(perm.getValue(), entry.getValue()))) continue;
            returnSet.add(entry.getKey());
            this.addShareMember(modelId, entityName, returnSet, (Long)entry.getKey());
        }
        return new Pair((Object)"in", (Object)returnSet);
    }

    private QFilter getAllMemberFilter() {
        return new QFilter("1", "=", (Object)1);
    }

    private QFilter getNoneMemberFilter() {
        return new QFilter("1", "=", (Object)2);
    }

    private void addShareMember(Long modelId, String entityName, Set<Long> returnList, Long memberId) {
        IDNumberTreeNode member = MemberReader.findMemberById((long)modelId, (String)entityName, (Long)memberId);
        if (CollectionUtils.isEmpty((Collection)member.getShareNodes())) {
            return;
        }
        returnList.addAll(member.getShareNodes().stream().map(IDNumberTreeNode::getId).collect(Collectors.toSet()));
    }

    private Set<String> getMatchMembersByNum(Long modelId, Long dimensionId, String entityName, Collection<String> memberNums, List<PermEnum> permEnum) {
        if (this.isAdmin()) {
            if (permEnum.contains(PermEnum.READWRITE)) {
                if (memberNums instanceof Set) {
                    return (Set)memberNums;
                }
                return Sets.newHashSet(memberNums);
            }
            return Collections.emptySet();
        }
        IPermHandler strategy = PermHandlerStrategy.getStrategy(permEnum);
        return strategy.getMatchMembersByNum(modelId, dimensionId, entityName, this.getRecords(dimensionId), memberNums, this.getDefaultPerm(dimensionId));
    }

    private Set<Long> getMatchMembers(Long modelId, Long dimensionId, String entityName, Collection<Long> memberIds, List<PermEnum> permEnum) {
        String longKey = Joiner.on((String)"#").join((Object)PermCacheKey.GET_MATCH_MEMBERS, permEnum.stream().map(PermEnum::getName).collect(Collectors.toList()), new Object[]{modelId, dimensionId, entityName, memberIds});
        String md5Key = StringUtils.stringToMD5((String)longKey);
        return (Set)ThreadCache.get((Object)md5Key, () -> this.getMatchMembersFromLocal(modelId, dimensionId, entityName, memberIds, permEnum));
    }

    private Set<Long> getMatchMembersFromLocal(Long modelId, Long dimensionId, String entityName, Collection<Long> memberIds, List<PermEnum> permEnum) {
        if (this.isAdmin()) {
            if (permEnum.contains(PermEnum.READWRITE)) {
                if (memberIds instanceof Set) {
                    return (Set)memberIds;
                }
                return Sets.newHashSet(memberIds);
            }
            return Collections.emptySet();
        }
        IPermHandler strategy = PermHandlerStrategy.getStrategy(permEnum);
        return strategy.getMatchMembers(modelId, dimensionId, entityName, this.getRecords(dimensionId), memberIds, this.getDefaultPerm(dimensionId));
    }

    private Map<Long, Integer> getMemberPerm(Long modelId, Long dimensionId, String entityName) {
        return new MemberPermSpreadLogic().getDistributeMemberPerm(entityName, dimensionId, modelId, RequestContext.get().getCurrUserId());
    }

    private Map<Long, Integer> getPermClass(Long modelId, String entityName) {
        ArrayListMultimap<String, Long> permissionMapBatch = PermClassEntityHelper.getPermissionMapBatch(entityName, String.valueOf(modelId), String.valueOf(RequestContext.get().getCurrUserId()));
        HashMap returnMap = Maps.newHashMap();
        permissionMapBatch.forEach((k, v) -> returnMap.put(v, 4 - Integer.parseInt(k)));
        return returnMap;
    }

    private Map<Long, Integer> getPermClass(Long modelId, String entityName, Collection<Long> memberIds) {
        ArrayListMultimap<String, Long> permissionMapBatch = PermClassEntityHelper.getPermissionMapBatch(entityName, String.valueOf(modelId), String.valueOf(RequestContext.get().getCurrUserId()), Lists.newArrayList(memberIds));
        HashMap returnMap = Maps.newHashMap();
        permissionMapBatch.forEach((k, v) -> returnMap.put(v, 4 - Integer.parseInt(k)));
        return returnMap;
    }

    private boolean isRate(IDNumberTreeNode member) {
        return Objects.equals("ExchangeRate", member.getNumber()) || Objects.nonNull(member.getParent()) && Objects.equals("ExchangeRate", member.getParent().getNumber());
    }

    @Override
    public boolean isAdmin() {
        if (!LongUtil.isvalidLong((Object)this.modelId)) {
            return Boolean.FALSE;
        }
        long userId = RequestContext.get().getCurrUserId();
        return (Boolean)ThreadCache.get((Object)Joiner.on((char)'-').join((Object)PermCacheKey.CHECK_ADMIN, (Object)this.modelId, new Object[]{userId}), () -> {
            Set<Long> groupIds = UserDistributeServiceHelper.queryAllGroupByUserId(RequestContext.get().getCurrUserId());
            groupIds.add(RequestContext.get().getCurrUserId());
            QFilter filter1 = new QFilter("model", "=", (Object)this.modelId);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"MemberPermSpreadLogic.ifUserHasRootPermByModel", (String)"bcm_modelperm", (String)"id,modelpermentry.eusers.id", (QFilter[])new QFilter[]{filter1}, null);){
                for (Row row : ds) {
                    if (!groupIds.contains(row.getLong("modelpermentry.eusers.id"))) continue;
                    Boolean bl = true;
                    return bl;
                }
            }
            return false;
        });
    }

    private int getDefaultPerm(Long dimensionId) {
        return (Integer)ThreadCache.get((Object)Joiner.on((char)'_').join((Object)PermCacheKey.DEFAULT_PERM, (Object)dimensionId, new Object[0]), () -> new MemberPermSpreadLogic().getDefaultPermValue(dimensionId));
    }

    @Override
    public boolean memberCanShow(Long dimensionId, Long memberId, Map<Long, List<Long>> relationMap) {
        if (this.hasWriteOrReadPerm(dimensionId, memberId)) {
            return true;
        }
        if (relationMap.get(memberId) != null) {
            for (long id : relationMap.get(memberId)) {
                if (!this.memberCanShow(dimensionId, id, relationMap)) continue;
                return true;
            }
        }
        return false;
    }
}

