/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.permission.perm.strategy;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;

public interface IPermHandler {
    public Set<String> getMatchMembersByNum(Long var1, Long var2, String var3, Map<Long, Integer> var4, Collection<String> var5, Integer var6);

    public Set<Long> getMatchMembers(Long var1, Long var2, String var3, Map<Long, Integer> var4, Collection<Long> var5, Integer var6);

    default public boolean isEntity(String entityName) {
        return Objects.equals("bcm_entitymembertree", entityName);
    }

    default public Set<Long> removeAllIds(Collection<Long> memberIds, Set<Long> ids) {
        HashSet newMemberIds = Sets.newHashSet(memberIds);
        newMemberIds.removeAll(ids);
        return newMemberIds;
    }

    default public Set<String> removeAllNums(Collection<String> memberNums, Set<String> nums, String entityName) {
        boolean isEntity = this.isEntity(entityName);
        return memberNums.stream().filter(t -> {
            if (isEntity && t.contains("_")) {
                String[] s1 = t.split("_");
                return !nums.contains(s1[s1.length - 1]);
            }
            return !nums.contains(t);
        }).collect(Collectors.toSet());
    }

    default public Set<String> retainAllNums(Collection<String> memberNums, Set<String> nums, String entityName) {
        boolean isEntity = this.isEntity(entityName);
        return memberNums.stream().filter(t -> {
            if (isEntity && t.contains("_")) {
                String[] s1 = t.split("_");
                return nums.contains(s1[s1.length - 1]);
            }
            return nums.contains(t);
        }).collect(Collectors.toSet());
    }

    default public void addSpecialAccountNumber(Set<String> numbers, Long modelId, Long dimId, String entityName) {
        String dimNum;
        boolean isAccount = Objects.equals(DimEntityNumEnum.ACCOUNT.getEntityNum(), entityName);
        if (!isAccount) {
            return;
        }
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode memberByNumber = MemberReader.findMemberByNumber((String)modelNumber, (String)(dimNum = MemberReader.getDimensionNumById((long)dimId)), (String)"ExchangeRate");
        if (Objects.equals(memberByNumber, IDNumberTreeNode.NotFoundTreeNode)) {
            return;
        }
        numbers.add(memberByNumber.getNumber());
        List allChildren = memberByNumber.getAllChildren(2);
        for (IDNumberTreeNode allChild : allChildren) {
            if (allChild.isShare()) continue;
            numbers.add(allChild.getNumber());
        }
    }

    default public void addSpecialAccountId(Set<Long> ids, Long modelId, Long dimId, String entityName) {
        String dimNum;
        boolean isAccount = Objects.equals(DimEntityNumEnum.ACCOUNT.getEntityNum(), entityName);
        if (!isAccount) {
            return;
        }
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode memberByNumber = MemberReader.findMemberByNumber((String)modelNumber, (String)(dimNum = MemberReader.getDimensionNumById((long)dimId)), (String)"ExchangeRate");
        if (Objects.equals(memberByNumber, IDNumberTreeNode.NotFoundTreeNode)) {
            return;
        }
        ids.add(memberByNumber.getId());
        ids.addAll(memberByNumber.getShareNodes().stream().map(IDNumberTreeNode::getId).collect(Collectors.toSet()));
        List allChildren = memberByNumber.getAllChildren(2);
        for (IDNumberTreeNode allChild : allChildren) {
            if (allChild.isShare()) continue;
            ids.add(allChild.getId());
            ids.addAll(allChild.getShareNodes().stream().map(IDNumberTreeNode::getId).collect(Collectors.toSet()));
        }
    }
}

