/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.permission.perm.strategy;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.permission.perm.strategy.IPermHandler;
import kd.fi.bcm.business.permission.perm.strategy.NoAndReadPermHandler;
import kd.fi.bcm.business.permission.perm.strategy.NoPermHandler;
import kd.fi.bcm.business.permission.perm.strategy.ReadAndWritePermHandler;
import kd.fi.bcm.business.permission.perm.strategy.ReadPermHandler;
import kd.fi.bcm.business.permission.perm.strategy.WritePermHandler;
import kd.fi.bcm.common.enums.PermEnum;

public class PermHandlerStrategy {
    private static final Map<String, IPermHandler> permMap = new ImmutableMap.Builder().put((Object)String.valueOf(PermEnum.NOPERM.getValue()), (Object)new NoPermHandler()).put((Object)String.valueOf(PermEnum.READONLY.getValue()), (Object)new ReadPermHandler()).put((Object)String.valueOf(PermEnum.READWRITE.getValue()), (Object)new WritePermHandler()).put((Object)Lists.newArrayList((Object[])new PermEnum[]{PermEnum.NOPERM, PermEnum.READONLY}).stream().map(t -> String.valueOf(t.getValue())).collect(Collectors.joining("#")), (Object)new NoAndReadPermHandler()).put((Object)Lists.newArrayList((Object[])new PermEnum[]{PermEnum.READONLY, PermEnum.READWRITE}).stream().map(t -> String.valueOf(t.getValue())).collect(Collectors.joining("#")), (Object)new ReadAndWritePermHandler()).build();

    public static IPermHandler getStrategy(List<PermEnum> permEnum) {
        String key = permEnum.stream().sorted(new Comparator<PermEnum>(){

            @Override
            public int compare(PermEnum o1, PermEnum o2) {
                return o2.getValue() - o1.getValue();
            }
        }).map(t -> String.valueOf(t.getValue())).collect(Collectors.joining("#"));
        IPermHandler iPermHandler = permMap.get(key);
        if (Objects.isNull(iPermHandler)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u6743\u9650\u7c7b\u578b\u3002", (String)"PermHandlerStrategy_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return iPermHandler;
    }
}

