/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.permission.perm.strategy;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.fi.bcm.business.permission.perm.strategy.IPermHandler;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.PermEnum;

public class ReadAndWritePermHandler
implements IPermHandler {
    @Override
    public Set<String> getMatchMembersByNum(Long modelId, Long dimId, String entityName, Map<Long, Integer> records, Collection<String> memberNums, Integer defaultPerm) {
        HashSet sets = Sets.newHashSetWithExpectedSize((int)memberNums.size());
        if (PermEnum.NOPERM.getValue() == defaultPerm.intValue()) {
            for (Map.Entry<Long, Integer> entry : records.entrySet()) {
                if (PermEnum.NOPERM.getValue() == entry.getValue().intValue()) continue;
                IDNumberTreeNode member = MemberReader.findMemberById((long)modelId, (String)entityName, (Long)entry.getKey());
                sets.add(member.getNumber());
            }
            this.addSpecialAccountNumber(sets, modelId, dimId, entityName);
            return this.retainAllNums(memberNums, sets, entityName);
        }
        for (Map.Entry<Long, Integer> entry : records.entrySet()) {
            if (PermEnum.NOPERM.getValue() != entry.getValue().intValue()) continue;
            IDNumberTreeNode member = MemberReader.findMemberById((long)modelId, (String)entityName, (Long)entry.getKey());
            sets.add(member.getNumber());
        }
        return this.removeAllNums(memberNums, sets, entityName);
    }

    @Override
    public Set<Long> getMatchMembers(Long modelId, Long dimId, String entityName, Map<Long, Integer> records, Collection<Long> memberIds, Integer defaultPerm) {
        HashSet sets = Sets.newHashSetWithExpectedSize((int)memberIds.size());
        if (PermEnum.NOPERM.getValue() == defaultPerm.intValue()) {
            for (Map.Entry<Long, Integer> entry : records.entrySet()) {
                if (PermEnum.NOPERM.getValue() == entry.getValue().intValue()) continue;
                IDNumberTreeNode member = MemberReader.findMemberById((long)modelId, (String)entityName, (Long)entry.getKey());
                sets.add(entry.getKey());
                sets.addAll(member.getShareNodes().stream().map(IDNumberTreeNode::getId).collect(Collectors.toSet()));
            }
            this.addSpecialAccountId(sets, modelId, dimId, entityName);
            sets.retainAll(memberIds);
            return sets;
        }
        for (Map.Entry<Long, Integer> entry : records.entrySet()) {
            if (PermEnum.NOPERM.getValue() != entry.getValue().intValue()) continue;
            IDNumberTreeNode member = MemberReader.findMemberById((long)modelId, (String)entityName, (Long)entry.getKey());
            sets.add(entry.getKey());
            sets.addAll(member.getShareNodes().stream().map(IDNumberTreeNode::getId).collect(Collectors.toSet()));
        }
        return this.removeAllIds(memberIds, sets);
    }
}

