/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.permission.perm.strategy;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.fi.bcm.business.permission.perm.strategy.IPermHandler;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.PermEnum;

public class ReadPermHandler
implements IPermHandler {
    @Override
    public Set<String> getMatchMembersByNum(Long modelId, Long dimId, String entityName, Map<Long, Integer> records, Collection<String> memberNums, Integer defaultPerm) {
        HashSet sets = Sets.newHashSetWithExpectedSize((int)memberNums.size());
        for (Map.Entry<Long, Integer> entry : records.entrySet()) {
            if (PermEnum.READONLY.getValue() != entry.getValue().intValue()) continue;
            IDNumberTreeNode member = MemberReader.findMemberById((long)modelId, (String)entityName, (Long)entry.getKey());
            sets.add(member.getNumber());
        }
        return this.retainAllNums(memberNums, sets, entityName);
    }

    @Override
    public Set<Long> getMatchMembers(Long modelId, Long dimId, String entityName, Map<Long, Integer> records, Collection<Long> memberIds, Integer defaultPerm) {
        HashSet sets = Sets.newHashSetWithExpectedSize((int)memberIds.size());
        for (Map.Entry<Long, Integer> entry : records.entrySet()) {
            if (PermEnum.READONLY.getValue() != entry.getValue().intValue()) continue;
            IDNumberTreeNode member = MemberReader.findMemberById((long)modelId, (String)entityName, (Long)entry.getKey());
            sets.add(entry.getKey());
            sets.addAll(member.getShareNodes().stream().map(IDNumberTreeNode::getId).collect(Collectors.toSet()));
        }
        sets.retainAll(memberIds);
        return sets;
    }
}

