/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.permission.permclass;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IPageCache;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;

public class PermClassCache {
    public static String getPermissionKey(String entityName) {
        return "permClass_" + entityName;
    }

    public static boolean isExistsPermClassCache(IPageCache pageCache, String entityName) {
        return StringUtils.isNotEmpty((String)pageCache.get(PermClassCache.getPermissionKey(entityName)));
    }

    public static List<Long> getPermissionMap(IPageCache pageCache, String entityName, DataTypeEnum dataTypeEnum) {
        String permJson = pageCache.get(PermClassCache.getPermissionKey(entityName));
        if (StringUtils.isEmpty((String)permJson)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        ArrayListMultimap permissionMap = (ArrayListMultimap)ObjectSerialUtil.parseObject((String)permJson, ArrayListMultimap.class);
        return permissionMap.get((Object)dataTypeEnum.getIndex()) != null ? permissionMap.get((Object)dataTypeEnum.getIndex()) : new ArrayList(16);
    }

    public static void cacheNewPermission(IPageCache pageCache, String entityName, String modelId) {
        PermClassCache.cacheNewPermission(pageCache, entityName, modelId, RequestContext.get().getUserId());
    }

    public static void cacheNewPermission(IPageCache pageCache, String entityName, String modelId, String userId) {
        if (StringUtils.isNotEmpty((String)modelId)) {
            ArrayListMultimap<String, Long> permissionMap = PermClassEntityHelper.getPermissionMap(entityName, modelId, userId);
            String json = ObjectSerialUtil.toJson(permissionMap);
            pageCache.put(PermClassCache.getPermissionKey(entityName), json);
        }
    }

    public static void removePermissionCache(IPageCache pageCache, String entityName) {
        if (pageCache != null && StringUtils.isNotEmpty((String)entityName)) {
            pageCache.remove(PermClassCache.getPermissionKey(entityName));
        }
    }

    public static List<Long> getPermissionMap(IPageCache pageCache, String perm) {
        String permJson = pageCache.get("permClass");
        if (StringUtils.isEmpty((String)permJson)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        ArrayListMultimap permissionMap = (ArrayListMultimap)ObjectSerialUtil.parseObject((String)permJson, ArrayListMultimap.class);
        return permissionMap.get((Object)perm);
    }

    public static void cachePermission(IPageCache pageCache, String entityName, String modelId) {
        String permJson = pageCache.get("permClass");
        if (!StringUtils.isEmpty((String)modelId)) {
            ArrayListMultimap<String, Long> permissionMap = PermClassEntityHelper.getPermissionMap(entityName, modelId, RequestContext.get().getUserId());
            String json = ObjectSerialUtil.toJson(permissionMap);
            pageCache.put("permClass", json);
        }
    }

    public static Set<Long> getPermissionIds(IPageCache pageCache, Collection<DynamicObject> colls) {
        ArrayListMultimap parentMap = ArrayListMultimap.create();
        HashSet all = Sets.newHashSetWithExpectedSize((int)colls.size());
        for (DynamicObject coll : colls) {
            parentMap.put((Object)coll.getLong("parent.id"), (Object)coll.getLong("id"));
            all.add(coll.getLong("id"));
        }
        List<Long> noPerms = PermClassCache.getPermissionMap(pageCache, DataTypeEnum.NO.getIndex());
        if (!CollectionUtils.isEmpty(noPerms)) {
            HashSet noPermIds = Sets.newHashSetWithExpectedSize((int)16);
            for (Long noPerm : noPerms) {
                if (noPerm != null && ((Object)noPerm).toString().equals("0")) continue;
                PermClassCache.getChildrenIds((ArrayListMultimap<Long, Long>)parentMap, LongUtil.toLong((Object)noPerm), noPermIds);
            }
            all.removeAll(noPermIds);
        }
        return all;
    }

    private static void getChildrenIds(ArrayListMultimap<Long, Long> parentMap, Long id, Set<Long> child) {
        child.add(id);
        if (!CollectionUtils.isEmpty((Collection)parentMap.get((Object)id))) {
            List ids = parentMap.get((Object)id);
            for (Object temp : ids) {
                PermClassCache.getChildrenIds(parentMap, LongUtil.toLong(temp), child);
            }
        }
    }

    public static Set<Long> getPermClassIds(Long modelId, String entityName, DataTypeEnum ... dataTypes) {
        boolean modelManager = MemberPermHelper.isModelManager(modelId);
        if (!modelManager) {
            ArrayListMultimap<String, Long> permissionMap = PermClassEntityHelper.getPermissionMap(entityName, String.valueOf(modelId), RequestContext.get().getUserId());
            HashSet<Long> perms = new HashSet<Long>(16);
            for (DataTypeEnum dataTypeEnum : dataTypes) {
                perms.addAll(permissionMap.get((Object)dataTypeEnum.getIndex()));
            }
            return perms;
        }
        return Collections.emptySet();
    }
}

