/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.permission.permclass;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.BasedataEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.log.DataPermLogHelper;
import kd.fi.bcm.business.permission.perm.PermCacheKey;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.Permission.UserTypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.log.DataPermLogMultiLangEnum;
import kd.fi.bcm.common.util.DynUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.spread.common.util.StringUtil;

public class PermClassEntityHelper {
    private static final Log LOGGER = LogFactory.getLog(PermClassEntityHelper.class);
    public static final String PERM_CLASS = "permclass";
    public static final String FIDMMODL = "fidmmodel";
    private static final List<String> showFields = Arrays.asList("shownumber", "number");

    public static void setPermClassFilter(BasedataEdit basedataEdit, Object modelId) {
        PermClassEntityHelper.setPermClassFilter(basedataEdit, modelId, "model", "");
    }

    public static void setPermClassFilter(BasedataEdit basedataEdit, Object modelId, String modelSign, String appType) {
        basedataEdit.addBeforeF7SelectListener(v -> {
            boolean adminUserBol;
            QFilter qFilter = new QFilter(modelSign, "=", (Object)ConvertUtil.convertObjToLong(modelId));
            if (StringUtil.equals((String)FIDMMODL, (String)modelSign)) {
                qFilter.and(new QFilter("app", "=", (Object)appType));
                adminUserBol = MemberPermHelper.isDiscModelAdmin(LongUtil.toLong((Object)modelId), appType);
            } else {
                adminUserBol = MemberPermHelper.ifUserHasRootPermByModel(Long.parseLong(RequestContext.get().getUserId()), modelId.toString());
            }
            if (!adminUserBol) {
                Set<Long> ids = PermClassEntityHelper.getWriteDataPermission(modelId.toString(), modelSign, appType);
                if (CollectionUtils.isEmpty(ids)) {
                    qFilter.and("id", "=", (Object)0);
                } else {
                    qFilter.and("id", "in", ids);
                }
            }
            v.getCustomQFilters().add(qFilter);
        });
    }

    public static void loadPermClass(IDataModel dataModel, Object modelId, boolean shareStorage) {
        DynamicObject dyn;
        if (dataModel.getDataEntity().getPkValue() != null && (dyn = shareStorage ? PermClassEntityHelper.getBasePermissionClassEntity(dataModel, modelId) : PermClassEntityHelper.getPermissionClassEntity(dataModel, modelId)) != null) {
            dataModel.setValue(PERM_CLASS, dyn.get("permclass.id"));
        }
    }

    public static DynamicObject getBasePermissionClassEntity(IDataModel dataModel, Object modelId) {
        Long baseMemberId = QueryMemberDetailsHelper.getBaseMemberId((Long)dataModel.getDataEntity().getPkValue(), dataModel.getDataEntityType().getName());
        QFBuilder range = new QFBuilder("model", "=", (Object)LongUtil.toLong((Object)modelId)).add("entityid", "=", (Object)baseMemberId).and("entityname", "=", (Object)dataModel.getDataEntityType().getName());
        return BusinessDataServiceHelper.loadSingle((String)"bcm_permclass_entity", (String)"permclass.id,entityname,permclass", (QFilter[])range.toArray());
    }

    public static DynamicObject getPermissionClass(String entityName, long modelId, long pkId) {
        QFBuilder filter = new QFBuilder("model", "=", (Object)modelId).add("entityid", "=", (Object)pkId).and("entityname", "=", (Object)entityName);
        return BusinessDataServiceHelper.loadSingle((String)"bcm_permclass_entity", (String)"permclass.id,entityname,permclass", (QFilter[])filter.toArray());
    }

    public static DynamicObject getBasePermissionClassEntity(String dataEntityTypeName, Long entityId, Object modelId) {
        Long baseMemberId = QueryMemberDetailsHelper.getBaseMemberId(entityId, dataEntityTypeName);
        QFBuilder range = new QFBuilder("model", "=", modelId).add("entityid", "=", (Object)baseMemberId).and("entityname", "=", (Object)dataEntityTypeName);
        return BusinessDataServiceHelper.loadSingle((String)"bcm_permclass_entity", (String)"permclass.id,entityname,permclass", (QFilter[])range.toArray());
    }

    public static void savePermClass(String entityName, Object entityId, Object modelId, Object permClass) {
        if (permClass == null) {
            QFBuilder qfBuilder = new QFBuilder("entityid", "=", entityId);
            qfBuilder.add("model", "=", modelId).add("entityname", "=", (Object)entityName);
            DeleteServiceHelper.delete((String)"bcm_permclass_entity", (QFilter[])qfBuilder.toArray());
            return;
        }
        DynamicObject permClassDy = PermClassEntityHelper.getPermissionClassEntity(entityName, Long.valueOf(entityId.toString()), modelId);
        if (permClassDy == null) {
            permClassDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_permclass_entity");
            permClassDy.set("entityname", (Object)entityName);
            permClassDy.set("entityid", entityId);
            permClassDy.set("model", modelId);
        }
        permClassDy.set(PERM_CLASS, permClass);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{permClassDy});
    }

    public static void savePermClass(IDataModel dataModel, Object modelId, OperationStatus status) {
        DynamicObject dyn;
        if (StorageTypeEnum.SHARE.index.equals(dataModel.getValue("storagetype"))) {
            dyn = PermClassEntityHelper.getBasePermissionClassEntity(dataModel, modelId);
            if (dyn == null) {
                dyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_permclass_entity");
                dyn.set("entityname", (Object)dataModel.getDataEntityType().getName());
                dyn.set("model", modelId);
                Long baseMemberId = QueryMemberDetailsHelper.getBaseMemberId((Long)dataModel.getDataEntity().getPkValue(), dataModel.getDataEntityType().getName());
                dyn.set("entityid", (Object)baseMemberId);
            }
        } else {
            dyn = PermClassEntityHelper.getPermissionClassEntity(dataModel, modelId);
        }
        if (dataModel.getValue(PERM_CLASS) != null) {
            if (status != OperationStatus.EDIT || dyn == null) {
                dyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_permclass_entity");
                dyn.set("entityname", (Object)dataModel.getDataEntityType().getName());
                dyn.set("model", modelId);
                dyn.set("entityid", dataModel.getDataEntity().getPkValue());
            }
            dyn.set(PERM_CLASS, dataModel.getValue(PERM_CLASS));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyn});
        } else if (dyn != null) {
            DeleteServiceHelper.delete((IDataEntityType)dyn.getDynamicObjectType(), (Object[])new Object[]{dyn.getPkValue()});
        }
    }

    public static void saveBatchPermClass(IDataModel dataModel, String entityName, List<Long> entityIds, Long modelId, String modelSign) {
        ArrayList<DynamicObject> permEntityList = new ArrayList<DynamicObject>(entityIds.size());
        if (dataModel.getValue(PERM_CLASS) != null) {
            for (Long entityId : entityIds) {
                DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_permclass_entity");
                dyn.set("entityname", (Object)entityName);
                dyn.set(modelSign, (Object)modelId);
                dyn.set("entityid", (Object)entityId);
                dyn.set(PERM_CLASS, dataModel.getValue(PERM_CLASS));
                permEntityList.add(dyn);
            }
            SaveServiceHelper.save((DynamicObject[])permEntityList.toArray(new DynamicObject[entityIds.size()]));
        }
    }

    public static void savePermClass(IDataModel dataModel, String entityName, Long entityId, Object modelId, OperationStatus status, String modelSign) {
        PermClassEntityHelper.saveDiscPermClass(dataModel, entityName, entityId, modelId, status, modelSign, ApplicationTypeEnum.FIDM.getAppnum());
    }

    public static void saveDiscPermClass(IDataModel dataModel, String entityName, Long entityId, Object modelId, OperationStatus status, String modelSign, String appType) {
        DynamicObject dyn = PermClassEntityHelper.getDiscPermissionClassEntity(entityName, entityId, modelId, modelSign, appType);
        if (dataModel.getValue(PERM_CLASS) != null) {
            if (status != OperationStatus.EDIT || dyn == null) {
                dyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_permclass_entity");
                dyn.set("entityname", (Object)entityName);
                dyn.set(modelSign, modelId);
                dyn.set("entityid", (Object)entityId);
            }
            dyn.set(PERM_CLASS, dataModel.getValue(PERM_CLASS));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyn});
        } else if (dyn != null) {
            DeleteServiceHelper.delete((IDataEntityType)dyn.getDynamicObjectType(), (Object[])new Object[]{dyn.getPkValue()});
        }
    }

    public static void savePermClass(IDataModel dataModel, String entityName, Long entityId, Object modelId, OperationStatus status) {
        PermClassEntityHelper.saveDiscPermClass(dataModel, entityName, entityId, modelId, status, "model", "");
    }

    public static DynamicObject getPermissionClassEntity(IDataModel dataModel, Object modelId) {
        QFBuilder range = new QFBuilder("model", "=", (Object)LongUtil.toLong((Object)modelId)).add("entityid", "=", dataModel.getDataEntity().getPkValue()).and("entityname", "=", (Object)dataModel.getDataEntityType().getName());
        return BusinessDataServiceHelper.loadSingle((String)"bcm_permclass_entity", (String)"permclass.id,entityname,permclass", (QFilter[])range.toArray());
    }

    public static DynamicObject getDiscPermissionClassEntity(String name, Long entityId, Object modelId, String modelSign, String appType) {
        QFBuilder range = new QFBuilder(modelSign, "=", modelId).add("entityid", "=", (Object)entityId).and("entityname", "=", (Object)name);
        if (!StringUtil.isEmptyString((String)appType)) {
            ArrayList<String> appField = new ArrayList<String>(2);
            appField.add(appType);
            if (!ApplicationTypeEnum.FAR.getAppnum().equals(appType)) {
                appField.add("bcm");
            }
            range.add(new QFilter("permclass.app", "in", appField));
        }
        return BusinessDataServiceHelper.loadSingle((String)"bcm_permclass_entity", (String)"permclass.id,permclass.number,entityname,permclass", (QFilter[])range.toArray());
    }

    public static DynamicObject getPermissionClassEntity(String name, Long entityId, Object modelId, String modelSign) {
        return PermClassEntityHelper.getDiscPermissionClassEntity(name, entityId, modelId, modelSign, ApplicationTypeEnum.FIDM.getAppnum());
    }

    public static DynamicObject getPermissionClassEntity(String name, Long entityId, Object modelId) {
        return PermClassEntityHelper.getDiscPermissionClassEntity(name, entityId, modelId, "model", "");
    }

    public static DynamicObject[] getPermClassList(String entityName, Set<Long> memberIds, Object modelId) {
        return (DynamicObject[])ThreadCache.get((Object)Joiner.on((char)'_').join(modelId, (Object)entityName, new Object[]{SerializationUtils.toJsonString(memberIds), "batch_get_perm_class"}), () -> PermClassEntityHelper.getPermClassListFromDB(entityName, memberIds, modelId));
    }

    private static DynamicObject[] getPermClassListFromDB(String name, Set<Long> memberIds, Object modelId) {
        QFBuilder range = new QFBuilder("model", "=", (Object)LongUtil.toLong((Object)modelId)).add("entityid", "in", memberIds).and("entityname", "=", (Object)name);
        return BusinessDataServiceHelper.load((String)"bcm_permclass_entity", (String)"entityid,permclass.id,entityname,permclass", (QFilter[])range.toArray());
    }

    public static void saveDiscPermClass(DynamicObject dyn, String modelSign, String appType) {
        DynamicObject entity = PermClassEntityHelper.getDiscPermissionClassEntity(dyn, modelSign, appType);
        Object perm = dyn.get(PERM_CLASS);
        if (perm == null || "0".equals(perm.toString())) {
            if (entity != null) {
                DeleteServiceHelper.delete((IDataEntityType)entity.getDynamicObjectType(), (Object[])new Object[]{entity.getPkValue()});
            }
            return;
        }
        if (entity == null) {
            entity = BusinessDataServiceHelper.newDynamicObject((String)"bcm_permclass_entity");
            entity.set("entityname", (Object)dyn.getDataEntityType().getName());
            if (Objects.nonNull(dyn.get("model")) && dyn.get("model") instanceof Long) {
                entity.set(modelSign, (Object)dyn.getLong("model"));
            } else {
                entity.set(modelSign, (Object)dyn.getLong("model.id"));
            }
            entity.set("entityid", (Object)dyn.getLong("id"));
        }
        entity.set(PERM_CLASS, perm);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entity});
    }

    public static void savePermClass(DynamicObject dyn, String modelSign) {
        PermClassEntityHelper.saveDiscPermClass(dyn, modelSign, ApplicationTypeEnum.FIDM.getAppnum());
    }

    public static void saveDiscPermClass(DynamicObject dyn, Long modelId, String modelSign, String appType) {
        DynamicObject entity = PermClassEntityHelper.getDiscPermissionClassEntity(dyn, modelSign, appType);
        if (dyn.get(PERM_CLASS) == null) {
            if (entity != null) {
                DeleteServiceHelper.delete((IDataEntityType)entity.getDynamicObjectType(), (Object[])new Object[]{entity.getPkValue()});
            }
            return;
        }
        if (entity == null) {
            entity = BusinessDataServiceHelper.newDynamicObject((String)"bcm_permclass_entity");
            entity.set("entityname", (Object)dyn.getDataEntityType().getName());
            entity.set(modelSign, (Object)modelId);
            entity.set("entityid", (Object)dyn.getLong("id"));
        }
        entity.set(PERM_CLASS, dyn.get(PERM_CLASS));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entity});
    }

    public static void savePermClass(DynamicObject dyn) {
        DynamicObject entity = PermClassEntityHelper.getPermissionClassEntity(dyn);
        if (dyn.get(PERM_CLASS) == null) {
            if (entity != null) {
                DeleteServiceHelper.delete((IDataEntityType)entity.getDynamicObjectType(), (Object[])new Object[]{entity.getPkValue()});
            }
            return;
        }
        if (entity == null) {
            entity = BusinessDataServiceHelper.newDynamicObject((String)"bcm_permclass_entity");
            entity.set("entityname", (Object)dyn.getDataEntityType().getName());
            entity.set("model", (Object)dyn.getLong("model"));
            entity.set("entityid", (Object)dyn.getLong("id"));
        }
        entity.set(PERM_CLASS, dyn.get(PERM_CLASS));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entity});
    }

    public static void saveBathPermClass(List<DynamicObject> dys, long modelId, String permclassKey) {
        Map<Object, DynamicObject> map = dys.stream().collect(Collectors.toMap(k -> k.getPkValue(), v -> v));
        DynamicObject[] entitys = PermClassEntityHelper.getPermissionClassEntitys(dys, modelId);
        if (entitys == null) {
            return;
        }
        if (entitys.length != 0) {
            for (DynamicObject entity : entitys) {
                DynamicObject dyn = map.get(entity.get("entityid"));
                if (dyn.get(permclassKey) == null) {
                    if (entity != null) {
                        DeleteServiceHelper.delete((IDataEntityType)entity.getDynamicObjectType(), (Object[])new Object[]{entity.getPkValue()});
                    }
                    return;
                }
                if (entity == null) {
                    entity = BusinessDataServiceHelper.newDynamicObject((String)"bcm_permclass_entity");
                    entity.set("entityname", (Object)dyn.getDataEntityType().getName());
                    entity.set("model", (Object)modelId);
                    entity.set("entityid", (Object)dyn.getLong("id"));
                }
                entity.set(PERM_CLASS, dyn.get(permclassKey));
            }
            SaveServiceHelper.save((DynamicObject[])entitys);
        } else {
            ArrayList<DynamicObject> ls = new ArrayList<DynamicObject>(16);
            for (DynamicObject dy : dys) {
                if (dy.get(permclassKey) == null) continue;
                DynamicObject entity = BusinessDataServiceHelper.newDynamicObject((String)"bcm_permclass_entity");
                entity.set("entityname", (Object)dy.getDataEntityType().getName());
                entity.set("model", (Object)modelId);
                entity.set("entityid", (Object)dy.getLong("id"));
                entity.set(PERM_CLASS, dy.get(permclassKey));
                ls.add(entity);
            }
            SaveServiceHelper.save((DynamicObject[])ls.toArray(new DynamicObject[0]));
        }
    }

    public static void savePermClass(DynamicObject dyn, Long modelId) {
        DynamicObject entity = PermClassEntityHelper.getPermissionClassEntity(dyn);
        if (dyn.get(PERM_CLASS) == null) {
            if (entity != null) {
                DeleteServiceHelper.delete((IDataEntityType)entity.getDynamicObjectType(), (Object[])new Object[]{entity.getPkValue()});
            }
            return;
        }
        if (entity == null) {
            entity = BusinessDataServiceHelper.newDynamicObject((String)"bcm_permclass_entity");
            entity.set("entityname", (Object)dyn.getDataEntityType().getName());
            entity.set("model", (Object)modelId);
            entity.set("entityid", (Object)dyn.getLong("id"));
        }
        entity.set(PERM_CLASS, dyn.get(PERM_CLASS));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entity});
    }

    public static void savePermClassAndLog(DynamicObject dyn, Long modelId, String appNumber, DataPermLogMultiLangEnum logEnum) {
        PermClassEntityHelper.savePermClassAndLog(dyn, modelId, appNumber, logEnum, PERM_CLASS);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void savePermClassAndLog(DynamicObject dyn, Long modelId, String appNumber, DataPermLogMultiLangEnum logEnum, String permclassSign) {
        String operName = "";
        String permClassNumber = dyn.getString(permclassSign + ".number");
        DynamicObject entity = PermClassEntityHelper.getPermissionClassEntity(dyn);
        if (dyn.get(permclassSign) == null) {
            if (entity == null) return;
            operName = DataPermLogMultiLangEnum.PermCLASS_Distribute_DELETE.getOperateName();
            permClassNumber = entity.getString("permclass.number");
            DeleteServiceHelper.delete((IDataEntityType)entity.getDynamicObjectType(), (Object[])new Object[]{entity.getPkValue()});
        } else {
            if (entity == null) {
                operName = DataPermLogMultiLangEnum.PermCLASS_Distribute_AddNew.getOperateName();
                entity = BusinessDataServiceHelper.newDynamicObject((String)"bcm_permclass_entity");
                entity.set("entityname", (Object)dyn.getDataEntityType().getName());
                entity.set("model", (Object)modelId);
                entity.set("entityid", (Object)dyn.getLong("id"));
            } else {
                if (DynUtils.getBaseId((DynamicObject)dyn, (String)permclassSign).longValue() == entity.getLong("permclass.id")) return;
                operName = DataPermLogMultiLangEnum.PermCLASS_Distribute_MODIFY.getOperateName();
            }
            entity.set(PERM_CLASS, dyn.get(permclassSign));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entity});
        }
        try {
            if (StringUtils.isEmpty((CharSequence)permClassNumber)) {
                DynamicObject pmDy = BusinessDataServiceHelper.loadSingleFromCache((Object)DynUtils.getBaseId((DynamicObject)dyn, (String)permclassSign), (String)"bcm_permissionclass");
                permClassNumber = pmDy == null ? "" : pmDy.getString("number");
            }
            DynamicObject permLog = DataPermLogHelper.newPermClassDistributeLog(modelId, null, null, null, permClassNumber, logEnum.getOperateName() + "_" + PermClassEntityHelper.showInfo(dyn), operName, appNumber);
            DataPermLogHelper.batchInsertDataPermLog(Lists.newArrayList((Object[])new DynamicObject[]{permLog}));
            return;
        }
        catch (Throwable e) {
            LOGGER.error("\u4fdd\u5b58\u6570\u636e\u6743\u9650\u65e5\u5fd7\u51fa\u73b0\u5f02\u5e38", e);
        }
    }

    private static String showInfo(DynamicObject dy) {
        DataEntityPropertyCollection properties = dy.getDataEntityType().getProperties();
        String showFiled = showFields.stream().filter(e -> properties.containsKey(e)).findFirst().orElseGet(() -> "id");
        return dy.getString(showFiled);
    }

    public static Map<Object, DynamicObject> getPermissionClass(Long modelId, String modelSign) {
        QFBuilder range = new QFBuilder(modelSign, "=", (Object)modelId);
        String fields = "id,number,modifier,modifytime,remark";
        return BusinessDataServiceHelper.loadFromCache((String)"bcm_permissionclass", (String)fields, (QFilter[])range.toArray());
    }

    public static Map<Object, DynamicObject> getPermissionClassByNum(Long modelId, String modelSign, Set<String> nums) {
        QFBuilder range = new QFBuilder(modelSign, "=", (Object)modelId);
        if (!CollectionUtils.isEmpty(nums)) {
            range.add(new QFilter("number", "in", nums));
        }
        String fields = "id,number";
        return BusinessDataServiceHelper.loadFromCache((String)"bcm_permissionclass", (String)fields, (QFilter[])range.toArray());
    }

    public static Map<Object, DynamicObject> getPermissionClass(Long modelId) {
        return PermClassEntityHelper.getPermissionClass(modelId, "model.id");
    }

    public static DynamicObject[] getPermissionClassByLoad(Long modelId, String modelSign) {
        QFBuilder range = new QFBuilder(modelSign, "=", (Object)modelId);
        String fields = "id,number,modifier,modifytime,remark";
        return BusinessDataServiceHelper.load((String)"bcm_permissionclass", (String)fields, (QFilter[])range.toArray());
    }

    public static DynamicObject getPermissionClassEntity(DynamicObject dyn) {
        return PermClassEntityHelper.getDiscPermissionClassEntity(dyn, "model", "");
    }

    public static DynamicObject getDiscPermissionClassEntity(DynamicObject dyn, String modelSign, String appType) {
        Object model = dyn.get("model");
        if (model instanceof DynamicObject) {
            model = dyn.getDynamicObject("model").getPkValue();
        }
        QFBuilder range = new QFBuilder(modelSign, "=", model);
        range.add("entityname", "=", (Object)dyn.getDataEntityType().getName());
        range.add("entityid", "=", dyn.getPkValue());
        if (!StringUtil.isEmptyString((String)appType)) {
            ArrayList<String> appField = new ArrayList<String>(2);
            appField.add(appType);
            if (!ApplicationTypeEnum.FAR.getAppnum().equals(appType)) {
                appField.add("bcm");
            }
            range.add("permclass.app", "in", appField);
        }
        return BusinessDataServiceHelper.loadSingle((String)"bcm_permclass_entity", (String)"permclass.id,entityname,permclass", (QFilter[])range.toArray());
    }

    public static DynamicObject getPermissionClassEntity(DynamicObject dyn, String modelSign) {
        return PermClassEntityHelper.getDiscPermissionClassEntity(dyn, modelSign, ApplicationTypeEnum.FIDM.getAppnum());
    }

    public static DynamicObject[] getPermissionClassEntitys(List<DynamicObject> dyn, long modelId) {
        if (dyn.isEmpty()) {
            return null;
        }
        QFBuilder range = new QFBuilder("model", "=", (Object)modelId);
        range.add("entityname", "=", (Object)dyn.get(0).getDataEntityType().getName());
        range.add("entityid", "in", dyn.stream().map(c -> c.getPkValue()).collect(Collectors.toList()));
        return BusinessDataServiceHelper.load((String)"bcm_permclass_entity", (String)"permclass.id,entityname,permclass,entityid", (QFilter[])range.toArray());
    }

    public static Map<Long, DynamicObject> batchGetPermissionClassByEntityAndId(long modelId, String entityName, Set<Long> idSet) {
        if (idSet.isEmpty()) {
            return Collections.emptyMap();
        }
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.add("entityname", "=", (Object)entityName);
        qfBuilder.add("entityid", "in", idSet);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bcm_permclass_entity", (String)"permclass.id,entityname,permclass,entityid", (QFilter[])qfBuilder.toArray());
        HashMap<Long, DynamicObject> permclassMap = new HashMap<Long, DynamicObject>(dynamicObjects.length);
        for (DynamicObject dyn : dynamicObjects) {
            permclassMap.put(dyn.getLong("entityid"), dyn);
        }
        return permclassMap;
    }

    @Deprecated
    public static Set<Long> getNoRightDataPermission(String modelId) {
        String userId = RequestContext.get().getUserId();
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel(Long.parseLong(RequestContext.get().getUserId()), modelId);
        if (adminUserBol) {
            return Sets.newHashSetWithExpectedSize((int)16);
        }
        HashSet users = Sets.newHashSetWithExpectedSize((int)16);
        QFilter qf = new QFilter("user", "=", (Object)LongUtil.toLong((Object)userId));
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bos_usergroupstaff", (String)"usergroup.id", (QFilter[])qf.toArray());
        if (dynamicObjectCollection != null && dynamicObjectCollection.size() > 0) {
            HashSet temp = Sets.newHashSetWithExpectedSize((int)16);
            IDataEntityProperty dataEntityProperty = (IDataEntityProperty)((DynamicObject)dynamicObjectCollection.get(0)).getDataEntityType().getProperties().get((Object)"usergroup.id");
            dynamicObjectCollection.forEach(d -> temp.add(d.getString(dataEntityProperty)));
            users.addAll(PermClassEntityHelper.getRelGroupIds(temp).stream().map(t -> LongUtil.toLong((Object)t)).collect(Collectors.toList()));
        }
        users.add(LongUtil.toLong((Object)userId));
        String selectField = "authclass.id";
        QFilter filter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        filter.and(new QFilter("users", "in", (Object)users));
        filter.and(new QFilter("data_auth", "=", (Object)DataTypeEnum.NO.getIndex()));
        DynamicObjectCollection authObjectCollection = QueryServiceHelper.query((String)"bcm_auth_info", (String)selectField, (QFilter[])filter.toArray());
        if (authObjectCollection == null || authObjectCollection.size() == 0) {
            return Sets.newHashSetWithExpectedSize((int)16);
        }
        HashSet authClassList = Sets.newHashSetWithExpectedSize((int)16);
        IDataEntityProperty dataEntityProperty = (IDataEntityProperty)((DynamicObject)authObjectCollection.get(0)).getDataEntityType().getProperties().get((Object)selectField);
        for (DynamicObject dynamicObject : authObjectCollection) {
            Long id = dynamicObject.getLong(dataEntityProperty);
            authClassList.add(id);
        }
        return authClassList;
    }

    public static Set<Long> getWriteDataPermission(String modelId, String modelSign, String appType) {
        String userId = RequestContext.get().getUserId();
        HashSet users = Sets.newHashSetWithExpectedSize((int)16);
        QFilter qf = new QFilter("user", "=", (Object)ConvertUtil.convertStrToLong(userId));
        DynamicObjectCollection groupData = QueryServiceHelper.query((String)"bos_usergroupstaff", (String)"usergroup.id", (QFilter[])qf.toArray());
        if (groupData != null && groupData.size() != 0) {
            HashSet temp = Sets.newHashSetWithExpectedSize((int)16);
            IDataEntityProperty dataEntityProperty = (IDataEntityProperty)((DynamicObject)groupData.get(0)).getDataEntityType().getProperties().get((Object)"usergroup.id");
            groupData.forEach(g -> temp.add(g.getString(dataEntityProperty)));
            users.addAll(PermClassEntityHelper.getRelGroupIds(temp));
        }
        users.add(userId);
        String selectFields = "authclass.id,authclass.number";
        QFilter filter = new QFilter(modelSign, "=", (Object)Long.valueOf(modelId));
        Set<Long> usersIds = PermClassEntityHelper.changeUsersIds(users);
        filter.and(new QFilter("users", "in", usersIds));
        filter.and(new QFilter("data_auth", "=", (Object)DataTypeEnum.WRITEIN.getIndex()));
        if (!StringUtil.isEmptyString((String)appType)) {
            ArrayList<String> appField = new ArrayList<String>(2);
            appField.add(appType);
            if (!ApplicationTypeEnum.FAR.getAppnum().equals(appType)) {
                appField.add("bcm");
            }
            filter.and(new QFilter("authclass.app", "in", appField));
        }
        filter.or(new QFilter("authclass.number", "=", (Object)"Default").and("model", "=", (Object)Long.valueOf(modelId)));
        DynamicObjectCollection authObjectCollection = QueryServiceHelper.query((String)"bcm_auth_info", (String)selectFields, (QFilter[])filter.toArray());
        HashSet authClassList = Sets.newHashSetWithExpectedSize((int)16);
        if (authObjectCollection == null || authObjectCollection.size() == 0) {
            return authClassList;
        }
        IDataEntityProperty dataEntityProperty = (IDataEntityProperty)((DynamicObject)authObjectCollection.get(0)).getDataEntityType().getProperties().get((Object)"authclass.id");
        authObjectCollection.forEach(auth -> authClassList.add(auth.getLong(dataEntityProperty)));
        return authClassList;
    }

    public static Set<Long> getWriteDataPermission(String modelId) {
        return PermClassEntityHelper.getWriteDataPermission(modelId, "model", "");
    }

    public static Set<Long> getHasDataPermission(long modelId) {
        String userId = RequestContext.get().getUserId();
        HashSet users = Sets.newHashSetWithExpectedSize((int)16);
        QFilter qf = new QFilter("user", "=", (Object)LongUtil.toLong((Object)userId));
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bos_usergroupstaff", (String)"usergroup.id", (QFilter[])qf.toArray());
        if (dynamicObjectCollection != null && dynamicObjectCollection.size() != 0) {
            HashSet temp = Sets.newHashSetWithExpectedSize((int)dynamicObjectCollection.size());
            IDataEntityProperty dataEntityProperty = (IDataEntityProperty)((DynamicObject)dynamicObjectCollection.get(0)).getDataEntityType().getProperties().get((Object)"usergroup.id");
            dynamicObjectCollection.forEach(d -> temp.add(d.getString(dataEntityProperty)));
            users.addAll(PermClassEntityHelper.getRelGroupIds(temp));
        }
        users.add(userId);
        String selectFields = "authclass.id";
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        Set<Long> usersIds = PermClassEntityHelper.changeUsersIds(users);
        filter.and(new QFilter("users", "in", usersIds));
        filter.and(new QFilter("data_auth", "in", (Object)Lists.newArrayList((Object[])new String[]{DataTypeEnum.WRITEIN.getIndex(), DataTypeEnum.READ.getIndex()})));
        filter.or(new QFilter("authclass.number", "=", (Object)"Default").and("model", "=", (Object)modelId));
        DynamicObjectCollection authObjectCollection = QueryServiceHelper.query((String)"bcm_auth_info", (String)selectFields, (QFilter[])filter.toArray());
        if (authObjectCollection == null || authObjectCollection.size() == 0) {
            return Sets.newHashSetWithExpectedSize((int)16);
        }
        IDataEntityProperty dataEntityProperty = (IDataEntityProperty)((DynamicObject)authObjectCollection.get(0)).getDataEntityType().getProperties().get((Object)selectFields);
        return authObjectCollection.stream().map(e -> e.getLong(dataEntityProperty)).collect(Collectors.toSet());
    }

    private static Set<Long> changeUsersIds(Set<String> users) {
        HashSet usersIds = Sets.newHashSetWithExpectedSize((int)users.size());
        try {
            if (!users.isEmpty()) {
                users.forEach(userId -> usersIds.add(ConvertUtil.convertStrToLong(userId)));
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u8f6c\u6362\u5f02\u5e38%s", (String)"PermClassEntityHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]), e.getMessage()));
        }
        return usersIds;
    }

    public static String getDataPermission(String userid, int userType, String PermissionClassId, String modelId, String modelSign) {
        String selectFields = "data_auth";
        QFilter filter = new QFilter(modelSign, "=", (Object)LongUtil.toLong((Object)modelId));
        filter.and(new QFilter("authclass", "=", (Object)LongUtil.toLong((Object)PermissionClassId)));
        filter.and(new QFilter("users", "=", (Object)LongUtil.toLong((Object)userid)));
        filter.and(new QFilter("usertype", "=", (Object)UserTypeEnum.getUserTypeEnumByIndex((int)userType).getName()));
        DynamicObject data = BusinessDataServiceHelper.loadSingle((String)"bcm_auth_info", (String)selectFields, (QFilter[])filter.toArray());
        if (data != null && "1".equals(data.getString("data_auth"))) {
            return "1";
        }
        String select = "usergroup.id";
        QFilter qf = new QFilter("user", "=", (Object)LongUtil.toLong((Object)userid));
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bos_usergroupstaff", (String)select, (QFilter[])qf.toArray());
        if (dynamicObjectCollection == null || dynamicObjectCollection.size() == 0) {
            if (null != data) {
                return data.getString("data_auth");
            }
            return "1";
        }
        HashSet groups = Sets.newHashSetWithExpectedSize((int)dynamicObjectCollection.size());
        IDataEntityProperty dataEntityProperty = (IDataEntityProperty)((DynamicObject)dynamicObjectCollection.get(0)).getDataEntityType().getProperties().get((Object)"usergroup.id");
        dynamicObjectCollection.forEach(d -> groups.add(d.getString(dataEntityProperty)));
        Set<String> groupIds = PermClassEntityHelper.getRelGroupIds(groups);
        Set groupIds2Long = groupIds.stream().map(s -> LongUtil.toLong((Object)s)).collect(Collectors.toSet());
        QFilter qfs = new QFilter(modelSign, "=", (Object)LongUtil.toLong((Object)modelId));
        qfs.and(new QFilter("authclass", "=", (Object)LongUtil.toLong((Object)PermissionClassId)));
        qfs.and(new QFilter("users", "in", groupIds2Long));
        qfs.and(new QFilter("usertype", "=", (Object)UserTypeEnum.getUserTypeEnumByIndex((int)0).getName()));
        DynamicObjectCollection authObjectCollection = QueryServiceHelper.query((String)"bcm_auth_info", (String)selectFields, (QFilter[])qfs.toArray());
        if (authObjectCollection == null || authObjectCollection.size() == 0) {
            if (null != data) {
                return data.getString("data_auth");
            }
            return "1";
        }
        if (null == data) {
            return Collections.min(authObjectCollection, Comparator.comparingInt(a -> Integer.parseInt(a.getString("data_auth")))).getString("data_auth");
        }
        int user = data.getInt("data_auth");
        int userGroup = Collections.min(authObjectCollection, Comparator.comparingInt(a -> Integer.parseInt(a.getString("data_auth")))).getInt("data_auth");
        return String.valueOf(Integer.min(user, userGroup));
    }

    public static String getDataPermission(String userid, int userType, String PermissionClassId, String modelId) {
        return PermClassEntityHelper.getDataPermission(userid, userType, PermissionClassId, modelId, "model");
    }

    public static Set<String> getRelGroupIds(Set<String> groupData) {
        HashMap<String, Set<String>> userGroupInhRelation = new HashMap<String, Set<String>>(8);
        DynamicObjectCollection authObjectCollection = QueryServiceHelper.query((String)"perm_usrgrp_inh", (String)"parent.id, children.id", null);
        if (authObjectCollection != null && authObjectCollection.size() > 0) {
            for (DynamicObject object : authObjectCollection) {
                String parent = object.getString("parent.id");
                String child = object.getString("children.id");
                String parentId = parent == null ? "8609760E-EF83-4775-A9FF-CCDEC7C0B689" : parent;
                Set childObjects = userGroupInhRelation.computeIfAbsent(parentId, k -> new HashSet());
                if (!Objects.nonNull(child)) continue;
                childObjects.add(child);
                userGroupInhRelation.put(parentId, childObjects);
            }
        }
        HashSet<String> groupIds = new HashSet<String>(16);
        for (String group : groupData) {
            HashSet<String> oneGroups = new HashSet<String>(16);
            oneGroups.add(group);
            PermClassEntityHelper.getParentsGroups(userGroupInhRelation, group, oneGroups);
            if (oneGroups.size() <= 0) continue;
            groupIds.addAll(oneGroups);
        }
        return groupIds;
    }

    private static void getParentsGroups(HashMap<String, Set<String>> userGroupInhRelation, String id, Set<String> oneGroups) {
        userGroupInhRelation.forEach((k, v) -> {
            if (v.contains(id)) {
                oneGroups.add((String)k);
                PermClassEntityHelper.getParentsGroups(userGroupInhRelation, k, oneGroups);
            }
        });
    }

    public static ArrayListMultimap<String, Long> getPermissionMap(String entityName, String modelId, String userId) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        HashMap map = new HashMap(16);
        String fields = "entityid,permclass.id";
        QFBuilder range = new QFBuilder("model", "=", (Object)ConvertUtil.convertObjToLong(modelId)).and("entityname", "=", (Object)entityName);
        DynamicObjectCollection permclassCollection = QueryServiceHelper.query((String)"bcm_permclass_entity", (String)fields, (QFilter[])range.toArray());
        if (!CollectionUtils.isEmpty((Collection)permclassCollection)) {
            DataEntityPropertyCollection dataEntityPropertyCollection = ((DynamicObject)permclassCollection.get(0)).getDataEntityType().getProperties();
            IDataEntityProperty permclassEntityProperty = (IDataEntityProperty)dataEntityPropertyCollection.get((Object)"permclass.id");
            IDataEntityProperty entityidEntityProperty = (IDataEntityProperty)dataEntityPropertyCollection.get((Object)"entityid");
            permclassCollection.forEach(object -> {
                long classId = object.getLong(permclassEntityProperty);
                long id = object.getLong(entityidEntityProperty);
                if (id == 0L) {
                    return;
                }
                if (map.get(classId) == null) {
                    String perm = PermClassEntityHelper.getDataPermission(userId, 1, String.valueOf(classId), modelId);
                    multimap.put((Object)perm, (Object)id);
                    map.put(classId, perm);
                } else {
                    String perm = (String)map.get(classId);
                    multimap.put((Object)perm, (Object)id);
                }
            });
        }
        return multimap;
    }

    public static ArrayListMultimap<String, Long> getFIDMPermissionMap(String entityName, Long modelId, Long userId) {
        return PermClassEntityHelper.getDiscPermissionMap(entityName, modelId, userId, ApplicationTypeEnum.FIDM.getAppnum());
    }

    public static ArrayListMultimap<String, Long> getFARPermissionMap(String entityName, Long modelId, Long userId) {
        return PermClassEntityHelper.getDiscPermissionMap(entityName, modelId, userId, ApplicationTypeEnum.FAR.getAppnum());
    }

    public static ArrayListMultimap<String, Long> getDiscPermissionMap(String entityName, Long modelId, Long userId, String appType) {
        String fields;
        DynamicObjectCollection permclassCollection;
        boolean isModelManager = MemberPermHelper.isDiscModelAdmin(modelId, appType);
        ArrayListMultimap multimap = ArrayListMultimap.create();
        HashMap map = new HashMap(16);
        QFBuilder range = new QFBuilder(FIDMMODL, "=", (Object)modelId).and("entityname", "=", (Object)entityName);
        if (!(StringUtil.isEmptyString((String)appType) || StringUtil.equals((String)"fidm_dataset", (String)entityName) || StringUtil.equals((String)"fidm_modulerepository", (String)entityName))) {
            ArrayList<String> appField = new ArrayList<String>(2);
            appField.add(appType);
            if (!ApplicationTypeEnum.FAR.getAppnum().equals(appType)) {
                appField.add("bcm");
            }
            range.add(new QFilter("permclass.app", "in", appField));
        }
        if (!CollectionUtils.isEmpty((Collection)(permclassCollection = QueryServiceHelper.query((String)"bcm_permclass_entity", (String)(fields = "entityid,permclass.id"), (QFilter[])range.toArray())))) {
            DataEntityPropertyCollection dataEntityPropertyCollection = ((DynamicObject)permclassCollection.get(0)).getDataEntityType().getProperties();
            IDataEntityProperty permclassEntityProperty = (IDataEntityProperty)dataEntityPropertyCollection.get((Object)"permclass.id");
            IDataEntityProperty entityidEntityProperty = (IDataEntityProperty)dataEntityPropertyCollection.get((Object)"entityid");
            permclassCollection.forEach(object -> {
                long classId = object.getLong(permclassEntityProperty);
                if (classId == 0L) {
                    map.put(classId, "3");
                }
                if (map.get(classId) == null) {
                    String perm = "3";
                    if (!isModelManager) {
                        perm = PermClassEntityHelper.getDataPermission(String.valueOf(userId), 1, String.valueOf(classId), String.valueOf(modelId), FIDMMODL);
                    }
                    multimap.put((Object)perm, (Object)object.getLong(entityidEntityProperty));
                    map.put(classId, perm);
                } else {
                    String perm = (String)map.get(classId);
                    multimap.put((Object)perm, (Object)object.getLong(entityidEntityProperty));
                }
            });
        }
        return multimap;
    }

    public static String getSingleFIDMPermission(String entityName, Long entityId, Long modelId, Long userId, String modelsign) {
        return PermClassEntityHelper.getSingleDiscPermission(entityName, entityId, modelId, userId, modelsign, ApplicationTypeEnum.FIDM.getAppnum());
    }

    public static String getSingleDiscPermission(String entityName, Long entityId, Long modelId, Long userId, String modelsign, String appType) {
        boolean isModelManager = MemberPermHelper.isDiscModelAdmin(modelId, appType);
        QFBuilder range = new QFBuilder(modelsign, "=", (Object)ConvertUtil.convertObjToLong(modelId)).and("entityname", "=", (Object)entityName).add("entityid", "=", (Object)entityId);
        if (!StringUtil.isEmptyString((String)appType)) {
            ArrayList<String> appField = new ArrayList<String>(2);
            appField.add(appType);
            if (!ApplicationTypeEnum.FAR.getAppnum().equals(appType)) {
                appField.add("bcm");
            }
            range.add(new QFilter("permclass.app", "in", appField));
        }
        String fields = "entityid,permclass.id";
        DynamicObject permclass = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_permclass_entity", (String)fields, (QFilter[])range.toArray());
        long classId = 0L;
        if (permclass != null && !isModelManager) {
            classId = permclass.getLong("permclass.id");
            return PermClassEntityHelper.getDataPermission(String.valueOf(userId), 1, String.valueOf(classId), String.valueOf(modelId), FIDMMODL);
        }
        return "3";
    }

    public static boolean checkDistribute(List<Long> classId, Long modelId, String modelSign) {
        boolean flag = false;
        if (!CollectionUtils.isEmpty(classId)) {
            QFBuilder range = new QFBuilder(modelSign, "=", (Object)modelId);
            range.add("authclass", "in", classId);
            flag = QueryServiceHelper.exists((String)"bcm_auth_info", (QFilter[])range.toArray());
        }
        return flag;
    }

    public static boolean checkDistribute(List<Long> classId, Long modelId) {
        return PermClassEntityHelper.checkDistribute(classId, modelId, "model");
    }

    public static boolean checkIsItReferenced(List<Long> classId, Long modelId, String modelSign) {
        boolean flag = false;
        if (!CollectionUtils.isEmpty(classId)) {
            QFBuilder range = new QFBuilder(modelSign, "=", (Object)modelId);
            range.add(PERM_CLASS, "in", classId);
            flag = QueryServiceHelper.exists((String)"bcm_permclass_entity", (QFilter[])range.toArray());
        }
        return flag;
    }

    public static boolean checkIsItReferenced(List<Long> classId, Long modelId) {
        return PermClassEntityHelper.checkIsItReferenced(classId, modelId, "model");
    }

    public static boolean isAuth(Long userId, Long permissionClassId, String approval) {
        return (Boolean)ThreadCache.get((Object)("queryDataAuthPerm" + userId + permissionClassId + approval), () -> {
            int value;
            String selectFields = "data_auth";
            QFilter userFilter = new QFilter("users", "=", (Object)userId);
            userFilter.and(new QFilter("authclass", "=", (Object)permissionClassId));
            QFilter qfs = new QFilter("level1", "=", (Object)approval);
            qfs.or("level1", "=", (Object)approval);
            qfs.or("level2", "=", (Object)approval);
            qfs.or("level3", "=", (Object)approval);
            qfs.or("level4", "=", (Object)approval);
            qfs.or("level5", "=", (Object)approval);
            qfs.or("level6", "=", (Object)approval);
            qfs.or("level7", "=", (Object)approval);
            qfs.or("level8", "=", (Object)approval);
            qfs.or("level9", "=", (Object)approval);
            qfs.or("level10", "=", (Object)approval);
            qfs.or("level11", "=", (Object)approval);
            qfs.or("level12", "=", (Object)approval);
            qfs.or("level13", "=", (Object)approval);
            qfs.or("level14", "=", (Object)approval);
            userFilter.and(qfs);
            DynamicObject userAuth = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_auth_info", (String)selectFields, (QFilter[])userFilter.toArray());
            QFilter qf = new QFilter("user", "=", (Object)userId);
            int n = value = userAuth == null ? 1 : userAuth.getInt("data_auth");
            if (userAuth != null && userAuth.getInt("data_auth") == 1) {
                return false;
            }
            DynamicObjectCollection groupData = QueryServiceHelper.query((String)"bos_usergroupstaff", (String)"usergroup.id", (QFilter[])qf.toArray());
            if (null != groupData && !groupData.isEmpty()) {
                IDataEntityProperty dataEntityProperty = (IDataEntityProperty)((DynamicObject)groupData.get(0)).getDataEntityType().getProperties().get((Object)"usergroup.id");
                HashSet groups = Sets.newHashSetWithExpectedSize((int)groupData.size());
                groupData.forEach(g -> groups.add(g.getString(dataEntityProperty)));
                Set<String> groupIds = PermClassEntityHelper.getRelGroupIds(groups);
                QFilter groupQfs = new QFilter("users", "in", (Object)LongUtil.toLongList(groupIds));
                groupQfs.and(new QFilter("authclass", "=", (Object)permissionClassId));
                groupQfs.and(new QFilter("usertype", "=", (Object)UserTypeEnum.getUserTypeEnumByIndex((int)0).getName()));
                groupQfs.and(qfs);
                DynamicObjectCollection authObjectCollection = QueryServiceHelper.query((String)"bcm_auth_info", (String)selectFields, (QFilter[])groupQfs.toArray());
                if (!CollectionUtils.isEmpty((Collection)authObjectCollection)) {
                    int userGroup = Collections.min(authObjectCollection, Comparator.comparingInt(a -> Integer.parseInt(a.getString("data_auth")))).getInt("data_auth");
                    value = userAuth == null ? userGroup : Integer.min(value, userGroup);
                }
            }
            return value > 1;
        });
    }

    public static DynamicObject[] getTotalDimensionPermissionClass(long modelId, String entityName) {
        return (DynamicObject[])ThreadCache.get((Object)Joiner.on((char)'_').join((Object)modelId, (Object)entityName, new Object[]{PermCacheKey.MODEL_ENTITY_PERM_CLASS}), () -> {
            QFBuilder rangeQf = new QFBuilder("model", "=", (Object)modelId).and("entityname", "=", (Object)entityName);
            return BusinessDataServiceHelper.load((String)"bcm_permclass_entity", (String)"entityid, permclass.id, permclass.number", (QFilter[])rangeQf.toArray());
        });
    }

    public static DynamicObjectCollection queryTotalDimensionPermissionClass(long modelId, String entityName) {
        return (DynamicObjectCollection)ThreadCache.get((Object)Joiner.on((char)'_').join((Object)modelId, (Object)entityName, new Object[]{PermCacheKey.MODEL_ENTITY_PERM_CLASS_BY_QUERY}), () -> {
            QFBuilder rangeQf = new QFBuilder("model", "=", (Object)modelId).and("entityname", "=", (Object)entityName);
            return QueryServiceHelper.query((String)"bcm_permclass_entity", (String)"entityid, permclass.id, permclass.number", (QFilter[])rangeQf.toArray());
        });
    }

    public static DynamicObject[] getTotalDimensionPermissionClass(long modelId, String entityName, List<Long> memberIds) {
        String key = Joiner.on((char)'_').join((Object)modelId, (Object)entityName, new Object[]{memberIds, PermCacheKey.MODEL_ENTITY_PERM_CLASS});
        String md5Key = StringUtils.stringToMD5((String)key);
        return (DynamicObject[])ThreadCache.get((Object)md5Key, () -> {
            QFBuilder rangeQf = new QFBuilder("model", "=", (Object)modelId).and("entityname", "=", (Object)entityName).and("entityid", "in", (Object)memberIds);
            return BusinessDataServiceHelper.load((String)"bcm_permclass_entity", (String)"entityid, permclass.id, permclass.number", (QFilter[])rangeQf.toArray());
        });
    }

    public static DynamicObjectCollection queryTotalDimensionPermissionClass(long modelId, String entityName, Collection<Long> memberIds) {
        String key = Joiner.on((char)'_').join((Object)modelId, (Object)entityName, new Object[]{memberIds, PermCacheKey.MODEL_ENTITY_PERM_CLASS_BY_QUERY});
        String md5Key = StringUtils.stringToMD5((String)key);
        return (DynamicObjectCollection)ThreadCache.get((Object)md5Key, () -> {
            QFBuilder rangeQf = new QFBuilder("model", "=", (Object)modelId).and("entityname", "=", (Object)entityName).and("entityid", "in", (Object)memberIds);
            return QueryServiceHelper.query((String)"bcm_permclass_entity", (String)"entityid, permclass.id, permclass.number", (QFilter[])rangeQf.toArray());
        });
    }

    public static DynamicObjectCollection getPermClassListFromDb(QFilter[] filter, String fields) {
        return QueryServiceHelper.query((String)"bcm_permclass_entity", (String)fields, (QFilter[])filter);
    }

    public static void savePermClassForExcelInput(String entityName, Long entityId, Object modelId, String number) {
        QFBuilder modelQf = new QFBuilder("model.id", "=", modelId);
        QFilter numberQf = new QFilter("number", "=", (Object)number);
        DynamicObject modelNumberClassEntity = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_permissionclass", (String)"number", (QFilter[])modelQf.add(numberQf).toArray());
        if (modelNumberClassEntity != null) {
            DynamicObject alreadyPermClass = PermClassEntityHelper.getPermissionClassEntity(entityName, entityId, modelId);
            if (alreadyPermClass != null) {
                alreadyPermClass.set(PERM_CLASS, (Object)modelNumberClassEntity);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{alreadyPermClass});
            } else {
                DynamicObject newPermClass = BusinessDataServiceHelper.newDynamicObject((String)"bcm_permclass_entity");
                newPermClass.set("entityname", (Object)entityName);
                newPermClass.set("model", modelId);
                newPermClass.set("entityid", (Object)entityId);
                newPermClass.set(PERM_CLASS, (Object)modelNumberClassEntity);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newPermClass});
            }
        }
    }

    public static void deleteEntities(List<Long> entityIds, Long modelId) {
        QFBuilder range = new QFBuilder("entityid", "in", entityIds);
        range.and("model", "=", (Object)modelId);
        int result = DeleteServiceHelper.delete((String)"bcm_permclass_entity", (QFilter[])range.toArray());
        LOGGER.info("delete permclass_entity: " + result);
    }

    public static ArrayListMultimap<String, Long> getPermissionMapBatch(String entityName, String modelId, String userId) {
        DynamicObjectCollection objects = PermClassEntityHelper.queryTotalDimensionPermissionClass(LongUtil.toLong((Object)modelId), entityName);
        if (!CollectionUtils.isEmpty((Collection)objects)) {
            return PermClassEntityHelper.getPermByPermClassList(modelId, userId, (List<DynamicObject>)objects, entityName, "permclass.id");
        }
        return ArrayListMultimap.create();
    }

    public static ArrayListMultimap<String, Long> getPermissionMapBatch(String entityName, String modelId, String userId, List<Long> memberIds) {
        DynamicObjectCollection objects = PermClassEntityHelper.queryTotalDimensionPermissionClass(LongUtil.toLong((Object)modelId), entityName, memberIds);
        if (!CollectionUtils.isEmpty((Collection)objects)) {
            return PermClassEntityHelper.getPermByPermClassList(modelId, userId, (List<DynamicObject>)objects, entityName, "permclass.id");
        }
        return ArrayListMultimap.create();
    }

    public static ArrayListMultimap<String, Long> getPermMapBatch(Object modelId, List<DynamicObject> permClass, String entityName) {
        return PermClassEntityHelper.getPermByPermClassList(String.valueOf(modelId), String.valueOf(RequestContext.get().getCurrUserId()), permClass, entityName);
    }

    private static ArrayListMultimap<String, Long> getPermByPermClassList(String modelId, String userId, List<DynamicObject> permClass, String entityName) {
        return PermClassEntityHelper.getPermByPermClassList(modelId, userId, permClass, entityName, "permclass_id");
    }

    private static ArrayListMultimap<String, Long> getPermByPermClassList(String modelId, String userId, List<DynamicObject> permClass, String entityName, String propertyKey) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        if (CollectionUtils.isEmpty(permClass)) {
            return multimap;
        }
        IDataEntityProperty dataEntityProperty = (IDataEntityProperty)permClass.get(0).getDataEntityType().getProperties().get((Object)propertyKey);
        List permClassIds = permClass.stream().map(object -> object.getLong(dataEntityProperty)).distinct().collect(Collectors.toList());
        permClassIds.remove(0L);
        if (CollectionUtils.isEmpty(permClassIds)) {
            return multimap;
        }
        String longKey = Joiner.on((char)'_').join((Object)modelId, permClassIds, new Object[]{entityName, PermCacheKey.PERM_CLASS_DB});
        String key = StringUtils.stringToMD5((String)longKey);
        return (ArrayListMultimap)ThreadCache.get((Object)key, () -> PermClassEntityHelper.getPermByPermClassListFromDb(modelId, userId, permClass, permClassIds, (ArrayListMultimap<String, Long>)multimap));
    }

    private static ArrayListMultimap<String, Long> getPermByPermClassListFromDb(String modelId, String userId, List<DynamicObject> permClass, List<Long> permClassIds, ArrayListMultimap<String, Long> multimap) {
        HashMap map = new HashMap(16);
        String selectFields = "data_auth,authclass.id";
        QFilter filter = new QFilter("model", "=", (Object)Long.parseLong(modelId));
        filter.and(new QFilter("authclass", "in", permClassIds));
        filter.and(new QFilter("users", "=", (Object)LongUtil.toLong((Object)userId)));
        filter.and(new QFilter("usertype", "=", (Object)UserTypeEnum.getUserTypeEnumByIndex((int)1).getName()));
        DynamicObjectCollection authInfos = QueryServiceHelper.query((String)"bcm_auth_info", (String)selectFields, (QFilter[])filter.toArray());
        Map<Object, Object> authInfoMap = Maps.newHashMapWithExpectedSize((int)authInfos.size());
        if (authInfos != null && authInfos.size() > 0) {
            IDataEntityProperty dataEntityProperty = (IDataEntityProperty)((DynamicObject)authInfos.get(0)).getDataEntityType().getProperties().get((Object)"authclass.id");
            authInfoMap = authInfos.stream().collect(Collectors.groupingBy(e -> e.getLong(dataEntityProperty)));
        }
        String select = "usergroup.id";
        QFilter qf = new QFilter("user", "=", (Object)LongUtil.toLong((Object)userId));
        DynamicObjectCollection groupData = QueryServiceHelper.query((String)"bos_usergroupstaff", (String)select, (QFilter[])qf.toArray());
        HashSet groups = Sets.newHashSetWithExpectedSize((int)groupData.size());
        if (groupData != null && groupData.size() > 0) {
            IDataEntityProperty groupDataProperty = (IDataEntityProperty)((DynamicObject)groupData.get(0)).getDataEntityType().getProperties().get((Object)"usergroup.id");
            groupData.forEach(e -> groups.add(e.getString(groupDataProperty)));
        }
        Set<String> groupIds = PermClassEntityHelper.getRelGroupIds(groups);
        QFilter qfs = new QFilter("model", "=", (Object)Long.parseLong(modelId));
        qfs.and(new QFilter("authclass", "in", permClassIds));
        qfs.and(new QFilter("users", "in", (Object)LongUtil.toLongList(groupIds)));
        qfs.and(new QFilter("usertype", "=", (Object)UserTypeEnum.getUserTypeEnumByIndex((int)0).getName()));
        DynamicObjectCollection groupDataAuth = QueryServiceHelper.query((String)"bcm_auth_info", (String)selectFields, (QFilter[])qfs.toArray());
        Map<Object, Object> groupDataAuthMap = Maps.newHashMapWithExpectedSize((int)groupDataAuth.size());
        if (groupDataAuth != null && groupDataAuth.size() > 0) {
            IDataEntityProperty groupDataAuthProperty = (IDataEntityProperty)((DynamicObject)groupDataAuth.get(0)).getDataEntityType().getProperties().get((Object)"authclass.id");
            groupDataAuthMap = groupDataAuth.stream().collect(Collectors.groupingBy(e -> e.getLong(groupDataAuthProperty)));
        }
        Map<Object, Object> finalAuthInfoMap = authInfoMap;
        HashMap finalGroupDataAuthMap = groupDataAuthMap;
        permClass.forEach(object -> {
            long classId = object.getLong("permclass.id");
            if (map.get(classId) == null) {
                String perm = PermClassEntityHelper.getDataPermissionBatch(userId, 1, classId, modelId, finalAuthInfoMap, groupData, finalGroupDataAuthMap);
                multimap.put((Object)perm, (Object)object.getLong("entityid"));
                map.put(classId, perm);
            } else {
                String perm = (String)map.get(classId);
                multimap.put((Object)perm, (Object)object.getLong("entityid"));
            }
        });
        return multimap;
    }

    public static String getDataPermissionBatch(String userid, int userType, Long PermissionClassId, String modelId, Map<Long, List<DynamicObject>> authInfoMap, DynamicObjectCollection groupData, Map<Long, List<DynamicObject>> groupDataAuthMap) {
        List<DynamicObject> data = authInfoMap.get(PermissionClassId);
        if (data != null && data.size() > 0 && "1".equals(data.get(0).getString("data_auth"))) {
            return "1";
        }
        if (groupData.size() == 0) {
            if (null != data && data.size() > 0) {
                return data.get(0).getString("data_auth");
            }
            return "1";
        }
        List<DynamicObject> groupDataAuth = groupDataAuthMap.get(PermissionClassId);
        if (groupDataAuth == null || groupDataAuth.size() == 0) {
            if (null != data && data.size() > 0) {
                return data.get(0).getString("data_auth");
            }
            return "1";
        }
        if (null == data || data.size() <= 0) {
            return Collections.min(groupDataAuth, Comparator.comparingInt(a -> Integer.parseInt(a.getString("data_auth")))).getString("data_auth");
        }
        int user = data.get(0).getInt("data_auth");
        int userGroup = Collections.min(groupDataAuth, Comparator.comparingInt(a -> Integer.parseInt(a.getString("data_auth")))).getInt("data_auth");
        return String.valueOf(Integer.min(user, userGroup));
    }

    public static List<Long> filterNoDistributePermMemb(String entityName, long modelId, ArrayListMultimap<String, Long> multimap) {
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)});
        return dynamicObjectCollection.stream().filter(d -> !multimap.values().contains(d.get("id"))).map(m -> m.getLong("id")).collect(Collectors.toList());
    }

    public static boolean isHasReadPerm(String entityName, Long modelId, Long entityId) {
        ArrayListMultimap<String, Long> map = PermClassEntityHelper.getPermissionMapBatch(entityName, modelId.toString(), RequestContext.get().getUserId());
        List list = map.get((Object)PermClassEnum.READONLY.value);
        return list.contains(entityId);
    }

    public static boolean isHasWritePerm(String entityName, Long modelId, Long entityId) {
        ArrayListMultimap<String, Long> map = PermClassEntityHelper.getPermissionMapBatch(entityName, modelId.toString(), RequestContext.get().getUserId());
        List list = map.get((Object)PermClassEnum.READWRITE.value);
        return list.contains(entityId);
    }

    public static boolean isHasReadPerm(String entityName, Long modelId, List<Long> entityIds) {
        ArrayListMultimap<String, Long> map = PermClassEntityHelper.getPermissionMapBatch(entityName, modelId.toString(), RequestContext.get().getUserId());
        List list = map.get((Object)PermClassEnum.READONLY.value);
        for (Long id : entityIds) {
            if (!list.contains(id)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNoPerm(String entityName, Long modelId, Long entityId) {
        ArrayListMultimap<String, Long> map = PermClassEntityHelper.getPermissionMapBatch(entityName, modelId.toString(), RequestContext.get().getUserId());
        List list = map.get((Object)PermClassEnum.NOPERM.value);
        return list.contains(entityId);
    }

    public static QFilter getNoPermMemberFilter(Long modelId) {
        long dimId = MemberReader.getDimensionIdByNum((long)LongUtil.toLong((Object)modelId), (String)PresetConstant.ENTITY_DIM);
        return PermissionServiceImpl.getInstance(modelId).getWritePermFilter(dimId, "bcm_entitymembertree", "org");
    }

    public static enum PermClassEnum {
        READWRITE(new MultiLangEnumBridge("\u8bfb\u5199", "PermClassEntityHelper_1", "fi-bcm-business"), "3"),
        READONLY(new MultiLangEnumBridge("\u53ea\u8bfb", "PermClassEntityHelper_2", "fi-bcm-business"), "2"),
        NOPERM(new MultiLangEnumBridge("\u65e0\u6743", "PermClassEntityHelper_3", "fi-bcm-business"), "1");

        private String name;
        private String value;
        private MultiLangEnumBridge bridge;

        private PermClassEnum(MultiLangEnumBridge bridge, String value) {
            this.bridge = bridge;
            this.value = value;
        }

        public String getName() {
            return this.bridge.loadKDString();
        }

        public String getValue() {
            return this.value;
        }

        public static PermClassEnum getPermTypeByVal(String val) {
            for (PermClassEnum p : PermClassEnum.values()) {
                if (!p.getValue().equals(val)) continue;
                return p;
            }
            throw new RuntimeException("error permEnum value : " + val);
        }
    }
}

