/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.permission.strategy;

import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.permission.cache.MembBaseItem;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.permission.strategy.IControl;
import kd.fi.bcm.business.permission.strategy.PermControlCacheHelper;
import kd.fi.bcm.business.serviceHelper.ICVersionServiceHelper;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;

public class AllChildrenExcludSelfControl
implements IControl {
    @Override
    public void matchItems(MembBaseItem pitem, Consumer<SimpleItem> c) {
        List<SimpleItem> s = PermControlCacheHelper.matchItems(pitem, () -> {
            if (pitem.isCustom()) {
                return TreeStructureServiceHelper.getChildByCustom(pitem.getEntityNum(), pitem.getmId(), pitem.getmLongNumber(), false, pitem.getSchemeId());
            }
            return TreeStructureServiceHelper.getChild(pitem.getEntityNum(), pitem.getmId(), pitem.getModelId());
        });
        if (s == null) {
            return;
        }
        for (SimpleItem s1 : s) {
            c.accept(s1);
        }
    }

    @Override
    public QFilter buildFilterByScope(MembBaseItem pitem) {
        if (pitem.isCustom()) {
            return TreeStructureServiceHelper.getFilterByCustomScope(pitem.getRange(), pitem.getmId(), pitem.getModelId());
        }
        return new QFilter("longnumber", "like", (Object)(pitem.getmLongNumber() + "!%"));
    }

    @Override
    public void matchItem4Ic(MembBaseItem item, Consumer<SimpleItem> consumer, VersionParam param) {
        List<SimpleItem> simpleItems = PermControlCacheHelper.matchItems(item, () -> {
            if (item.isCustom()) {
                return TreeStructureServiceHelper.getChildByCustom(item.getEntityNum(), item.getmId(), item.getmLongNumber(), false, item.getSchemeId());
            }
            return TreeStructureServiceHelper.getChild(item.getEntityNum(), item.getmId(), item.getModelId());
        });
        if (simpleItems == null) {
            return;
        }
        Set<Long> ids = ICVersionServiceHelper.getInvalidIdByParent(param);
        for (SimpleItem simple : simpleItems) {
            if (ids.contains(simple.getId())) continue;
            consumer.accept(simple);
        }
    }
}

