/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.permission.strategy;

import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.permission.cache.MembBaseItem;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.permission.strategy.IControl;
import kd.fi.bcm.business.permission.strategy.PermControlCacheHelper;
import kd.fi.bcm.business.serviceHelper.ICVersionServiceHelper;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;

public class AllChildrenOnlyDetailControl
implements IControl {
    @Override
    public void matchItems(MembBaseItem pitem, Consumer<SimpleItem> c) {
        List<SimpleItem> s2 = PermControlCacheHelper.matchItems(pitem, () -> {
            if (pitem.isCustom()) {
                return TreeStructureServiceHelper.getAssignChildByCustom(pitem.getEntityNum(), pitem.getmId(), pitem.getmLongNumber(), true, pitem.getSchemeId());
            }
            List<SimpleItem> s = TreeStructureServiceHelper.getChildByAssign(pitem.getEntityNum(), pitem.getmId(), pitem.getModelId(), true);
            return s;
        });
        for (SimpleItem s1 : s2) {
            c.accept(s1);
        }
    }

    @Override
    public QFilter buildFilterByScope(MembBaseItem pitem) {
        boolean isTrue = true;
        if (pitem.isCustom()) {
            return TreeStructureServiceHelper.getFilterByCustomScope(pitem.getRange(), pitem.getmId(), pitem.getModelId());
        }
        QFilter filter = new QFilter("longnumber", "like", (Object)(pitem.getmLongNumber() + "!%")).and("isleaf", "=", (Object)isTrue);
        filter.or(new QFilter("id", "=", (Object)pitem.getmId()).and(new QFilter("isleaf", "=", (Object)isTrue)));
        return filter;
    }

    @Override
    public void matchItem4Ic(MembBaseItem item, Consumer<SimpleItem> consumer, VersionParam param) {
        List<SimpleItem> simpleItems = PermControlCacheHelper.matchItems(item, () -> {
            if (item.isCustom()) {
                return TreeStructureServiceHelper.getAssignChildByCustom(item.getEntityNum(), item.getmId(), item.getmLongNumber(), true, item.getSchemeId());
            }
            return TreeStructureServiceHelper.getChildByAssign(item.getEntityNum(), item.getmId(), item.getModelId(), true);
        });
        if (simpleItems == null) {
            return;
        }
        Set<Long> ids = ICVersionServiceHelper.getInvalidIdByParent(param);
        for (SimpleItem simple : simpleItems) {
            if (ids.contains(simple.getId())) continue;
            consumer.accept(simple);
        }
    }
}

