/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.permission.strategy;

import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.permission.cache.MembBaseItem;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.permission.strategy.IControl;
import kd.fi.bcm.business.permission.strategy.PermControlCacheHelper;
import kd.fi.bcm.business.serviceHelper.ICVersionServiceHelper;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;

public class DirectChildrenIncSelfControl
implements IControl {
    @Override
    public void matchItems(MembBaseItem pitem, Consumer<SimpleItem> c) {
        List<SimpleItem> s = PermControlCacheHelper.matchItems(pitem, () -> {
            if (pitem.isCustom()) {
                return TreeStructureServiceHelper.getDirectChildByCustom(pitem.getEntityNum(), pitem.getmId(), true, pitem.getSchemeId());
            }
            List<SimpleItem> s2 = TreeStructureServiceHelper.getDirectChild(pitem.getEntityNum(), (Object)pitem.getmId(), pitem.getModelId());
            s2.add(SimpleItem.newOne(pitem.getmId(), pitem.getNumber()));
            return s2;
        });
        for (SimpleItem s1 : s) {
            c.accept(s1);
        }
    }

    @Override
    public QFilter buildFilterByScope(MembBaseItem pitem) {
        if (pitem.isCustom()) {
            return TreeStructureServiceHelper.getFilterByCustomScope(pitem.getRange(), pitem.getmId(), pitem.getModelId());
        }
        return new QFilter("id", "=", (Object)pitem.getmId()).or("parent", "=", (Object)pitem.getmId());
    }

    @Override
    public void matchItem4Ic(MembBaseItem item, Consumer<SimpleItem> consumer, VersionParam param) {
        List<SimpleItem> simpleItems = PermControlCacheHelper.matchItems(item, () -> {
            if (item.isCustom()) {
                return TreeStructureServiceHelper.getDirectChildByCustom(item.getEntityNum(), item.getmId(), true, item.getSchemeId());
            }
            List<SimpleItem> s2 = TreeStructureServiceHelper.getDirectChild(item.getEntityNum(), (Object)item.getmId(), item.getModelId());
            s2.add(SimpleItem.newOne(item.getmId(), item.getNumber()));
            return s2;
        });
        if (simpleItems == null) {
            return;
        }
        Set<Long> ids = ICVersionServiceHelper.getInvalidIdByParent(param);
        for (SimpleItem simple : simpleItems) {
            if (ids.contains(simple.getId())) continue;
            consumer.accept(simple);
        }
    }
}

