/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.permission.strategy;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.member.MemberListUtil;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.permission.cache.MembBaseItem;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.strategy.IControl;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.RangeEnum;

public class DynamicMemberControl
implements IControl {
    @Override
    public void matchItems(MembBaseItem pitem, Consumer<SimpleItem> c) {
        ArrayList s = new ArrayList(16);
        Set<Object> ids = this.getDynamicMemberIds(pitem);
        DynamicObjectCollection result = QueryServiceHelper.query((String)pitem.getEntityNum(), (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids.toArray())});
        result.forEach(e -> s.add(SimpleItem.newOne(e.get("id"), e.getString("number"))));
        for (SimpleItem s1 : s) {
            c.accept(s1);
        }
    }

    @Override
    public QFilter buildFilterByScope(MembBaseItem pitem) {
        if (pitem.isCustom()) {
            return TreeStructureServiceHelper.getFilterByCustomScope(pitem.getRange(), pitem.getmId(), pitem.getModelId());
        }
        return new QFilter("id", "in", this.getDynamicMemberIds(pitem));
    }

    public Set<Object> getDynamicMemberIds(MembBaseItem pitem) {
        HashSet<Object> ids = new HashSet<Object>(16);
        QFilter range = MemberListUtil.buildFilter(pitem.getModelId(), pitem.getEntityNum(), pitem.getRangeId());
        DynamicObjectCollection list = QueryServiceHelper.query((String)pitem.getEntityNum(), (String)"id,number,name", (QFilter[])range.toArray());
        list.forEach(val -> ids.add(val.getLong("id")));
        return ids;
    }

    private Set<Object> getBaseRange(String entityName, long base, int range, Object modelId) {
        HashSet allIds = Sets.newHashSetWithExpectedSize((int)16);
        String dimNum = MemberReader.getDimensionNumById((long)base);
        if (range < RangeEnum.VALUE_20000.getValue()) {
            new MembRangeItem(entityName, (Long)base, dimNum, range, false, modelId).matchItems(v -> allIds.add(v.id));
        }
        return allIds;
    }

    private String getEntityName(Long dimensionId) {
        QFilter fdimenId = new QFilter("id", "=", (Object)dimensionId);
        QFilter[] filters = new QFilter[]{fdimenId};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)"bcm_dimension", (String)"membermodel", (QFilter[])filters, (String)"");
        if (dcs != null && dcs.size() > 0) {
            return ((DynamicObject)dcs.get(0)).getString("membermodel");
        }
        return "";
    }
}

