/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.permission.strategy;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.permission.cache.MembBaseItem;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.permission.strategy.IControl;
import kd.fi.bcm.business.permission.strategy.PermControlCacheHelper;
import kd.fi.bcm.business.serviceHelper.ICVersionServiceHelper;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;

public class OnlySelfControl
implements IControl {
    @Override
    public void matchItems(MembBaseItem pitem, Consumer<SimpleItem> c) {
        List<SimpleItem> s = PermControlCacheHelper.matchItems(pitem, () -> {
            if (pitem.isCustom()) {
                return TreeStructureServiceHelper.getSelfByCustom(pitem.getModelId(), pitem.getEntityNum(), pitem.getmId(), pitem.getSchemeId());
            }
            return Lists.newArrayList((Object[])new SimpleItem[]{SimpleItem.newOne(pitem.getmId(), pitem.getNumber())});
        });
        if (s == null) {
            return;
        }
        for (SimpleItem s1 : s) {
            c.accept(s1);
        }
    }

    @Override
    public QFilter buildFilterByScope(MembBaseItem pitem) {
        if (pitem.isCustom()) {
            return TreeStructureServiceHelper.getFilterByCustomScope(pitem.getRange(), pitem.getmId(), pitem.getModelId());
        }
        return new QFilter("id", "=", (Object)pitem.getmId());
    }

    @Override
    public void matchItem4Ic(MembBaseItem item, Consumer<SimpleItem> consumer, VersionParam param) {
        List<SimpleItem> simpleItems = PermControlCacheHelper.matchItems(item, () -> {
            if (item.isCustom()) {
                return TreeStructureServiceHelper.getSelfByCustom(item.getModelId(), item.getEntityNum(), item.getmId(), item.getSchemeId());
            }
            return Lists.newArrayList((Object[])new SimpleItem[]{SimpleItem.newOne(item.getmId(), item.getNumber())});
        });
        if (simpleItems == null) {
            return;
        }
        Set<Long> ids = ICVersionServiceHelper.getInvalidIdByParent(param);
        for (SimpleItem simple : simpleItems) {
            if (ids.contains(simple.getId())) continue;
            consumer.accept(simple);
        }
    }
}

