/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.permission.strategy;

import kd.fi.bcm.business.permission.strategy.AllChildrenExcludSelfControl;
import kd.fi.bcm.business.permission.strategy.AllChildrenIncSelfControl;
import kd.fi.bcm.business.permission.strategy.AllChildrenOnlyDetailControl;
import kd.fi.bcm.business.permission.strategy.AllChildrenOnlyNonDetailControl;
import kd.fi.bcm.business.permission.strategy.BrotherExcludeSelfControl;
import kd.fi.bcm.business.permission.strategy.BrotherIncSelfControl;
import kd.fi.bcm.business.permission.strategy.DirectChildrenExcludSelfControl;
import kd.fi.bcm.business.permission.strategy.DirectChildrenIncSelfControl;
import kd.fi.bcm.business.permission.strategy.DynamicMemberControl;
import kd.fi.bcm.business.permission.strategy.IControl;
import kd.fi.bcm.business.permission.strategy.InvSheetChildrenIncludeSelfMemberControl;
import kd.fi.bcm.business.permission.strategy.InvSheetOnlySelfMember;
import kd.fi.bcm.business.permission.strategy.OnlySelfControl;
import kd.fi.bcm.business.permission.strategy.StaticMemberControl;
import kd.fi.bcm.common.enums.RangeEnum;

public class PermControlStrategy {
    private static final IControl self = new OnlySelfControl();
    private static final IControl dirChildIncSelf = new DirectChildrenIncSelfControl();
    private static final IControl dirChildExcSelf = new DirectChildrenExcludSelfControl();
    private static final IControl allChildIncSelf = new AllChildrenIncSelfControl();
    private static final IControl allChildExcSelf = new AllChildrenExcludSelfControl();
    private static final IControl brotherIncSelf = new BrotherIncSelfControl();
    private static final IControl brotherExcSelf = new BrotherExcludeSelfControl();
    private static final IControl allDetailChild = new AllChildrenOnlyDetailControl();
    private static final IControl allNonDetailChild = new AllChildrenOnlyNonDetailControl();
    private static final IControl staticMember = new StaticMemberControl();
    private static final IControl dynamicMember = new DynamicMemberControl();
    private static final IControl invSheetChildrenIncludeSelfMember = new InvSheetChildrenIncludeSelfMemberControl();
    private static final IControl invSheetOnlySelfMember = new InvSheetOnlySelfMember();

    public static IControl getStrategy(RangeEnum range) {
        switch (range) {
            case VALUE_10: {
                return Strategy.Only_Self.supply();
            }
            case VALUE_20: {
                return Strategy.Direct_Chidren_Exclude_self.supply();
            }
            case VALUE_30: {
                return Strategy.Direct_Chidren_Iclude_Self.supply();
            }
            case VALUE_40: {
                return Strategy.ALL_Chidren_Exclude_Self.supply();
            }
            case VALUE_50: {
                return Strategy.ALL_Chidren_Iclude_Self.supply();
            }
            case VALUE_60: {
                return Strategy.Brother_Exclude_Self.supply();
            }
            case VALUE_70: {
                return Strategy.Brother_Include_Self.supply();
            }
            case VALUE_90: {
                return Strategy.All_Detail_Children.supply();
            }
            case VALUE_110: {
                return Strategy.All_NonDetail_Children.supply();
            }
            case VALUE_10000: {
                return Strategy.Static_Member.supply();
            }
            case VALUE_20000: {
                return Strategy.Dynamic_Member.supply();
            }
            case VALUE_300: {
                return Strategy.Non_Independent_Parent_All_Children_Include_Self.supply();
            }
            case VALUE_310: {
                return Strategy.Non_Independent_Parent_Only_Self.supply();
            }
        }
        throw new RuntimeException("not support perm Range:" + range.getName());
    }

    static enum Strategy {
        Only_Self{

            @Override
            IControl supply() {
                return self;
            }
        }
        ,
        Direct_Chidren_Iclude_Self{

            @Override
            IControl supply() {
                return dirChildIncSelf;
            }
        }
        ,
        Direct_Chidren_Exclude_self{

            @Override
            IControl supply() {
                return dirChildExcSelf;
            }
        }
        ,
        ALL_Chidren_Iclude_Self{

            @Override
            IControl supply() {
                return allChildIncSelf;
            }
        }
        ,
        ALL_Chidren_Exclude_Self{

            @Override
            IControl supply() {
                return allChildExcSelf;
            }
        }
        ,
        Brother_Include_Self{

            @Override
            IControl supply() {
                return brotherIncSelf;
            }
        }
        ,
        Brother_Exclude_Self{

            @Override
            IControl supply() {
                return brotherExcSelf;
            }
        }
        ,
        All_Detail_Children{

            @Override
            IControl supply() {
                return allDetailChild;
            }
        }
        ,
        All_NonDetail_Children{

            @Override
            IControl supply() {
                return allNonDetailChild;
            }
        }
        ,
        Static_Member{

            @Override
            IControl supply() {
                return staticMember;
            }
        }
        ,
        Dynamic_Member{

            @Override
            IControl supply() {
                return dynamicMember;
            }
        }
        ,
        Non_Independent_Parent_All_Children_Include_Self{

            @Override
            IControl supply() {
                return invSheetChildrenIncludeSelfMember;
            }
        }
        ,
        Non_Independent_Parent_Only_Self{

            @Override
            IControl supply() {
                return invSheetOnlySelfMember;
            }
        };


        abstract IControl supply();
    }
}

