/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.reportlist;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.report.ReportLeftTreeTabEnum;
import kd.fi.bcm.common.util.LongUtil;

public class OpenReportListHelper {
    public static final String MODEL = "model";
    public static final String YEAR = "year";
    public static final String PERIOD = "period";
    public static final String SCENE = "scenario";
    public static final String ENTITY = "entity";
    public static final String CURRENCY = "currency";
    public static final String CSLSCHEME = "cslscheme";
    public static final String LEFTTREETYPE = "lefttreetype";
    public static final String TEMPLATESELECTEDNODEID = "templateselectedNodeId";

    public static void openReportList(Map<String, Object> params, IFormView currentView) {
        if (params.get(MODEL) == null || params.get(SCENE) == null || params.get(YEAR) == null || params.get(PERIOD) == null || params.get(CURRENCY) == null || params.get(ENTITY) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f3a\u5931\u6253\u5f00\u62a5\u8868\u7f16\u5236\u5217\u8868\u754c\u9762\u6240\u9700\u7684\u516c\u5171\u53c2\u6570\uff08\u4f53\u7cfb\u3001\u60c5\u666f\u3001\u8d22\u5e74\u3001\u671f\u95f4\u3001\u5e01\u79cd\u548c\u7ec4\u7ec7\uff09\uff0c\u8bf7\u8865\u5168\u53c2\u6570\u540e\u518d\u91cd\u8bd5\u3002", (String)"OpenReportListHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        IFormView mainPageView = currentView.getMainView();
        String pageId = currentView.getPageId() + "openReportList" + params.get(SCENE) + params.get(YEAR) + params.get(PERIOD) + params.get(ENTITY) + params.get(CURRENCY);
        if (mainPageView == null || mainPageView.getView(pageId) == null) {
            ListShowParameter formShowParameter = new ListShowParameter();
            formShowParameter.setFormId("bcm_report_list");
            formShowParameter.setPageId(pageId);
            long modelId = OpenReportListHelper.getIdFromParams(MODEL, params);
            formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)modelId);
            formShowParameter.setCustomParam(MODEL, (Object)modelId);
            Long cslschemeId = 0L;
            Long orgId = OpenReportListHelper.getIdFromParams(ENTITY, params);
            if (params.get(CSLSCHEME) != null) {
                cslschemeId = OpenReportListHelper.getIdFromParams(CSLSCHEME, params);
            } else {
                IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
                if (node != IDNumberTreeNode.NotFoundTreeNode) {
                    cslschemeId = (Long)node.getProperty("cslscheme.id");
                }
            }
            if (params.get(TEMPLATESELECTEDNODEID) != null) {
                formShowParameter.setCustomParam(TEMPLATESELECTEDNODEID, (Object)OpenReportListHelper.getIdFromParams(TEMPLATESELECTEDNODEID, params));
            }
            formShowParameter.setCustomParam(CSLSCHEME, (Object)cslschemeId);
            formShowParameter.setCustomParam(SCENE, params.get(SCENE));
            formShowParameter.setCustomParam(YEAR, params.get(YEAR));
            formShowParameter.setCustomParam(PERIOD, params.get(PERIOD));
            formShowParameter.setCustomParam(CURRENCY, params.get(CURRENCY));
            formShowParameter.setCustomParam("common_guide_page", currentView.getFormShowParameter().getCustomParam("common_guide_page"));
            formShowParameter.setCustomParam(ENTITY, (Object)orgId);
            ReportLeftTreeTabEnum tabpage = ReportLeftTreeTabEnum.ENTITY;
            if (params.get(LEFTTREETYPE) instanceof ReportLeftTreeTabEnum) {
                tabpage = (ReportLeftTreeTabEnum)params.get(LEFTTREETYPE);
            }
            formShowParameter.setBillFormId("bcm_reportlistentitylay");
            formShowParameter.setCustomParam(LEFTTREETYPE, (Object)tabpage.getKey());
            formShowParameter.setCustomParam("used", (Object)"weavereport");
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            IFormView pageView = currentView.getParentView();
            if (pageView == null) {
                pageView = currentView;
            }
            pageView.showForm((FormShowParameter)formShowParameter);
            currentView.sendFormAction(pageView);
        } else {
            IFormView pageView = mainPageView.getView(pageId);
            pageView.activate();
            currentView.sendFormAction(pageView);
        }
    }

    public static Long getIdFromParams(String key, Map<String, Object> customParams) {
        try {
            return LongUtil.toLong((Object)customParams.get(key));
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static String getTemplateselectedNodeId(IFormView currentView) {
        String selectnode = currentView.getPageCache().get(TEMPLATESELECTEDNODEID);
        Map customParams = currentView.getFormShowParameter().getCustomParams();
        if (customParams.get(TEMPLATESELECTEDNODEID) != null) {
            long id = OpenReportListHelper.getIdFromParams(TEMPLATESELECTEDNODEID, customParams);
            if (id != 0L) {
                selectnode = Long.toString(id);
            }
            if (selectnode != null) {
                currentView.getPageCache().put(TEMPLATESELECTEDNODEID, selectnode);
            }
        }
        return selectnode;
    }
}

