/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.reportlist.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class ReportRedisCache {
    public static final String TEMPLATECACHEFORREPORTLIST = "queryTemplateList";

    public static List<TemplateModel> queryTemplateModelFromCache(Set<? extends Object> selecttemplateidList, long modelId, boolean isOnlyWeaveTmpl) {
        Map queryTemplateMap = (Map)GlobalCacheServiceHelper.getCommonCache().getOrLoad(TEMPLATECACHEFORREPORTLIST + modelId, () -> {
            ConcurrentHashMap<Long, TemplateModel> queryTemplateCache = new ConcurrentHashMap<Long, TemplateModel>(16);
            ReportRedisCache.queryTemplateModel(selecttemplateidList, isOnlyWeaveTmpl, queryTemplateCache);
            return queryTemplateCache;
        });
        HashSet<? extends Object> copy = new HashSet<Object>(selecttemplateidList);
        copy.removeIf(p -> queryTemplateMap.containsKey(Long.valueOf(p.toString())));
        if (!copy.isEmpty()) {
            ReportRedisCache.queryTemplateModel(copy, isOnlyWeaveTmpl, queryTemplateMap);
            GlobalCacheServiceHelper.getCommonCache().replaceCache(TEMPLATECACHEFORREPORTLIST + modelId, (Object)queryTemplateMap);
        }
        return queryTemplateMap.values().stream().filter(p -> selecttemplateidList.contains(p.getId())).collect(Collectors.toList());
    }

    private static void queryTemplateModel(Set<? extends Object> selecttemplateidList, boolean isOnlyWeaveTmpl, Map<Long, TemplateModel> queryTemplateCache) {
        ArrayList<TemplateModel> models = new ArrayList<TemplateModel>();
        ArrayList<Object> notexist = new ArrayList<Object>();
        for (Object object : selecttemplateidList) {
            String templateSerial = AppCacheServiceHelper.get(ReportRedisCache.getAppCacheKey(object), String.class);
            if (StringUtils.isEmpty((CharSequence)templateSerial)) {
                notexist.add(object);
                continue;
            }
            TemplateModel t = (TemplateModel)ObjectSerialUtil.deSerializedBytes((String)templateSerial);
            if (isOnlyWeaveTmpl && TemplateModel.UsageEnum.QUERY.getStatuValue().equals(t.getUsage())) continue;
            models.add(t);
        }
        List<TemplateModel> templates = ReportRedisCache.transferDynaObj2Model(notexist, false, isOnlyWeaveTmpl);
        for (TemplateModel tml : templates) {
            AppCacheServiceHelper.put(ReportRedisCache.getAppCacheKey(tml.getId()), ObjectSerialUtil.toByteSerialized((Object)tml));
        }
        models.addAll(templates);
        models.forEach(m -> queryTemplateCache.put(m.getId(), (TemplateModel)m));
    }

    private static List<TemplateModel> transferDynaObj2Model(Collection<?> ids, boolean isExcludeNoFormulaTemplate, boolean isOnlyWeaveTmpl) {
        ArrayList<TemplateModel> templates = new ArrayList<TemplateModel>(16);
        if (isExcludeNoFormulaTemplate) {
            // empty if block
        }
        if (!ids.isEmpty()) {
            DynamicObject[] dynas;
            QFBuilder fb = new QFBuilder();
            fb.add("isfintemplate", "=", (Object)"1").add("id", "in", ids);
            if (isOnlyWeaveTmpl) {
                fb.add("usage", "=", (Object)"1");
            }
            if (Objects.isNull(dynas = BusinessDataServiceHelper.load((String)"bcm_templateentity", (String)TemplateModel.getSimpleModelSeleter(), (QFilter[])fb.toArray(), (String)"createtime")) || dynas.length == 0) {
                return templates;
            }
            long modelId = dynas[0].getLong("model.id");
            List<Long> notCacheId = ids.stream().map(i -> LongUtil.toLong((Object)i)).collect(Collectors.toList());
            TemplateUtil.transferDynaObj2Model(modelId, dynas, notCacheId, templates, true, false);
        }
        return templates;
    }

    public static void removeTemplateModelFromCache(Object templateid) {
        AppCacheServiceHelper.remove(ReportRedisCache.getAppCacheKey(templateid));
    }

    public static String getAppCacheKey(Object templateid) {
        return String.valueOf(templateid) + "reportlistplugin";
    }
}

