/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.scheme;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.scheme.AbstractScheme;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.DimensionScope;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.enums.BusinessTypeEnum;
import kd.fi.bcm.common.util.CollectionUtil;

public class AdjustCvtCurrencyScheme
extends AbstractScheme
implements Serializable {
    private List<String> bustypeList;
    private DimensionScope orgScope;
    private Set<Long> curIds = new HashSet<Long>(5);

    public AdjustCvtCurrencyScheme(Long model) {
        super(model, "", "", false, "");
    }

    public AdjustCvtCurrencyScheme(DynamicObject scheme) {
        this(scheme.getLong("model.id"));
        this.initScheme(scheme);
    }

    private void initScheme(DynamicObject scheme) {
        String value = (String)scheme.get("businesstype");
        if (!StringUtils.isBlank((String)value)) {
            this.bustypeList = Arrays.asList(value.split(","));
        }
        DynamicObjectCollection entryCol = scheme.getDynamicObjectCollection("entryentity");
        for (DynamicObject detail : entryCol) {
            switch (detail.getString("dimensionnum")) {
                case "Entity": {
                    this.getDimensionScope().addDimeMemRange(detail.getLong("memberid"), detail.getInt("scope"));
                    break;
                }
                case "Currency": {
                    this.curIds.add(detail.getLong("memberid"));
                }
            }
        }
    }

    public boolean ishit(long orgId, String businessType) {
        if (CollectionUtil.isEmpty(this.bustypeList)) {
            return false;
        }
        String busIndex = BusinessTypeEnum.searchByName((String)businessType).getIndex();
        String modelNum = AdjustCvtCurrencyScheme.getAdjCvtCurDimCtx(this.getModel()).getModelNumber();
        IDNumberTreeNode orgNode = BcmThreadCache.findNodeById((String)modelNum, (String)"Entity", (long)orgId);
        return this.bustypeList.contains(busIndex) && this.orgScope.contains(orgNode.getNumber());
    }

    public Set<Long> getCurIds() {
        return this.curIds;
    }

    private DimensionScope getDimensionScope() {
        if (this.orgScope == null) {
            Dimension dim = AdjustCvtCurrencyScheme.getAdjCvtCurDimCtx(this.getModel()).getDimensionByNumber("Entity");
            this.orgScope = new DimensionScope(this.getModel() + "", dim);
        }
        return this.orgScope;
    }

    public static SchemeContext getAdjCvtCurDimCtx(Long modelId) {
        return (SchemeContext)ThreadCache.get((Object)"AdjustCvtCurrencyScheme", () -> new SchemeContext(modelId));
    }

    @Override
    protected void initSchemeDetails(DynamicObjectCollection schemedetailDys) {
    }

    @Override
    public DynamicObject toDy(SchemeContext schemeContext) {
        return null;
    }
}

