/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.scheme;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.common.util.QFBuilder;

public class Dimension
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String number;
    private Long id;
    private String fieldmapped;
    private String entity;
    private boolean issys;
    private int seq;
    private String membermodel;
    private String shortnum;
    private DynamicObject dynamicObject;
    private Set<String> dimensionMembers;

    @JsonCreator
    public Dimension(@JsonProperty(value="name") String name, @JsonProperty(value="number") String number, @JsonProperty(value="id") Long uqCode, @JsonProperty(value="realfieldKey") String fieldmapped) {
        this.name = name;
        this.number = number;
        this.id = uqCode;
        this.entity = DimensionServiceHelper.getDimMembEntityNumByDimNum(number);
        this.issys = !"bcm_userdefinedmembertree".equalsIgnoreCase(this.entity);
        this.fieldmapped = StringUtils.isBlank((CharSequence)fieldmapped) ? number.toLowerCase(Locale.ENGLISH) : fieldmapped;
    }

    public Dimension(DynamicObject dimension) {
        this.name = dimension.getString("name");
        this.number = dimension.getString("number");
        this.id = dimension.getLong("id");
        this.fieldmapped = dimension.getString("fieldmapped");
        this.entity = DimensionServiceHelper.getDimMembEntityNumByDimNum(this.number);
        this.issys = !"bcm_userdefinedmembertree".equalsIgnoreCase(this.entity);
        this.shortnum = dimension.getString("shortnumber");
        this.dynamicObject = dimension;
        this.fieldmapped = StringUtils.isBlank((CharSequence)this.fieldmapped) ? this.number.toLowerCase(Locale.ENGLISH) : this.fieldmapped;
    }

    public String getShortnum() {
        return this.shortnum;
    }

    public DynamicObject getDynamicObject() {
        return this.dynamicObject;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public Integer getSeq() {
        return this.seq;
    }

    public String getMembermodel() {
        return this.membermodel;
    }

    public void setMembermodel(String membermodel) {
        this.membermodel = membermodel;
    }

    public String getEntity() {
        return this.entity;
    }

    public boolean isIssys() {
        return this.issys;
    }

    public Set<String> getDimensionMembers() {
        return this.dimensionMembers;
    }

    public void initDimenMembers(QFBuilder qf) {
        this.dimensionMembers = BusinessDataServiceHelper.loadFromCache((String)this.getEntity(), (String)"number", (QFilter[])qf.toArray()).values().stream().map(p -> p.getString("number")).collect(Collectors.toSet());
        if (this.dimensionMembers == null) {
            this.dimensionMembers = new HashSet<String>();
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Dimension) {
            Dimension dimension1 = (Dimension)o;
            return this.getNumber().equalsIgnoreCase(dimension1.getNumber());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getName() {
        return this.name;
    }

    public String getNumber() {
        return this.number;
    }

    public Long getId() {
        return this.id;
    }

    public String getFieldmapped() {
        return this.fieldmapped;
    }

    public String toString() {
        return "name:" + this.name + " number:" + this.number;
    }

    public void setFieldmapped(String fieldmapped) {
        this.fieldmapped = fieldmapped;
    }
}

