/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.scheme;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.model.AbstractDimensionMember;
import kd.fi.bcm.business.scheme.model.DimensionMember;
import kd.fi.bcm.business.scheme.model.PrefPropertyDimensionMember;
import kd.fi.bcm.business.scheme.model.SysPropertyDimensionMember;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.MenuShowTypeEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.papertemplate.PaperTemplateScenarioSettingConstant;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.fel.common.StringUtils;

public class DimensionScope
implements Serializable {
    private String modelId;
    private final Map<String, String> dimensionMemberMap = new HashMap<String, String>();
    private Dimension dimension;
    private final List<AbstractDimensionMember> dimensionMembers = new ArrayList<AbstractDimensionMember>();
    private final Set<String> resolveScopes = new HashSet<String>();
    private final Set<Long> resolveScopeIds = new HashSet<Long>();
    private List<Map<String, String>> dimMembers = new ArrayList<Map<String, String>>();

    public DimensionScope(String modelId, Dimension dimension) {
        this.init(modelId, dimension);
    }

    public DimensionScope(String modelId, Dimension dimension, Map<Long, Integer> dimemMap) {
        this.init(modelId, dimension);
        dimemMap.forEach(this::addDimeMemRange);
    }

    public DimensionScope(String modelId, Dimension dimension, List<DynamicObject> dimMembers) {
        this.init(modelId, dimension);
        boolean hasApplyType = true;
        if (dimMembers.size() > 0) {
            hasApplyType = dimMembers.get(0).containsProperty("applytype");
        }
        boolean finalHasApplyType = hasApplyType;
        dimMembers.stream().filter(p -> p.getLong("dimensionmember") != 0L).forEach(dimMember -> this.addDimeMemRange(dimMember.getLong("dimensionmember"), dimMember.getInt("scope"), finalHasApplyType ? dimMember.getInt("applytype") : 0));
    }

    private void init(String modelId, Dimension dimension) {
        this.dimension = dimension;
        this.modelId = modelId;
    }

    public static boolean isDimensionScopeEqual(DimensionScope r1Ds, DimensionScope r2Ds) {
        return r1Ds == null || r2Ds == null || r1Ds.equals(r2Ds);
    }

    public void addDimeMemRange(long memId, int range) {
        this.addDimeMemRange(memId, range, 0);
    }

    public void addDimeMemRange(long memId, int range, int applyType) {
        Map allNode = MemberReader.getAllNodeFromCache((String)this.dimension.getEntity(), (Object)LongUtil.toLong((Object)this.modelId));
        Map allNodeProperty = MemberReader.getAllNodeFromCache((String)"bcm_definedpropertyvalue", (Object)LongUtil.toLong((Object)this.modelId));
        IDNumberTreeNode treeNode = (IDNumberTreeNode)allNode.get(memId);
        if (treeNode != null) {
            this.dimensionMemberMap.put(treeNode.getNumber(), treeNode.getName());
            if (this.dimensionMembers.stream().noneMatch(p -> p.getScope() == range && p.getId().equals(memId) && p.getApplyType() == applyType)) {
                this.dimensionMembers.add(new DimensionMember(this.dimension, treeNode.getNumber(), memId, range, applyType));
            }
        } else {
            treeNode = (IDNumberTreeNode)allNodeProperty.get(memId);
            if (treeNode != null) {
                this.dimensionMemberMap.put(treeNode.getNumber(), treeNode.getName());
                this.dimensionMembers.add(new SysPropertyDimensionMember(this.dimension, String.format("%s:%s", StringUtils.isEmpty((CharSequence)((CharSequence)treeNode.getProperty("property.number"))) ? treeNode.getNumber() : treeNode.getProperty("property.number"), treeNode.getNumber()), memId, range, applyType));
            }
        }
    }

    public void addDimPreAttribute(String commonfield, int scope) {
        this.dimensionMembers.add(new PrefPropertyDimensionMember(this.dimension, commonfield, scope));
    }

    public DimensionScope(String modelId, Dimension dimension, DynamicObjectCollection dimMembers) {
        this.modelId = modelId;
        this.dimension = dimension;
        dimMembers.forEach(dimMember -> this.addDimeMemRange(dimMember.getLong("mid1"), dimMember.getInt("filltypevalue1")));
    }

    public Set<String> getResolveScopes() {
        return this.getResolveScopes(null);
    }

    public Set<String> getResolveScopes(VersionParam param) {
        List<AbstractDimensionMember> applyMemberScops;
        if (this.resolveScopes.isEmpty() && (applyMemberScops = this.dimensionMembers.stream().filter(e -> e.getApplyType() == 0).collect(Collectors.toList())).size() > 0) {
            HashSet applyNums = new HashSet(16);
            applyMemberScops.forEach(dimensionMember -> applyNums.addAll(dimensionMember.resolveItems(this.modelId, param)));
            if (applyNums.size() > 0) {
                List<AbstractDimensionMember> unApplyMemberScops = this.dimensionMembers.stream().filter(e -> e.getApplyType() == 1).collect(Collectors.toList());
                unApplyMemberScops.forEach(dimensionMember -> applyNums.removeAll(dimensionMember.resolveItems(this.modelId, param)));
            }
            this.resolveScopes.addAll(applyNums);
        }
        return this.resolveScopes;
    }

    public Set<String> getNoResolveScopes() {
        return this.dimensionMembers.stream().map(AbstractDimensionMember::getNumber).collect(Collectors.toSet());
    }

    public Set<Long> getResolveScopeIds() {
        return this.getResolveScopeIds(null);
    }

    public Set<Long> getResolveScopeIds(VersionParam param) {
        List<AbstractDimensionMember> applyMemberScops;
        if (this.resolveScopeIds.isEmpty() && (applyMemberScops = this.dimensionMembers.stream().filter(e -> e.getApplyType() == 0).collect(Collectors.toList())).size() > 0) {
            HashSet applyIds = new HashSet(16);
            applyMemberScops.forEach(dimensionMember -> applyIds.addAll(dimensionMember.resolveItemIds(this.modelId, param)));
            if (applyIds.size() > 0) {
                List<AbstractDimensionMember> unApplyMemberScops = this.dimensionMembers.stream().filter(e -> e.getApplyType() == 1).collect(Collectors.toList());
                unApplyMemberScops.forEach(dimensionMember -> applyIds.removeAll(dimensionMember.resolveItemIds(this.modelId, param)));
            }
            this.resolveScopeIds.addAll(applyIds);
        }
        return this.resolveScopeIds;
    }

    public void clear() {
        this.dimensionMembers.clear();
        this.dimMembers.clear();
        this.resolveScopeIds.clear();
        this.dimensionMembers.clear();
    }

    public void getDys(DynamicObjectCollection dys) {
        this.dimensionMembers.forEach(dimensionMember -> dimensionMember.toDy(dys));
    }

    public List<Map<String, String>> getdimMembers() {
        if (this.dimMembers == null || this.dimMembers.isEmpty()) {
            this.dimMembers = this.dimensionMembers.stream().map(dimensionMember -> {
                String name = this.dimensionMemberMap.get(dimensionMember.getNumber());
                Map<String, String> dimMember = dimensionMember.getDimMember();
                if (StringUtils.isNotEmpty((CharSequence)name)) {
                    dimMember.put("name", name);
                }
                return dimMember;
            }).collect(Collectors.toList());
        }
        return this.dimMembers;
    }

    public List<AbstractDimensionMember> getDimensionMembers() {
        return this.dimensionMembers;
    }

    public String getDimMemNameByNum(String number) {
        return this.dimensionMemberMap.get(number);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof DimensionScope) {
            DimensionScope ds = (DimensionScope)o;
            Set<String> resolveScopes = this.getResolveScopes();
            Set<String> resolveScopesDs = ds.getResolveScopes();
            if (CollectionUtil.isEmpty(resolveScopes) || CollectionUtil.isEmpty(resolveScopesDs)) {
                return true;
            }
            return resolveScopes.stream().anyMatch(resolveScopesDs::contains);
        }
        return true;
    }

    public boolean contains(String number) {
        return this.getResolveScopes().contains(number);
    }

    public boolean isEmpty() {
        return this.getResolveScopes().isEmpty();
    }

    public int size() {
        return this.getResolveScopes().size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.dimensionMembers.stream().forEach(dimensionMember -> sb.append(dimensionMember.toString(this.dimensionMemberMap)));
        return sb.toString();
    }

    public String getApplyString() {
        StringBuilder sb = new StringBuilder();
        this.dimensionMembers.stream().forEach(dimensionMember -> {
            sb.append(PaperTemplateScenarioSettingConstant.ExceptEnum.getExcepByCode((String)(dimensionMember.getApplyType() + "")).getName());
            sb.append(dimensionMember.toString(this.dimensionMemberMap));
        });
        return sb.toString();
    }

    public String getNumberName() {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        int size = this.dimensionMemberMap.size();
        for (Map.Entry<String, String> entry : this.dimensionMemberMap.entrySet()) {
            sb.append(entry.getKey()).append(" ").append(entry.getValue());
            if (index < size) {
                sb.append(" ");
            }
            ++index;
        }
        return sb.toString();
    }

    public String toPersonalString(MenuShowTypeEnum userShowType) {
        String result = "";
        StringBuilder sb = new StringBuilder();
        if (userShowType == MenuShowTypeEnum.NUMBER) {
            this.dimensionMembers.forEach(dimensionMember -> sb.append(dimensionMember.getNumber()).append(";"));
            result = sb.toString();
        } else if (userShowType == MenuShowTypeEnum.NAME) {
            this.dimensionMembers.forEach(dimensionMember -> sb.append(this.dimensionMemberMap.get(dimensionMember.getNumber())).append(";"));
            result = sb.toString();
        } else if (userShowType == MenuShowTypeEnum.NUMBERNDNAME) {
            this.dimensionMembers.forEach(dimensionMember -> sb.append(dimensionMember.getNumber()).append("-").append(this.dimensionMemberMap.get(dimensionMember.getNumber())).append(";"));
            result = sb.toString();
        }
        return result;
    }

    public String toMultiPersonalString(MenuShowTypeEnum userShowType) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.dimensionMembers.size(); ++i) {
            StringBuilder rangeName = new StringBuilder();
            AbstractDimensionMember member = this.dimensionMembers.get(i);
            String number = member.getNumber();
            String name = null;
            name = member instanceof PrefPropertyDimensionMember ? ((PrefPropertyDimensionMember)member).getName() : this.getDimMemNameByNum(number);
            if (RangeEnum.getRangeByVal((int)member.getScope()) != RangeEnum.VALUE_10 && i != this.dimensionMembers.size() - 1) {
                rangeName.append(ResManager.loadKDString((String)"\u7684", (String)"DimensionScope_0", (String)"fi-bcm-business", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)member.getScope()).getName()).append(',');
            } else {
                rangeName.append(",");
            }
            if (userShowType == null) {
                result.append(name).append((CharSequence)rangeName);
                continue;
            }
            if (MenuShowTypeEnum.NUMBERNDNAME == userShowType) {
                result.append(number).append("-").append(name).append("@").append(RangeEnum.getRangeByVal((int)member.getScope()).getNumber()).append("-").append(RangeEnum.getRangeByVal((int)member.getScope()).getName()).append(',');
                continue;
            }
            if (MenuShowTypeEnum.NUMBER == userShowType) {
                result.append(number).append("@").append(RangeEnum.getRangeByVal((int)member.getScope()).getNumber()).append(',');
                continue;
            }
            result.append(name).append((CharSequence)rangeName);
        }
        String res = result.toString();
        return StringUtils.isNotEmpty((CharSequence)res) ? res.substring(0, res.length() - 1) : null;
    }

    public Dimension getDimension() {
        return this.dimension;
    }
}

