/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.scheme;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.scheme.AbstractScheme;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.DimensionScope;
import kd.fi.bcm.business.scheme.SchemeContext;

public class LossCarryScheme
extends AbstractScheme
implements Serializable {
    protected static final List<String> lossSchemeSysDim = new ArrayList<String>(3);
    private DimensionScope applyEntityScope;
    private DimensionScope applySceneScope;
    private boolean isOpen = true;
    public static List<String> applyDims;
    private Map<Dimension, DynamicObject> afterDimenSopeInfo;
    private int rowIndex = -1;
    private boolean isRepeat = Boolean.FALSE;

    public static SchemeContext getLossCarryDimCtx(Long modelId) {
        return (SchemeContext)ThreadCache.get((Object)"LossCarrySchemeCtx", () -> {
            SchemeContext ctx = new SchemeContext(modelId);
            ctx.removeIf(dim -> dim.isIssys() && !lossSchemeSysDim.contains(dim.getNumber()) && !applyDims.contains(dim.getNumber()));
            return ctx;
        });
    }

    public static List<Dimension> getDimensions(Long modelId) {
        List<Dimension> dimensions = LossCarryScheme.getLossCarryDimCtx(modelId).getDimensions();
        return dimensions.stream().filter(d -> !applyDims.contains(d.getNumber())).collect(Collectors.toList());
    }

    public Map<Dimension, DynamicObject> getAfterDimenSopeInfo() {
        if (this.afterDimenSopeInfo == null) {
            this.afterDimenSopeInfo = new HashMap<Dimension, DynamicObject>();
        }
        return this.afterDimenSopeInfo;
    }

    public LossCarryScheme(long modelid) {
        super(modelid, null, null, false, null);
        this.initSchemeDetails();
    }

    private void initSchemeDetails() {
        this.initSchemeDetails(null);
    }

    public LossCarryScheme(DynamicObject scheme) {
        super(0L, null, null, false, null);
        this.setModel(this.transformDimid(scheme, "model"));
        this.setSeq(scheme.getInt("dseq"));
        this.setOpen(scheme.getBoolean("isopen"));
        this.initSchemeDetailsByData(scheme, scheme.getDynamicObjectCollection("annualaccountbefore"));
    }

    private void initSchemeDetailsByData(DynamicObject scheme, DynamicObjectCollection schemedetailDys) {
        for (Dimension dim : LossCarryScheme.getDimensions(this.getModel())) {
            this.getAfterDimenSopeInfo().put(dim, scheme.getDynamicObject(dim.getFieldmapped()));
        }
        this.initSchemeDetails(schemedetailDys);
    }

    @Override
    protected void initSchemeDetails(DynamicObjectCollection schemedetailDys) {
        if (schemedetailDys == null || schemedetailDys.isEmpty()) {
            return;
        }
        HashMap schemedetails = new HashMap();
        Map<Long, List<DynamicObject>> annacc = schemedetailDys.stream().collect(Collectors.groupingBy(rowData -> rowData.getLong("dimension.id")));
        this.getAfterDimenSopeInfo().keySet().forEach(dim -> {
            List dimscopes = (List)annacc.get(dim.getId());
            DimensionScope dimensionScope = null;
            if (dimscopes != null && !dimscopes.isEmpty()) {
                dimensionScope = new DimensionScope(Long.toString(this.getModel()), (Dimension)dim, dimscopes);
            }
            schemedetails.put(dim, dimensionScope);
        });
        this.setSchemeDetails(schemedetails);
        applyDims.forEach(dimNum -> {
            Optional<Dimension> dimensionOptional = LossCarryScheme.getLossCarryDimCtx(this.getModel()).getDimensions().stream().filter(e -> e.getNumber().equals(dimNum)).findFirst();
            dimensionOptional.ifPresent(dim -> {
                List dimscopes = (List)annacc.get(dim.getId());
                DimensionScope dimensionScope = null;
                if (dimscopes != null && !dimscopes.isEmpty()) {
                    dimensionScope = new DimensionScope(Long.toString(this.getModel()), (Dimension)dim, dimscopes);
                }
                if ("Entity".equals(dim.getNumber())) {
                    this.applyEntityScope = dimensionScope;
                } else if ("Scenario".equals(dim.getNumber())) {
                    this.applySceneScope = dimensionScope;
                }
            });
        });
    }

    @Override
    public DynamicObject toDy(SchemeContext schemeContext) {
        DynamicObject annaccount = BusinessDataServiceHelper.newDynamicObject((String)"bcm_annualaccount");
        annaccount.set("model", (Object)this.getModel());
        annaccount.set("dseq", (Object)this.getSeq());
        annaccount.set("isopen", (Object)this.isOpen());
        this.getAfterDimenSopeInfo().forEach((dim, dy) -> annaccount.set(dim.getFieldmapped(), dy));
        DynamicObjectCollection annualaccount = annaccount.getDynamicObjectCollection("annualaccountbefore");
        this.getSchemeDetails().forEach((dim, ds) -> {
            if (ds != null) {
                ((DimensionScope)ds).getDys(annualaccount);
            }
        });
        if (this.getApplySceneScope() != null) {
            this.getApplySceneScope().getDys(annualaccount);
        }
        if (this.getApplyEntityScope() != null) {
            this.getApplyEntityScope().getDys(annualaccount);
        }
        return annaccount;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public final void setOpen(boolean open) {
        this.isOpen = open;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public boolean isRepeat() {
        return this.isRepeat;
    }

    public void setRepeat(boolean repeat) {
        this.isRepeat = repeat;
    }

    public DimensionScope getApplyEntityScope() {
        return this.applyEntityScope;
    }

    public DimensionScope getApplySceneScope() {
        return this.applySceneScope;
    }

    public void setApplyEntityScope(DimensionScope applyEntityScope) {
        this.applyEntityScope = applyEntityScope;
    }

    public void setApplySceneScope(DimensionScope applySceneScope) {
        this.applySceneScope = applySceneScope;
    }

    static {
        lossSchemeSysDim.add("Account");
        lossSchemeSysDim.add("MultiGAAP");
        lossSchemeSysDim.add("ChangeType");
        lossSchemeSysDim.add("InternalCompany");
        lossSchemeSysDim.add("MyCompany");
        lossSchemeSysDim.add("DataSort");
        lossSchemeSysDim.add("AuditTrail");
        applyDims = Arrays.asList("Entity", "Scenario");
    }
}

