/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.scheme;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.scheme.AbstractScheme;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.DimensionScope;
import kd.fi.bcm.business.scheme.SchemeContext;

public class ModelOlapScheme
extends AbstractScheme
implements Serializable {
    public static final String TYPE_SRC = "0";
    public static final String TYPE_DES = "1";
    public static final String TYPE_CLEAR = "2";
    private String storagetype;
    private SchemeContext schemeContext;
    private String detailmsg;
    private Map<String, Set<String>> resolveParams;
    private String status = "0";

    public ModelOlapScheme(long model, String runmodel) {
        super(model, null, null, true, runmodel);
        this.initSchemeDetails();
    }

    private void initSchemeDetails() {
        this.initSchemeDetails(null);
    }

    public ModelOlapScheme(Long model, DynamicObject modelos) {
        super(model, modelos.getString("number"), modelos.getString("name"), true, modelos.getString("runmodel"));
        this.storagetype = modelos.getString("storagetype");
        this.setRemark(modelos.getString("remark"));
        this.initSchemeDetailsForData(modelos.getDynamicObjectCollection("dimrange"));
    }

    private void initSchemeDetailsForData(DynamicObjectCollection schemedetailDys) {
        this.initSchemeDetails(schemedetailDys);
    }

    @Override
    protected void initSchemeDetails(DynamicObjectCollection schemedetailDys) {
        this.initSchemeModel();
        if (schemedetailDys == null) {
            return;
        }
        Map<String, List<DynamicObject>> schemedetails = schemedetailDys.stream().collect(Collectors.groupingBy(schemedetailDy -> schemedetailDy.getString("dimension")));
        schemedetails.forEach((dimnum, dimList) -> {
            Dimension dimension = this.getSchemeContext().getDimensionByNumber((String)dimnum);
            Map<String, List<DynamicObject>> dimdetails = dimList.stream().collect(Collectors.groupingBy(dim -> dim.getString("dimensionproperty")));
            dimdetails.forEach((type, dimdetail) -> ((Map)this.getSchemeDetails().get(type)).put(dimension, new DimensionScope(Long.toString(this.getModel()), dimension, (List<DynamicObject>)dimdetail)));
        });
    }

    private void initSchemeModel() {
        this.schemeContext = new SchemeContext(this.getModel());
        this.schemeDetails = new HashMap();
        if (this.isCopy()) {
            this.schemeDetails.put(TYPE_SRC, new HashMap());
            this.schemeDetails.put(TYPE_DES, new HashMap());
        } else {
            this.schemeDetails.put(TYPE_CLEAR, new HashMap());
        }
    }

    @Override
    public DynamicObject toDy(SchemeContext schemeContext) {
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_modelolap_record");
        dy.set("model", (Object)this.getModel());
        dy.set("runmodel", (Object)this.getRunnmodel());
        dy.set("rundetails", (Object)this.toString());
        dy.set("creater", (Object)RequestContext.get().getUserId());
        dy.set("createdate", (Object)TimeServiceHelper.now());
        dy.set("number", (Object)this.getNumber());
        dy.set("storagetype", (Object)this.getStoragetype());
        dy.set("remark", (Object)this.getRemark());
        if (!this.isRecord()) {
            dy.set("modifier", (Object)RequestContext.get().getUserId());
            dy.set("modifydate", (Object)TimeServiceHelper.now());
            dy.set("name", (Object)this.getName());
            DynamicObjectCollection dimRange = dy.getDynamicObjectCollection("dimrange");
            this.getSchemeDetails().forEach((type, details) -> ((Map)details).forEach((dimension, detail) -> detail.getDimensionMembers().forEach(member -> {
                DynamicObject dim = dimRange.addNew();
                dim.set("dimension", (Object)dimension.getNumber());
                dim.set("dimensionproperty", type);
                dim.set("dimensionmember", (Object)member.getId());
                dim.set("dimmembernum", (Object)member.getNumber());
                dim.set("dimemname", (Object)detail.getDimMemNameByNum(member.getNumber()));
                dim.set("scope", (Object)member.getScope());
            })));
        }
        return dy;
    }

    public boolean isCopy() {
        return TYPE_SRC.equalsIgnoreCase(this.getRunnmodel());
    }

    public boolean isRecord() {
        return this.getStoragetype().equalsIgnoreCase(TYPE_SRC);
    }

    public String getRunnmodel() {
        return super.getSchemeType();
    }

    public void setRunnmodel(String runnmodel) {
        this.setSchemeType(runnmodel);
    }

    public String getStoragetype() {
        return this.storagetype;
    }

    public SchemeContext getSchemeContext() {
        return this.schemeContext;
    }

    public void setResolveParams(Map<String, Set<String>> resolveParams) {
        this.resolveParams = resolveParams;
    }

    public Map<String, Set<String>> getResolveParams() {
        return this.resolveParams;
    }

    public String getDetailmsg() {
        return this.detailmsg;
    }

    public void setDetailmsg(String detailmsg) {
        this.detailmsg = detailmsg;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.getSchemeContext().getDimensions().forEach(dim -> {
            DimensionScope src = (DimensionScope)((Map)this.getSchemeDetails().get(this.isCopy() ? TYPE_SRC : TYPE_CLEAR)).get(dim);
            if (src != null && !src.isEmpty()) {
                sb.append(dim.getNumber()).append(" ").append(dim.getName()).append('\uff1a').append(src.getNumberName());
                if (this.isCopy() && src.size() == 1) {
                    src = (DimensionScope)((Map)this.getSchemeDetails().get(TYPE_DES)).get(dim);
                    sb.append(" --> ").append(src.getNumberName());
                }
                sb.append('\n');
            }
        });
        return sb.toString();
    }

    public void setStoragetype(String storagetype) {
        this.storagetype = storagetype;
    }
}

