/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.scheme;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.scheme.AbstractScheme;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.scheme.SimpleIDNumberTreeNode;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;

public class ReportDataScheme
extends AbstractScheme
implements Serializable {
    public static final String SELECT = "id,number,name,dimension,dimension.id,dimension.number";

    public ReportDataScheme(long model, String number, String name, boolean issys, String schemeType, DynamicObjectCollection schemedetailDys) {
        super(model, number, name, issys, schemeType);
        this.initSchemeDetailsByData(schemedetailDys);
    }

    private void initSchemeDetailsByData(DynamicObjectCollection schemedetailDys) {
        this.initSchemeDetails(schemedetailDys);
    }

    public ReportDataScheme(long model, DynamicObject dy) {
        super(model, dy.getString("number"), dy.getString("name"), dy.getBoolean("issystem"), dy.getString("schemetype"));
        this.initSchemeDetailsByData(dy.getDynamicObjectCollection("detail"));
    }

    private String getModelNum() {
        return (String)ThreadCache.get((Object)String.join((CharSequence)"_", "ReportDataScheme", "" + this.getModel()), () -> MemberReader.findModelNumberById((Object)this.getModel()));
    }

    @Override
    protected void initSchemeDetails(DynamicObjectCollection schemedetailDys) {
        if (schemedetailDys == null) {
            return;
        }
        if (this.schemeDetails == null) {
            this.schemeDetails = new HashMap(16);
            for (DynamicObject detail : schemedetailDys) {
                String dimNum = detail.getString("dimension.number");
                long memId = detail.getLong("dimensionmember");
                this.schemeDetails.put(dimNum, ReportDataScheme.covert2Simple(BcmThreadCache.findNodeById((String)this.getModelNum(), (String)dimNum, (long)memId)));
            }
        }
    }

    @Override
    public Map getSchemeDetails() {
        if (this.schemeDetails == null) {
            this.schemeDetails = new HashMap();
        }
        return ReportDataScheme.convertIDNumberTreeNode2Dyna(this.schemeDetails);
    }

    @Override
    public void appendSchemeDetail(String key, Object node) {
        if (this.schemeDetails == null) {
            this.schemeDetails = new HashMap();
        }
        if (node instanceof IDNumberTreeNode) {
            this.schemeDetails.put(key, ReportDataScheme.covert2Simple((IDNumberTreeNode)node));
        }
    }

    public Map getTreeNodeSchemeDetails() {
        if (this.schemeDetails == null) {
            this.schemeDetails = new HashMap();
        }
        return this.schemeDetails;
    }

    public static Map<String, DynamicObject> convertIDNumberTreeNode2Dyna(Map<String, SimpleIDNumberTreeNode> map) {
        HashMap<String, DynamicObject> details = new HashMap<String, DynamicObject>(16);
        if (map == null) {
            return details;
        }
        map.forEach((k, v) -> details.put((String)k, ReportDataScheme.queryDynamicObjectById(v)));
        return details;
    }

    public static DynamicObject queryDynamicObjectById(SimpleIDNumberTreeNode node) {
        return (DynamicObject)ThreadCache.get((Object)String.join((CharSequence)"_", "queryDynamicObjectById", node.getDimNum(), node.getNumber(), node.getId() + ""), () -> BusinessDataServiceHelper.loadSingle((String)DimEntityNumEnum.getEntieyNumByNumber((String)node.getDimNum()), (String)SELECT, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)node.getId())}));
    }

    public static SimpleIDNumberTreeNode covert2Simple(IDNumberTreeNode node) {
        SimpleIDNumberTreeNode parent = null;
        IDNumberTreeNode treeNode = node.getParent();
        if (treeNode != null) {
            parent = new SimpleIDNumberTreeNode(treeNode.getId(), treeNode.getNumber(), treeNode.getDimNumber(), treeNode.getName(), treeNode.getModelId(), null, treeNode.isLeaf());
        }
        return new SimpleIDNumberTreeNode(node.getId(), node.getNumber(), node.getDimNumber(), node.getName(), node.getModelId(), parent, node.isLeaf());
    }

    @Override
    public DynamicObject toDy(SchemeContext schemeContext) {
        DynamicObject reportdata = BusinessDataServiceHelper.newDynamicObject((String)"bcm_reportdata_custseting");
        reportdata.set("number", (Object)this.getNumber());
        reportdata.set("name", (Object)this.getName());
        reportdata.set("model", (Object)this.getModel());
        reportdata.set("issystem", (Object)(this.isIssys() ? "1" : "0"));
        reportdata.set("sequence", (Object)this.getSeq());
        reportdata.set("schemetype", (Object)this.getSchemeType());
        DynamicObjectCollection details = reportdata.getDynamicObjectCollection("detail");
        this.getTreeNodeSchemeDetails().forEach((dimnumber, v) -> {
            if (v != null) {
                DynamicObject det = details.addNew();
                det.set("dimension", (Object)schemeContext.getDimensionByNumber(dimnumber.toString()).getId());
                det.set("dimensionmember", (Object)((SimpleIDNumberTreeNode)v).getId());
            }
        });
        return reportdata;
    }
}

