/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.scheme;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CacheTypeEnum;

public class SchemeContext
implements Serializable {
    private final long model;
    private long templateId;
    private final List<Dimension> dimensions;
    private final String modelNumber;
    private final Map<String, Long> fieldMap;
    private final Map<String, Long> numberMap;
    private final Map<String, Long> shortNumberMap;
    private final Map<Long, Dimension> idMap;
    public static final String TEMPLATEID = "template";

    public static SchemeContext getInstance(long modelId) {
        return new SchemeContext(modelId);
    }

    public SchemeContext(long model) {
        this.model = model;
        this.fieldMap = new HashMap<String, Long>(16);
        this.numberMap = new HashMap<String, Long>(16);
        this.idMap = new HashMap<Long, Dimension>(16);
        this.shortNumberMap = new HashMap<String, Long>(16);
        this.modelNumber = MemberReader.findModelNumberById((Object)model);
        String cacheKey = "SchemeContext." + model;
        List dimListCache = (List)ThreadCache.get((Object)cacheKey, () -> (List)GlobalCacheServiceHelper.getCache((CacheTypeEnum)CacheTypeEnum.TemporaryCache).getOrLoad(cacheKey, () -> QueryServiceHelper.query((String)"bcm_dimension", (String)"shortnumber,id,dseq,membermodel,issysdimension,name,number,fieldmapped", (QFilter[])new QFilter("model", "=", (Object)model).toArray(), (String)"dseq").stream().map(p -> {
            Dimension dimension = new Dimension((DynamicObject)p);
            dimension.setSeq(p.getInt("dseq"));
            dimension.setMembermodel(p.getString("membermodel"));
            return dimension;
        }).collect(Collectors.toList())));
        this.dimensions = new ArrayList<Dimension>(dimListCache);
        this.dimensions.forEach(p -> {
            this.idMap.put(p.getId(), (Dimension)p);
            this.fieldMap.put(p.getFieldmapped(), p.getId());
            this.numberMap.put(p.getNumber(), p.getId());
            this.shortNumberMap.put(p.getShortnum(), p.getId());
        });
    }

    public SchemeContext(long model, Object templateId) {
        this(model);
        this.templateId = templateId == null ? 0L : (Long)templateId;
    }

    public boolean removeIf(Predicate<? super Dimension> predicate) {
        Objects.requireNonNull(predicate);
        boolean isToRemove = false;
        Iterator<Dimension> iterator = this.dimensions.iterator();
        while (iterator.hasNext()) {
            Dimension dimension = iterator.next();
            if (!predicate.test(dimension)) continue;
            iterator.remove();
            isToRemove = true;
            this.idMap.remove(dimension.getId());
            this.fieldMap.remove(dimension.getFieldmapped());
            this.numberMap.remove(dimension.getNumber());
        }
        return isToRemove;
    }

    public String getModelNumber() {
        return this.modelNumber;
    }

    public List<Dimension> getDimensions() {
        return new ArrayList<Dimension>(this.dimensions);
    }

    public long getModel() {
        return this.model;
    }

    public Dimension getDimensionById(long dimensionid) {
        return this.dimensions.stream().filter(p -> dimensionid == p.getId()).findFirst().orElse(null);
    }

    public Dimension getDimensionByNumber(String dimnumber) {
        return this.dimensions.stream().filter(p -> dimnumber.equalsIgnoreCase(p.getNumber())).findFirst().orElse(null);
    }

    public Dimension getDimensionByShortNum(String shortNum) {
        Long dimId = this.shortNumberMap.get(shortNum);
        if (dimId != null) {
            return this.idMap.get(dimId);
        }
        return null;
    }

    public Dimension getDimensionByField(String fieldKey) {
        Long dimId = this.fieldMap.get(fieldKey);
        if (dimId != null) {
            return this.idMap.get(dimId);
        }
        return null;
    }

    public Map<String, Long> getNumberMap() {
        return new HashMap<String, Long>(this.numberMap);
    }

    public Map<String, Long> getFieldMap() {
        return new HashMap<String, Long>(this.fieldMap);
    }

    public Map<String, Long> getShortNumberMap() {
        return new HashMap<String, Long>(this.shortNumberMap);
    }

    public Map<Long, Dimension> getDimensionMap() {
        return new HashMap<Long, Dimension>(this.idMap);
    }

    public long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(long templateId) {
        this.templateId = templateId;
    }
}

