/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.scheme.model;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.model.AbstractDimensionMember;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.RangeEnum;

public class DimensionMember
extends AbstractDimensionMember
implements Serializable {
    public DimensionMember(Dimension dimension, DynamicObject dy) {
        super(dimension, dy);
    }

    public DimensionMember(Dimension dimension, String number, Long id, int scope) {
        super(dimension, number, id, scope);
    }

    public DimensionMember(Dimension dimension, String number, Long id, int scope, int applyType) {
        super(dimension, number, id, scope, applyType);
    }

    @Override
    public String toString(Map<String, String> dimensionMemberMap) {
        StringBuilder sb = new StringBuilder();
        sb.append(dimensionMemberMap.get(this.getNumber())).append("(").append(this.getNumber()).append(")");
        if (this.scope != 0 && this.scope != 10) {
            sb.append(ResManager.loadKDString((String)"\u7684", (String)"DimensionMember_0", (String)"fi-bcm-business", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)this.scope).getName());
        }
        sb.append(';');
        return sb.toString();
    }

    @Override
    public Set<String> resolveItems(String modelId, VersionParam param) {
        Dimension dim = this.getDimension();
        if (param != null && "InternalCompany".equals(dim.getNumber())) {
            return AdjustOperationHelper.queryIcMemberNumbersByRange(param, this.number, RangeEnum.getRangeByVal((int)this.scope));
        }
        return QueryMemberDetailsHelper.queryMemberNumbersByRange(this.dimension.getEntity(), this.id, this.number, this.scope, modelId, DetailTypeEnum.MEMBERPERM);
    }

    @Override
    public Set<Long> resolveItemIds(String modelId, VersionParam param) {
        if (param != null && "InternalCompany".equals(this.dimension.getNumber())) {
            return AdjustOperationHelper.queryIcMemberIdsByRange(param, this.id, RangeEnum.getRangeByVal((int)this.scope));
        }
        return QueryMemberDetailsHelper.queryMemberIdsByRange(this.dimension.getEntity(), this.id, this.scope, modelId, DetailTypeEnum.MEMBERPERM);
    }
}

