/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.script;

import java.util.List;
import java.util.Objects;
import kd.bos.olap.dataSources.AggAxis;
import kd.bos.olap.dataSources.AggExpressionItem;
import kd.bos.olap.dataSources.AggPair;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.ComputingCommandInfo;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.IExpressionItem;
import kd.bos.olap.dataSources.MultiDimensionAggExpressionItem;
import kd.bos.olap.dataSources.OlapCommand;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.enums.AggOprtEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.util.OlapCommandUtil;

public class MultiDimAggCommandBuilder {
    private String cube;
    private ComputingCommandInfo command;
    private MultiDimensionAggExpressionItem aggItem;

    public MultiDimAggCommandBuilder(String cube, OlapSourceEnum sourceEnum) {
        this.cube = cube;
        this.command = new ComputingCommandInfo();
        this.command.setMainMeaName("FMONEY");
        this.aggItem = new MultiDimensionAggExpressionItem();
        this.command.addExpression((IExpressionItem)this.aggItem);
        OlapCommandUtil.addSourceMeasure((String)cube, (CommandInfo)this.command, (OlapSourceEnum)sourceEnum);
    }

    public AggAxisBuilder builtAggAxis() {
        return new AggAxisBuilder(this);
    }

    public FilterBuilder builtFilter() {
        return new FilterBuilder(this);
    }

    public void postCommand() {
        OlapCommand cmd = new OlapCommand(OlapServiceHelper.getOlapConnection(this.cube), (CommandInfo)this.command);
        cmd.executeCompute();
    }

    static abstract class AbstractBuilder {
        private MultiDimAggCommandBuilder builder;

        AbstractBuilder(MultiDimAggCommandBuilder builder) {
            this.builder = builder;
        }

        public void setBuilder(MultiDimAggCommandBuilder builder) {
            this.builder = builder;
        }

        public MultiDimAggCommandBuilder getBuilder() {
            return this.builder;
        }

        abstract MultiDimAggCommandBuilder endBuilt();
    }

    public static class FilterBuilder
    extends AbstractBuilder {
        FilterBuilder(MultiDimAggCommandBuilder builder) {
            super(builder);
        }

        public FilterBuilder addDimensionFilter(String dim, String ... filters) {
            this.getBuilder().command.addFilter(dim, filters);
            return this;
        }

        public FilterBuilder setDimensionFilter(List<DimensionFilterItem> filters) {
            this.getBuilder().command.setFilter(filters);
            return this;
        }

        @Override
        public MultiDimAggCommandBuilder endBuilt() {
            return this.getBuilder();
        }
    }

    public static class AggAxisBuilder
    extends AbstractBuilder {
        private AggAxis axis = new AggAxis();
        private AggExpressionItem aggExpr;

        AggAxisBuilder(MultiDimAggCommandBuilder builder) {
            super(builder);
        }

        public AggAxisBuilder setMainDimensionName(String dim) {
            this.axis.setMainDimensionName(dim);
            return this;
        }

        public AggAxisBuilder setLeftAggExpressionItem(String member) {
            Objects.requireNonNull(member);
            if (this.aggExpr == null) {
                this.aggExpr = new AggExpressionItem(member);
            }
            return this;
        }

        public AggAxisBuilder setRightAggExpressionItem(String member, String oprt) {
            if (this.aggExpr == null) {
                this.aggExpr = new AggExpressionItem();
            }
            Objects.requireNonNull(member);
            Objects.requireNonNull(oprt);
            this.aggExpr.addExpressRight(new AggPair(member, oprt));
            return this;
        }

        public AggAxisBuilder setRightAggExpressionItems(PairList<String, String> pairs) {
            if (this.aggExpr == null) {
                this.aggExpr = new AggExpressionItem();
            }
            pairs.forEach(p -> this.aggExpr.addExpressRight(new AggPair((String)p.p1, (String)p.p2)));
            return this;
        }

        public AggAxisBuilder setRightAggExpressionItemsByDefaultAddOprt(String ... members) {
            if (this.aggExpr == null) {
                this.aggExpr = new AggExpressionItem();
            }
            for (String m : members) {
                this.aggExpr.addExpressRight(new AggPair(m, AggOprtEnum.ADD.name));
            }
            return this;
        }

        @Override
        public MultiDimAggCommandBuilder endBuilt() {
            this.axis.addExpressionItem(this.aggExpr);
            this.getBuilder().aggItem.addAxis(this.axis);
            return this.getBuilder();
        }
    }
}

