/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.script;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.fi.bcm.business.log.ErrorLogServiceHelper;
import kd.fi.bcm.business.olap.verify.OlapDataVerifyServiceHelper;
import kd.fi.bcm.business.script.ScopeBuilder;
import kd.fi.bcm.common.FiBcmErrorCode;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.ThrowableHelper;
import org.apache.commons.collections.CollectionUtils;

public class RunScriptRecordUtil {
    private static final Log LOG = LogFactory.getLog(RunScriptRecordUtil.class);
    private static final String RUN_SCRIPT = "bcm_runscript";
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"bcm_runscript", (int)5);
    private static final List<String> checkDimensions = Arrays.asList(PresetConstant.ENTITY_DIM, PresetConstant.SCENE_DIM, PresetConstant.FY_DIM, PresetConstant.PERIOD_DIM, PresetConstant.CURRENCY_DIM);

    public static void recordRunScript(Exception e, String cubecatalog, String command, boolean saveDb) {
        if (saveDb) {
            threadPool.execute(() -> ErrorLogServiceHelper.saveErrorLog(MemberReader.findModelIdByNum((String)cubecatalog), "runscript", command, ThrowableHelper.generatekernelMessageInfo((Throwable)e, (int)20)));
        } else {
            LOG.error(String.format("[%s] runscript error! command:[%s]", cubecatalog, command), (Throwable)e);
        }
    }

    public static void verifyDimensionDataStatus(List<ScopeBuilder.DimensionScopeInfo> scopes, List<List<Map<String, String>>> scriptDims, String cubecatalog) {
        ArrayList scope = new ArrayList();
        for (int i = 0; i < scopes.size(); ++i) {
            ScopeBuilder.DimensionScopeInfo scopeDimensionInfo = scopes.get(i);
            if (!checkDimensions.contains(scopeDimensionInfo.getDimNum())) continue;
            String[] scope1 = scopeDimensionInfo.getScope();
            ArrayList list = new ArrayList(scope1.length);
            for (String s : scope1) {
                HashMap<String, String> scopeMap = new HashMap<String, String>();
                scopeMap.put(scopeDimensionInfo.getDimNum(), s);
                list.add(scopeMap);
            }
            scope.add(list);
        }
        List scopeDims = Lists.cartesianProduct(scope);
        boolean noScope = CollectionUtils.isEmpty((Collection)scopeDims);
        if (noScope) {
            RunScriptRecordUtil.verifyScript(scriptDims, cubecatalog);
        } else {
            RunScriptRecordUtil.verifyScript(scriptDims, cubecatalog, scopeDims);
        }
    }

    private static void verifyScript(List<List<Map<String, String>>> scriptDims, String cubecatalog, List<List<Map<String, String>>> scopeDims) {
        Long entityId = null;
        Long scenarioId = null;
        Long yearId = null;
        Long periodId = null;
        String entityNum = null;
        String storageCurrencyNum = null;
        String scenarioNum = null;
        String fyNum = null;
        String periodNum = null;
        for (List<Map<String, String>> scriptDim : scriptDims) {
            for (Map<String, String> script : scriptDim) {
                for (Map.Entry<String, String> e : script.entrySet()) {
                    if (e.getKey().equals(PresetConstant.ENTITY_DIM)) {
                        entityId = RunScriptRecordUtil.findMemberIdByNumber(cubecatalog, PresetConstant.ENTITY_DIM, e.getValue());
                        entityNum = e.getValue();
                        continue;
                    }
                    if (e.getKey().equals(PresetConstant.SCENE_DIM)) {
                        scenarioId = RunScriptRecordUtil.findMemberIdByNumber(cubecatalog, PresetConstant.SCENE_DIM, e.getValue());
                        scenarioNum = e.getValue();
                        continue;
                    }
                    if (e.getKey().equals(PresetConstant.FY_DIM)) {
                        yearId = RunScriptRecordUtil.findMemberIdByNumber(cubecatalog, PresetConstant.FY_DIM, e.getValue());
                        fyNum = e.getValue();
                        continue;
                    }
                    if (e.getKey().equals(PresetConstant.PERIOD_DIM)) {
                        periodId = RunScriptRecordUtil.findMemberIdByNumber(cubecatalog, PresetConstant.PERIOD_DIM, e.getValue());
                        periodNum = e.getValue();
                        continue;
                    }
                    if (!e.getKey().equals(PresetConstant.CURRENCY_DIM)) continue;
                    storageCurrencyNum = e.getValue();
                }
            }
        }
        boolean scriptNoEntity = entityNum == null;
        boolean scriptNoScenario = scenarioNum == null;
        boolean scriptNoFy = fyNum == null;
        boolean scriptNoPeriod = periodNum == null;
        boolean scriptNoCurrency = storageCurrencyNum == null;
        ArrayList<String> checkedList = new ArrayList<String>(10);
        for (List<Map<String, String>> cross : scopeDims) {
            for (Map<String, String> one : cross) {
                for (Map.Entry<String, String> e : one.entrySet()) {
                    if (scriptNoEntity && e.getKey().equals(PresetConstant.ENTITY_DIM)) {
                        entityId = RunScriptRecordUtil.findMemberIdByNumber(cubecatalog, PresetConstant.ENTITY_DIM, e.getValue());
                        entityNum = e.getValue();
                        continue;
                    }
                    if (scriptNoScenario && e.getKey().equals(PresetConstant.SCENE_DIM)) {
                        scenarioId = RunScriptRecordUtil.findMemberIdByNumber(cubecatalog, PresetConstant.SCENE_DIM, e.getValue());
                        scenarioNum = e.getValue();
                        continue;
                    }
                    if (scriptNoFy && e.getKey().equals(PresetConstant.FY_DIM)) {
                        yearId = RunScriptRecordUtil.findMemberIdByNumber(cubecatalog, PresetConstant.FY_DIM, e.getValue());
                        fyNum = e.getValue();
                        continue;
                    }
                    if (scriptNoPeriod && e.getKey().equals(PresetConstant.PERIOD_DIM)) {
                        periodId = RunScriptRecordUtil.findMemberIdByNumber(cubecatalog, PresetConstant.PERIOD_DIM, e.getValue());
                        periodNum = e.getValue();
                        continue;
                    }
                    if (!scriptNoCurrency || !e.getKey().equals(PresetConstant.CURRENCY_DIM)) continue;
                    storageCurrencyNum = e.getValue();
                }
            }
            String checkedKey = String.format("%s|%s|%s|%s|%s", entityNum, scenarioNum, fyNum, periodNum, storageCurrencyNum);
            if (checkedList.contains(checkedKey)) continue;
            checkedList.add(checkedKey);
            if (entityId != null && storageCurrencyNum == null) {
                storageCurrencyNum = MemberReader.findEntityMemberById((String)cubecatalog, (Long)entityId).getCurrency();
            }
            RunScriptRecordUtil.verifyStatus(cubecatalog, entityId, scenarioId, yearId, periodId, entityNum, storageCurrencyNum, scenarioNum, fyNum, periodNum);
        }
    }

    private static void verifyScript(List<List<Map<String, String>>> scriptDims, String cubecatalog) {
        Long entityId = null;
        Long scenarioId = null;
        Long yearId = null;
        Long periodId = null;
        String entityNum = null;
        String storageCurrencyNum = null;
        String scenarioNum = null;
        String fyNum = null;
        String periodNum = null;
        for (List<Map<String, String>> scriptDim : scriptDims) {
            for (Map<String, String> script : scriptDim) {
                for (Map.Entry<String, String> e : script.entrySet()) {
                    if (e.getKey().equals(PresetConstant.ENTITY_DIM)) {
                        entityId = RunScriptRecordUtil.findMemberIdByNumber(cubecatalog, PresetConstant.ENTITY_DIM, e.getValue());
                        entityNum = e.getValue();
                        continue;
                    }
                    if (e.getKey().equals(PresetConstant.SCENE_DIM)) {
                        scenarioId = RunScriptRecordUtil.findMemberIdByNumber(cubecatalog, PresetConstant.SCENE_DIM, e.getValue());
                        scenarioNum = e.getValue();
                        continue;
                    }
                    if (e.getKey().equals(PresetConstant.FY_DIM)) {
                        yearId = RunScriptRecordUtil.findMemberIdByNumber(cubecatalog, PresetConstant.FY_DIM, e.getValue());
                        fyNum = e.getValue();
                        continue;
                    }
                    if (e.getKey().equals(PresetConstant.PERIOD_DIM)) {
                        periodId = RunScriptRecordUtil.findMemberIdByNumber(cubecatalog, PresetConstant.PERIOD_DIM, e.getValue());
                        periodNum = e.getValue();
                        continue;
                    }
                    if (!e.getKey().equals(PresetConstant.CURRENCY_DIM)) continue;
                    storageCurrencyNum = e.getValue();
                }
            }
        }
        if (entityId != null && storageCurrencyNum == null) {
            storageCurrencyNum = MemberReader.findEntityMemberById((String)cubecatalog, entityId).getCurrency();
        }
        RunScriptRecordUtil.verifyStatus(cubecatalog, entityId, scenarioId, yearId, periodId, entityNum, storageCurrencyNum, scenarioNum, fyNum, periodNum);
    }

    private static void verifyStatus(String cubecatalog, Long entityId, Long scenarioId, Long yearId, Long periodId, String entityNum, String storageCurrencyNum, String scenarioNum, String fyNum, String periodNum) {
        if (entityId == null || scenarioId == null || yearId == null || periodId == null || storageCurrencyNum == null) {
            throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.scriptParamError"), new Object[0]);
        }
        boolean verifyCanExecute = OlapDataVerifyServiceHelper.verifyCanExecute(cubecatalog, entityId, scenarioId, yearId, periodId, storageCurrencyNum);
        if (!verifyCanExecute) {
            throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.periodFlowStatusError"), new Object[]{entityNum, fyNum, periodNum, scenarioNum});
        }
    }

    public static long findMemberIdByNumber(String modelNumber, String dim, String member) {
        return (Long)ThreadCache.get((Object)(modelNumber + "|" + dim + "|" + member), () -> {
            IDNumberTreeNode node = null;
            String tempMemb = member;
            if (PresetConstant.ENTITY_DIM.equals(dim)) {
                tempMemb = RunScriptRecordUtil.isVirtualEntity(tempMemb) ? tempMemb.split("_")[0] : tempMemb;
            }
            node = MemberReader.findMemberByNumber((String)modelNumber, (String)dim, (String)tempMemb);
            return node.getId();
        });
    }

    private static boolean isVirtualEntity(String entityNum) {
        return entityNum != null && entityNum.contains("_");
    }
}

