/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.script.run;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.script.RunScriptRecordUtil;
import kd.fi.bcm.business.script.ScopeBuilder;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.util.ToStringHelper;
import org.apache.commons.collections.CollectionUtils;

public class RunScriptBuilder {
    private String cubecatalog;
    private ScopeBuilder scopeBuilder;
    private OlapSourceEnum sourceEnum;
    private int sourceType;
    private StringBuilder runScript = new StringBuilder();
    private StringBuilder runScriptFact = new StringBuilder();
    private List<StringBuilder> batchRunScript = new ArrayList<StringBuilder>();
    private static final String key_scope = "run_scope";
    private List<List<Map<String, String>>> scriptDims = new ArrayList<List<Map<String, String>>>();

    public RunScriptBuilder(String cubecatalog) {
        this.cubecatalog = cubecatalog;
        this.scopeBuilder = new ScopeBuilder();
    }

    public void setSourceEnum(OlapSourceEnum sourceEnum) {
        this.sourceEnum = sourceEnum;
    }

    public void setSourceEnum(int sourceEnumType) {
        this.sourceType = sourceEnumType;
    }

    public void addDimensionScope(String dimNum, String ... scope) {
        this.scopeBuilder.addDimensionScope(dimNum, scope);
    }

    public void runScript() {
        this.runScript(true);
    }

    public void runScript(boolean isVerifyData) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(key_scope, this.scopeBuilder.genScopeInfo());
        if (!Objects.isNull(this.sourceEnum)) {
            params.put("sourceType", this.sourceEnum.getType());
        }
        if (this.sourceType != 0) {
            params.put("sourceType", this.sourceType);
        }
        if (isVerifyData) {
            this.verifyData();
        }
        OlapServiceHelper.excuteScript(this.cubecatalog, this.runScriptFact.toString(), params);
    }

    private void verifyData() {
        if (OlapServiceHelper.isSandBoxCube(this.cubecatalog)) {
            return;
        }
        try {
            RunScriptRecordUtil.verifyDimensionDataStatus(this.scopeBuilder.getScopes(), this.scriptDims, this.cubecatalog);
        }
        catch (Exception e) {
            RunScriptRecordUtil.recordRunScript(e, this.cubecatalog, String.format("%s %s", this.scopeBuilder.toString(), this.runScriptFact.toString()), true);
            if (e instanceof KDBizException && !"fi.bcm.scriptParamError".equals(((KDBizException)((Object)e)).getErrorCode().getCode())) {
                throw e;
            }
        }
        finally {
            this.scriptDims.clear();
        }
    }

    private String buildRunScript() {
        return "run(run_scope,\"" + this.runScript.toString() + "\");";
    }

    public void appendV(PairList<String, String> pairs) {
        this.runScript.append(this.parseV(pairs));
    }

    public void appendOneV(PairList<String, String> pairs) {
        StringBuilder one = new StringBuilder();
        one.append(this.parseV(pairs));
        this.batchRunScript.add(one);
    }

    public void appendOneEqualSign() {
        if (this.batchRunScript.size() > 0) {
            this.batchRunScript.get(this.batchRunScript.size() - 1).append("=");
        }
    }

    public void appendOneStr(String str) {
        if (this.batchRunScript.size() > 0) {
            this.batchRunScript.get(this.batchRunScript.size() - 1).append(str);
        }
    }

    public void endBatchRunExpress() {
        StringJoiner sj = new StringJoiner("\",\"");
        this.batchRunScript.forEach(sj::add);
        this.runScriptFact.append("run(").append(key_scope).append(",\"").append(sj.toString()).append("\");");
        this.runScript.setLength(0);
    }

    public void appendEqualSign() {
        this.runScript.append('=');
    }

    public void appendStr(String data) {
        this.runScript.append(data);
    }

    public void appendLeftBracket() {
        this.runScript.append('(');
    }

    public void endRunExpress() {
        this.runScriptFact.append(this.buildRunScript());
        this.runScript.setLength(0);
    }

    public void appendRightBracket() {
        this.runScript.append(')');
    }

    public void addV(PairList<String, String> pairs) {
        this.runScript.append('+').append(this.parseV(pairs));
    }

    public void subtractV(PairList<String, String> pairs) {
        this.runScript.append('-').append(this.parseV(pairs));
    }

    public void multiplyV(PairList<String, String> pairs) {
        this.runScript.append('*').append(this.parseV(pairs));
    }

    public void divideV(PairList<String, String> pairs) {
        this.runScript.append('/').append(this.parseV(pairs));
    }

    public String parseV(PairList<String, String> pairs) {
        StringBuilder sb = new StringBuilder();
        sb.append("v('");
        pairs.forEach(p -> sb.append(String.format("%s%s%s,", p.p1, "@", p.p2)));
        sb.deleteCharAt(sb.length() - 1);
        sb.append("')");
        this.addScriptDims(pairs);
        return sb.toString();
    }

    private void addScriptDims(PairList<String, String> pairs) {
        if (this.runScript.toString().contains("=")) {
            return;
        }
        try {
            ArrayList vDims = new ArrayList();
            pairs.forEach(p -> {
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                map.put(p.p1, p.p2);
                vDims.add(map);
            });
            this.scriptDims.add(vDims);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void lockDimData(Map<String, Set<String>> scope, List<Map<String, String>> combo) {
        this.lockOrUnlockData(scope, combo, "1 * 1");
    }

    public void unlockDimData(Map<String, Set<String>> scope, List<Map<String, String>> combo) {
        this.lockOrUnlockData(scope, combo, null);
    }

    private void lockOrUnlockData(Map<String, Set<String>> scope, List<Map<String, String>> combo, Object value) {
        List<Map<String, String>> newCombo = this.removeRepeatedCombo(combo);
        if (CollectionUtils.isNotEmpty(newCombo) || scope != null && !scope.isEmpty()) {
            HashMap<String, Set<String>> newScope = new HashMap<String, Set<String>>(scope);
            ArrayList<Object> expressions = new ArrayList<Object>();
            if (newCombo.isEmpty()) {
                PairList pairList = new PairList();
                for (Map.Entry<String, Set<String>> entry : scope.entrySet()) {
                    if (entry.getValue().size() != 1) continue;
                    pairList.add(Pair.onePair((Object)entry.getKey(), new ArrayList(entry.getValue()).get(0)));
                    newScope.remove(entry.getKey());
                    break;
                }
                expressions.add(pairList);
            } else {
                newCombo.forEach(com -> {});
                for (Map map : newCombo) {
                    PairList pairList = new PairList();
                    map.forEach((key, val) -> pairList.add(Pair.onePair((Object)key, (Object)val)));
                    expressions.add(pairList);
                }
            }
            if (!expressions.isEmpty()) {
                newScope.forEach((key, val) -> this.addDimensionScope((String)key, val.toArray(new String[0])));
                for (PairList pairList : expressions) {
                    this.appendOneV((PairList<String, String>)pairList);
                    this.appendOneStr("=");
                    this.appendOneStr(value == null ? "null" : value.toString());
                }
                this.endBatchRunExpress();
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put(key_scope, this.scopeBuilder.genScopeInfo());
                params.put("FLOCK", true);
                OlapServiceHelper.excuteScript(this.cubecatalog, this.runScriptFact.toString(), params);
            }
        }
    }

    private List<Map<String, String>> removeRepeatedCombo(List<Map<String, String>> combo) {
        ArrayList<Map<String, String>> newCombos = new ArrayList<Map<String, String>>();
        for (Map<String, String> map : combo) {
            boolean exist = false;
            block1: for (Map map2 : newCombos) {
                if (map2.size() != map.size()) continue;
                int index = 0;
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    if (!map2.containsKey(entry.getKey()) || !entry.getValue().equals(map2.get(entry.getKey()))) continue block1;
                    ++index;
                }
                if (index != map2.size()) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            newCombos.add(map);
        }
        return newCombos;
    }

    public String toString() {
        return ToStringHelper.deepToString((Object)this);
    }
}

