/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper;

import java.util.Collection;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.mq.consumer.MQMessagePublisherServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import org.apache.commons.collections.CollectionUtils;

public class AppCacheServiceHelper {
    public static final String APP_BCM = "_bcm.";

    private static IAppCache getAppCache() {
        return AppCache.get((String)APP_BCM);
    }

    public static void put(String key, Object value) {
        AppCacheServiceHelper.getAppCache().put(key, value);
    }

    public static void put(String key, Object value, int timeout) {
        AppCacheServiceHelper.getAppCache().put(key, value, timeout);
    }

    public static String getString(String key) {
        return (String)AppCacheServiceHelper.getAppCache().get(key, String.class);
    }

    public static Object get(String key) {
        return AppCacheServiceHelper.getAppCache().get(key, Object.class);
    }

    public static <T> T get(String key, Class<T> clazz) {
        return (T)AppCacheServiceHelper.getAppCache().get(key, clazz);
    }

    public static void remove(String key) {
        AppCacheServiceHelper.getAppCache().remove(key);
    }

    public static void clear() {
        AppCacheServiceHelper.getAppCache().clear();
    }

    public static void removeTemplateDispenseCache(String modelNum) {
        boolean isTrue = true;
        if (ThreadCache.exists((Object)("haveDeleteTmplDispenseCache" + modelNum))) {
            return;
        }
        AppCacheServiceHelper.getAppCache().remove("tmpl_map_org_4dispense" + modelNum);
        AppCacheServiceHelper.getAppCache().remove("tmpl_map_org_4dispense_part_" + modelNum);
        MQMessagePublisherServiceHelper.publishInvalidateTemplateDispense(modelNum);
        ThreadCache.put((Object)("haveDeleteTmplDispenseCache" + modelNum), (Object)isTrue);
    }

    public static String getTemplateDispenseCache(String modelNum) {
        return AppCacheServiceHelper.get("tmpl_map_org_4dispense" + modelNum, String.class);
    }

    public static void cacheTemplateDispenseCache(String modelNum, String cacheItem) {
        AppCacheServiceHelper.put("tmpl_map_org_4dispense" + modelNum, cacheItem);
    }

    public static String getTemplateDispenseCacheByPart(String modelNum) {
        return AppCacheServiceHelper.get("tmpl_map_org_4dispense_part_" + modelNum, String.class);
    }

    public static void cacheTemplateDispenseCacheByPart(String modelNum, String cacheItem) {
        AppCacheServiceHelper.put("tmpl_map_org_4dispense_part_" + modelNum, cacheItem);
    }

    public static Set<String> getCacheMeasures(String modelNum) {
        String cacheKey = "model_measure_" + modelNum;
        return (Set)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)cacheKey, () -> {
            Set<String> measures = AppCacheServiceHelper.get(cacheKey, Set.class);
            if (CollectionUtils.isEmpty((Collection)measures)) {
                measures = OlapServiceHelper.getCubeMeasures(modelNum);
                DynamicObject model = QueryServiceHelper.queryOne((String)"bcm_model", (String)"issourcemeasure,islockmeasure", (QFilter[])QFilter.of((String)"number = ?", (Object[])new Object[]{modelNum}).toArray());
                if (measures.contains(FacTabFieldDefEnum.FIELD_SOURCE.getField()) && !model.getBoolean("issourcemeasure")) {
                    measures.remove(FacTabFieldDefEnum.FIELD_SOURCE.getField());
                }
                if (measures.contains(FacTabFieldDefEnum.FIELD_LOCK.getField()) && !model.getBoolean("islockmeasure")) {
                    measures.remove(FacTabFieldDefEnum.FIELD_LOCK.getField());
                }
                AppCacheServiceHelper.put(cacheKey, measures);
            }
            return measures;
        });
    }

    public static void clearMeasureCache(String modelNum) {
        String cacheKey = "model_measure_" + modelNum;
        AppCacheServiceHelper.remove(cacheKey);
        GlobalCacheServiceHelper.getCommonCache().invalidateByKey(cacheKey);
    }

    public static final class CacheKeyConstant {
        public static final String KEY_TMPL_DISPENSE_MAP_ORG = "tmpl_map_org_4dispense";
        public static final String KEY_TMPL_DISPENSE_MAP_ORG_PART = "tmpl_map_org_4dispense_part_";
        public static final String KEY_TMPL_DISPENSE_LACAL_CACH = "template_dis_cache_";
        public static final String KEY_MODEL_MEASURE_CACH = "model_measure_";
    }
}

