/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.log.FunctionPermLogHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.log.FunctionPermLogMultiLangEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import org.apache.commons.collections.CollectionUtils;

public class BcmFuncPermServiceHelper {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, BcmFuncPermServiceHelper.class);
    IFormView view;
    private static final String BEFORESAVE_ORGSPERMITEMS = "beforeSaveUserOrgsPermItems";

    public BcmFuncPermServiceHelper(IFormView view) {
        this.view = view;
    }

    public void writeFunPermLog() {
        DynamicObject user = (DynamicObject)this.view.getModel().getValue("user");
        if (user == null) {
            log.info("FunctionPermLogHelper-user == null \u5f53\u524d\u9875\u9762\u7684\u7528\u6237\u4e3a\u7a7a--\u5f02\u5e38");
            return;
        }
        String initAllPermItems = this.view.getPageCache().get(BEFORESAVE_ORGSPERMITEMS);
        if (StringUtils.isEmpty((String)initAllPermItems)) {
            log.info("FunctionPermLogHelper-writeFunPermLog()-initAllPermItems == null (BEFORESAVE_ORGSPERMITEMS)\u521d\u59cb\u5316\u67e5\u5e93\u5931\u8d25\uff01");
            return;
        }
        Map beforeSaveOrgPermItems = (Map)SerializationUtils.fromJsonString((String)initAllPermItems, Map.class);
        Map beforeSaveOrgPermItemsBAK = (Map)SerializationUtils.fromJsonString((String)initAllPermItems, Map.class);
        Map beforeSaveOrgPermItemsBAK1 = (Map)SerializationUtils.fromJsonString((String)initAllPermItems, Map.class);
        Map<String, List<String>> afterSaveOrgPermItems = this.getAfterSaveOrgPermItems();
        String afterSaveOrgPermItemsJsonStr = SerializationUtils.toJsonString(afterSaveOrgPermItems);
        Map afterSaveOrgPermItemsBAK = (Map)SerializationUtils.fromJsonString((String)afterSaveOrgPermItemsJsonStr, Map.class);
        beforeSaveOrgPermItems.keySet().removeAll(afterSaveOrgPermItems.keySet());
        afterSaveOrgPermItems.keySet().removeAll(beforeSaveOrgPermItemsBAK.keySet());
        beforeSaveOrgPermItemsBAK.keySet().removeAll(beforeSaveOrgPermItems.keySet());
        beforeSaveOrgPermItemsBAK1.keySet().removeAll(beforeSaveOrgPermItems.keySet());
        afterSaveOrgPermItemsBAK.keySet().removeAll(afterSaveOrgPermItems.keySet());
        for (Map.Entry entry : beforeSaveOrgPermItemsBAK.entrySet()) {
            ((List)entry.getValue()).removeAll((Collection)afterSaveOrgPermItemsBAK.get(entry.getKey()));
        }
        for (Map.Entry entry : afterSaveOrgPermItemsBAK.entrySet()) {
            ((List)entry.getValue()).removeAll((Collection)beforeSaveOrgPermItemsBAK1.get(entry.getKey()));
        }
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>();
        this.addPermLogs(beforeSaveOrgPermItems, logs, 1);
        this.addPermLogs(afterSaveOrgPermItems, logs, 0);
        this.addPermLogs(beforeSaveOrgPermItemsBAK, logs, 1);
        this.addPermLogs(afterSaveOrgPermItemsBAK, logs, 0);
        if (logs.size() > 0) {
            this.view.getPageCache().put(BEFORESAVE_ORGSPERMITEMS, afterSaveOrgPermItemsJsonStr);
            try {
                FunctionPermLogHelper.batchInsertFunctionPermLog(logs);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                log.info("FunctionPermLogHelper.batchInsertFunctionPermLog \u6267\u884c\u5f02\u5e38");
            }
        }
    }

    private void addPermLogs(Map<String, List<String>> userFuncPermModels, List<DynamicObject> logs, int logType) {
        if (userFuncPermModels.values().isEmpty()) {
            return;
        }
        DynamicObject dy = (DynamicObject)this.view.getModel().getValue("user");
        String usernumber = dy.getString("number");
        String username = dy.getString("name");
        String operationName = FunctionPermLogMultiLangEnum.DIRECT_Distribute.getOperateName();
        if (logType == 1) {
            operationName = FunctionPermLogMultiLangEnum.DIRECT_DelDistribute.getOperateName();
        }
        for (Map.Entry<String, List<String>> entry : userFuncPermModels.entrySet()) {
            List<String> permItemsList = entry.getValue();
            for (String permItem : permItemsList) {
                String[] permItems = permItem.split("@");
                String entityname = permItems.length < 5 ? null : permItems[4];
                String permitemname = permItems.length < 6 ? null : permItems[5];
                String appnum = permItems[permItems.length - 1];
                String appId = this.getAppIdByAppNum(appnum);
                DynamicObject funcLog = FunctionPermLogHelper.newFunctionPermLog(Long.parseLong(entry.getKey()), usernumber, username, entityname, permitemname, "", operationName, appId);
                logs.add(funcLog);
            }
        }
    }

    protected String getAppIdByAppNum(String appNum) {
        String appId = ApplicationTypeEnum.CM.appnum;
        String cmNum = AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.CM.appnum).getId();
        if (!cmNum.equals(appNum)) {
            appId = ApplicationTypeEnum.RPT.appnum;
        }
        return appId;
    }

    public Map<String, List<String>> getAfterSaveOrgPermItems() {
        DynamicObjectCollection orgsAllPermItems = this.getUserOrgsAllPermItems();
        Map<String, List<String>> afterSaveMap = this.getPermItemsMap(orgsAllPermItems);
        return afterSaveMap;
    }

    private Map<String, List<String>> getPermItemsMap(DynamicObjectCollection initAllPermItem) {
        if (CollectionUtils.isEmpty((Collection)initAllPermItem)) {
            return Collections.emptyMap();
        }
        Map<String, List<DynamicObject>> modelMap = initAllPermItem.stream().collect(Collectors.groupingBy(t -> t.getString("modelid")));
        Set<String> keySet = modelMap.keySet();
        HashMap<String, List<String>> permMaps = new HashMap<String, List<String>>(keySet.size());
        for (Map.Entry<String, List<DynamicObject>> entry : modelMap.entrySet()) {
            List collect = entry.getValue().stream().map(t -> t.getString("modelid") + "@" + t.getString("userid") + "@" + t.getString("entitynumber") + "@" + t.getString("permitemid") + "@" + t.getString("entityname") + "@" + t.getString("permitemname") + "@" + t.getString("appnum")).collect(Collectors.toList());
            permMaps.put(entry.getKey(), collect);
        }
        return permMaps;
    }

    private DynamicObjectCollection getUserOrgsAllPermItems() {
        QFilter directPermFilter = new QFilter("dimtype", "=", (Object)this.getEntityName());
        directPermFilter.and("entryentity.bizapp", "in", this.getAppIds());
        DynamicObject user = (DynamicObject)this.view.getModel().getValue("user");
        directPermFilter.and("user.id", "=", (Object)user.getLong("id"));
        String userPermSelectFields = "id,org.id as modelid,user.id as userid,user.name as username,user.number as usernumber,entryentity.entitytype.name as entityname,entryentity.permitem.name as permitemname,entryentity.entitytype.number as entitynumber,entryentity.permitem.id as permitemid,entryentity.bizapp as appnum";
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        try {
            DataSet perm_userperm = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"perm_userperm", (String)userPermSelectFields, (QFilter[])new QFilter[]{directPermFilter}, (String)"").distinct();
            ORMImpl orm = new ORMImpl();
            dynamicObjects = orm.toPlainDynamicObjectCollection(perm_userperm);
        }
        catch (Exception e) {
            log.info("FunctionPermLogHelper-DataSet perm_userperm \u6267\u884c\u67e5\u5e93\u5f02\u5e38");
        }
        return dynamicObjects;
    }

    protected List<String> getAppIds() {
        String cm = AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.CM.appnum).getId();
        String rpt = AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.RPT.appnum).getId();
        ArrayList<String> appIds = new ArrayList<String>();
        appIds.add(cm);
        appIds.add(rpt);
        return appIds;
    }

    protected String getEntityName() {
        return "DIM_BCM_MODEL";
    }
}

