/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.paramsetting.ParamSettingService;
import kd.epm.epbs.business.paramsetting.ParamSettingServiceHelper;
import kd.fi.bcm.business.adjust.util.AdjustBusinessTypeUtil;
import kd.fi.bcm.business.config.BatchConfigModel;
import kd.fi.bcm.business.config.CmConfigAdapterService;
import kd.fi.bcm.business.config.ConfigModel;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigProxyHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.util.LanguageUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.config.CM053SettingEnum;
import kd.fi.bcm.common.config.CM053TypeEnum;
import kd.fi.bcm.common.config.SamePeriodLastYearVo;
import kd.fi.bcm.common.config.SceneSettingVo;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;

public class ConfigServiceHelper {
    private static final String CONFIG = "config";
    private static final String NUMBER = "number";
    private static final String MODEL = "model";
    private static final String ID = "id";
    private static final String JSON = "json";
    private static final List<String> JSON_BOOLEAN_CONFIG = Arrays.asList("CM004", "CM021", "CM030", "CM034", "CM041", "CM043", "CM053", "CM056", "isSupportNewMytemplate");

    public static boolean getGlobalBoolParam(String key) {
        return ConfigProxyHelper.get().getBool(0L, key);
    }

    public static String getStringParam(Long modelId, String paramNum) {
        return ConfigProxyHelper.get().getString(modelId, paramNum);
    }

    public static Integer getIntegerParam(Long modelId, String paramNum, String key, Integer defaultValue) {
        try {
            JSONObject jsonObject = ParamSettingServiceHelper.getJSON((long)modelId, (String)paramNum);
            if (jsonObject != null) {
                return jsonObject.getInteger(key);
            }
        }
        catch (Exception e) {
            return defaultValue;
        }
        return defaultValue;
    }

    public static String getStringParamNoModel(String paramNum) {
        return ConfigProxyHelper.get().getString(0L, paramNum);
    }

    public static boolean getBoolParam(String modelNumber, String key) {
        Long modelId = MemberReader.findModelIdByNum((String)modelNumber);
        return ConfigServiceHelper.getBoolParam(modelId, key);
    }

    public static String getAdjustContinueType(Long modelid) {
        return ConfigProxyHelper.get().getAdjustContinueType(modelid);
    }

    public static BigDecimal getAdjustBalance(Long modelid) {
        return ConfigProxyHelper.get().getAdjustBalance(modelid);
    }

    public static boolean getBoolParam(Long modelid, String key) {
        if (JSON_BOOLEAN_CONFIG.contains(key)) {
            if (ConfigProxyHelper.get() instanceof CmConfigAdapterService) {
                return ConfigProxyHelper.get().getBool(modelid, key);
            }
            return ConfigProxyHelper.get().getBool(modelid, key, CONFIG);
        }
        if ("CM012".equals(key)) {
            return ConfigProxyHelper.get().getBoolChildParam(modelid, key, "params");
        }
        return ConfigProxyHelper.get().getBool(modelid, key);
    }

    public static boolean getBoolParam(Long modelid, String key, String filedKey) {
        return ConfigProxyHelper.get().getBool(modelid, key, filedKey);
    }

    public static Pair<Object, Set<String>> getCfgWithExpOrg(long modelId, String key) {
        return ConfigProxyHelper.get().getCfgWithExpOrg(modelId, key);
    }

    public static boolean getCM012InitPeriodStatus(Long modelId) {
        return ConfigProxyHelper.get().getCM012InitPeriodStatus(modelId);
    }

    public static boolean getBoolChildParam(Long modelid, String key, String childKey) {
        return ConfigProxyHelper.get().getBoolChildParam(modelid, key, childKey);
    }

    public static boolean resolverConfigParam(Object result) {
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        if (result instanceof String) {
            return "true".equalsIgnoreCase(result.toString()) || "1".equals(result.toString());
        }
        if (result instanceof Integer) {
            return (Integer)result == 1;
        }
        return false;
    }

    public static void cacheIt(Long modelid, String key, Object value) {
        if (value != null) {
            AppCacheServiceHelper.put(modelid + "." + key, value);
        }
    }

    public static void cacheIt(Long modelid, String key, String childKey, Object value) {
        if (value != null) {
            AppCacheServiceHelper.put(modelid + "." + key + "." + childKey, value);
        }
    }

    public static Object getCacheOrLoad(long modelId, String key, String flag, Supplier<Object> sp) {
        Object value;
        StringBuilder appCacheKey = new StringBuilder().append(modelId).append(".").append(key);
        if (StringUtils.isNotBlank((CharSequence)flag)) {
            appCacheKey.append(flag);
        }
        if (Objects.nonNull(value = AppCacheServiceHelper.get(appCacheKey.toString()))) {
            return value;
        }
        value = ThreadCache.get((Object)appCacheKey.append("ThreadCache").toString(), sp::get);
        ConfigServiceHelper.cacheIt(modelId, key, value);
        return value;
    }

    public static void upgradeConfig(Object modelId) {
        ConfigServiceHelper.batchUpgradeConfig(Collections.singletonList(modelId), false);
    }

    public static void batchUpgradeConfig(List<Object> modelIds, boolean isUpdateOldChildConfig) {
        ArrayList<BatchConfigModel> batchConfigModels = new ArrayList<BatchConfigModel>(10);
        ArrayList<DynamicObject> configdys = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> childrenConfigdys = new ArrayList<DynamicObject>(10);
        List<ConfigModel> globalConfigs = ConfigEnum.getGlobalConfigData().stream().map(p -> new ConfigModel((ConfigEnum)p)).collect(Collectors.toList());
        List<ConfigModel> localConfigs = ConfigEnum.getLocalConfigData().stream().map(p -> {
            ConfigModel configModel = new ConfigModel((ConfigEnum)p);
            if (configModel.hasChildConfig()) {
                batchConfigModels.add(configModel.getBatchConfigModel());
            }
            return configModel;
        }).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> configs = BusinessDataServiceHelper.loadFromCache((String)"bcm_configsetting", (QFilter[])new QFilter[]{new QFilter(MODEL, "in", modelIds).or(MODEL, "=", (Object)0L)}).values().stream().collect(Collectors.groupingBy(config -> config.getLong("model.id")));
        ConfigServiceHelper.createConfigDy(modelIds, configs, localConfigs, configdys, childrenConfigdys);
        ConfigServiceHelper.createConfigDy(Collections.singletonList(0L), configs, globalConfigs, configdys, childrenConfigdys);
        try (TXHandle tx = TX.required();){
            try {
                if (!configdys.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])configdys.toArray(new DynamicObject[0]));
                }
                if (!childrenConfigdys.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])childrenConfigdys.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(ThrowableHelper.toString((Exception)e));
            }
        }
        if (isUpdateOldChildConfig) {
            ConfigServiceHelper.updateChildConfig(modelIds, batchConfigModels);
        }
    }

    public static void updateChildConfig(List<Object> modelIds, List<BatchConfigModel> batchConfigModels) {
        Map<Long, List<DynamicObject>> batchConfigMap = Arrays.stream(BusinessDataServiceHelper.load((String)"bcm_adjustbiztypeconfig", (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_adjustbiztypeconfig").getAllFields().keySet()), (QFilter[])new QFilter[]{new QFilter(MODEL, "in", modelIds)})).collect(Collectors.groupingBy(p -> p.getLong("model.id")));
        HashMap modelConfigMap = new HashMap();
        ArrayList toSaveDy = new ArrayList(10);
        for (Object modelId : modelIds) {
            modelConfigMap.clear();
            ((List)batchConfigMap.getOrDefault(Long.parseLong(modelId.toString()), new ArrayList())).stream().forEach(p -> modelConfigMap.put(p.getString(NUMBER), p));
            batchConfigModels.stream().forEach(p -> {
                DynamicObject newDy = p.toDy(modelId)[0];
                if (modelConfigMap.containsKey(p.getNumber())) {
                    ConfigServiceHelper.repairBatchConfigModel(newDy, (DynamicObject)modelConfigMap.get(p.getNumber()));
                }
                toSaveDy.add(newDy);
            });
        }
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"bcm_adjustbiztypeconfig", (QFilter[])new QFilter[]{new QFilter(MODEL, "in", modelIds)});
                SaveServiceHelper.save((DynamicObject[])toSaveDy.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(ThrowableHelper.toString((Exception)e));
            }
        }
    }

    private static DynamicObject repairBatchConfigModel(DynamicObject newConfigDy, DynamicObject configDy) {
        DynamicObjectCollection childConfigs = newConfigDy.getDynamicObjectCollection("entryentity");
        HashMap<String, DynamicObject> containconfigs = new HashMap<String, DynamicObject>(10);
        configDy.getDynamicObjectCollection("entryentity").forEach(p -> containconfigs.put(p.getString("businesstypevalue"), (DynamicObject)p));
        childConfigs.forEach(childConfig -> {
            DynamicObject oldDy = (DynamicObject)containconfigs.remove(childConfig.getString("businesstypevalue"));
            if (oldDy != null) {
                childConfig.set("isshow", oldDy.get("isshow"));
                childConfig.set("presetname", oldDy.get("presetname"));
                childConfig.set("showname", oldDy.get("showname"));
                childConfig.set("entrydescription", oldDy.get("entrydescription"));
            }
        });
        containconfigs.forEach((p, v) -> {
            DynamicObject newDy = childConfigs.addNew();
            newDy.set("isshow", v.get("isshow"));
            newDy.set("presetname", v.get("presetname"));
            newDy.set("showname", v.get("showname"));
            newDy.set("entrydescription", v.get("entrydescription"));
            newDy.set("businesstypevalue", v.get("businesstypevalue"));
        });
        return configDy;
    }

    private static void createConfigDy(List<Object> modelIds, Map<Long, List<DynamicObject>> configs, List<ConfigModel> configModels, List<DynamicObject> configdys, List<DynamicObject> childrenConfigdys) {
        modelIds.stream().forEach(modelId -> {
            Long model = Long.parseLong(modelId.toString());
            ArrayList existConfig = configs.get(model) == null ? new ArrayList(10) : ((List)configs.get(model)).stream().map(config -> config.getString(NUMBER)).collect(Collectors.toList());
            configModels.forEach(p -> {
                if (!existConfig.contains(p.getNumber())) {
                    DynamicObject[] dynamicObjects = p.toDy(model);
                    ConfigServiceHelper.cacheIt(model, p.getNumber(), p.isConfig());
                    configdys.add(dynamicObjects[0]);
                    if (p.hasChildConfig()) {
                        childrenConfigdys.add(dynamicObjects[1]);
                    }
                }
            });
        });
    }

    public static void transConfig() {
        DynamicObject[] dys;
        for (DynamicObject dy : dys = BusinessDataServiceHelper.load((String)"bcm_configsetting", (String)"id,name,number,description", null)) {
            String name = dy.getString("name");
            String number = dy.getString(NUMBER);
            String description = dy.getString("description");
            if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
            Map<Lang, String> trans_name = ConfigModel.getLanguageTranslate(name, number);
            Map<Lang, String> trans_des = ConfigModel.getLanguageTranslateDesc(description, number);
            dy.set("name", LanguageUtil.getName(name, trans_name));
            dy.set("description", LanguageUtil.getName(description, trans_des));
        }
        SaveServiceHelper.save((DynamicObject[])dys);
    }

    public static boolean isHwApp() {
        return ConfigServiceHelper.getBoolParam(0L, "P002");
    }

    public static void remove(Long modelId, String key) {
        AppCacheServiceHelper.remove(modelId + "." + key);
    }

    public static Map<String, Object> getAdditionFieldMap(Long modelId, String configNumber) {
        String addtionField;
        QFBuilder configBuilder = new QFBuilder();
        configBuilder.add(new QFilter(MODEL, "=", (Object)modelId));
        configBuilder.add(new QFilter(NUMBER, "=", (Object)configNumber));
        DynamicObject config = QueryServiceHelper.queryOne((String)"bcm_configsetting", (String)JSON, (QFilter[])configBuilder.toArray());
        if (config != null && !StringUtil.isEmptyString((String)(addtionField = config.getString(JSON)))) {
            Map addtionFieldMap = (Map)SerializationUtils.fromJsonString((String)addtionField, Map.class);
            return addtionFieldMap;
        }
        return null;
    }

    public static Map<String, Object> getCM052(Long modelId) {
        JSONObject json = ParamSettingServiceHelper.getJSON((long)modelId, (String)"CM052");
        if (json == null || !(json.get((Object)"config_num") instanceof Integer)) {
            return null;
        }
        HashMap<String, Object> addtionFieldMap = new HashMap<String, Object>(16);
        addtionFieldMap.put("config_num", json.get((Object)"config_num"));
        return addtionFieldMap;
    }

    public static Object getAdditionFieldValue(Long modelId, String configNumber, String controlSign) {
        Map<String, Object> addtionFieldMap = ConfigServiceHelper.getAdditionFieldMap(modelId, configNumber);
        if (addtionFieldMap != null && addtionFieldMap.containsKey(controlSign)) {
            return addtionFieldMap.get(controlSign);
        }
        return null;
    }

    public static Pair<Boolean, Set<String>> getConfigOfCMO04(Long modelId) {
        return ConfigProxyHelper.get().getConfigOfCMO04(modelId);
    }

    public static JSONArray getConfigCM005(long modelId) {
        return (JSONArray)ParamSettingService.queryParamSetting((long)modelId, (String)"CM005", oldData -> AdjustBusinessTypeUtil.repairConfigCM005(modelId, oldData == null ? null : ((JSONObject)oldData).getJSONArray("entryentity")));
    }

    public static void lockCM034(Long modelId) {
        ParamSettingServiceHelper.save((long)modelId, (String)"CM034", k -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(CONFIG, (Object)1);
            jsonObject.put("scenario", null);
            return jsonObject;
        });
    }

    public static Pair<Boolean, List<SceneSettingVo>> getCM044SceneSetting(Long modelId) {
        return (Pair)ThreadCache.get((Object)String.format("getConfig_%d_CM044", modelId), () -> {
            JSONArray entryentity;
            boolean checkParam = ConfigServiceHelper.getBoolChildParam(modelId, "CM044", CONFIG);
            ArrayList sceneSettingVoList = new ArrayList(10);
            if (checkParam && (entryentity = (JSONArray)ParamSettingServiceHelper.getJsonChildKey((long)modelId, (String)"CM044", (String)"entryentity")) != null && !entryentity.isEmpty()) {
                List list = SerializationUtils.fromJsonStringToList((String)entryentity.toString(), SceneSettingVo.class);
                sceneSettingVoList.addAll(list);
            }
            return Pair.onePair((Object)checkParam, sceneSettingVoList);
        });
    }

    public static Pair<Boolean, List<SceneSettingVo>> getCM053SceneSetting(Long modelId) {
        return (Pair)ThreadCache.get((Object)String.format("getConfig_%d_CM053", modelId), () -> {
            JSONArray entryentity;
            boolean checkParam = ConfigServiceHelper.getBoolChildParam(modelId, "CM053", CONFIG);
            ArrayList sceneSettingVoList = new ArrayList(10);
            if (checkParam && (entryentity = (JSONArray)ParamSettingServiceHelper.getJsonChildKey((long)modelId, (String)"CM053", (String)"entryentity")) != null && !entryentity.isEmpty()) {
                List list = SerializationUtils.fromJsonStringToList((String)entryentity.toString(), SceneSettingVo.class);
                sceneSettingVoList.addAll(list);
            }
            return Pair.onePair((Object)checkParam, sceneSettingVoList);
        });
    }

    public static CM053SettingEnum checkCM053SceneSetting(Long modelId, Long sceneId) {
        IDNumberTreeNode sceneMember = MemberReader.findScenaMemberById((Long)modelId, (Long)sceneId);
        Pair<Boolean, List<SceneSettingVo>> cm053SceneSetting = ConfigServiceHelper.getCM053SceneSetting(modelId);
        if (((Boolean)cm053SceneSetting.p1).booleanValue()) {
            for (SceneSettingVo sceneSettingVo : (List)cm053SceneSetting.p2) {
                if (!sceneMember.getNumber().equals(sceneSettingVo.getSceneNumber()) || !CM053TypeEnum.APPLY.getValue().equals(sceneSettingVo.getType())) continue;
                if (sceneSettingVo.getSetting().equals(CM053SettingEnum.NOT_CONTROL.getValue())) {
                    return CM053SettingEnum.NOT_CONTROL;
                }
                if (!sceneSettingVo.getSetting().equals(CM053SettingEnum.FORBIDDEN_MERGE.getValue())) continue;
                return CM053SettingEnum.FORBIDDEN_MERGE;
            }
        }
        return CM053SettingEnum.ONLY_TIP;
    }

    public static List<SamePeriodLastYearVo> getCM056Config(long modelId) {
        return (List)ThreadCache.get((Object)String.format("getCM056Config_%d_CM056", modelId), () -> {
            String jsonStr;
            JSONObject json;
            boolean checkParam = ConfigServiceHelper.getBoolChildParam(modelId, "CM056", CONFIG);
            ArrayList result = new ArrayList(16);
            if (checkParam && (json = ParamSettingServiceHelper.getJSON((long)modelId, (String)"CM056")) != null && json.get((Object)"entryentity") != null && !StringUtil.isEmptyString((String)(jsonStr = json.get((Object)"entryentity").toString()))) {
                List list = SerializationUtils.fromJsonStringToList((String)jsonStr, SamePeriodLastYearVo.class);
                result.addAll(list);
            }
            return result;
        });
    }

    public static String getExchangePeriodForLastYear(long modelId, String sceario, String currentPeriod) {
        Optional<SamePeriodLastYearVo> vo;
        List<SamePeriodLastYearVo> periodLastYearVos = ConfigServiceHelper.getCM056Config(modelId);
        if (CollectionUtils.isNotEmpty(periodLastYearVos) && (vo = periodLastYearVos.stream().filter(e -> sceario.equals(e.getSceario()) && currentPeriod.equals(e.getCurrentPeriod())).findFirst()).isPresent() && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)vo.get().getExchangePeriod())) {
            return vo.get().getExchangePeriod();
        }
        return currentPeriod;
    }

    public static boolean getNonLeafOfCM030(Long modelId) {
        return ConfigServiceHelper.getBoolParam(modelId, "CM030", "ismerge");
    }

    public static JSONObject getJsonParamNoModel(String paramNum) {
        return ConfigProxyHelper.get().getJSON(0L, paramNum);
    }

    public static Set<String> getPreLoadModel() {
        DynamicObject param = QueryServiceHelper.queryOne((String)"epbs_preset_param", (String)ID, (QFilter[])new QFilter(NUMBER, "=", (Object)"isPreLoadIC").toArray());
        if (param != null && param.getLong(ID) != 0L) {
            DynamicObject params = BusinessDataServiceHelper.loadSingle((Object)param.getLong(ID), (String)"epbs_preset_param");
            Set<Long> modelIds = params.getDynamicObjectCollection("entryentity").stream().filter(f -> f.getLong("model.id") != 0L && f.getBoolean("params")).map(m -> m.getLong("model.id")).collect(Collectors.toSet());
            HashSet<String> numbers = new HashSet<String>(modelIds.size());
            modelIds.forEach(m -> numbers.add(MemberReader.findModelNumberById((Object)m)));
            return numbers;
        }
        return new HashSet<String>(0);
    }

    public static boolean getCM024CheckReportSubmit(Long modelId) {
        return ParamSettingServiceHelper.getBooleanWithChild((long)modelId, (String)"CM024", (String)"checkreportsubmit");
    }

    public static Set<String> getCM024IgnoreCheckOrg(Long modelId, Long sceneId, Long yearId, Long periodId) {
        Set<String> orgNumberSet = new HashSet<String>(16);
        JSONObject params = ParamSettingServiceHelper.getJSON((long)modelId, (String)"CM024");
        JSONArray entry = params.getJSONArray("entryentity");
        if (entry == null) {
            return orgNumberSet;
        }
        ArrayList<Map<String, String>> multiEntityList = new ArrayList<Map<String, String>>(10);
        for (Object o : entry) {
            JSONObject jsonObject = (JSONObject)o;
            Long tmpScenarioId = LongUtil.toLong((Object)jsonObject.get((Object)"scenario"));
            Long tmpYearId = LongUtil.toLong((Object)jsonObject.get((Object)"year"));
            Long tmpPeriodId = LongUtil.toLong((Object)jsonObject.getString("period"));
            boolean needIgnore = true;
            if (tmpScenarioId > 0L && !Objects.equals(sceneId, tmpScenarioId)) {
                needIgnore = false;
            }
            if (tmpYearId > 0L && !Objects.equals(yearId, tmpYearId)) {
                needIgnore = false;
            }
            if (tmpPeriodId > 0L && !Objects.equals(periodId, tmpPeriodId)) {
                needIgnore = false;
            }
            if (!needIgnore) continue;
            HashMap<String, String> orgRange = new HashMap<String, String>(16);
            orgRange.put(ID, jsonObject.getString("oid"));
            orgRange.put("pid", jsonObject.getString("pid"));
            orgRange.put("scope", jsonObject.getString("range"));
            multiEntityList.add(orgRange);
        }
        if (!multiEntityList.isEmpty()) {
            Set<Long> orgIdSet = QueryMemberDetailsHelper.queryMemberIdsByListData(modelId, "bcm_entitymembertree", multiEntityList);
            orgNumberSet = OrgServiceHelper.getOrgList(modelId, new ArrayList<Long>(orgIdSet)).stream().map(r -> r.getString(NUMBER)).collect(Collectors.toSet());
        }
        return orgNumberSet;
    }
}

