/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.util.LongUtil;
import org.apache.commons.collections.CollectionUtils;

public class CycleTablesServiceHelper {
    public static Collection<Long> getAllCycleTables(Long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        List objects = QueryServiceHelper.queryPrimaryKeys((String)"CycleTablesServiceHelper_getAllCycleTables", (String)"bcm_cycletable", (QFilter[])qFilter.toArray(), (String)"sequence", (int)-1);
        if (objects == null || objects.isEmpty()) {
            return null;
        }
        ArrayList<Long> idList = new ArrayList<Long>(objects.size());
        objects.forEach(o -> idList.add(LongUtil.toLong((Object)o)));
        return idList;
    }

    public static HashMultimap<Long, MembRangeItem> getCycleTablesDisOrg(Collection<Long> cycleTableIds, Long modelId) {
        DynamicObjectCollection dynamicObjects;
        HashMultimap dispenses = HashMultimap.create();
        String selectFields = "id, entity,cycletable, range";
        QFilter filter1 = new QFilter("model", "=", (Object)modelId);
        if (cycleTableIds != null) {
            filter1.and(new QFilter("cycletable", "in", cycleTableIds));
        }
        if (CollectionUtils.isNotEmpty((Collection)(dynamicObjects = QueryServiceHelper.query((String)"bcm_cycletabledisentity", (String)selectFields, (QFilter[])filter1.toArray())))) {
            for (DynamicObject dis : dynamicObjects) {
                long orgId = dis.getLong("entity");
                IDNumberTreeNode treeNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
                if (treeNode == IDNumberTreeNode.NotFoundTreeNode) continue;
                MembRangeItem membRangeItem = new MembRangeItem("bcm_entitymembertree", (Long)orgId, treeNode.getLongNumber(), treeNode.getNumber(), RangeEnum.getRangeByVal((int)dis.getInt("range")), false, (Object)modelId);
                dispenses.put((Object)dis.getLong("cycletable"), (Object)membRangeItem);
            }
        }
        return dispenses;
    }

    public static Map<Long, Set<Long>> getCycleTablesToOrg(Long modelId, Collection<Long> cycleTableIds) {
        Map<Long, IDNumberTreeNode> orgMap = TreeStructureServiceHelper.getAllNode("bcm_entitymembertree", modelId);
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(orgMap.size());
        HashMultimap<Long, MembRangeItem> dispenses = CycleTablesServiceHelper.getCycleTablesDisOrg(cycleTableIds, modelId);
        dispenses.entries().forEach(e -> {
            if (!map.containsKey(e.getKey())) {
                map.put((Long)e.getKey(), new HashSet(10));
            }
            Set temp = (Set)map.get(e.getKey());
            temp.addAll((Collection)ThreadCache.get((Object)((MembRangeItem)e.getValue()).genKey(null), () -> {
                HashSet ids = new HashSet();
                ((MembRangeItem)e.getValue()).matchItems(c -> ids.add((Long)c.id));
                return MemberReader.change2BaseMember((long)modelId, (String)"bcm_entitymembertree", ids);
            }));
        });
        return map;
    }

    public static Set<Long> getCycleTablesSetDisByOrg(Long modelId, Set<Long> orgIds) {
        Map<Long, Set<Long>> tablesToOrg = CycleTablesServiceHelper.getCycleTablesToOrg(modelId, CycleTablesServiceHelper.getAllCycleTables(modelId));
        if (orgIds == null || orgIds.isEmpty() || tablesToOrg == null || tablesToOrg.isEmpty()) {
            return null;
        }
        HashSet<Long> ctSet = new HashSet<Long>(10);
        for (Long id : orgIds) {
            long orgId = LongUtil.toLong((Object)id);
            tablesToOrg.entrySet().forEach(e -> {
                if (((Set)e.getValue()).contains(orgId)) {
                    ctSet.add((Long)e.getKey());
                }
            });
        }
        return ctSet;
    }

    public static Map<Long, Set<Long>> getCycleTablesDisByOrg(Long modelId, Set<Long> orgIds) {
        Map<Long, Set<Long>> tablesToOrg = CycleTablesServiceHelper.getCycleTablesToOrg(modelId, CycleTablesServiceHelper.getAllCycleTables(modelId));
        if (orgIds == null || orgIds.isEmpty() || tablesToOrg == null || tablesToOrg.isEmpty()) {
            return tablesToOrg;
        }
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(orgIds.size());
        for (Long id : orgIds) {
            long orgId = LongUtil.toLong((Object)id);
            tablesToOrg.entrySet().forEach(e -> {
                Set value = (Set)e.getValue();
                if (!map.containsKey(orgId)) {
                    map.put(orgId, new HashSet(10));
                }
                Set temp = (Set)map.get(orgId);
                if (value.contains(orgId)) {
                    temp.add(e.getKey());
                }
            });
        }
        return map;
    }

    public static Map<Long, Set<Long>> getCycleTables2OrgMapOfDispense(Long modelId, Collection<Long> cycleTableIds) {
        HashMultimap<Long, MembRangeItem> dispenses = CycleTablesServiceHelper.getCycleTablesDisOrg(cycleTableIds, modelId);
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(dispenses.size());
        dispenses.entries().forEach(e -> {
            if (!map.containsKey(e.getKey())) {
                map.put((Long)e.getKey(), new HashSet(10));
            }
            Set temp = (Set)map.get(e.getKey());
            temp.addAll((Collection)ThreadCache.get((Object)((MembRangeItem)e.getValue()).genKey(null), () -> {
                HashSet ids = new HashSet(10);
                ((MembRangeItem)e.getValue()).matchItems(c -> ids.add((Long)c.id));
                return MemberReader.change2BaseMember((long)modelId, (String)"bcm_entitymembertree", ids);
            }));
        });
        return map;
    }

    public static Map<Long, Set<Long>> getTmplDisCycleTablesDetail(Object modelId, Set<Long> cycleTableIds) {
        QFilter qFilter = new QFilter("model", "=", modelId);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bcm_tempdiscycletable", (String)"cycletable,template,template.status", (QFilter[])qFilter.toArray());
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(collection.size());
        collection.forEach(dynamicObject -> {
            if (TemplateModel.TplStatus.ENABLE.getStatuValue().equals(dynamicObject.getString("template.status"))) {
                long cycletableId = dynamicObject.getLong("cycletable");
                long templateId = dynamicObject.getLong("template");
                if (!map.containsKey(cycletableId)) {
                    map.put(cycletableId, new HashSet(10));
                }
                Set temp = (Set)map.get(cycletableId);
                temp.add(templateId);
            }
        });
        if (cycleTableIds == null || cycleTableIds.isEmpty() || map == null || map.isEmpty()) {
            return map;
        }
        HashMap<Long, Set<Long>> cycletableMap = new HashMap<Long, Set<Long>>(cycleTableIds.size());
        for (Long id : cycleTableIds) {
            long tableId = LongUtil.toLong((Object)id);
            if (!map.containsKey(tableId)) continue;
            cycletableMap.put(tableId, (Set<Long>)map.get(tableId));
        }
        return cycletableMap;
    }

    public static Map<Long, String> getTmplDisCtDetail(Object modelId) {
        HashMap<Long, String> map = new HashMap<Long, String>(16);
        QFilter qFilter = new QFilter("model", "=", modelId);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bcm_tempdiscycletable", (String)"cycletable,cycletable.name,template", (QFilter[])qFilter.toArray());
        if (!collection.isEmpty()) {
            collection.forEach(dyo -> map.put(dyo.getLong("template"), dyo.getString("cycletable.name")));
        }
        return map;
    }

    public static boolean isExitTmplDisCycleTables(Long modelId, Long ctId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        if (ctId != null && ctId != 0L) {
            qFilter.and("cycletable", "=", (Object)ctId);
        }
        return QueryServiceHelper.exists((String)"bcm_tempdiscycletable", (QFilter[])qFilter.toArray());
    }

    public static boolean isExitCycleTableRecord(Long modelId, Long ctId) {
        QFilter ctFilter = new QFilter("cycletable", "=", (Object)ctId).and("model", "=", (Object)modelId);
        QFilter statusFilter = new QFilter("cycletabstatus", "in", Arrays.asList(ReportStatusEnum.COMPLETE.status(), ReportStatusEnum.COMMIT.status()));
        return QueryServiceHelper.exists((String)"bcm_cycletablereport", (QFilter[])new QFilter[]{ctFilter, statusFilter});
    }
}

