/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.common.MembersKey;
import kd.bos.olap.dataSources.FixedDimension;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.convert.util.ConvertServiceHelper;
import kd.fi.bcm.business.mergecontrol.MergeStatusHelper;
import kd.fi.bcm.business.script.AggScriptBuilder;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.computing.bizrule.BizRuleExecParam;
import kotlin.Pair;

public class DataMonitorServiceHelper {
    private static void saveMergeControlEntity(String org, String year, String period, String scene, String model, String currency) {
        long modelId = MemberReader.findModelIdByNum((String)model);
        Long fyId = MemberReader.findFyMemberByNum((String)model, (String)year).getId();
        Long periodId = MemberReader.findPeriodMemberByNum((String)model, (String)period).getId();
        Long sceneId = MemberReader.findScenaMemberByNum((String)model, (String)scene).getId();
        MergeStatusHelper.updateCalcStatusByCurrencyNum(modelId, sceneId, fyId, periodId, org, currency);
    }

    public static void dataMonitor(Object info, String model, CellSet cellSets) {
        if (ThreadCache.exists((Object)"all_in_one_thread")) {
            return;
        }
        if (info instanceof AggScriptBuilder) {
            DataMonitorServiceHelper.analysisAggScriptScopeBuilder((AggScriptBuilder)info, model);
        } else if (info instanceof BizRuleExecParam) {
            DataMonitorServiceHelper.analysisBizRuleExecParam((BizRuleExecParam)info, model);
        } else if (info instanceof SaveCommandInfo) {
            DataMonitorServiceHelper.analysisSaveCommandInfo((SaveCommandInfo)info, model, cellSets);
        }
    }

    private static void analysisAggScriptScopeBuilder(AggScriptBuilder aggScriptScopeBuilder, String model) {
        if (!aggScriptScopeBuilder.isNeedUpdateDataStatus()) {
            return;
        }
        Map<String, String[]> dimNumToScope = aggScriptScopeBuilder.getScopeAndDimNum();
        String year = dimNumToScope.get(DimTypesEnum.YEAR.getNumber())[0];
        String period = dimNumToScope.get(DimTypesEnum.PERIOD.getNumber())[0];
        String scene = dimNumToScope.get(DimTypesEnum.SCENARIO.getNumber())[0];
        String currencyNum = dimNumToScope.get(DimTypesEnum.CURRENCY.getNumber())[0];
        String[] orgs = dimNumToScope.get(DimTypesEnum.ENTITY.getNumber());
        Set cache = (Set)ThreadCache.get((Object)"monitor_cache", () -> new HashSet(16));
        for (String org : orgs) {
            String[] split = org.split("_");
            if (split.length == 2) {
                org = split[0];
            }
            if (cache == null || !cache.add(org)) continue;
            DataMonitorServiceHelper.matchDataName(model, org, year, period, scene, currencyNum);
        }
    }

    private static void analysisBizRuleExecParam(BizRuleExecParam bizRuleExecParam, String model) {
        String org = bizRuleExecParam.getEntityNumber();
        String year = bizRuleExecParam.getFyNumber();
        String period = bizRuleExecParam.getPeriodNumber();
        String scene = bizRuleExecParam.getScenarioNumber();
        String currency = bizRuleExecParam.getCurrencyNumber();
        DataMonitorServiceHelper.matchDataName(model, org, year, period, scene, currency);
    }

    private static void analysisSaveCommandInfo(SaveCommandInfo info, String model, CellSet cellSets) {
        String org = "";
        String year = "";
        String period = "";
        String scene = "";
        String currency = "";
        String process = null;
        for (FixedDimension fixedDimension : info.getFixedDimensions()) {
            String dim = fixedDimension.getName();
            if (DimTypesEnum.ENTITY.getNumber().equals(dim)) {
                org = fixedDimension.getValue();
                continue;
            }
            if (DimTypesEnum.YEAR.getNumber().equals(dim)) {
                year = fixedDimension.getValue();
                continue;
            }
            if (DimTypesEnum.PERIOD.getNumber().equals(dim)) {
                period = fixedDimension.getValue();
                continue;
            }
            if (DimTypesEnum.SCENARIO.getNumber().equals(dim)) {
                scene = fixedDimension.getValue();
                continue;
            }
            if (DimTypesEnum.CURRENCY.getNumber().equals(dim)) {
                currency = fixedDimension.getValue();
                continue;
            }
            if (!PresetConstant.PROCESS_DIM.equals(dim)) continue;
            process = fixedDimension.getValue();
        }
        HashSet<Map<String, String>> rows = new HashSet<Map<String, String>>();
        if (StringUtils.isEmpty((String)org) || StringUtils.isEmpty((String)year) || StringUtils.isEmpty((String)period) || StringUtils.isEmpty((String)scene) || StringUtils.isEmpty((String)currency) || StringUtils.isEmpty(process)) {
            List crossDims = info.getDimensions();
            int indexOfOrg = -1;
            int indexOfYear = -1;
            int indexOfScene = -1;
            int indexOfPeriod = -1;
            int indexOfProcess = -1;
            int indexOfCurrency = -1;
            for (int i = 0; i < crossDims.size(); ++i) {
                String dim = (String)crossDims.get(i);
                if (PresetConstant.ENTITY_DIM.equals(dim)) {
                    indexOfOrg = i;
                    continue;
                }
                if (PresetConstant.FY_DIM.equals(dim)) {
                    indexOfYear = i;
                    continue;
                }
                if (PresetConstant.SCENE_DIM.equals(dim)) {
                    indexOfScene = i;
                    continue;
                }
                if (PresetConstant.PERIOD_DIM.equals(dim)) {
                    indexOfPeriod = i;
                    continue;
                }
                if (PresetConstant.PROCESS_DIM.equals(dim)) {
                    indexOfProcess = i;
                    continue;
                }
                if (!PresetConstant.CURRENCY_DIM.equals(dim)) continue;
                indexOfCurrency = i;
            }
            Iterator cell = cellSets.getMutableMetricEntries(FacTabFieldDefEnum.FIELD_MONEY.getField());
            while (cell.hasNext()) {
                HashMap<String, String> row = new HashMap<String, String>(6);
                MembersKey membKey = (MembersKey)((Pair)cell.next()).getFirst();
                row.put(PresetConstant.ENTITY_DIM, indexOfOrg >= 0 ? membKey.getKey(indexOfOrg) : org);
                row.put(PresetConstant.FY_DIM, indexOfYear >= 0 ? membKey.getKey(indexOfYear) : year);
                row.put(PresetConstant.SCENE_DIM, indexOfScene >= 0 ? membKey.getKey(indexOfScene) : scene);
                row.put(PresetConstant.PERIOD_DIM, indexOfPeriod >= 0 ? membKey.getKey(indexOfPeriod) : period);
                row.put(PresetConstant.PROCESS_DIM, indexOfProcess >= 0 ? membKey.getKey(indexOfProcess) : process);
                row.put(PresetConstant.CURRENCY_DIM, indexOfCurrency >= 0 ? membKey.getKey(indexOfCurrency) : currency);
                rows.add(row);
            }
        } else {
            HashMap<String, String> row = new HashMap<String, String>(6);
            row.put(PresetConstant.ENTITY_DIM, org);
            row.put(PresetConstant.FY_DIM, year);
            row.put(PresetConstant.SCENE_DIM, scene);
            row.put(PresetConstant.PERIOD_DIM, period);
            row.put(PresetConstant.PROCESS_DIM, process);
            row.put(PresetConstant.CURRENCY_DIM, currency);
            rows.add(row);
        }
        DataMonitorServiceHelper.batchUpdateStatus(model, rows);
    }

    private static void matchDataName(String model, String org, String year, String period, String scene, String currency) {
        if (StringUtils.isEmpty((String)org) || StringUtils.isEmpty((String)year) || StringUtils.isEmpty((String)period) || StringUtils.isEmpty((String)scene) || StringUtils.isEmpty((String)currency)) {
            return;
        }
        DataMonitorServiceHelper.saveMergeControlEntity(org, year, period, scene, model, currency);
    }

    private static void batchUpdateStatus(String cube, Set<Map<String, String>> rows) {
        Long modelId = MemberReader.findModelIdByNum((String)cube);
        HashMap periodToOrgNumberSetMap = new HashMap(16);
        for (Map<String, String> map : rows) {
            Long periodId;
            Long fyId;
            String org = map.get(PresetConstant.ENTITY_DIM);
            String year = map.get(PresetConstant.FY_DIM);
            String period = map.get(PresetConstant.PERIOD_DIM);
            String scene = map.get(PresetConstant.SCENE_DIM);
            String currency = map.get(PresetConstant.CURRENCY_DIM);
            if (!StringUtils.isNotEmpty((String)org) || !StringUtils.isNotEmpty((String)year) || !StringUtils.isNotEmpty((String)period) || !StringUtils.isNotEmpty((String)scene)) continue;
            Long sceneId = MemberReader.findScenaMemberByNum((String)cube, (String)scene).getId();
            String uniqueKey = String.format("%s_%s_%s_%s", sceneId, fyId = MemberReader.findFyMemberByNum((String)cube, (String)year).getId(), periodId = MemberReader.findPeriodMemberByNum((String)cube, (String)period).getId(), currency);
            HashSet<String> orgNumberSet = (HashSet<String>)periodToOrgNumberSetMap.get(uniqueKey);
            if (null == orgNumberSet) {
                orgNumberSet = new HashSet<String>(16);
            }
            String orgNumber = org;
            if (org.contains("_")) {
                orgNumber = org.split("_")[0];
            }
            orgNumberSet.add(orgNumber);
            periodToOrgNumberSetMap.put(uniqueKey, orgNumberSet);
        }
        for (Map.Entry entry : periodToOrgNumberSetMap.entrySet()) {
            String[] splitArray = ((String)entry.getKey()).split("_");
            if (splitArray.length != 4) continue;
            Long sceneId = LongUtil.toLong((Object)splitArray[0]);
            Long yearId = LongUtil.toLong((Object)splitArray[1]);
            Long periodId = LongUtil.toLong((Object)splitArray[2]);
            String currencyNum = splitArray[3];
            MergeStatusHelper.batchUpdateCalcStatusByCurrencyNum(modelId, sceneId, yearId, periodId, currencyNum, (Collection)entry.getValue());
        }
        HashSet<Map<String, String>> newRows = new HashSet<Map<String, String>>(rows.size());
        for (Map<String, String> row : rows) {
            String process = row.get(PresetConstant.PROCESS_DIM);
            if ("IRpt".equals(process) || "EIRpt".equals(process) || "ERpt".equals(process) || "RAdj".equals(process) || "ERAdj".equals(process) || "Rpt".equals(process)) {
                row.put(PresetConstant.PROCESS_DIM, "Rpt");
            }
            newRows.add(row);
        }
        ConvertServiceHelper.updateConvertStatusBatch(cube, newRows);
    }
}

