/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.exchangeRate.ExchageRateServiceHelper;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ThrowableHelper;

public class DistributionDetailsSpreadLogic {
    protected static WatchLogger log;
    private static final String[] selectFields2;

    public DistributionDetailsSpreadLogic() {
        log = BcmLogFactory.getWatchLogInstance(this.getClass());
    }

    public List<QFilter> buildQueryAllChildFilter(String entity, Object entityid, String modelid, Integer iDetail, boolean needQueryLongNumber, boolean needAddDelExchangeRatePlanFilter, boolean includeSelf) {
        boolean isFalse = false;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        if (modelid != null) {
            filterList.add(new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelid)));
        }
        if (needQueryLongNumber) {
            Object longNumber = this.getOrgMemLongNumber(entity, entityid);
            filterList.add(new QFilter("longnumber", "like", (Object)(longNumber + String.valueOf('!') + "%")));
        }
        if (needAddDelExchangeRatePlanFilter) {
            if ("bcm_entitymembertree".equals(entity)) {
                filterList.add(new QFilter("isexchangerate", "=", (Object)isFalse));
            } else if ("bcm_eb_versionmembertree".equals(entity)) {
                filterList.add(new QFilter("isactual", "!=", (Object)"1"));
            }
        }
        if (iDetail != null) {
            filterList.add(new QFilter("isleaf", "=", (Object)String.valueOf(iDetail)));
        }
        return filterList;
    }

    protected Object getOrgMemLongNumber(String entity, Object entityid) {
        DynamicObject orgmen = BusinessDataServiceHelper.loadSingleFromCache((Object)entityid, (String)entity, (String)"longnumber");
        return orgmen != null ? orgmen.get("longnumber") : null;
    }

    List<DynamicObject> queryAllChild(String entity, Long entityid, String modelid, Integer iDetail) {
        List<QFilter> filters = this.buildQueryAllChildFilter(entity, entityid, modelid, iDetail, true, true, true);
        return new ArrayList<DynamicObject>(BusinessDataServiceHelper.loadFromCache((String)entity, (String)"id,number,name, copyfrom", (QFilter[])filters.toArray(new QFilter[0])).values());
    }

    Set<Long> queryAllChild(String entity, Set<Long> entityIds, String modelid, String parent, Integer iDetail) {
        QFilter filter1 = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelid)).and(new QFilter(parent, "in", entityIds));
        if (iDetail != null) {
            filter1.and(new QFilter("isleaf", "=", (Object)String.valueOf(iDetail)));
        }
        ExchageRateServiceHelper.delExchangeRatePlanFilter(filter1, entity);
        Map dynMap = BusinessDataServiceHelper.loadFromCache((String)entity, (String)"id", (QFilter[])filter1.toArray());
        HashSet<Long> ids = new HashSet<Long>(dynMap.size());
        for (DynamicObject dyn : dynMap.values()) {
            ids.add(dyn.getLong("id"));
        }
        if (!ids.isEmpty()) {
            ids.addAll(this.queryAllChild(entity, ids, modelid, parent, iDetail));
        }
        return ids;
    }

    List<DynamicObject> queryAllChild(String entity, Long entityid, String modelid) {
        List<QFilter> filters = this.buildQueryAllChildFilter(entity, entityid, modelid, null, true, true, true);
        return new ArrayList<DynamicObject>(BusinessDataServiceHelper.loadFromCache((String)entity, (String)"id,number,name,isleaf,copyfrom,parent,level,dseq", (QFilter[])filters.toArray(new QFilter[0]), (String)"dseq").values());
    }

    DynamicObject querySelf(String entity, Long entityid, String modelid) {
        QFilter filter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelid));
        QFilter filter1 = new QFilter("id", "=", (Object)entityid);
        return BusinessDataServiceHelper.loadSingleFromCache((String)entity, (String)"id,number,name,isleaf,copyfrom,parent,level,dseq", (QFilter[])new QFilter[]{filter, filter1});
    }

    List<DynamicObject> queryAllChild4Dim(String entity, Object memberId, Object dimensionId) {
        List<QFilter> filters = this.buildQueryAllChildFilter(entity, memberId, null, null, true, true, true);
        filters.add(new QFilter("dimension", "=", dimensionId));
        return new ArrayList<DynamicObject>(BusinessDataServiceHelper.loadFromCache((String)entity, (String)"id, number, name, isleaf", (QFilter[])filters.toArray(new QFilter[0])).values());
    }

    public List<QFilter> buildQueryDirectChild(String entity, Collection<?> entityIds, String parent, boolean needAddDelExchangeRatePlanFilter) {
        boolean isFalse = false;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        if (parent != null) {
            filterList.add(new QFilter(parent, "in", entityIds));
        }
        if (needAddDelExchangeRatePlanFilter) {
            if ("bcm_entitymembertree".equals(entity)) {
                filterList.add(new QFilter("isexchangerate", "=", (Object)isFalse));
            } else if ("bcm_eb_versionmembertree".equals(entity)) {
                filterList.add(new QFilter("isactual", "!=", (Object)"1"));
            }
        }
        return filterList;
    }

    private Set<Long> queryDirectChild(String entity, Set<Long> entityIds, String parent) {
        HashSet<Long> ids = new HashSet<Long>(16);
        for (DynamicObject dyn : BusinessDataServiceHelper.loadFromCache((String)entity, (String)"id", (QFilter[])this.buildQueryDirectChild(entity, entityIds, parent, true).toArray(new QFilter[0])).values()) {
            ids.add(dyn.getLong("id"));
        }
        return ids;
    }

    private List<DynamicObject> queryDirectChild(String entity, Long entityid, String parent) {
        return new ArrayList<DynamicObject>(BusinessDataServiceHelper.loadFromCache((String)entity, (String)"id, number, name, isleaf, copyfrom", (QFilter[])this.buildQueryDirectChild(entity, Collections.singletonList(entityid), parent, true).toArray(new QFilter[0]), (String)"dseq").values());
    }

    protected List<QFilter> buildQueryAllBrothersFilters(String entity, Collection<?> entityIds, String modelid, String parent) {
        QFilter filter = new QFilter("id", "in", entityIds);
        HashSet<Object> parentIds = new HashSet<Object>();
        for (DynamicObject dyn : QueryServiceHelper.query((String)entity, (String)parent, (QFilter[])filter.toArray())) {
            parentIds.add(dyn.get(parent));
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelid));
        ExchageRateServiceHelper.delExchangeRatePlanFilter(filter, entity);
        filterList.add(filter);
        filterList.add(new QFilter(parent, "in", parentIds));
        filterList.add(new QFilter("number", "!=", (Object)DimTypesEnum.ENTITY.getNumber()));
        return filterList;
    }

    private Set<Long> queryAllBrothers(String entity, Set<Long> entityIds, String modelid, String parent) {
        HashSet<Long> ids = new HashSet<Long>(16);
        for (DynamicObject dyn : BusinessDataServiceHelper.loadFromCache((String)entity, (String)"id", (QFilter[])this.buildQueryAllBrothersFilters(entity, entityIds, modelid, parent).toArray(new QFilter[0])).values()) {
            ids.add(dyn.getLong("id"));
        }
        return ids;
    }

    private List<DynamicObject> queryAllBrothers(String entity, Long entityId, String modelid, String parent) {
        return new ArrayList<DynamicObject>(BusinessDataServiceHelper.loadFromCache((String)entity, (String)"id, number, name, isleaf, copyfrom", (QFilter[])this.buildQueryAllBrothersFilters(entity, Collections.singletonList(entityId), modelid, parent).toArray(new QFilter[0]), (String)"dseq").values());
    }

    Long getBaseMemberId(Long mid, String membermodel) {
        DynamicObject member = BusinessDataServiceHelper.loadSingleFromCache((Object)mid, (String)membermodel, (String)"member,dimension.id");
        QFilter filter = new QFilter("dimension", "=", member.get("dimension.id")).and(new QFilter("number", "=", (Object)member.getString("number"))).and(new QFilter("storagetype", "!=", (Object)"3"));
        member = BusinessDataServiceHelper.loadSingleFromCache((String)membermodel, (String)"id", (QFilter[])filter.toArray());
        return member.getLong("id");
    }

    DynamicObject getBaseMember(Long mid, String membermodel, String[] selectedFields) {
        DynamicObject member = BusinessDataServiceHelper.loadSingleFromCache((Object)mid, (String)membermodel, (String)"member,dimension.id");
        QFilter filter = new QFilter("dimension", "=", member.get("dimension.id")).and(new QFilter("number", "=", (Object)member.getString("number"))).and(new QFilter("storagetype", "!=", (Object)"3"));
        return BusinessDataServiceHelper.loadSingleFromCache((String)membermodel, (String)String.join((CharSequence)",", selectedFields), (QFilter[])filter.toArray());
    }

    Set<Long> change2BaseMember(Set<Long> mids) {
        return MemberReader.change2BaseMember((String)"bcm_entitymembertree", mids);
    }

    List<DynamicObject> getDefinedPropertyDynObjectByIds(Collection<?> ids) {
        DynamicObjectType dtType = EntityMetadataCache.getSubDataEntityType((String)"bcm_definedpropertyvalue", Arrays.asList(selectFields2));
        return new ArrayList<DynamicObject>(BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(), (DynamicObjectType)dtType).values());
    }

    DynamicObject getDefinedPropertyById(Object id) {
        List<DynamicObject> list = this.getDefinedPropertyDynObjectByIds(Collections.singletonList(id));
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Deprecated
    public Set<Long> chooseMethodByRange(String entity, int value, Set<Long> entityIds, String modelid, String parent, DetailTypeEnum type) {
        switch (value) {
            case 10: {
                return this.getNotOrgRootMember(entityIds, type);
            }
            case 20: {
                return this.queryDirectChild(entity, entityIds, parent);
            }
            case 30: {
                Set<Long> templateSet = this.getNotOrgRootMember(entityIds, type);
                templateSet.addAll(this.queryDirectChild(entity, entityIds, parent));
                return templateSet;
            }
            case 40: {
                return this.queryAllChild(entity, entityIds, modelid, parent, null);
            }
            case 50: {
                Set<Long> templateSet = this.getNotOrgRootMember(entityIds, type);
                templateSet.addAll(this.queryAllChild(entity, entityIds, modelid, parent, null));
                return templateSet;
            }
            case 60: {
                Set<Long> templateSet = this.queryAllBrothers(entity, entityIds, modelid, parent);
                templateSet.removeAll(entityIds);
                return templateSet;
            }
            case 70: {
                return this.queryAllBrothers(entity, entityIds, modelid, parent);
            }
            case 90: {
                return this.queryAllChild(entity, entityIds, modelid, parent, 1);
            }
            case 110: {
                Set<Long> templateSet = this.getNotOrgRootMember(entityIds, type);
                templateSet.addAll(this.queryAllChild(entity, entityIds, modelid, parent, 0));
                return templateSet;
            }
        }
        return new HashSet<Long>();
    }

    public List<DynamicObject> chooseMethodColByRange(String entity, int scope, Long entityid, String modelid, String parent, DetailTypeEnum type) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> temp = new ArrayList<DynamicObject>();
        DynamicObject self = this.querySelf(entity, entityid, modelid);
        switch (scope) {
            case 10: {
                if (this.isOrgRootMember(entityid, type)) break;
                result.add(self);
                break;
            }
            case 20: {
                result.addAll(this.queryDirectChild(entity, entityid, parent));
                break;
            }
            case 30: {
                if (!this.isOrgRootMember(entityid, type)) {
                    result.add(self);
                }
                result.addAll(this.queryDirectChild(entity, entityid, parent));
                break;
            }
            case 40: {
                temp.add(self);
                temp.addAll(this.queryAllChild(entity, entityid, modelid));
                String parentId = self.getDynamicObject("parent") == null ? "" : self.getDynamicObject("parent").getString("id");
                this.getMemberListByLevelAndDseq(result, temp, parentId, 40);
                break;
            }
            case 50: {
                temp.add(self);
                temp.addAll(this.queryAllChild(entity, entityid, modelid));
                this.getMemberListByLevelAndDseq(result, temp, self.getDynamicObject("parent") != null ? self.getDynamicObject("parent").getString("id") : "0", 50);
                break;
            }
            case 60: {
                result.addAll(this.queryAllBrothers(entity, entityid, modelid, parent));
                this.removeSelf(result, entityid);
                break;
            }
            case 70: {
                result.addAll(this.queryAllBrothers(entity, entityid, modelid, parent));
                break;
            }
            case 90: {
                temp.add(self);
                temp.addAll(this.queryAllChild(entity, entityid, modelid));
                String parentId = self.getDynamicObject("parent") == null ? "" : self.getDynamicObject("parent").getString("id");
                this.getMemberListByLevelAndDseq(result, temp, parentId, 90);
                break;
            }
            case 110: {
                temp.add(self);
                temp.addAll(this.queryAllChild(entity, entityid, modelid));
                String parentId = self.getDynamicObject("parent") == null ? "" : self.getDynamicObject("parent").getString("id");
                this.getMemberListByLevelAndDseq(result, temp, parentId, 110);
            }
        }
        return result;
    }

    public Set<Long> chooseMethodByRange(String entityName, Object modelid, Map<Integer, Set<Long>> lookupSourceMap, DetailTypeEnum type) {
        Map<Long, IDNumberTreeNode> entityTree = TreeStructureServiceHelper.getAllNode(entityName, modelid);
        HashSet<Long> resultList = new HashSet<Long>();
        for (Map.Entry<Integer, Set<Long>> en : lookupSourceMap.entrySet()) {
            for (Long entityId : en.getValue()) {
                resultList.addAll(this.chooseMethodByRange(entityTree, en.getKey(), entityId, type));
            }
        }
        return resultList;
    }

    public Set<Long> chooseMethodByRange(Map<Long, IDNumberTreeNode> entityTree, int scope, Long entityId, DetailTypeEnum type) {
        HashSet<Long> resultList = new HashSet<Long>();
        boolean addSelf = false;
        switch (scope) {
            case 10: {
                addSelf = true;
                break;
            }
            case 30: {
                addSelf = true;
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getIds(treeNodeBuf.getChildren()));
                break;
            }
            case 20: {
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getIds(treeNodeBuf.getChildren()));
                break;
            }
            case 50: {
                addSelf = true;
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getIds(treeNodeBuf.getAllChildren()));
                break;
            }
            case 40: {
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getIds(treeNodeBuf.getAllChildren()));
                break;
            }
            case 70: {
                resultList.add(entityId);
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getIds(treeNodeBuf.getBrother()));
                break;
            }
            case 60: {
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getIds(treeNodeBuf.getBrother()));
                break;
            }
            case 90: {
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getIds(treeNodeBuf.getAllChildren(2)));
                break;
            }
            case 110: {
                addSelf = true;
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getIds(treeNodeBuf.getAllChildren(1)));
                break;
            }
        }
        if (addSelf && !entityTree.isEmpty() && !TreeStructureServiceHelper.isRootEntityNodeId(entityTree.values().iterator().next().getModelId(), entityId, type)) {
            resultList.add(entityId);
        }
        return resultList;
    }

    @Deprecated
    public Set<Long> chooseMethodByRange(String entity, int value, Long entityid, String modelid, String parent, DetailTypeEnum type) {
        HashSet<Long> templateSet = new HashSet<Long>();
        switch (value) {
            case 10: {
                if (this.isOrgRootMember(entityid, type)) break;
                templateSet.add(entityid);
                break;
            }
            case 20: {
                for (DynamicObject mem : this.queryDirectChild(entity, entityid, parent)) {
                    templateSet.add(mem.getLong("id"));
                }
                break;
            }
            case 30: {
                if (!this.isOrgRootMember(entityid, type)) {
                    templateSet.add(entityid);
                }
                for (DynamicObject mem : this.queryDirectChild(entity, entityid, parent)) {
                    templateSet.add(mem.getLong("id"));
                }
                break;
            }
            case 40: {
                for (DynamicObject mem : this.queryAllChild(entity, entityid, modelid)) {
                    templateSet.add(mem.getLong("id"));
                }
                break;
            }
            case 50: {
                if (!this.isOrgRootMember(entityid, type)) {
                    templateSet.add(entityid);
                }
                for (DynamicObject mem : this.queryAllChild(entity, entityid, modelid)) {
                    templateSet.add(mem.getLong("id"));
                }
                break;
            }
            case 60: {
                for (DynamicObject mem : this.queryAllBrothers(entity, entityid, modelid, parent)) {
                    templateSet.add(mem.getLong("id"));
                }
                templateSet.remove(entityid);
                break;
            }
            case 70: {
                for (DynamicObject mem : this.queryAllBrothers(entity, entityid, modelid, parent)) {
                    templateSet.add(mem.getLong("id"));
                }
                break;
            }
            case 90: {
                for (DynamicObject mem : this.queryAllChild(entity, entityid, modelid, 1)) {
                    templateSet.add(mem.getLong("id"));
                }
                break;
            }
            case 110: {
                if (!this.isOrgRootMember(entityid, type)) {
                    templateSet.add(entityid);
                }
                for (DynamicObject mem : this.queryAllChild(entity, entityid, modelid, 0)) {
                    templateSet.add(mem.getLong("id"));
                }
                break;
            }
        }
        return templateSet;
    }

    public Map<Long, Integer> chooseMethodMapByRange(String entity, int value, Long entityid, String modelid, String parent, DetailTypeEnum type) {
        HashMap<Long, Integer> templateMap = new HashMap<Long, Integer>();
        Long id = null;
        switch (value) {
            case 10: {
                if (this.isOrgRootMember(entityid, type)) break;
                templateMap.putIfAbsent(entityid, 0);
                templateMap.computeIfPresent(entityid, (k, v) -> v + 1);
                break;
            }
            case 20: {
                for (DynamicObject mem : this.queryDirectChild(entity, entityid, parent)) {
                    id = mem.getLong("id");
                    templateMap.putIfAbsent(id, 0);
                    templateMap.computeIfPresent(id, (k, v) -> v + 1);
                }
                break;
            }
            case 30: {
                if (!this.isOrgRootMember(entityid, type)) {
                    templateMap.putIfAbsent(entityid, 0);
                    templateMap.computeIfPresent(entityid, (k, v) -> v + 1);
                }
                for (DynamicObject mem : this.queryDirectChild(entity, entityid, parent)) {
                    id = mem.getLong("id");
                    templateMap.putIfAbsent(id, 0);
                    templateMap.computeIfPresent(id, (k, v) -> v + 1);
                }
                break;
            }
            case 40: {
                for (DynamicObject mem : this.queryAllChild(entity, entityid, modelid)) {
                    id = mem.getLong("id");
                    templateMap.putIfAbsent(id, 0);
                    templateMap.computeIfPresent(id, (k, v) -> v + 1);
                }
                break;
            }
            case 50: {
                if (!this.isOrgRootMember(entityid, type)) {
                    templateMap.putIfAbsent(entityid, 0);
                    templateMap.computeIfPresent(entityid, (k, v) -> v + 1);
                }
                for (DynamicObject mem : this.queryAllChild(entity, entityid, modelid)) {
                    id = mem.getLong("id");
                    templateMap.putIfAbsent(id, 0);
                    templateMap.computeIfPresent(id, (k, v) -> v + 1);
                }
                break;
            }
            case 60: {
                for (DynamicObject mem : this.queryAllBrothers(entity, entityid, modelid, parent)) {
                    id = mem.getLong("id");
                    templateMap.putIfAbsent(id, 0);
                    templateMap.computeIfPresent(id, (k, v) -> v + 1);
                }
                templateMap.remove(entityid);
                break;
            }
            case 70: {
                for (DynamicObject mem : this.queryAllBrothers(entity, entityid, modelid, parent)) {
                    id = mem.getLong("id");
                    templateMap.putIfAbsent(id, 0);
                    templateMap.computeIfPresent(id, (k, v) -> v + 1);
                }
                break;
            }
            case 90: {
                for (DynamicObject mem : this.queryAllChild(entity, entityid, modelid, 1)) {
                    id = mem.getLong("id");
                    templateMap.putIfAbsent(id, 0);
                    templateMap.computeIfPresent(id, (k, v) -> v + 1);
                }
                break;
            }
            case 110: {
                if (!this.isOrgRootMember(entityid, type)) {
                    templateMap.putIfAbsent(entityid, 0);
                    templateMap.computeIfPresent(entityid, (k, v) -> v + 1);
                }
                for (DynamicObject mem : this.queryAllChild(entity, entityid, modelid, 0)) {
                    id = mem.getLong("id");
                    templateMap.putIfAbsent(id, 0);
                    templateMap.computeIfPresent(id, (k, v) -> v + 1);
                }
                break;
            }
        }
        return templateMap;
    }

    public Set<String> chooseMethodByRange4Number(String entity, int scope, Long entityId, String number, String modelid, String parent, DetailTypeEnum type) {
        String key = entity + "|" + scope + "|" + entityId + "|" + modelid + "|" + type;
        HashSet<String> resultList = (HashSet<String>)ThreadCache.get((Object)key);
        if (resultList != null) {
            return resultList;
        }
        resultList = new HashSet<String>();
        ThreadCache.put((Object)key, resultList);
        Map<Long, IDNumberTreeNode> entityTree = TreeStructureServiceHelper.getAllNode(entity, modelid);
        boolean addSelf = false;
        switch (scope) {
            case 10: {
                addSelf = true;
                break;
            }
            case 30: {
                addSelf = true;
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getNumbers(treeNodeBuf.getChildren()));
                break;
            }
            case 20: {
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getNumbers(treeNodeBuf.getChildren()));
                break;
            }
            case 50: {
                addSelf = true;
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getNumbers(treeNodeBuf.getAllChildren()));
                break;
            }
            case 40: {
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getNumbers(treeNodeBuf.getAllChildren()));
                break;
            }
            case 70: {
                resultList.add(number);
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getNumbers(treeNodeBuf.getBrother()));
                break;
            }
            case 60: {
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getNumbers(treeNodeBuf.getBrother()));
                break;
            }
            case 90: {
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getNumbers(treeNodeBuf.getAllChildren(2)));
                break;
            }
            case 110: {
                addSelf = true;
                IDNumberTreeNode treeNodeBuf = entityTree.get(entityId);
                if (treeNodeBuf == null) break;
                resultList.addAll(TreeStructureServiceHelper.getNumbers(treeNodeBuf.getAllChildren(1)));
                break;
            }
        }
        if (addSelf && !TreeStructureServiceHelper.isRootEntityNodeId(Long.parseLong(modelid), entityId, type)) {
            resultList.add(number);
        }
        return resultList;
    }

    public HashMap<String, Long> chooseMethodByRange4NumberDetail(String entity, int value, Long entityid, String modelid, String parent, DetailTypeEnum type) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        String selectFields = "id, number, isleaf, copyfrom";
        DynamicObject doc = BusinessDataServiceHelper.loadSingleFromCache((Object)entityid, (String)entity, (String)selectFields);
        if (doc != null) {
            String number = doc.getString("number");
            Long memberId = doc.getLong("id");
            switch (value) {
                case 10: {
                    if (!doc.getBoolean("isleaf")) break;
                    hashMap.put(number, this.getBaseMembId(doc));
                    break;
                }
                case 20: {
                    for (DynamicObject mem : this.queryDirectChild(entity, entityid, parent)) {
                        if (!mem.getBoolean("isleaf")) continue;
                        hashMap.put(mem.getString("number"), this.getBaseMembId(mem));
                    }
                    break;
                }
                case 30: {
                    hashMap.put(number, this.getBaseMembId(doc));
                    for (DynamicObject mem : this.queryDirectChild(entity, entityid, parent)) {
                        if (!mem.getBoolean("isleaf")) continue;
                        hashMap.put(mem.getString("number"), this.getBaseMembId(mem));
                    }
                    break;
                }
                case 40: {
                    for (DynamicObject mem : this.queryAllChild(entity, entityid, modelid)) {
                        if (!mem.getBoolean("isleaf")) continue;
                        hashMap.put(mem.getString("number"), this.getBaseMembId(mem));
                    }
                    break;
                }
                case 50: {
                    if (doc.getBoolean("isleaf")) {
                        hashMap.put(number, this.getBaseMembId(doc));
                    }
                    for (DynamicObject mem : this.queryAllChild(entity, entityid, modelid)) {
                        if (!mem.getBoolean("isleaf")) continue;
                        hashMap.put(mem.getString("number"), this.getBaseMembId(mem));
                    }
                    break;
                }
                case 60: {
                    for (DynamicObject mem : this.queryAllBrothers(entity, entityid, modelid, parent)) {
                        if (!mem.getBoolean("isleaf")) continue;
                        hashMap.put(mem.getString("number"), this.getBaseMembId(mem));
                    }
                    hashMap.remove(number);
                    break;
                }
                case 70: {
                    for (DynamicObject mem : this.queryAllBrothers(entity, entityid, modelid, parent)) {
                        if (!mem.getBoolean("isleaf")) continue;
                        hashMap.put(mem.getString("number"), this.getBaseMembId(mem));
                    }
                    break;
                }
                case 90: {
                    for (DynamicObject mem : this.queryAllChild(entity, entityid, modelid, 1)) {
                        hashMap.put(mem.getString("number"), this.getBaseMembId(mem));
                    }
                    break;
                }
                case 110: {
                    if (!doc.getBoolean("isleaf")) break;
                    hashMap.put(number, this.getBaseMembId(doc));
                    break;
                }
            }
        }
        return hashMap;
    }

    private Long getBaseMembId(DynamicObject dynaObj) {
        try {
            Long copyfrom = dynaObj.getLong("copyfrom.id");
            if (copyfrom != null && copyfrom != 0L) {
                return copyfrom;
            }
            return dynaObj.getLong("id");
        }
        catch (Throwable t) {
            log.error("--getBaseMembId--\n:" + ThrowableHelper.toString((Throwable)t));
            return dynaObj.getLong("id");
        }
    }

    public Set<String> chooseMethodByRange(String entity, int rangeValue, Long selectMemberId, String selectMemberNumber, String modelid, String parent) {
        HashSet<String> memberNumberSet = new HashSet<String>();
        switch (rangeValue) {
            case 10: {
                memberNumberSet.add(selectMemberNumber);
                break;
            }
            case 20: {
                for (DynamicObject mem : this.queryDirectChild(entity, selectMemberId, parent)) {
                    memberNumberSet.add(mem.getString("number"));
                }
                break;
            }
            case 30: {
                memberNumberSet.add(selectMemberNumber);
                for (DynamicObject mem : this.queryDirectChild(entity, selectMemberId, parent)) {
                    memberNumberSet.add(mem.getString("number"));
                }
                break;
            }
            case 40: {
                for (DynamicObject mem : this.queryAllChild(entity, selectMemberId, modelid)) {
                    memberNumberSet.add(mem.getString("number"));
                }
                break;
            }
            case 50: {
                for (DynamicObject mem : this.queryAllChild(entity, selectMemberId, modelid)) {
                    memberNumberSet.add(mem.getString("number"));
                }
                memberNumberSet.add(selectMemberNumber);
                break;
            }
            case 60: {
                for (DynamicObject mem : this.queryAllBrothers(entity, selectMemberId, modelid, parent)) {
                    memberNumberSet.add(mem.getString("number"));
                }
                memberNumberSet.remove(selectMemberNumber);
                break;
            }
            case 70: {
                for (DynamicObject mem : this.queryAllBrothers(entity, selectMemberId, modelid, parent)) {
                    memberNumberSet.add(mem.getString("number"));
                }
                break;
            }
            case 90: {
                for (DynamicObject mem : this.queryAllChild(entity, selectMemberId, modelid, 1)) {
                    memberNumberSet.add(mem.getString("number"));
                }
                break;
            }
            case 110: {
                for (DynamicObject mem : this.queryAllChild(entity, selectMemberId, modelid, 0)) {
                    memberNumberSet.add(mem.getString("number"));
                }
                memberNumberSet.add(selectMemberNumber);
                break;
            }
        }
        return memberNumberSet;
    }

    private boolean isOrgRootMember(Long entityid, DetailTypeEnum type) {
        if (DetailTypeEnum.TEMPLATEDIS == type) {
            QFilter filter = new QFilter("id", "=", (Object)entityid);
            QFilter filter2 = new QFilter("number", "=", (Object)DimTypesEnum.ENTITY.getNumber());
            return QueryServiceHelper.exists((String)"bcm_entitymembertree", (QFilter[])new QFilter[]{filter, filter2});
        }
        return false;
    }

    private Set<Long> getNotOrgRootMember(Set<Long> entityIds, DetailTypeEnum type) {
        HashSet<Long> idSet = new HashSet<Long>();
        if (DetailTypeEnum.TEMPLATEDIS == type) {
            QFilter filter = new QFilter("id", "in", entityIds);
            QFilter filter2 = new QFilter("number", "!=", (Object)DimTypesEnum.ENTITY.getNumber());
            for (DynamicObject dyn : BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)"id", (QFilter[])new QFilter[]{filter, filter2}).values()) {
                idSet.add(dyn.getLong("id"));
            }
        }
        return idSet;
    }

    private void removeSelf(List<DynamicObject> result, Long id) {
        for (DynamicObject dot : result) {
            if (!id.equals(dot.getLong("id"))) continue;
            result.remove(dot);
            break;
        }
    }

    private void getMemberListByLevelAndDseq(List<DynamicObject> result, List<DynamicObject> dots, String rootId, int scope) {
        TreeNode root = new TreeNode("root", null);
        root = this.getTree(dots, root, rootId);
        if (scope == 40) {
            this.scan(root, result);
            result.remove(0);
        } else if (scope == 50) {
            this.scan(root, result);
        } else if (scope == 90) {
            this.scanOnlyLeaf(root, result, true);
        } else if (scope == 110) {
            this.scanOnlyLeaf(root, result, false);
        }
    }

    private void scan(TreeNode b, List<DynamicObject> result) {
        result.add(b.getData());
        for (TreeNode child : b.getChildren()) {
            this.scan(child, result);
        }
    }

    private void scanOnlyLeaf(TreeNode b, List<DynamicObject> result, boolean onlyLeaf) {
        if (onlyLeaf) {
            if (b.getChildren().isEmpty()) {
                result.add(b.getData());
            }
        } else if (!b.getChildren().isEmpty()) {
            result.add(b.getData());
        }
        for (TreeNode child : b.getChildren()) {
            this.scanOnlyLeaf(child, result, onlyLeaf);
        }
    }

    public TreeNode getTree(List<DynamicObject> rootNodeList, TreeNode root, String parentId) {
        return this.getDimensionTreeRoot(false, rootNodeList, root, parentId);
    }

    private TreeNode getDimensionTreeRoot(boolean ishaveroot, List<DynamicObject> rootNodeList, TreeNode parent, String parentId) {
        for (DynamicObject map : rootNodeList) {
            if (!ishaveroot) {
                if (map.getDynamicObject("parent") != null && !map.getDynamicObject("parent").getString("id").equals(parentId)) continue;
                parent = new TreeNode(map.getString("id"), map);
                parent.setParent(null);
                this.getDimensionTreeRoot(true, rootNodeList, parent, parentId);
                continue;
            }
            if (map.getDynamicObject("parent") == null || !map.getDynamicObject("parent").getString("id").equals(parent.getId())) continue;
            TreeNode child = new TreeNode(map.getString("id"), map);
            child.setParent(parent);
            parent.addChild(child);
            this.getDimensionTreeRoot(true, rootNodeList, child, parentId);
        }
        return parent;
    }

    static {
        selectFields2 = new String[]{"propertyid", "propertyid.name", "propertyid.number", "propertyid.propertyn"};
    }

    static class TreeNode {
        private String id;
        private TreeNode parent;
        private List<TreeNode> children = new ArrayList<TreeNode>();
        private DynamicObject data;

        public TreeNode(String id, DynamicObject dot) {
            this.id = id;
            this.data = dot;
        }

        public String getId() {
            return this.id;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public void setParent(TreeNode parent) {
            this.parent = parent;
        }

        public List<TreeNode> getChildren() {
            return this.children;
        }

        public void addChild(TreeNode child) {
            this.children.add(child);
            child.setParent(this);
        }

        public DynamicObject getData() {
            return this.data;
        }
    }
}

