/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper;

import com.google.common.base.Joiner;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.model.ExecuteContext;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.allinone.service.BizRuleExecuteService;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.extend.ExtConvertBaseUnit;
import kd.fi.bcm.business.convert.extend.ExtConvertUnitsUtil;
import kd.fi.bcm.business.convert.extend.ExtendDataModelInfo;
import kd.fi.bcm.business.convert.query.BaseConvertFormula;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.convert.query.ModelRate;
import kd.fi.bcm.business.convert.query.RateModel;
import kd.fi.bcm.business.convert.query.RateSchema;
import kd.fi.bcm.business.convert.util.ConvertSchemeServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.helper.ExtDimensionHelper;
import kd.fi.bcm.business.extdata.ExtDataLockServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataServiceHelper;
import kd.fi.bcm.business.extdata.ExtFieldMappedService;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.extdata.sql.EDResultSet;
import kd.fi.bcm.business.extdata.sql.EDRow;
import kd.fi.bcm.business.extdata.sql.EdQueryComInfo;
import kd.fi.bcm.business.innertrade.model.IntrMergeParam;
import kd.fi.bcm.business.innertrade.report.IntrReportHelper;
import kd.fi.bcm.business.innertrade.report.IntrTemplateHelper;
import kd.fi.bcm.business.innertrade.report.QueryIntrDataHelper;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.mergecontrol.MergeStatusHelper;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.olap.scale.CurrencyScaleHandler;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.sql.util.TypeConversionUtils;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.factory.CacheGenFactory;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ExchangeEnum;
import kd.fi.bcm.common.enums.ExtendDimGroupType;
import kd.fi.bcm.common.enums.MergeDataSourceEnum;
import kd.fi.bcm.common.enums.rule.BizRuleExecuteTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;

public class ExtConvertServiceHelper {
    private static final String PREFIX = "extConvert";
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ExtConvertServiceHelper.class);

    public static ResultBox convertExtModels(ExecuteContext ctx, boolean isExecChildNode) {
        ResultBox result = ResultBox.of();
        Long modelId = (Long)ctx.getModel().getId();
        if (!ExtConvertServiceHelper.checkIsExistExtDimension(modelId)) {
            return result;
        }
        Long orgId = (Long)ctx.getOrg().getId();
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        if ("Entity".equals(orgNode.getNumber())) {
            return result;
        }
        SimpleItem model = ctx.getModel();
        SimpleItem scenario = ctx.getScenario();
        SimpleItem year = ctx.getFy();
        SimpleItem period = ctx.getPeriod();
        SimpleItem org = ctx.getOrg();
        List<Pair<Long, String>> cvtPaths = ctx.getNowPaths();
        Pair<Long, String> sourceCurrencyPair = cvtPaths.get(0);
        String sourceCurrency = (String)sourceCurrencyPair.p2;
        Pair<Long, String> targetCurrencyPair = cvtPaths.get(1);
        String targetCurrency = (String)targetCurrencyPair.p2;
        BaseData baseData = new BaseData((Long)model.getId(), scenario, year, period);
        Map<Long, String> mdsMap = MergeControlHelper.geAllMergeDs(modelId, scenario.getId(), year.getId(), period.getId());
        if (orgNode.isLeaf() || !mdsMap.isEmpty() && MergeDataSourceEnum.CSTE.getIndex().equals(mdsMap.get(orgId))) {
            if (!PeriodSettingHelper.checkPeriodStatus((Long)model.getId(), org.getNumber(), (Long)scenario.getId(), (Long)year.getId(), (Long)period.getId(), "datastatus")) {
                return result;
            }
            McStatus mcStatus = MergeStatusHelper.getMcStatusByCurrencyNumber((Long)model.getId(), (Long)scenario.getId(), (Long)year.getId(), (Long)period.getId(), (Long)org.getId(), targetCurrency);
            if (mcStatus.getPcFlow().isSubmit()) {
                return result;
            }
            List<SimpleVo> extModels = ExtConvertServiceHelper.getConvertExtModels(modelId);
            if (!extModels.isEmpty()) {
                ExtConvertBaseUnit baseUnit = new ExtConvertBaseUnit(baseData, SimpleVo.newOne(orgNode), "ERpt", sourceCurrency, targetCurrency, extModels);
                ArrayList<ExtConvertBaseUnit> baseUnits = new ArrayList<ExtConvertBaseUnit>();
                baseUnits.add(baseUnit);
                result.append(ExtConvertServiceHelper.convertExtModel(baseUnits));
                BizRuleExecuteService bizRuleExecuteService = ExtConvertServiceHelper.getBizRuleExecuteService(model, SimpleItem.newOne(orgNode.getId(), orgNode.getNumber()), year, period, scenario);
                bizRuleExecuteService.executeRule(Collections.singletonList("IRpt"), targetCurrency, BizRuleExecuteTypeEnum.EXTCONV_ONLY);
            }
        } else {
            List<SimpleVo> partMergeExtModels;
            if (isExecChildNode) {
                Map<String, String> canCvtOrgAndECMap = ExtConvertServiceHelper.getCanCvtOrgAndECMap(model, scenario, year, period, org, targetCurrency, true);
                List<SimpleVo> partMergeExtModels2 = ExtConvertServiceHelper.getConvertExtModels(modelId, true);
                if (!partMergeExtModels2.isEmpty()) {
                    for (Map.Entry<String, String> entry : canCvtOrgAndECMap.entrySet()) {
                        McStatus mcStatus;
                        String orgEc = entry.getValue();
                        IDNumberTreeNode orgTreeNode = MemberReader.findEntityMemberByNum((String)model.getNumber(), (String)entry.getKey());
                        if (!PeriodSettingHelper.checkPeriodStatus((Long)model.getId(), orgTreeNode.getNumber(), (Long)scenario.getId(), (Long)year.getId(), (Long)period.getId(), "datastatus") || (mcStatus = MergeStatusHelper.getMcStatusByCurrencyNumber((Long)model.getId(), (Long)scenario.getId(), (Long)year.getId(), (Long)period.getId(), orgTreeNode.getId(), targetCurrency)).getPcFlow().isSubmit()) continue;
                        ArrayList<ExtConvertBaseUnit> baseUnits = new ArrayList<ExtConvertBaseUnit>();
                        ExtConvertBaseUnit baseUnit = new ExtConvertBaseUnit(baseData, SimpleVo.newOne(orgTreeNode), "ERpt", orgEc, targetCurrency, partMergeExtModels2);
                        baseUnits.add(baseUnit);
                        ExtConvertServiceHelper.convertExtModel(baseUnits);
                        BizRuleExecuteService bizRuleExecuteService = ExtConvertServiceHelper.getBizRuleExecuteService(model, SimpleItem.newOne(orgTreeNode.getId(), orgTreeNode.getNumber()), year, period, scenario);
                        bizRuleExecuteService.executeRule(Collections.singletonList("IRpt"), targetCurrency, BizRuleExecuteTypeEnum.EXTCONV_ONLY);
                    }
                }
            }
            if (!PeriodSettingHelper.checkPeriodStatus((Long)model.getId(), orgNode.getNumber(), (Long)scenario.getId(), (Long)year.getId(), (Long)period.getId(), "datastatus")) {
                return result;
            }
            McStatus mcStatus = MergeStatusHelper.getMcStatusByCurrencyNumber((Long)model.getId(), (Long)scenario.getId(), (Long)year.getId(), (Long)period.getId(), orgNode.getId(), targetCurrency);
            if (mcStatus.getPcFlow().isSubmit()) {
                return result;
            }
            ArrayList<ExtConvertBaseUnit> baseUnits = new ArrayList<ExtConvertBaseUnit>();
            List<SimpleVo> notPartMergeExtModels = ExtConvertServiceHelper.getConvertExtModels(modelId, false);
            if (!notPartMergeExtModels.isEmpty()) {
                ExtConvertBaseUnit baseUnit = new ExtConvertBaseUnit(baseData, SimpleVo.newOne(orgNode), "ERpt", sourceCurrency, targetCurrency, notPartMergeExtModels);
                baseUnits.add(baseUnit);
            }
            if (!(partMergeExtModels = ExtConvertServiceHelper.getConvertExtModels(modelId, true)).isEmpty()) {
                ExtConvertBaseUnit extConvertBaseUnit = new ExtConvertBaseUnit(baseData, SimpleVo.newOne(orgNode), "RAdj", sourceCurrency, targetCurrency, partMergeExtModels);
                baseUnits.add(extConvertBaseUnit);
            }
            if (!baseUnits.isEmpty()) {
                result.append(ExtConvertServiceHelper.convertExtModel(baseUnits));
                BizRuleExecuteService bizRuleExecuteService = ExtConvertServiceHelper.getBizRuleExecuteService(model, SimpleItem.newOne(orgNode.getId(), orgNode.getNumber()), year, period, scenario);
                bizRuleExecuteService.executeRule(Collections.singletonList("IRpt"), targetCurrency, BizRuleExecuteTypeEnum.EXTCONV_ONLY);
            }
        }
        return result;
    }

    public static ResultBox convertExtModelsForMerge(ExecuteContext ctx) {
        Long orgId;
        ResultBox result = ResultBox.of();
        Long modelId = (Long)ctx.getModel().getId();
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)(orgId = (Long)ctx.getOrg().getId()));
        if ("Entity".equals(orgNode.getNumber())) {
            return result;
        }
        Long startMergeOrgId = ctx.getEntryOrgId();
        Set<String> needConvertCurrencyNumber = ExtConvertServiceHelper.findNeedConvertCurrencyNumber(modelId, orgId, startMergeOrgId);
        log.info(String.format("%s ExtCvtCurrency: %s", orgNode.getNumber(), String.join((CharSequence)";", needConvertCurrencyNumber)));
        if (needConvertCurrencyNumber.isEmpty()) {
            return result;
        }
        SimpleItem model = ctx.getModel();
        SimpleItem scenario = ctx.getScenario();
        SimpleItem year = ctx.getFy();
        SimpleItem period = ctx.getPeriod();
        SimpleItem org = ctx.getOrg();
        BaseData baseData = new BaseData((Long)model.getId(), scenario, year, period);
        String orcEc = orgNode.getCurrency();
        List<SimpleVo> allConvertExtModels = ExtConvertServiceHelper.getConvertExtModels(modelId);
        if (allConvertExtModels.isEmpty()) {
            return result;
        }
        MergeDataSourceEnum mergeDataSourceEnum = MergeControlHelper.getMergeSource((Object)modelId, scenario.getId(), year.getId(), period.getId(), orgNode.getId());
        boolean isCSTE = mergeDataSourceEnum.getIndex().equals(MergeDataSourceEnum.CSTE.getIndex());
        if (orgNode.isLeaf() || isCSTE) {
            for (String convertTargetCurrencyNumber : needConvertCurrencyNumber) {
                try {
                    if (!PeriodSettingHelper.checkPeriodStatus((Long)model.getId(), org.getNumber(), (Long)scenario.getId(), (Long)year.getId(), (Long)period.getId(), "datastatus")) {
                        result.addTip(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7 %1$s \u5728\u8d22\u5e74 %2$s \u671f\u95f4 %3$s \u7684\u671f\u95f4\u72b6\u6001\u5df2\u5173\u95ed", (String)"ExtConvertServiceHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]), org.number, year.number, period.number));
                        continue;
                    }
                    McStatus mcStatus = MergeStatusHelper.getMcStatusByCurrencyNumber((Long)model.getId(), (Long)scenario.getId(), (Long)year.getId(), (Long)period.getId(), (Long)org.getId(), convertTargetCurrencyNumber);
                    if (mcStatus.getPcFlow().isSubmit()) {
                        result.addTip(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7 %1$s \u5728\u5e01\u79cd %2$s \u4e0a\u7684\u6d41\u7a0b\u5df2\u63d0\u4ea4", (String)"ExtConvertServiceHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]), org.number, convertTargetCurrencyNumber));
                        continue;
                    }
                    ArrayList<ExtConvertBaseUnit> baseUnits = new ArrayList<ExtConvertBaseUnit>();
                    ExtConvertBaseUnit baseUnit = new ExtConvertBaseUnit(baseData, SimpleVo.newOne(org.getNumber(), (Long)org.getId()), "ERpt", orcEc, convertTargetCurrencyNumber, allConvertExtModels);
                    baseUnits.add(baseUnit);
                    result.append(ExtConvertServiceHelper.convertExtModel(baseUnits));
                    BizRuleExecuteService bizRuleExecuteService = ExtConvertServiceHelper.getBizRuleExecuteService(model, org, year, period, scenario);
                    bizRuleExecuteService.executeRule(Collections.singletonList("IRpt"), convertTargetCurrencyNumber, BizRuleExecuteTypeEnum.EXTCONV_ONLY);
                }
                catch (Exception e) {
                    log.error(String.format("%s:%s->%sExtCvtForMerge error:", org.getNumber(), orgNode.getCurrency(), convertTargetCurrencyNumber), (Throwable)e);
                    result.addError(e.getMessage());
                }
            }
        } else {
            List<SimpleVo> partMergeConvertExtModels = ExtConvertServiceHelper.getConvertExtModels(modelId, true);
            List<SimpleVo> notPartMergeExtModels = ExtConvertServiceHelper.getConvertExtModels(modelId, false);
            for (String convertTargetCurrencyNumber : needConvertCurrencyNumber) {
                try {
                    ExtConvertBaseUnit baseUnit;
                    ArrayList<ExtConvertBaseUnit> extConvertBaseUnits = new ArrayList<ExtConvertBaseUnit>(10);
                    if (!partMergeConvertExtModels.isEmpty()) {
                        baseUnit = new ExtConvertBaseUnit(baseData, SimpleVo.newOne(org.getNumber(), (Long)org.getId()), "RAdj", orcEc, convertTargetCurrencyNumber, partMergeConvertExtModels);
                        extConvertBaseUnits.add(baseUnit);
                        result.append(ExtConvertServiceHelper.convertExtModel(extConvertBaseUnits));
                    }
                    if (!notPartMergeExtModels.isEmpty()) {
                        baseUnit = new ExtConvertBaseUnit(baseData, SimpleVo.newOne(org.getNumber(), (Long)org.getId()), "ERpt", orcEc, convertTargetCurrencyNumber, notPartMergeExtModels);
                        extConvertBaseUnits.add(baseUnit);
                    }
                    if (extConvertBaseUnits.isEmpty()) continue;
                    result.append(ExtConvertServiceHelper.convertExtModel(extConvertBaseUnits));
                    BizRuleExecuteService bizRuleExecuteService = ExtConvertServiceHelper.getBizRuleExecuteService(model, org, year, period, scenario);
                    bizRuleExecuteService.executeRule(Collections.singletonList("IRpt"), convertTargetCurrencyNumber, BizRuleExecuteTypeEnum.EXTCONV_ONLY);
                }
                catch (Exception e) {
                    log.error(String.format("%s:%s->%sExtCvtForMerge error:", org.getNumber(), orgNode.getCurrency(), convertTargetCurrencyNumber), (Throwable)e);
                    result.addError(e.getMessage());
                }
            }
        }
        return result;
    }

    private static Set<String> findNeedConvertCurrencyNumber(long modelId, long currentOrgId, long entryMergeOrgId) {
        IDNumberTreeNode currentOrgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)currentOrgId);
        IDNumberTreeNode entryMergeOrgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)entryMergeOrgId);
        IDNumberTreeNode entryMergeOrgParentNode = entryMergeOrgNode.getParent();
        HashSet<String> cvtCurrencyNumberSet = new HashSet<String>(16);
        for (IDNumberTreeNode parentOrgNode = currentOrgNode.getParent(); parentOrgNode != null && parentOrgNode != IDNumberTreeNode.NotFoundTreeNode && entryMergeOrgParentNode != null && entryMergeOrgParentNode != IDNumberTreeNode.NotFoundTreeNode && !parentOrgNode.getNumber().equals("Entity") && parentOrgNode.getCurrency() != null && !parentOrgNode.getId().equals(entryMergeOrgParentNode.getId()); parentOrgNode = parentOrgNode.getParent()) {
            if (currentOrgNode.getCurrency().equals(parentOrgNode.getCurrency())) continue;
            cvtCurrencyNumberSet.add(parentOrgNode.getCurrency());
        }
        return cvtCurrencyNumberSet;
    }

    private static String findStandardCvtPlanAuditTrail(long modelId) {
        return (String)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)("CvtAfterAuditTrail" + modelId), () -> {
            BaseConvertFormula baseConvertFormula = ConvertSchemeServiceHelper.getBaseConvertFormula(modelId, 0L);
            return baseConvertFormula.getConvertAudittrial() == null ? "" : baseConvertFormula.getConvertAudittrial();
        });
    }

    public static void clearStandardCvtPlanAuditTrail(long modelId) {
        CacheGenFactory.getCommonCache().invalidateByKey("CvtAfterAuditTrail" + modelId);
    }

    public static Map<String, String> getCanCvtOrgAndECMap(SimpleItem model, SimpleItem scene, SimpleItem year, SimpleItem period, SimpleItem org, String targetCurrency, boolean isLeaf) {
        Long modelId = (Long)model.getId();
        Long orgId = (Long)org.getId();
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        Map<String, Set<Long>> effectiveOrg = InvestServiceHelper.queryEffectiveOrgMapCache(modelId, (Long)scene.getId(), (Long)year.getId(), (Long)period.getId(), (Long)org.getId());
        ArrayList<IDNumberTreeNode> allChildren = orgNode.getAllChildren(isLeaf ? 2 : 1);
        Map<Long, String> mdsMap = MergeControlHelper.geAllMergeDs(modelId, scene.getId(), year.getId(), period.getId());
        if (!mdsMap.isEmpty()) {
            HashSet excludesOrg = new HashSet(16);
            String ownType = mdsMap.get(orgId);
            if (MergeDataSourceEnum.CSTE.getIndex().equals(ownType)) {
                return Collections.emptyMap();
            }
            orgNode.getAllChildren(1).forEach(child -> {
                String type = (String)mdsMap.get(child.getId());
                if (MergeDataSourceEnum.CSTE.getIndex().equals(type)) {
                    excludesOrg.add(child.getId());
                    excludesOrg.addAll(child.getAllChildrenIds());
                }
            });
            ArrayList<IDNumberTreeNode> temp = new ArrayList<IDNumberTreeNode>(allChildren);
            temp.removeIf(child -> excludesOrg.contains(child.getId()));
            allChildren = temp;
        }
        return ExtConvertServiceHelper.getAllOrgNums((List<IDNumberTreeNode>)allChildren, targetCurrency, effectiveOrg.keySet());
    }

    private static Map<String, String> getAllOrgNums(List<IDNumberTreeNode> allLeafChildren, String targetCurrency, Set<String> effectiveOrg) {
        HashMap<String, String> orgCurrencyMap = new HashMap<String, String>(16);
        for (IDNumberTreeNode idNumberTreeNode : allLeafChildren) {
            String number = idNumberTreeNode.getNumber();
            if (!effectiveOrg.contains(number) || Objects.equals(targetCurrency, idNumberTreeNode.getCurrency())) continue;
            orgCurrencyMap.put(number, idNumberTreeNode.getCurrency());
        }
        return orgCurrencyMap;
    }

    public static List<SimpleVo> getConvertExtModels(Long modelId, boolean isPartMerge) {
        String cacheKey = isPartMerge ? "partExtModels" : "notPartMergeExtModels";
        return (List)ThreadCache.get((Object)(PREFIX + modelId + cacheKey), () -> {
            QFilter qFilter = new QFilter("model", "=", (Object)modelId).and("enable", "=", (Object)Character.valueOf('1')).and("isconvert", "=", (Object)Character.valueOf('1')).and("extendsgroup.isparticipmerge", "=", (Object)isPartMerge).and("extendsgroup.grouptype", "!=", (Object)"3");
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"id,number,extendsgroup.number", (QFilter[])qFilter.toArray());
            return collection.stream().map(s -> SimpleVo.newOne(s.getString("number"), s.getLong("id"))).collect(Collectors.toList());
        });
    }

    public static List<SimpleVo> getConvertExtModels(Long modelId) {
        return (List)ThreadCache.get((Object)(PREFIX + modelId + "allCvtExtModels"), () -> {
            QFilter qFilter = new QFilter("model", "=", (Object)modelId).and("enable", "=", (Object)Character.valueOf('1')).and("isconvert", "=", (Object)Character.valueOf('1')).and("extendsgroup.grouptype", "!=", (Object)"3");
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"id,number,extendsgroup.number", (QFilter[])qFilter.toArray());
            return collection.stream().map(s -> SimpleVo.newOne(s.getString("number"), s.getLong("id"))).collect(Collectors.toList());
        });
    }

    private static ExtendDataModelInfo generateExtDataInfo(ExtendsModel extModel) {
        return (ExtendDataModelInfo)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)(PREFIX + extModel.getId() + "ExtendDataModelInfo"), () -> {
            ExtendDataModelInfo extendDataModelInfo = new ExtendDataModelInfo();
            String groupType = extModel.getExtendsGroupType();
            extendDataModelInfo.setGroupType(groupType);
            extendDataModelInfo.setGroupNumber(extModel.getExtendsGroupNumber());
            extendDataModelInfo.setDataTableEntity(ExtendDimGroupType.COMMON.getIndex().equals(groupType) ? "bcm_extenddata" : "bcm_extenddata_bus");
            Set<String> extFeilds = extModel.getExtFieldEntry().stream().map(s -> s.getExtField().getNumber()).collect(Collectors.toSet());
            Set<String> dimFeilds = extModel.getDimFieldEntry().stream().map(s -> s.getDimension().getNumber()).collect(Collectors.toSet());
            extendDataModelInfo.setExtendField(extFeilds);
            extendDataModelInfo.setOlapDimField(dimFeilds);
            ExtFieldMappedService mapService = new ExtFieldMappedService(extModel.getModelId(), extendDataModelInfo.getGroupNumber());
            extendDataModelInfo.setFieldMap(mapService.getColsFieldMapped(extendDataModelInfo.getExtendField().toArray(new String[0])));
            extendDataModelInfo.setFieldDimMap(mapService.getDimsFieldMapped(extendDataModelInfo.getOlapDimField().toArray(new String[0])));
            Map<String, String> cvtFieldToRateTypeMap = ExtDimensionHelper.getExtMemberForNumberType(extModel.getModelId(), extendDataModelInfo.getGroupNumber(), extendDataModelInfo.getExtendField());
            extendDataModelInfo.setCvtFieldToRateTypeMap(cvtFieldToRateTypeMap);
            return extendDataModelInfo;
        });
    }

    public static ResultBox convertExtModel(List<ExtConvertBaseUnit> extConvertBaseUnits) {
        ArrayList<Callable<ResultBox>> tasks = new ArrayList<Callable<ResultBox>>();
        ResultBox resultBox = ResultBox.of();
        ExtConvertUnitsUtil util = new ExtConvertUnitsUtil(extConvertBaseUnits);
        extConvertBaseUnits = util.getEffectiveExtConvertBaseUnit();
        for (ExtConvertBaseUnit unit : extConvertBaseUnits) {
            ModelRate modelRate = ExchangeQueryHelper.getModeRate(util.getBaseData());
            RateSchema rateSchema = modelRate.getRateSchema(unit.getOrg().id);
            RateModel rateModel = rateSchema.getRateModelBySrcTgt(unit.getOrginCurrency(), unit.getTargetCurrency());
            if (rateModel == RateModel.EMPTY_RATE_MODEL) {
                resultBox.addError(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7 %1$s \u5728\u539f\u5e01 %2$s -> \u76ee\u6807\u5e01 %3$s\u7684\u6c47\u7387\u4e0d\u5b58\u5728\uff0c\u4e0d\u6267\u884c\u6298\u7b97\uff0c\u8bf7\u67e5\u8be2\u201c\u6c47\u7387\u7ba1\u7406\u201d\u914d\u7f6e\u3002", (String)"ExtConvertServiceHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]), unit.getOrg().number, unit.getOrginCurrency(), unit.getTargetCurrency()));
                continue;
            }
            for (SimpleVo extModel : unit.getExtModels()) {
                ExtendsModel extendsModel = util.getExtModelById(extModel.id);
                tasks.add(() -> ExtConvertServiceHelper.executeConvertExtendModel(unit.getBaseData(), unit.getOrg(), unit.getProcess(), unit.getOrginCurrency(), unit.getTargetCurrency(), extendsModel));
            }
        }
        if (tasks.size() > 0) {
            List results = ThreadPoolService.runInConvertWaiting4Thread(tasks.toArray(new Callable[0]));
            DynamicObjectCollection convertedData = new DynamicObjectCollection();
            DynamicObjectCollection convertedBusData = new DynamicObjectCollection();
            results.stream().forEach(s -> {
                if (s.isError()) {
                    resultBox.addError(s.getMessageText());
                } else if (s.getData() != null && s.getData() instanceof Pair) {
                    Pair data = (Pair)s.getData();
                    if (data.p1 != null) {
                        convertedData.addAll((Collection)data.p1);
                    } else if (data.p2 != null) {
                        convertedBusData.addAll((Collection)data.p2);
                    }
                }
            });
            try (TXHandle tx = TX.requiresNew((String)"insertExtConvertDataBatch");){
                try {
                    ExtConvertServiceHelper.clearTargetData(util);
                    SaveServiceHelper.save((DynamicObject[])((DynamicObject[])convertedData.toArray((Object[])new DynamicObject[0])));
                    SaveServiceHelper.save((DynamicObject[])((DynamicObject[])convertedBusData.toArray((Object[])new DynamicObject[0])));
                }
                catch (Exception e) {
                    tx.markRollback();
                    log.error(String.format("%s ExtCvt error:", util.getBaseData()), (Throwable)e);
                    resultBox.addError(e.getMessage());
                }
            }
        }
        return resultBox;
    }

    public static void clearTargetData(ExtConvertUnitsUtil util) {
        BaseData baseData = util.getBaseData();
        Map<SimpleVo, Collection<SimpleVo>> collectionMap = util.groupByExtModelOrgs();
        String targetCurrency = util.getTargetCurrency();
        Long modelId = baseData.getModel().id;
        String modelShowNumber = MemberReader.findModelSNumberById((Object)modelId);
        collectionMap.forEach((k, v) -> {
            ExtendsModel extendsModel = util.getExtModelById(k.id);
            Set orgNums = v.stream().map(s -> s.number).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(orgNums)) {
                return;
            }
            String baseSql = "delete from t_bcm_extenddata where fmodelnumber = '" + modelShowNumber + "' and fextendsgroup = '" + extendsModel.getExtendsGroupNumber() + "' and fdatamodel = '" + k.number + "' and forg in  ( '" + Joiner.on((String)"','").join(orgNums) + "' ) and fscene = '" + baseData.getScene().number + "' and fyear = '" + baseData.getYear().number + "' and fperiod = '" + baseData.getPeriod().number + "' and fprocess = '" + "IRpt" + "' and fcurrency = '" + targetCurrency + "'";
            String baseBusSql = "delete from t_bcm_extenddata_bus where fmodelnumber = '" + modelShowNumber + "' and fextendsgroup = '" + extendsModel.getExtendsGroupNumber() + "' and fdatamodel = '" + k.number + "' and forg in  ( '" + Joiner.on((String)"','").join(orgNums) + "' ) and fscene = '" + baseData.getScene().number + "' and fyear = '" + baseData.getYear().number + "' and fperiod = '" + baseData.getPeriod().number + "' and fprocess = '" + "IRpt" + "' and fcurrency = '" + targetCurrency + "'";
            if (ExtendDimGroupType.COMMON.getIndex().equals(extendsModel.getExtendsGroupType())) {
                DB.execute((DBRoute)DBRoute.of((String)"bcm"), (String)baseSql);
            } else {
                DB.execute((DBRoute)DBRoute.of((String)"bcm"), (String)baseBusSql);
            }
        });
    }

    public static ResultBox executeConvertExtendModel(BaseData baseData, SimpleVo org, String process, String orginCurrency, String targetCurrency, ExtendsModel extendsModel) {
        EDRow[] rows;
        Long modelId = baseData.getModel().id;
        Long sceneId = baseData.getScene().id;
        Long fyId = baseData.getYear().id;
        Long periodId = baseData.getPeriod().id;
        Long extModelId = extendsModel.getId();
        String extModelNum = extendsModel.getNumber();
        ResultBox resultBox = ResultBox.of();
        IDNumberTreeNode targetCurrencyNode = MemberReader.findCurrencyMemberByNum((String)baseData.getModel().number, (String)targetCurrency);
        boolean locked = ExtDataLockServiceHelper.isLocked((long)modelId, (long)extModelId, org.id, sceneId, fyId, periodId, targetCurrencyNode.getId());
        if (locked) {
            return resultBox;
        }
        ModelRate modelRate = ExchangeQueryHelper.getModeRate(baseData);
        RateSchema rateSchema = modelRate.getRateSchema(org.id);
        RateModel rateModel = rateSchema.getRateModelBySrcTgt(orginCurrency, targetCurrency);
        ExtendDataModelInfo extendDataModelInfo = ExtConvertServiceHelper.generateExtDataInfo(extendsModel);
        String modelShowNumber = MemberReader.findModelSNumberById((Object)modelId);
        String extendGroupNumber = extendDataModelInfo.getGroupNumber();
        String targetAuditTrail = ExtConvertServiceHelper.findStandardCvtPlanAuditTrail(modelId);
        boolean isFlatTurn = StringUtil.isEmptyString((String)targetAuditTrail);
        EdQueryComInfo edQueryComInfo = new EdQueryComInfo(modelShowNumber, extendGroupNumber, extModelNum);
        edQueryComInfo.addDimFilter("Entity", org.number);
        edQueryComInfo.addDimFilter("Scenario", baseData.getScene().number);
        edQueryComInfo.addDimFilter("Year", baseData.getYear().number);
        edQueryComInfo.addDimFilter("Period", baseData.getPeriod().number);
        if ("ERpt".equals(process) && isFlatTurn) {
            edQueryComInfo.addDimFilter("Process", "IRpt", "RAdj");
        } else {
            edQueryComInfo.addDimFilter("Process", process);
        }
        if (!isFlatTurn) {
            edQueryComInfo.addDimFilter("AuditTrail", "ATTotal");
        }
        edQueryComInfo.addDimFilter("Currency", orginCurrency);
        HashSet<String> olapDimField = new HashSet<String>(extendDataModelInfo.getOlapDimField());
        if (isFlatTurn) {
            if (!extendDataModelInfo.getOlapDimField().contains(DimTypesEnum.AUDITTRIAL.getNumber())) {
                olapDimField.add(DimTypesEnum.AUDITTRIAL.getNumber());
            }
            edQueryComInfo.setQueryOriData(true);
        }
        edQueryComInfo.setDimselects(olapDimField.toArray(new String[0]));
        edQueryComInfo.setExtselects(extendDataModelInfo.getExtendField().toArray(new String[0]));
        edQueryComInfo.setNeedSum(true);
        try (EDResultSet sourceEDSet = ExtDataServiceHelper.queryData(edQueryComInfo);){
            rows = sourceEDSet.getRows();
        }
        if (rows.length > 0) {
            DynamicObjectCollection cvtDataResult = new DynamicObjectCollection();
            Map<String, String> cvtFieldToRateTypeMap = extendDataModelInfo.getCvtFieldToRateTypeMap();
            Map<String, Pair<Boolean, BigDecimal>> cvtExtFieldRateMap = ExtConvertServiceHelper.getCvtExtFieldRateMapPair(extModelId, cvtFieldToRateTypeMap, rateModel);
            Set<String> cvtFieldSet = cvtFieldToRateTypeMap.keySet();
            long[] idArray = GlobalIdUtil.genGlobalLongIds((int)rows.length);
            for (int i = 0; i < rows.length; ++i) {
                DynamicObject cvtData = BusinessDataServiceHelper.newDynamicObject((String)extendDataModelInfo.getDataTableEntity());
                EDRow row = rows[i];
                cvtData.set("modelnumber", (Object)modelShowNumber);
                cvtData.set("datamodel", (Object)extModelNum);
                cvtData.set("extendsgroup", (Object)extendGroupNumber);
                cvtData.set("id", (Object)idArray[i]);
                cvtData.set("sid", (Object)("TRA_" + idArray[i]));
                cvtData.set("org", (Object)org.number);
                cvtData.set("entity", (Object)org.number);
                cvtData.set("scenario", (Object)baseData.getScene().number);
                cvtData.set("year", (Object)baseData.getYear().number);
                cvtData.set("period", (Object)baseData.getPeriod().number);
                cvtData.set("process", (Object)"IRpt");
                cvtData.set("auditTrail", (Object)(isFlatTurn ? row.getString("AuditTrail") : targetAuditTrail));
                cvtData.set("currency", (Object)targetCurrency);
                Map<String, String> fieldMappedForCols = extendDataModelInfo.getFieldMap();
                fieldMappedForCols.forEach((key, value) -> ExtConvertServiceHelper.dealConvertData(baseData.getCube(), baseData.getScene().number, targetCurrency, key, value, cvtFieldSet, cvtExtFieldRateMap, row.getOriginalValue((String)key), row.getString(DimTypesEnum.ACCOUNT.getNumber()), cvtData));
                Map<String, String> fieldMapForDims = extendDataModelInfo.getFieldDimMap();
                fieldMapForDims.forEach((key, value) -> cvtData.set(value, row.getOriginalValue((String)key)));
                cvtDataResult.add((Object)cvtData);
            }
            if (cvtDataResult.size() > 0) {
                if (extendDataModelInfo.getDataTableEntity().equals("bcm_extenddata")) {
                    resultBox.setData((Object)new Pair((Object)cvtDataResult, null));
                } else {
                    resultBox.setData((Object)new Pair(null, (Object)cvtDataResult));
                }
            }
        }
        return resultBox;
    }

    private static Map<String, Pair<Boolean, BigDecimal>> getCvtExtFieldRateMapPair(long extModelId, Map<String, String> cvtFieldToRateTypeMap, RateModel rateModel) {
        return (Map)ThreadCache.get((Object)("ExtFieldToRateMapPair" + extModelId + rateModel.getTag()), () -> {
            HashMap<String, Pair> fieldToRateMap = new HashMap<String, Pair>(cvtFieldToRateTypeMap.size());
            for (Map.Entry entry : cvtFieldToRateTypeMap.entrySet()) {
                BigDecimal rate;
                String field = (String)entry.getKey();
                String rateType = (String)entry.getValue();
                ExchangeEnum realExchange = ExchangeEnum.getExchangeEnumByIndex((String)rateType);
                if (realExchange == null || (rate = ConvertUtil.getRate(rateModel, realExchange)) == null || rate.compareTo(BigDecimal.ZERO) == 0) continue;
                fieldToRateMap.put(field, Pair.onePair((Object)rateModel.isMultiply(), (Object)rate));
            }
            return fieldToRateMap;
        });
    }

    public static void convertIntrMergeData(Pair<Long, String> srcCurrency, Pair<Long, String> targetCurrency, IntrMergeParam param) {
        BaseData baseData = new BaseData((Long)param.getModel().p1, param.getScenario(), param.getYear(), param.getPeriod());
        RateModel rateModel = ExchangeQueryHelper.getRateData(baseData, SimpleVo.newOne((String)param.getEntity().p2, (Long)param.getEntity().p1), (String)srcCurrency.p2, (String)targetCurrency.p2);
        if (rateModel == null || RateModel.EMPTY_RATE_MODEL == rateModel) {
            log.error(String.format("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6c47\u7387\uff0c\u8bf7\u67e5\u8be2\u201c\u6c47\u7387\u7ba1\u7406\u201d\u914d\u7f6e\uff0c\u4f53\u7cfb\uff1a%s\uff0c\u60c5\u666f\uff1a%s\uff0c\u7ec4\u7ec7\u7f16\u7801\uff1a%s\uff0c\u8d22\u5e74\uff1a%s\uff0c\u671f\u95f4\uff1a%s\uff0c\u539f\u5e01\uff1a%s\uff0c\u76ee\u6807\u5e01\uff1a%s", param.getModel().p2, param.getScenario().p2, param.getEntity().p2, param.getYear().p2, param.getPeriod().p2, srcCurrency.p2, targetCurrency.p2));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6c47\u7387\uff0c\u8bf7\u67e5\u8be2\u201c\u6c47\u7387\u7ba1\u7406\u201d\u914d\u7f6e\uff0c\u7ec4\u7ec7\u7f16\u7801\uff1a%1$s\uff0c\u8d22\u5e74\uff1a%2$s\uff0c\u671f\u95f4\uff1a%3$s\uff0c\u539f\u5e01\uff1a%4$s\uff0c\u76ee\u6807\u5e01\uff1a%5$s\u3002", (String)"ExtConvertServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), param.getEntity().p2, param.getYear().p2, param.getPeriod().p2, srcCurrency.p2, targetCurrency.p2));
        }
        DynamicObject templateInfo = IntrTemplateHelper.getTemplateInfo((Long)param.getModel().p1, param.getTemplateId());
        String mergeExtNum = templateInfo.getString("mergenode.number");
        long mergeExtModelId = templateInfo.getLong("mergenode.id");
        DynamicObjectCollection srcDyns = QueryIntrDataHelper.queryMergeData((String)param.getModel().p2, mergeExtNum, (String)param.getEntity().p2, (String)param.getScenario().p2, (String)param.getYear().p2, (String)param.getPeriod().p2, (String)srcCurrency.p2);
        if (srcDyns == null || srcDyns.size() == 0) {
            return;
        }
        Set fields = EntityMetadataCache.getDataEntityType((String)"bcm_extenddata_bus").getAllFields().keySet();
        ExtendsModel extendsModel = new ExtendsModel(mergeExtModelId);
        ExtendDataModelInfo extendDataModelInfo = ExtConvertServiceHelper.generateExtDataInfo(extendsModel);
        Map<String, String> cvtFieldToRateTypeMap = extendDataModelInfo.getCvtFieldToRateTypeMap();
        Map<String, Pair<Boolean, BigDecimal>> cvtExtFieldRateMap = ExtConvertServiceHelper.getCvtExtFieldRateMapPair(mergeExtModelId, cvtFieldToRateTypeMap, rateModel);
        Map<String, String> mappedNumMap = cvtFieldToRateTypeMap.keySet().stream().collect(Collectors.toMap(k -> extendDataModelInfo.getFieldMap().get(k), v -> v, (e1, e2) -> e1));
        Set<String> cvtFieldSet = cvtFieldToRateTypeMap.keySet();
        ArrayList<DynamicObject> targetDyns = new ArrayList<DynamicObject>(srcDyns.size());
        for (DynamicObject srcDyn : srcDyns) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_extenddata_bus");
            for (String field : fields) {
                ExtConvertServiceHelper.dealConvertData(param.getModelNumber(), (String)param.getScenario().p2, (String)targetCurrency.p2, mappedNumMap.get(field), field, cvtFieldSet, cvtExtFieldRateMap, srcDyn.get(field), srcDyn.getString(DimTypesEnum.ACCOUNT.getNumber().toLowerCase(Locale.ENGLISH)), obj);
                obj.set(DimTypesEnum.CURRENCY.getNumber().toLowerCase(Locale.ENGLISH), targetCurrency.p2);
            }
            targetDyns.add(obj);
        }
        try (TXHandle tx = TX.required();){
            try {
                IntrReportHelper.deleteExtData((String)param.getModel().p2, (String)param.getEntity().p2, (String)param.getScenario().p2, (String)param.getYear().p2, (String)param.getPeriod().p2, (String)targetCurrency.p2, mergeExtNum);
                SaveServiceHelper.save((DynamicObject[])targetDyns.toArray(new DynamicObject[0]));
            }
            catch (Throwable t) {
                tx.markRollback();
                log.error("--\u5185\u90e8\u4ea4\u6613\u5408\u5e76\u8282\u70b9\u6298\u7b97\u51fa\u73b0\u95ee\u9898--:\n" + ThrowableHelper.toString((Throwable)t));
                throw new KDBizException(t, new ErrorCode("", ThrowableHelper.toString((Throwable)t)), new Object[0]);
            }
        }
    }

    private static void dealConvertData(String cubeNumber, String sceneNumber, String targetCurrency, String fieldNum, String fieldMapping, Set<String> cvtFieldSet, Map<String, Pair<Boolean, BigDecimal>> cvtExtFieldRateMap, Object orginVal, String account, DynamicObject cvtData) {
        if (cvtFieldSet.contains(fieldNum)) {
            Pair<Boolean, BigDecimal> ratePair = cvtExtFieldRateMap.get(fieldNum);
            if (ratePair == null) {
                return;
            }
            BigDecimal data = TypeConversionUtils.objToBigDecimal(orginVal);
            if (Objects.nonNull(data) && BigDecimal.ZERO.compareTo(data) != 0 && BigDecimal.ZERO.compareTo((BigDecimal)ratePair.p2) != 0) {
                Integer scale = ConvertUtil.getCurrencyScale(cubeNumber, sceneNumber, targetCurrency, account);
                BigDecimal realvalue = (Boolean)ratePair.p1 != false ? data.multiply((BigDecimal)ratePair.p2) : data.divide((BigDecimal)ratePair.p2, 15, RoundingMode.HALF_UP);
                cvtData.set(fieldMapping, (Object)CurrencyScaleHandler.handleByScaleEnum(realvalue, scale));
            }
        } else {
            cvtData.set(fieldMapping, orginVal);
        }
    }

    public static void clearExtGroupCache(Long modelId, Long groupId) {
        QFBuilder qfBuilder = new QFBuilder("extendsgroup.id", "=", (Object)groupId);
        qfBuilder.add(new QFilter("isconvert", "=", (Object)Character.valueOf('1')));
        qfBuilder.add(new QFilter("enable", "=", (Object)Character.valueOf('1')));
        qfBuilder.add(new QFilter("extendsgroup.grouptype", "!=", (Object)"3"));
        DynamicObjectCollection extmodels = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"id", (QFilter[])qfBuilder.toArray());
        extmodels.forEach(s -> {
            Long extModelId = s.getLong("id");
            ExtConvertServiceHelper.clearExtModelCache(extModelId);
        });
    }

    public static void clearExtModelCache(Long extModelId) {
        CacheGenFactory.getCommonCache().invalidateStartsWithKey(PREFIX + extModelId + "ExtendDataModelInfo");
    }

    private static BizRuleExecuteService getBizRuleExecuteService(SimpleItem model, SimpleItem org, SimpleItem year, SimpleItem period, SimpleItem scene) {
        ExecuteContext exeCtx = new ExecuteContext(model, org, year, period, scene, false);
        return new BizRuleExecuteService(exeCtx);
    }

    private static boolean checkIsExistExtDimension(Long modelId) {
        return (Boolean)ThreadCache.get((Object)("checkIsExistExtDimension" + modelId), () -> {
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            return QueryServiceHelper.exists((String)"bcm_dimension_ext", (QFilter[])qFilter.toArray());
        });
    }
}

