/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.adjust.formula.AdjustFormulaParseHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkFormulaServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.model.FormulaEnum;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaParseHelper;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.serviceHelper.ExpressionServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.CvtFactorEnum;
import kd.fi.bcm.common.enums.CvtFactorEnum4Edit;
import kd.fi.bcm.common.enums.invest.HolderTypeEnum;
import kd.fi.bcm.common.enums.invest.InvFetchType;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.spread.formula.EncoderService;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.formula.expr.StringExpr;
import org.apache.commons.lang.RandomStringUtils;

public class FormulaServiceHelper {
    private static final String FORMULA = "formula";
    private static final String EXCHANGE = "exchange";
    private static final String PRE_EXCHANGE = "preexchange";
    private static final String EXCHANGE_INFO = "exchangeInfo";
    private static final String CVT_FACTOR = "cvtfactor";
    private static final HashSet<String> TRANS_FORMULA = Sets.newHashSet((Object[])new String[]{"Inv", "Esp", "Gev", "Lyv", "Dvb", "Pn", "Mf", "Bn", "V", "CVT"});

    public static String transFormula(String formula, IPageCache pageCache) {
        String[] leftStrs;
        ArrayList strLs = Lists.newArrayList();
        for (String leftStr : leftStrs = formula.split("\\{")) {
            String[] rightStrs = leftStr.split("\\}");
            strLs.addAll(Arrays.asList(rightStrs));
        }
        HashSet<String> formulaSet = new HashSet<String>();
        formulaSet.add("formula_fx_");
        formulaSet.add("invformulacb");
        formulaSet.add("gevformulacb");
        formulaSet.add("espformulacb");
        formulaSet.add("bn");
        formulaSet.add("lyvformulacb");
        formulaSet.add("dvbformulacb");
        formulaSet.add("mfformulacb");
        formulaSet.add("pnformulacb");
        formulaSet.add("getinvperformulacb");
        formulaSet.add("getinvactformulacb");
        formulaSet.add("despformulacb");
        formulaSet.add("getjlentryformulacb");
        formulaSet.add("excrateacbformulacb");
        StringBuilder text = new StringBuilder();
        StringBuilder name = new StringBuilder();
        for (String str : strLs) {
            boolean flag = formulaSet.stream().anyMatch(str::contains);
            if (flag) {
                String s = str.subSequence(1, str.length() - 1).toString();
                text.append(pageCache.get(s));
                name.append(pageCache.get(s + "name"));
                continue;
            }
            text.append(str);
            name.append(str);
        }
        return text.append("@@@").append((CharSequence)name).toString();
    }

    public static String rebuildFormula(String formula, IPageCache pageCache) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < formula.length(); ++i) {
            char c = formula.charAt(i);
            if (c == '{') {
                str.append(c);
                str.append(formula.charAt(++i));
                ++i;
                StringBuilder keystr = new StringBuilder();
                while (i < formula.length()) {
                    c = formula.charAt(i);
                    str.append(c);
                    if (c == '\"') break;
                    keystr.append(c);
                    ++i;
                }
                String key = keystr.toString();
                String text = "";
                if (pageCache.get(key) != null) {
                    text = pageCache.get(key + "name");
                }
                str.append(",\"");
                str.append(text);
                str.append('\"');
                str.append(formula.charAt(++i));
                continue;
            }
            str.append(c);
        }
        return str.toString();
    }

    public static String analyFullFormula(String formulaExpress, IPageCache pageCache, long modelId) {
        return FormulaServiceHelper.analyFullFormula(formulaExpress, pageCache, modelId, null);
    }

    public static String analyFullFormulaNew(String formulaExpress, IPageCache pageCache, long modelId) {
        Set formulaNames = Arrays.stream(FormulaEnum.values()).map(p -> p.getCode().toUpperCase(Locale.ROOT)).collect(Collectors.toSet());
        return InvestFormulaParseHelper.handelParam(AdjustFormulaParseHelper.walkDeepExpress(InvestFormulaParseHelper.parseFormula(formulaExpress), expr -> {
            if (expr instanceof FunctionExpr && formulaNames.contains(((FunctionExpr)expr).getFuncionName().toUpperCase(Locale.ROOT))) {
                expr = new StringExpr(FormulaServiceHelper.analyFullFormula(expr.toString(), pageCache, modelId, null));
            }
            return expr;
        }));
    }

    public static String getEnglishName(String formulaExpress) {
        ExpressParser parser = new ExpressParser();
        EncoderService encoder = new EncoderService();
        StringBuilder str = new StringBuilder();
        String result = "";
        try {
            Pair<String, List<IFormula>> pair = parser.parse(formulaExpress, encoder);
            int size = ((List)pair.p2).size();
            HashMap<String, String> uuid2en = new HashMap<String, String>(size);
            HashMap<String, String> uuid2origin = new HashMap<String, String>(size);
            for (int flag = 0; flag < size; ++flag) {
                IFormula formula = (IFormula)((List)pair.p2).get(flag);
                String englishName = formula.toString();
                if ("CVT".equals(formula.getName())) {
                    String[] number = ((ParamItem)formula.getParamList().get(0)).toString().split("@");
                    englishName = number[1];
                }
                uuid2origin.put(formula.getUUID(), formula.toString());
                uuid2en.put(formula.getUUID(), englishName);
            }
            for (int i = 0; i < ((String)pair.p1).length(); ++i) {
                if (((String)pair.p1).charAt(i) >= 'A' && ((String)pair.p1).charAt(i) <= 'Z') {
                    if (!ExpressionServiceHelper.checkFactorComplete(i, (String)pair.p1)) continue;
                    String key = String.valueOf(((String)pair.p1).charAt(i));
                    str.append((String)uuid2en.get(key));
                    uuid2en.remove(key);
                    continue;
                }
                String oper = String.valueOf(((String)pair.p1).charAt(i));
                str.append(oper);
            }
            result = str.toString();
            for (Map.Entry data : uuid2en.entrySet()) {
                result = result.replace((CharSequence)uuid2origin.get(data.getKey()), (CharSequence)data.getValue());
            }
        }
        catch (Exception e1) {
            throw new KDBizException(ThrowableHelper.toString((Exception)e1));
        }
        return result;
    }

    public static String analyCvtFullFormula(String formulaExpress, IPageCache pageCache, long modelId) {
        for (Map.Entry<String, List<IFormula>> data : ChkCheckServiceHelper.getPoolMng(formulaExpress)) {
            if (!TRANS_FORMULA.contains(data.getKey())) continue;
            for (IFormula s : data.getValue()) {
                formulaExpress = Pattern.compile(s.toString(), 16).matcher(formulaExpress).replaceFirst(FormulaServiceHelper.analyFullFormula(s.toString(), pageCache, modelId, null));
            }
        }
        return formulaExpress;
    }

    public static String analyFullFormula(String formulaExpress, IPageCache pageCache, long modelId, Function custom) {
        return FormulaServiceHelper.analyFullFormula(formulaExpress, pageCache, modelId, custom, true);
    }

    public static String analyFullFormula(String formulaExpress, IPageCache pageCache, long modelId, Function custom, boolean isPutCache) {
        ExpressParser parser = new ExpressParser();
        EncoderService encoder = new EncoderService();
        StringBuilder str = new StringBuilder();
        HashMap cache = Maps.newHashMap();
        try {
            Pair<String, List<IFormula>> pair = parser.parse(formulaExpress, encoder);
            int flag = 0;
            for (int i = 0; i < ((String)pair.p1).length(); ++i) {
                if (((String)pair.p1).charAt(i) >= 'A' && ((String)pair.p1).charAt(i) <= 'Z') {
                    DynamicObject a;
                    if (!ExpressionServiceHelper.checkFactorComplete(i, (String)pair.p1)) continue;
                    IFormula formula = (IFormula)((List)pair.p2).get(flag);
                    str.append("{\"");
                    StringBuilder chinaName = new StringBuilder();
                    String sign = "";
                    if (FormulaEnum.Inv.name().equalsIgnoreCase(formula.getName())) {
                        sign = FormulaServiceHelper.getComboSign("invformulacb");
                        str.append(sign);
                        String aNumber = ((ParamItem)formula.getParamList().get(1)).toString();
                        String ctNumber = ((ParamItem)formula.getParamList().get(2)).toString();
                        DynamicObject a2 = DimensionServiceHelper.queryMemberNameByNumber("bcm_accountmembertree", modelId, aNumber);
                        DynamicObject ct = DimensionServiceHelper.queryMemberNameByNumber("bcm_changetypemembertree", modelId, ctNumber);
                        chinaName.append(a2 == null ? "" : a2.getString("name"));
                        chinaName.append('|').append(ct == null ? "" : ct.getString("name"));
                    } else if (FormulaEnum.Esp.name().equalsIgnoreCase(formula.getName())) {
                        sign = FormulaServiceHelper.getComboSign("espformulacb");
                        str.append(sign);
                        String invType = ((ParamItem)formula.getParamList().get(0)).toString();
                        String numberType = ((ParamItem)formula.getParamList().get(1)).toString();
                        String name = HolderTypeEnum.getNameByNumber((String)numberType);
                        if ("4".equals(invType) || "5".equals(invType)) {
                            name = HolderTypeEnum.UniteScale.getName();
                        }
                        chinaName.append(name);
                    } else if (FormulaEnum.Gev.name().equalsIgnoreCase(formula.getName())) {
                        sign = FormulaServiceHelper.getComboSign("gevformulacb");
                        str.append(sign);
                        chinaName.append(FormulaEnum.Gev.getText());
                        chinaName.append("(");
                        chinaName.append((Object)(Objects.isNull(custom) ? ((ParamItem)formula.getParamList().get(0)).toString() : custom.apply(((ParamItem)formula.getParamList().get(0)).toString())));
                        chinaName.append(")");
                    } else if (FormulaEnum.Lyv.name().equalsIgnoreCase(formula.getName())) {
                        sign = FormulaServiceHelper.getComboSign("lyvformulacb");
                        str.append(sign);
                        chinaName.append(FormulaEnum.Lyv.getText());
                        chinaName.append("(");
                        chinaName.append((Object)(Objects.isNull(custom) ? ((ParamItem)formula.getParamList().get(0)).toString() : custom.apply(((ParamItem)formula.getParamList().get(0)).toString())));
                        chinaName.append(")");
                    } else if (FormulaEnum.Dvb.name().equalsIgnoreCase(formula.getName())) {
                        sign = FormulaServiceHelper.getComboSign("dvbformulacb");
                        str.append(sign);
                        chinaName.append(FormulaEnum.Dvb.getText());
                        chinaName.append("(");
                        chinaName.append((Object)(Objects.isNull(custom) ? ((ParamItem)formula.getParamList().get(0)).toString() : custom.apply(((ParamItem)formula.getParamList().get(0)).toString())));
                        if (formula.getParamList().size() >= 2) {
                            chinaName.append(",");
                            chinaName.append((Object)(Objects.isNull(custom) ? ((ParamItem)formula.getParamList().get(1)).toString() : custom.apply(((ParamItem)formula.getParamList().get(1)).toString())));
                        }
                        chinaName.append(")");
                    } else if (FormulaEnum.Pn.name().equalsIgnoreCase(formula.getName())) {
                        sign = FormulaServiceHelper.getComboSign("pnformulacb");
                        str.append(sign);
                        chinaName.append(FormulaEnum.Pn.getText());
                        chinaName.append("(");
                        chinaName.append((Object)(Objects.isNull(custom) ? ((ParamItem)formula.getParamList().get(0)).toString() : custom.apply(((ParamItem)formula.getParamList().get(0)).toString())));
                        chinaName.append(",");
                        chinaName.append((Object)(Objects.isNull(custom) ? ((ParamItem)formula.getParamList().get(1)).toString() : custom.apply(((ParamItem)formula.getParamList().get(1)).toString())));
                        chinaName.append("\u2014");
                        chinaName.append((Object)(Objects.isNull(custom) ? ((ParamItem)formula.getParamList().get(2)).toString() : custom.apply(((ParamItem)formula.getParamList().get(2)).toString())));
                        chinaName.append(",");
                        chinaName.append((Object)(Objects.isNull(custom) ? ((ParamItem)formula.getParamList().get(3)).toString() : custom.apply(((ParamItem)formula.getParamList().get(3)).toString())));
                        chinaName.append(")");
                    } else if (FormulaEnum.Mf.name().equalsIgnoreCase(formula.getName())) {
                        sign = FormulaServiceHelper.getComboSign("mfformulacb");
                        str.append(sign);
                        chinaName.append(FormulaEnum.Mf.getText());
                        chinaName.append("(");
                        chinaName.append(((ParamItem)formula.getParamList().get(0)).toString());
                        chinaName.append(")");
                    } else if (FormulaEnum.Bn.name().equalsIgnoreCase(formula.getName())) {
                        sign = "bn";
                        str.append(sign);
                        chinaName.append(FormulaEnum.Bn.getText());
                    } else if (FormulaEnum.Getinvper.name().equalsIgnoreCase(formula.getName())) {
                        sign = FormulaServiceHelper.getComboSign("getinvperformulacb");
                        str.append(sign);
                        chinaName.append(FormulaEnum.Getinvper.getText());
                    } else if (FormulaEnum.Getinvact.name().equalsIgnoreCase(formula.getName())) {
                        sign = FormulaServiceHelper.getComboSign("getinvactformulacb");
                        str.append(sign);
                        chinaName.append(FormulaEnum.Getinvact.getText());
                    } else if (FormulaEnum.ExcRate.name().equalsIgnoreCase(formula.getName())) {
                        sign = FormulaServiceHelper.getComboSign("excrateacbformulacb");
                        str.append(sign);
                        chinaName.append(FormulaEnum.ExcRate.getText());
                    } else if (FormulaEnum.Desp.name().equalsIgnoreCase(formula.getName())) {
                        sign = FormulaServiceHelper.getComboSign("despformulacb");
                        str.append(sign);
                        String numberType = ((ParamItem)formula.getParamList().get(1)).toString();
                        chinaName.append(InvFetchType.getDescByName((String)numberType));
                    } else if ("V".equalsIgnoreCase(formula.getName())) {
                        sign = FormulaServiceHelper.getComboSign("formula_fx_");
                        str.append(sign);
                        for (ParamItem paramItem : formula.getParamList()) {
                            String s = paramItem.toString();
                            if (s.startsWith("A.")) {
                                String aNumber = s.substring(2);
                                a = DimensionServiceHelper.queryMemberNameByNumber("bcm_accountmembertree", modelId, aNumber);
                                chinaName.append(a == null ? "" : a.getString("name"));
                                continue;
                            }
                            if (!s.startsWith("CT.")) continue;
                            String ctNumber = s.substring(3);
                            DynamicObject ct = DimensionServiceHelper.queryMemberNameByNumber("bcm_changetypemembertree", modelId, ctNumber);
                            chinaName.append('|').append(ct == null ? "" : ct.getString("name"));
                        }
                    } else if ("CVT".equals(formula.getName())) {
                        sign = FormulaServiceHelper.getComboSign("cvtformulacb");
                        str.append(sign);
                        String[] number = ((ParamItem)formula.getParamList().get(0)).toString().split("@");
                        switch (number[0]) {
                            case "cvtfactor": {
                                chinaName.append(CvtFactorEnum4Edit.getCvtFactorEnum4EditByNumber((String)number[1]).getName());
                                break;
                            }
                            case "exchange": {
                                if ("CurYearAvgRate".equals(number[1])) {
                                    chinaName.append(CvtFactorEnum.CurYearAvgRate.getName());
                                    break;
                                }
                            }
                            case "preexchange": {
                                String exchangeNum = number[1].replaceFirst("pre", "");
                                a = DimensionServiceHelper.queryMemberNameByNumber("bcm_accountmembertree", modelId, exchangeNum);
                                chinaName.append(number[1].startsWith("pre") ? ResManager.loadKDString((String)"\u4e0a\u671f%s", (String)"FormulaServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[]{a.getString("name")}) : a.getString("name"));
                                break;
                            }
                            case "rights": {
                                chinaName.append(ResManager.loadKDString((String)"\u7b49\u6548\u6301\u80a1\u6bd4\u4f8b", (String)"FormulaServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]));
                            }
                        }
                    } else if ("GetjlEntry".equalsIgnoreCase(formula.getName())) {
                        sign = FormulaServiceHelper.getComboSign("getjlentryformulacb");
                        str.append(sign);
                        chinaName.append(ResManager.loadKDString((String)"\u5206\u5f55\u6570", (String)"FormulaServiceHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]));
                    }
                    cache.put(sign, formula.toString());
                    cache.put(sign + "name", chinaName.toString());
                    str.append("\",\"");
                    str.append((CharSequence)chinaName);
                    str.append("\"}");
                    if (pageCache == null) {
                        str = chinaName;
                    }
                    ++flag;
                    continue;
                }
                String oper = String.valueOf(((String)pair.p1).charAt(i));
                str.append(oper);
            }
            if (pageCache != null && !cache.isEmpty() && isPutCache) {
                pageCache.put((Map)cache);
                FormulaServiceHelper.cacheFormula(cache);
            }
        }
        catch (Exception e1) {
            throw new KDBizException(ThrowableHelper.toString((Exception)e1));
        }
        return str.toString();
    }

    public static void cacheFormula(Map<String, String> dataCache) {
        LinkedHashMap cache = (LinkedHashMap)AppCacheServiceHelper.get("invchangeformulacache");
        if (cache != null) {
            cache.putAll(dataCache);
            AppCacheServiceHelper.put("invchangeformulacache", cache, 1800);
        } else {
            AppCacheServiceHelper.put("invchangeformulacache", dataCache, 1800);
        }
    }

    public static Object packGetText() {
        JSONObject data = new JSONObject();
        data.put("operate", (Object)"getText");
        data.put("data", (Object)TimeServiceHelper.getTimeStamp());
        return data;
    }

    public static Object packAddText(String key, String text) {
        StringBuilder data = new StringBuilder();
        data.append("{\"");
        data.append(key);
        data.append("\",\"");
        data.append(text);
        data.append("\"}");
        JSONObject obj = new JSONObject();
        obj.put("operate", (Object)"addText");
        obj.put("data", (Object)data.toString());
        obj.put("time", (Object)TimeServiceHelper.now());
        return obj;
    }

    public static Object packUpdateText(String text) {
        JSONObject data = new JSONObject();
        data.put("operate", (Object)"updateText");
        data.put("data", (Object)text);
        data.put("time", (Object)TimeServiceHelper.now());
        return data;
    }

    public static Object packUpdateTextWithHide(String text, String functions) {
        Object data = FormulaServiceHelper.packUpdateText(text);
        FormulaServiceHelper.packUpdateTextWithHide((JSONObject)data, functions);
        return data;
    }

    public static Object packUpdateTextWithHide(JSONObject data, String functions) {
        if (!data.containsKey((Object)"operate")) {
            data.put("operate", (Object)"init");
        }
        data.put("ishide", (Object)functions);
        return data;
    }

    public static Object packUpdateText(String key, String text) {
        StringBuilder data = new StringBuilder();
        data.append("{\"");
        data.append(key);
        data.append("\",\"");
        data.append(text);
        data.append("\"}");
        JSONObject obj = new JSONObject();
        obj.put("operate", (Object)"updateText");
        obj.put("data", (Object)data.toString());
        obj.put("time", (Object)TimeServiceHelper.now());
        return obj;
    }

    public static String getComboSign(String type) {
        return type + RandomStringUtils.randomAlphanumeric((int)5).toLowerCase(Locale.ENGLISH);
    }

    public static Pair<String, String> transFormula(Long modelId, String formula, Map<String, String> exchangeInfo) {
        ExpressParser parser = new ExpressParser();
        EncoderService coder = new EncoderService();
        StringBuilder chinese = new StringBuilder();
        try {
            Pair<String, List<IFormula>> pair = parser.parse(formula, coder);
            int flag = 0;
            for (int i = 0; i < ((String)pair.p1).length(); ++i) {
                if (((String)pair.p1).charAt(i) >= 'A' && ((String)pair.p1).charAt(i) <= 'Z') {
                    if (!ExpressionServiceHelper.checkFactorComplete(i, (String)pair.p1)) continue;
                    chinese.append(FormulaServiceHelper.transToChinese(modelId, (IFormula)((List)pair.p2).get(flag), exchangeInfo));
                    ++flag;
                    continue;
                }
                chinese.append(((String)pair.p1).charAt(i));
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6298\u7b97\u516c\u5f0f\u3002", (String)"CvtFormulaEditPlugin_5", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return Pair.onePair((Object)formula, (Object)chinese.toString());
    }

    public static String transToChinese(Long modelId, IFormula f, Map<String, String> exchangeInfo) {
        StringBuilder chinaName = new StringBuilder();
        if (f.getName().equals("CVT")) {
            String[] number = ((ParamItem)f.getParamList().get(0)).toString().split("@");
            if (number[0].equals(CVT_FACTOR)) {
                chinaName.append(CvtFactorEnum4Edit.getCvtFactorEnum4EditByNumber((String)number[1]).getName());
            } else if (number[0].equals(EXCHANGE) || number[0].equals(PRE_EXCHANGE)) {
                chinaName.append(number[1].startsWith("pre") ? String.format(ResManager.loadKDString((String)"\u4e0a\u671f%s", (String)"CvtFormulaEditPlugin_0", (String)"fi-bcm-business", (Object[])new Object[0]), exchangeInfo.get(number[1].replaceFirst("pre", ""))) : exchangeInfo.get(number[1]));
            } else if (number[0].equals("rights")) {
                chinaName.append(ResManager.loadKDString((String)"\u7b49\u6548\u6301\u80a1\u6bd4\u4f8b", (String)"CvtFormulaEditPlugin_6", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        } else if (f.getName().equals(FormulaEnum.Inv.name())) {
            String aNumber = ((ParamItem)f.getParamList().get(1)).toString();
            String ctNumber = ((ParamItem)f.getParamList().get(2)).toString();
            DynamicObject a = DimensionServiceHelper.queryMemberNameByNumber("bcm_accountmembertree", modelId, aNumber);
            DynamicObject ct = DimensionServiceHelper.queryMemberNameByNumber("bcm_changetypemembertree", modelId, ctNumber);
            chinaName.append(a.getString("name"));
            chinaName.append('|').append(ct.getString("name"));
        } else if (f.getName().equals(FormulaEnum.Esp.name())) {
            String invType = ((ParamItem)f.getParamList().get(0)).toString();
            String numberType = ((ParamItem)f.getParamList().get(1)).toString();
            String name = HolderTypeEnum.getNameByNumber((String)numberType);
            if ("4".equals(invType) || "5".equals(invType)) {
                name = HolderTypeEnum.UniteScale.getName();
            }
            chinaName.append(name);
        } else if (f.getName().equals("V")) {
            String oldValue = f.toString();
            chinaName.append(ChkFormulaServiceHelper.translateChkformla(oldValue, modelId, 1, "account;changetype"));
        }
        return chinaName.toString();
    }

    public static Map getExchangeInfoMap(Long modelId) {
        return (Map)ThreadCache.get((Object)("exchangeinfomap" + modelId), () -> {
            HashMap<String, String> exchangeInfo = new HashMap<String, String>();
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            qFilter.and("parent.number", "=", (Object)"ExchangeRate");
            DynamicObjectCollection cols = QueryServiceHelper.query((String)"bcm_accountmembertree", (String)"name,number", (QFilter[])new QFilter[]{qFilter}, (String)"dseq");
            for (DynamicObject dot : cols) {
                String name = dot.getString("name");
                String number = dot.getString("number");
                exchangeInfo.put(number, name);
            }
            return exchangeInfo;
        });
    }
}

