/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.olap.common.CommandTypes;
import kd.bos.olap.common.PropertyBag;
import kd.bos.olap.dataSources.BlackWhiteScopeItem;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.FunctionCommandInfo;
import kd.bos.olap.dataSources.MetadataItem;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.PiecewisePairMetadataItem;
import kd.bos.olap.metadata.MetadataTypes;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapScopeHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.serviceHelper.SlowEvolvingServiceHelper;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.fel.common.StringUtils;

public class ICVersionServiceHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, ICVersionServiceHelper.class);
    private static final String IC_SCOPE = "IC_SCOPE_";
    private static final String IC_FUN = "IC_FUN_";
    private static final String SELECT_FIELD = "id,number,parent.number,forbiddenrecords.forbiddeneffdate,forbiddenrecords.forbiddenexpdate,forbiddentype";

    public static synchronized void openICVersion(long modelId) {
        try {
            logger.startWatch();
            String modelNum = MemberReader.findModelNumberById((Object)modelId);
            ICVersionServiceHelper.resetICPiecewise(modelNum);
            SlowEvolvingServiceHelper.createTags(modelNum, PresetConstant.INTERNALCOMPANY_DIM, new String[]{"internal", "external", "ICNone"});
            logger.errorEnd("ic version create dimension tags end.");
            logger.startWatch();
            Collection allNodes = MemberReader.getAllNodeByDimNum((String)PresetConstant.INTERNALCOMPANY_DIM, (String)modelNum);
            ArrayList<String> internalNumbers = new ArrayList<String>(16);
            ArrayList<String> externalNumbers = new ArrayList<String>(16);
            List<String> allNumbers = allNodes.stream().map(m -> m.getNumber()).collect(Collectors.toList());
            allNodes.stream().filter(a -> a.isLeaf() && !a.getNumber().equals("ICNone")).forEach(a -> {
                if ("ICEntity".equals(a.getParent().getNumber())) {
                    internalNumbers.add(a.getNumber());
                } else if ("ICOEntity".equals(a.getParent().getNumber())) {
                    externalNumbers.add(a.getNumber());
                }
            });
            logger.errorEnd("ic version load dimension cache end.");
            logger.startWatch();
            SlowEvolvingServiceHelper.untagMembers(modelNum, PresetConstant.INTERNALCOMPANY_DIM, PresetConstant.TAG_IC_TOTAL, allNumbers);
            SlowEvolvingServiceHelper.tagMembers(modelNum, PresetConstant.INTERNALCOMPANY_DIM, "ICNone", Lists.newArrayList((Object[])new String[]{"ICNone"}));
            SlowEvolvingServiceHelper.tagMembers(modelNum, PresetConstant.INTERNALCOMPANY_DIM, "internal", internalNumbers);
            SlowEvolvingServiceHelper.tagMembers(modelNum, PresetConstant.INTERNALCOMPANY_DIM, "external", externalNumbers);
            logger.errorEnd("ic version tag members end.");
            logger.startWatch();
            SlowEvolvingServiceHelper.setAggTagSlowEvolvingExpression(modelNum, PresetConstant.INTERNALCOMPANY_DIM, "ICOEntity", "external");
            SlowEvolvingServiceHelper.setAggTagSlowEvolvingExpression(modelNum, PresetConstant.INTERNALCOMPANY_DIM, "ICEntity", "internal");
            SlowEvolvingServiceHelper.setAggTagExpression(modelNum, PresetConstant.INTERNALCOMPANY_DIM, "ICTotal", String.join((CharSequence)",", PresetConstant.TAG_IC_TOTAL));
            SlowEvolvingServiceHelper.setAggTagExpression(modelNum, PresetConstant.INTERNALCOMPANY_DIM, "InternalCompany", String.join((CharSequence)",", PresetConstant.TAG_INTERNAL_COMPANY));
            logger.errorEnd("ic version set expression end.");
        }
        catch (Exception ex) {
            logger.error("ic version open fail." + ThrowableHelper.toString((Exception)ex));
            throw new KDBizException(ex.getMessage());
        }
    }

    public static Set<String> getVersionRecord(long modelId) {
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        String cacheKey = GlobalCacheServiceHelper.packAboutDimCacheKey((String)modelNum, (String)"bcm_entitymembertree") + "#getVersionRecord";
        return (Set)GlobalCacheServiceHelper.getCommonCache().getOrLoad(cacheKey, () -> {
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            filter.and(new QFilter("isinnerorg", "=", (Object)true));
            filter.and(new QFilter("entitypart.isouterorg", "=", (Object)true));
            return QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"number", (QFilter[])filter.toArray()).stream().map(m -> m.getString("number")).collect(Collectors.toSet());
        });
    }

    private static int convertDate(Date date) {
        if (date == null) {
            return 0;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1) * 10000 + (calendar.get(2) + 1) * 100 + calendar.get(5);
    }

    private static int convertToMonth(Date date) {
        if (date == null) {
            return 0;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1) * 10000 + (calendar.get(2) + 1) * 100;
    }

    private static int convertPeriodDay(long modelId, long yearId, long periodId) {
        int year = MemberReader.findFyMemberById((Long)modelId, (Long)yearId).getYear();
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberById((Long)modelId, (Long)periodId);
        if (periodNode == null || periodNode == IDNumberTreeNode.NotFoundTreeNode) {
            return year * 10000;
        }
        if (((Boolean)periodNode.getProperty("isadjust")).booleanValue()) {
            String relatedNum = (String)periodNode.getProperty("relatednumber");
            periodNode = MemberReader.findPeriodMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)relatedNum);
        }
        return year * 10000 + periodNode.getPeriodLastDay();
    }

    private static void resetICPiecewise(String modelNum) {
        HashSet<String> innerName = new HashSet<String>(16);
        HashSet<String> outerName = new HashSet<String>(16);
        List<String> innerPiecewise = ICVersionServiceHelper.findPiecewise(modelNum, PresetConstant.INTERNALCOMPANY_DIM, "ICEntity");
        List<String> outerPiecewise = ICVersionServiceHelper.findPiecewise(modelNum, PresetConstant.INTERNALCOMPANY_DIM, "ICOEntity");
        innerPiecewise.stream().filter(i -> i.startsWith(IC_FUN)).forEach(name -> innerName.add((String)name));
        outerPiecewise.stream().filter(i -> i.startsWith(IC_FUN)).forEach(name -> outerName.add((String)name));
        ICVersionServiceHelper.dropIcPiecewise(modelNum, "ICEntity", innerName);
        ICVersionServiceHelper.dropIcPiecewise(modelNum, "ICOEntity", outerName);
        ICVersionServiceHelper.dropScopes(modelNum);
    }

    private static void dropScopes(String modelNum) {
        logger.startWatch();
        List<String> scopes = ICVersionServiceHelper.findCubeDataScope(modelNum);
        HashSet items = new HashSet(16);
        scopes.stream().filter(i -> i.startsWith(IC_SCOPE)).forEach(name -> items.add(new BlackWhiteScopeItem(name)));
        OlapScopeHelper.execCubeMetadata(modelNum, modelNum, MetadataTypes.CubeDataScope, CommandTypes.drop, items.toArray(new MetadataItem[0]));
        logger.errorEnd(String.format("ic version drop ic scopes. modelNum:%s", modelNum));
    }

    private static void dropIcPiecewise(String modelNum, String number, Set<String> piecewiseName) {
        if (CollectionUtil.isEmpty(piecewiseName)) {
            return;
        }
        String ownerName = modelNum + "." + PresetConstant.INTERNALCOMPANY_DIM + "." + number;
        PiecewisePairMetadataItem[] items = new PiecewisePairMetadataItem[piecewiseName.size()];
        int i = 0;
        for (String item : piecewiseName) {
            items[i++] = new PiecewisePairMetadataItem(item);
        }
        OlapScopeHelper.execCubeMetadata(modelNum, ownerName, MetadataTypes.PiecewiseExpression, CommandTypes.drop, (MetadataItem[])items);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> findPiecewise(String cubeNum, String dimNumber, String number) {
        String path = dimNumber + "@" + number;
        ArrayList<String> expressionList = new ArrayList<String>(16);
        try (OlapConnection olapConn = OlapServiceHelper.getOlapConnection(cubeNum);){
            PropertyBag propertyBag = new PropertyBag();
            propertyBag.set("cubeName", cubeNum);
            propertyBag.set("path", path);
            FunctionCommandInfo commandInfo = new FunctionCommandInfo("getFactorsV2", propertyBag);
            OlapCommand command = new OlapCommand(olapConn, (CommandInfo)commandInfo);
            PropertyBag result = command.executeFunction();
            JSONArray resultArray = JSON.parseArray((String)result.get("result"));
            if (resultArray == null || resultArray.size() == 0) {
                ArrayList<String> arrayList = expressionList;
                return arrayList;
            }
            JSONObject jsonObject = resultArray.getJSONObject(0);
            if (jsonObject == null) {
                ArrayList<String> arrayList = expressionList;
                return arrayList;
            }
            String name = jsonObject.getString("name");
            if (!number.equals(name)) {
                ArrayList<String> arrayList = expressionList;
                return arrayList;
            }
            JSONObject calcExpression = jsonObject.getJSONObject("calcExpression");
            if (calcExpression == null) {
                ArrayList<String> arrayList = expressionList;
                return arrayList;
            }
            JSONArray expressions = calcExpression.getJSONArray("expressions");
            if (expressions == null || expressions.size() == 0) {
                ArrayList<String> arrayList = expressionList;
                return arrayList;
            }
            for (int i = 0; i < expressions.size(); ++i) {
                JSONObject expression = expressions.getJSONObject(i);
                if (expression == null) continue;
                expressionList.add(expression.getString("name"));
            }
            ArrayList<String> arrayList = expressionList;
            return arrayList;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> findCubeDataScope(String cubeNum) {
        ArrayList<String> scopeList = new ArrayList<String>(16);
        try (OlapConnection olapConn = OlapServiceHelper.getOlapConnection(cubeNum);){
            PropertyBag propertyBag = new PropertyBag();
            propertyBag.set("cubeName", cubeNum);
            FunctionCommandInfo commandInfo = new FunctionCommandInfo("getCubeDataScopes", propertyBag);
            OlapCommand command = new OlapCommand(olapConn, (CommandInfo)commandInfo);
            PropertyBag result = command.executeFunction();
            JSONArray resultArray = JSON.parseArray((String)result.get("result"));
            if (resultArray == null || resultArray.size() == 0) {
                ArrayList<String> arrayList = scopeList;
                return arrayList;
            }
            for (int i = 0; i < resultArray.size(); ++i) {
                scopeList.add(resultArray.getJSONObject(i).getString("name"));
            }
            ArrayList<String> arrayList = scopeList;
            return arrayList;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    public static Set<Long> getInvalidIdByParent(VersionParam param) {
        HashSet<Long> result = new HashSet<Long>(16);
        if (param == null || param.getModelId() == 0L || param.getYearId() == 0L || param.getPeriodId() == 0L) {
            return result;
        }
        if (!ConfigServiceHelper.getBoolParam(param.getModelId(), "CM060")) {
            return new HashSet<Long>(16);
        }
        String modelNum = MemberReader.findModelNumberById((Object)param.getModelId());
        String longKey = Joiner.on((String)"#").join((Object)modelNum, (Object)"bcm_icmembertree", new Object[]{param.getYearId(), param.getPeriodId(), param.getParentId(), "getInvalidIC"});
        String cacheKey = StringUtils.stringToMD5((String)longKey);
        return (Set)GlobalCacheServiceHelper.getCommonCache().getOrLoad(cacheKey, () -> {
            QFilter filter = new QFilter("model", "=", (Object)param.getModelId());
            filter.and("forbiddenrecords", "is not null", null);
            DynamicObject[] records = BusinessDataServiceHelper.load((String)"bcm_icmembertree", (String)SELECT_FIELD, (QFilter[])filter.toArray());
            if (records == null || records.length == 0) {
                return result;
            }
            String parentNum = MemberReader.findMemberById((long)param.getModelId(), (String)"bcm_icmembertree", (Long)param.getParentId()).getNumber();
            int yearMonth = ICVersionServiceHelper.convertPeriodDay(param.getModelId(), param.getYearId(), param.getPeriodId());
            for (DynamicObject record : records) {
                if ("InternalCompany".equals(parentNum) || "ICTotal".equals(parentNum) || param.getParentId() == 0L) {
                    result.addAll(ICVersionServiceHelper.getInvalidIdByParent(record, true, yearMonth));
                    result.addAll(ICVersionServiceHelper.getInvalidIdByParent(record, false, yearMonth));
                    continue;
                }
                if (!"ICEntity".equals(parentNum) && !"ICOEntity".equals(parentNum)) continue;
                result.addAll(ICVersionServiceHelper.getInvalidIdByParent(record, "ICEntity".equals(parentNum), yearMonth));
            }
            return result;
        });
    }

    private static Set<Long> getInvalidIdByParent(DynamicObject record, boolean isInner, int periodScope) {
        HashSet<Long> result = new HashSet<Long>(16);
        String parentNum = record.getString("parent.number");
        if (isInner && !"ICEntity".equals(parentNum) || !isInner && !"ICOEntity".equals(parentNum)) {
            return result;
        }
        record.getDynamicObjectCollection("forbiddenrecords").stream().filter(r -> r.getString("forbiddentype").equals(isInner ? "0" : "1")).forEach(d -> {
            int expDate;
            int effDate = ICVersionServiceHelper.convertDate(d.getDate("forbiddeneffdate"));
            int n = expDate = d.getDate("forbiddenexpdate") == null ? 0 : ICVersionServiceHelper.convertDate(d.getDate("forbiddenexpdate"));
            if (periodScope >= effDate && (expDate == 0 || periodScope <= expDate)) {
                result.add(record.getLong("id"));
            }
        });
        return result;
    }

    public static IDNumberTreeNode getValidIC(VersionParam param, String number) {
        if (param == null || param.getModelId() == 0L || param.getYearId() == 0L || param.getPeriodId() == 0L) {
            return IDNumberTreeNode.NotFoundTreeNode;
        }
        String modelNum = MemberReader.findModelNumberById((Object)param.getModelId());
        if (!ConfigServiceHelper.getBoolParam(param.getModelId(), "CM060")) {
            return MemberReader.findMemberByNumber((String)modelNum, (String)PresetConstant.INTERNALCOMPANY_DIM, (String)number);
        }
        String cacheKey = GlobalCacheServiceHelper.packAboutDimCacheKey((String)modelNum, (String)"bcm_icmembertree") + "#" + param.getYearId() + "#" + param.getPeriodId() + "#getValidIC#" + number;
        return (IDNumberTreeNode)GlobalCacheServiceHelper.getCommonCache().getOrLoad(cacheKey, () -> {
            Set<String> versionNumbers = ICVersionServiceHelper.getVersionRecord(param.getModelId());
            if (!versionNumbers.contains(number)) {
                return MemberReader.findMemberByNumber((String)modelNum, (String)PresetConstant.INTERNALCOMPANY_DIM, (String)number);
            }
            QFilter filter = new QFilter("model", "=", (Object)param.getModelId());
            filter.and(new QFilter("number", "=", (Object)number));
            DynamicObject[] records = BusinessDataServiceHelper.load((String)"bcm_icmembertree", (String)SELECT_FIELD, (QFilter[])filter.toArray());
            if (records == null || records.length == 0) {
                return IDNumberTreeNode.NotFoundTreeNode;
            }
            int yearMonth = ICVersionServiceHelper.convertPeriodDay(param.getModelId(), param.getYearId(), param.getPeriodId());
            for (DynamicObject record : records) {
                String parentNum = record.getString("parent.number");
                AtomicBoolean isValid = new AtomicBoolean(true);
                record.getDynamicObjectCollection("forbiddenrecords").stream().filter(r -> r.getString("forbiddentype").equals("ICEntity".equals(parentNum) ? "0" : "1")).forEach(d -> {
                    int expDate;
                    int effDate = ICVersionServiceHelper.convertDate(d.getDate("forbiddeneffdate"));
                    int n = expDate = d.getDate("forbiddenexpdate") == null ? 0 : ICVersionServiceHelper.convertDate(d.getDate("forbiddenexpdate"));
                    if (yearMonth >= effDate && (expDate == 0 || yearMonth <= expDate)) {
                        isValid.set(false);
                    }
                });
                if (!isValid.get()) continue;
                return MemberReader.findMemberById((long)param.getModelId(), (String)"bcm_icmembertree", (Long)record.getLong("id"));
            }
            return IDNumberTreeNode.NotFoundTreeNode;
        });
    }

    public static Set<String> getInvalidNumbers(VersionParam param) {
        if (param == null || param.getModelId() == 0L || param.getYearId() == 0L || param.getPeriodId() == 0L) {
            return new HashSet<String>(16);
        }
        if (!ConfigServiceHelper.getBoolParam(param.getModelId(), "CM060")) {
            return new HashSet<String>(16);
        }
        String modelNum = MemberReader.findModelNumberById((Object)param.getModelId());
        String cacheKey = GlobalCacheServiceHelper.packAboutDimCacheKey((String)modelNum, (String)"bcm_icmembertree") + "#" + param.getYearId() + "#" + param.getPeriodId() + "#getInvalidNumbers";
        return (Set)GlobalCacheServiceHelper.getCommonCache().getOrLoad(cacheKey, () -> {
            QFilter filter = new QFilter("model", "=", (Object)param.getModelId());
            filter.and("forbiddenrecords", "is not null", null);
            DynamicObject[] records = BusinessDataServiceHelper.load((String)"bcm_icmembertree", (String)SELECT_FIELD, (QFilter[])filter.toArray());
            if (records == null || records.length == 0) {
                return new HashSet(16);
            }
            int yearMonth = ICVersionServiceHelper.convertPeriodDay(param.getModelId(), param.getYearId(), param.getPeriodId());
            HashSet innerRecord = new HashSet(16);
            HashSet outerRecord = new HashSet(16);
            for (DynamicObject record : records) {
                String parentNum = record.getString("parent.number");
                record.getDynamicObjectCollection("forbiddenrecords").stream().filter(r -> r.getString("forbiddentype").equals("ICEntity".equals(parentNum) ? "0" : "1")).forEach(d -> {
                    int expDate;
                    int effDate = ICVersionServiceHelper.convertDate(d.getDate("forbiddeneffdate"));
                    int n = expDate = d.getDate("forbiddenexpdate") == null ? 0 : ICVersionServiceHelper.convertDate(d.getDate("forbiddenexpdate"));
                    if (yearMonth >= effDate && (expDate == 0 || yearMonth <= expDate)) {
                        if ("ICEntity".equals(parentNum)) {
                            innerRecord.add(record.getString("number"));
                        } else {
                            outerRecord.add(record.getString("number"));
                        }
                    }
                });
            }
            innerRecord.retainAll(outerRecord);
            return innerRecord;
        });
    }

    public static synchronized void updateMemberSlowEvolving(long modelId, String number, DynamicObject member) {
        TreeMap<Integer, String> periodScope = member != null ? ICVersionServiceHelper.getSlowEvolvingPeriod(member) : ICVersionServiceHelper.getSlowEvolvingPeriod(modelId, number);
        SlowEvolvingServiceHelper.setMemberSlowEvolving(MemberReader.findModelNumberById((Object)modelId), PresetConstant.INTERNALCOMPANY_DIM, number, periodScope, "external");
    }

    public static synchronized void batchSynchroMemberSlowEvolving(long modelId) {
        if (!ICVersionServiceHelper.isICVersion(modelId, "InternalCompany")) {
            return;
        }
        ICVersionServiceHelper.openICVersion(modelId);
        logger.startWatch();
        Set<String> numbers = ICVersionServiceHelper.getVersionRecord(modelId);
        numbers.forEach(number -> SlowEvolvingServiceHelper.setMemberSlowEvolving(MemberReader.findModelNumberById((Object)modelId), PresetConstant.INTERNALCOMPANY_DIM, number, ICVersionServiceHelper.getSlowEvolvingPeriod(modelId, number), "internal"));
        logger.errorEnd("ic version batch synchro member slow evolving end.");
    }

    private static TreeMap<Integer, String> getSlowEvolvingPeriod(long modelId, String number) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and(new QFilter("storagetype", "=", (Object)StorageTypeEnum.SHARE.getOIndex()));
        filter.and(new QFilter("number", "=", (Object)number));
        DynamicObject member = BusinessDataServiceHelper.loadSingle((String)"bcm_icmembertree", (String)SELECT_FIELD, (QFilter[])filter.toArray());
        return ICVersionServiceHelper.getSlowEvolvingPeriod(member);
    }

    private static TreeMap<Integer, String> getSlowEvolvingPeriod(DynamicObject member) {
        TreeMap<Integer, String> periodScope = new TreeMap<Integer, String>();
        if (member != null) {
            member.getDynamicObjectCollection("forbiddenrecords").forEach(d -> periodScope.put(ICVersionServiceHelper.convertToMonth(d.getDate("forbiddeneffdate")), d.getString("forbiddentype").equals("0") ? "external" : "internal"));
        }
        return periodScope;
    }

    public static String getMemberTags(String parentNum) {
        if ("ICEntity".equals(parentNum)) {
            return "internal";
        }
        if ("ICOEntity".equals(parentNum)) {
            return "external";
        }
        if ("InternalCompany".equals(parentNum)) {
            return "ICNone";
        }
        return null;
    }

    public static boolean isICVersion(long modelId, String dimNum) {
        return "InternalCompany".equals(dimNum) && ConfigServiceHelper.getBoolParam(modelId, "CM060");
    }

    public static boolean isICVersion(String modelNum, String dimNum) {
        return ICVersionServiceHelper.isICVersion(MemberReader.findModelIdByNum((String)modelNum), dimNum);
    }
}

