/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.business.paramsetting.ParamSettingServiceHelper;
import kd.fi.bcm.business.permission.UserDistributeServiceHelper;
import kd.fi.bcm.business.permission.perm.PermPackageList;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermSpreadLogic;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.ICache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.CacheTypeEnum;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.util.ParamCheck;
import kd.fi.bcm.fel.common.StringUtils;

public class MemberPermHelper {
    public static final String NUMBER = "number";
    public static final String ID = "id";
    public static final String USERS = "users";
    public static final String USERS_ID = "users.id";
    public static final String USERTYPE = "usertype";
    public static final String USERS_NUMBER = "users.number";
    public static final String USERNAME = "username";
    public static final String MODEL_ID = "model.id";
    public static final String MODEL_SHOWNUMBER = "model.shownumber";
    public static final String DIMENSION = "dimension";
    public static final String DIMENSION_ID = "dimension.id";
    public static final String DIMENSION_NUMBER = "dimension.number";
    public static final String MEMBER = "member";
    public static final String MEMBERTYPE = "membertype";
    public static final String MEMBER_ID = "member.id";
    public static final String MEMBER_NUMBER = "member.number";
    public static final String MEMBERNAME = "membername";
    public static final String RANGE = "range";
    public static final String PERMISSION = "permission";
    public static final String ISCUSTOMPROP = "iscustomprop";
    public static final String CM021_SYNCRPTCOMMIT = "syncrptcommit";

    private static PermissionService getService() {
        return (PermissionService)ServiceFactory.getService(PermissionService.class);
    }

    @Deprecated
    public static Set<Long> getNoPermMembers(Object dimensionId) {
        MemberPermSpreadLogic mp = new MemberPermSpreadLogic();
        return mp.getNoPermtMembers(dimensionId);
    }

    @Deprecated
    public static Set<Long> getNoPermMembers(String dimensionType, Object modelId) {
        MemberPermSpreadLogic mp = new MemberPermSpreadLogic();
        return mp.getNoPermtMembers(dimensionType, modelId);
    }

    @Deprecated
    public static Set<String> getNoPermMemberNums(String dimensionType, Object modelId) {
        Set<Long> ids = MemberPermHelper.getNoPermMembers(DimEntityNumEnum.getEntieyNumByNumber((String)dimensionType), modelId);
        QFilter idFilter = new QFilter(ID, "in", ids);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)DimEntityNumEnum.getEntieyNumByNumber((String)dimensionType), (String)NUMBER, (QFilter[])new QFilter[]{idFilter});
        return doc.stream().map(d -> d.getString(NUMBER)).collect(Collectors.toSet());
    }

    public static Set<String> getNoPermMemberNums(String entityName, long dimId, Object modelId) {
        Set<Long> ids = MemberPermHelper.getNoPermissionIds(entityName, dimId, modelId);
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptySet();
        }
        QFilter idFilter = new QFilter(ID, "in", ids);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)entityName, (String)NUMBER, (QFilter[])new QFilter[]{idFilter});
        return doc.stream().map(d -> d.getString(NUMBER)).collect(Collectors.toSet());
    }

    public static Set<String> getNoPermMemberNumCaches(String entityName, long dimId, Object modelId) {
        Set<Long> ids = MemberPermHelper.getNoPermissionIds(entityName, dimId, modelId);
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptySet();
        }
        Set noPerms = MemberReader.change2MemberNumsById((long)((Long)modelId), (String)entityName, (List)Lists.newArrayList(ids));
        return noPerms;
    }

    @Deprecated
    public static Set<Long> getNoPermReadOnlyMembers(String dimensionType, Object modelId) {
        MemberPermSpreadLogic mp = new MemberPermSpreadLogic();
        return mp.getNoPermtReanOnlyMembers(dimensionType, modelId);
    }

    @Deprecated
    public static Set<Long> getNoPermMembersIds(String dimensionType, Object modelId) {
        MemberPermSpreadLogic mp = new MemberPermSpreadLogic();
        return mp.getNoPermtMembersIds(dimensionType, modelId);
    }

    @Deprecated
    public static Map<Long, Integer> getCslSchemePermission(String entityName, Long modelid, DynamicObjectCollection queryNodes) {
        MemberPermSpreadLogic mp = new MemberPermSpreadLogic();
        return mp.getCslMemberPermission(entityName, modelid, queryNodes);
    }

    @Deprecated
    public static Map<Long, Integer> getMemberPermission(String entityName, long dimensionId, Object modelid) {
        MemberPermSpreadLogic mp = new MemberPermSpreadLogic();
        return MemberPermHelper.permMapTransform(mp.getCommonPermissions(entityName, dimensionId, modelid, Arrays.asList(PermEnum.values()), RequestContext.get().getCurrUserId()));
    }

    private static Map<Long, Integer> permMapTransform(Map<Integer, Set<Long>> commonPermissions) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry<Integer, Set<Long>> entry : commonPermissions.entrySet()) {
            Set<Long> memberIds = entry.getValue();
            if (CollectionUtils.isEmpty(memberIds)) continue;
            memberIds.forEach(t -> {
                Integer cfr_ignored_0 = (Integer)map.put(t, entry.getKey());
            });
        }
        return map;
    }

    @Deprecated
    public static Map<Long, Integer> getMemberPermission(String entityName, long dimensionId, Object modelid, Long loginuserId) {
        MemberPermSpreadLogic mp = new MemberPermSpreadLogic();
        return MemberPermHelper.permMapTransform(mp.getCommonPermissions(entityName, dimensionId, modelid, Arrays.asList(PermEnum.values()), loginuserId));
    }

    @SDKMark
    public static Map<String, Set<Long>> getHasEntityPermByNumber(Long modelId, List<String> numbers) {
        MemberPermSpreadLogic mp = new MemberPermSpreadLogic();
        return mp.getHasPermByNumber(modelId, "bcm_entitymembertree", DimTypesEnum.ENTITY.getNumber(), numbers);
    }

    public static int getDefaultPermValue(long dimensionId) {
        MemberPermSpreadLogic mp = new MemberPermSpreadLogic();
        return mp.getDefaultPermValue(dimensionId);
    }

    public static boolean memberCanShow(Object memberId, PermPackageList perms, Map<Long, List<Long>> relationMap) {
        MemberPermSpreadLogic mp = new MemberPermSpreadLogic();
        return mp.memberCanShow(memberId, perms, relationMap);
    }

    public static Map<Long, List<Long>> BuildPCRelation(DynamicObjectCollection doc) {
        MemberPermSpreadLogic mp = new MemberPermSpreadLogic();
        return mp.BuildPCRelation(doc);
    }

    public static Map<Long, List<Long>> BuildPCRelation(List<Map<String, String>> treeList) {
        MemberPermSpreadLogic mp = new MemberPermSpreadLogic();
        return mp.BuildPCRelation(treeList);
    }

    public static Map<Long, List<Long>> getPCRelationByEntity(String entityName, Object dimensionId) {
        MemberPermSpreadLogic mp = new MemberPermSpreadLogic();
        return mp.getPCRelationByEntity(entityName, dimensionId);
    }

    public static void addModelPermFilter(String filterField, BasedataEdit control) {
        control.getQFilters().add(MemberPermHelper.getModelPermFilter(filterField));
    }

    @Deprecated
    public static PermEnum getPermByMemberId(String entityName, Object modelId, long memberId, long dimensionId) {
        return MemberPermHelper.getPermByMemberIds(entityName, modelId, Sets.newHashSet((Object[])new Long[]{memberId}), dimensionId).get(memberId);
    }

    @Deprecated
    public static Map<Long, PermEnum> getPermByMemberIds(String entityName, Object modelId, Set<Long> memberIds, long dimensionId) {
        MemberPermHelper.checkParam(entityName, modelId, dimensionId, memberIds);
        boolean isAdmin = MemberPermHelper.ifUserHasRootPermByModel(RequestContext.get().getCurrUserId(), String.valueOf(modelId));
        if (isAdmin) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)memberIds.size());
            for (Long memberId : memberIds) {
                map.put(memberId, PermEnum.READWRITE);
            }
            return map;
        }
        MemberPermSpreadLogic mp = new MemberPermSpreadLogic();
        return mp.getPermByMemberIds(entityName, modelId, memberIds, dimensionId);
    }

    public static Set<Long> getNoPermissionIds(String entityName, long dimensionId, Object modelId) {
        MemberPermSpreadLogic mp = new MemberPermSpreadLogic();
        return mp.getCommonPermissions(entityName, dimensionId, modelId, Collections.singletonList(PermEnum.NOPERM), RequestContext.get().getCurrUserId()).get(PermEnum.NOPERM.getValue());
    }

    public static Set<Long> getReadPermissionIds(String entityName, long dimensionId, Object modelId) {
        MemberPermSpreadLogic mp = new MemberPermSpreadLogic();
        return mp.getCommonPermissions(entityName, dimensionId, modelId, Collections.singletonList(PermEnum.READONLY), RequestContext.get().getCurrUserId()).get(PermEnum.READONLY.getValue());
    }

    @Deprecated
    public static Set<Long> getWritePermissionIds(String entityName, long dimensionId, Object modelId) {
        MemberPermSpreadLogic mp = new MemberPermSpreadLogic();
        return mp.getCommonPermissions(entityName, dimensionId, modelId, Collections.singletonList(PermEnum.READWRITE), RequestContext.get().getCurrUserId()).get(PermEnum.READWRITE.getValue());
    }

    @Deprecated
    public static Map<Long, Integer> getReadAndWritePermission(String entityName, long dimensionId, Object modelId) {
        MemberPermSpreadLogic mp = new MemberPermSpreadLogic();
        Map<Integer, Set<Long>> commonPermissions = mp.getCommonPermissions(entityName, dimensionId, modelId, Arrays.asList(PermEnum.READONLY, PermEnum.READWRITE), RequestContext.get().getCurrUserId());
        return MemberPermHelper.permMapTransform(commonPermissions);
    }

    @Deprecated
    public static Map<Long, Integer> getNoPermAndReadPermission(String entityName, long dimensionId, Object modelId) {
        MemberPermSpreadLogic mp = new MemberPermSpreadLogic();
        Map<Integer, Set<Long>> commonPermissions = mp.getCommonPermissions(entityName, dimensionId, modelId, Arrays.asList(PermEnum.NOPERM, PermEnum.READONLY), RequestContext.get().getCurrUserId());
        return MemberPermHelper.permMapTransform(commonPermissions);
    }

    @Deprecated
    public static Set<Long> getReadAndWritePermissionIds(String entityName, long dimensionId, Object modelId) {
        MemberPermSpreadLogic mp = new MemberPermSpreadLogic();
        Map<Integer, Set<Long>> commonPermissions = mp.getCommonPermissions(entityName, dimensionId, modelId, Arrays.asList(PermEnum.READONLY, PermEnum.READWRITE), RequestContext.get().getCurrUserId());
        return MemberPermHelper.permMapTransformSet(commonPermissions);
    }

    private static Set<Long> permMapTransformSet(Map<Integer, Set<Long>> commonPermissions) {
        HashSet returnSet = Sets.newHashSet();
        for (Set<Long> value : commonPermissions.values()) {
            returnSet.addAll(value);
        }
        return returnSet;
    }

    private static void checkParam(String entityName, Object modelId, Long dimensionId, Set<Long> memberIds) {
        ParamCheck.checkNotBlank((String)entityName);
        ParamCheck.checkNotNull((Object)modelId);
        ParamCheck.checkNotNull((Object)dimensionId);
        ParamCheck.checkNotEmpty(memberIds);
    }

    public static QFilter getModelPermFilter(String filterField) {
        QFilter qcfPerm = new QFilter(filterField, "in", MemberPermHelper.getLimitedModelListByUser());
        return qcfPerm;
    }

    public static void clearPermCache(CacheTypeEnum cacheEnum, Set<String> keys) {
        ICache cache = GlobalCacheServiceHelper.getCache((CacheTypeEnum)cacheEnum);
        for (String key : keys) {
            cache.invalidateStartsWithKey(key);
        }
    }

    public static QFilter getModelPermFilter(String filterField, String formId, ApplicationTypeEnum application) {
        if ("bcm_modelperm_manager".equals(formId) || "report_modelperm_manager".equals(formId)) {
            return new QFilter(filterField, "in", MemberPermHelper.getLimitedModelListByUser(application, true));
        }
        return new QFilter(filterField, "in", MemberPermHelper.getLimitedModelListByUser(application, false));
    }

    private static QFilter[] getRptModelQFilter(QFilter filter) {
        return new QFilter[]{filter};
    }

    public static Set<Long> getLimitedModelListByUser() {
        return MemberPermHelper.getLimitedModelListByUser(null);
    }

    public static Set<Long> getLimitedModelListByUser(ApplicationTypeEnum application) {
        return MemberPermHelper.getLimitedModelListByUser(application, false);
    }

    public static Set<Long> getLimitedModelListByUser(String formId, ApplicationTypeEnum application) {
        if ("bcm_modelperm_manager".equals(formId) || "report_modelperm_manager".equals(formId)) {
            return MemberPermHelper.getLimitedModelListByUser(application, true);
        }
        return MemberPermHelper.getLimitedModelListByUser(application, false);
    }

    public static Set<Long> getLimitedModelListByUser(ApplicationTypeEnum application, Boolean ifCheckManager) {
        MemberPermSpreadLogic memberPermSpreadLogic = new MemberPermSpreadLogic();
        return memberPermSpreadLogic.getLimitedModelListByUser(application, ifCheckManager, true);
    }

    public static boolean isManager(ApplicationTypeEnum application, String formId) {
        if ("bcm_modelperm_manager".equals(formId) || "report_modelperm_manager".equals(formId)) {
            return MemberPermHelper.isManager(application);
        }
        return false;
    }

    public static boolean isManager(ApplicationTypeEnum application) {
        MemberPermSpreadLogic memberPermSpreadLogic = new MemberPermSpreadLogic();
        return memberPermSpreadLogic.isManager(application);
    }

    public static Set<Long> getLimitedCompleteIsolationModelListByUser(ApplicationTypeEnum application) {
        RequestContext tx = RequestContext.get();
        long userId = Long.parseLong(tx.getUserId());
        return (Set)ThreadCache.get((Object)("isolate_model_" + userId + application), () -> {
            QFilter[] filters;
            DynamicObjectCollection dys;
            Set<Object> modelIds = new HashSet();
            Set<Long> groupIds = UserDistributeServiceHelper.queryAllGroupByUserId(userId);
            groupIds.add(userId);
            QFilter filter = new QFilter("modelpermentry.eusers", "in", (Object)groupIds.toArray());
            if (application != null) {
                if (application == ApplicationTypeEnum.RPT) {
                    filter.and(new QFilter("model.reporttype", "in", (Object)new String[]{ApplicationTypeEnum.RPT.index, ApplicationTypeEnum.PUB.index}));
                } else if (application == ApplicationTypeEnum.BGBD) {
                    filter.and("model.reporttype", "=", (Object)ApplicationTypeEnum.EB.index).or("model.reporttype", "=", (Object)ApplicationTypeEnum.BGMD.index);
                } else {
                    filter.and(new QFilter("model.reporttype", "=", (Object)application.index));
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(dys = QueryServiceHelper.query((String)"bcm_modelperm", (String)MODEL_ID, (QFilter[])(filters = MemberPermHelper.getRptModelQFilter(filter)))))) {
                modelIds = dys.stream().map(dy -> dy.getLong(MODEL_ID)).collect(Collectors.toSet());
            }
            return modelIds;
        });
    }

    public static Set<Long> getLimitedModelListByUser(ApplicationTypeEnum application, String userId) {
        RequestContext tx = RequestContext.get();
        HashSet<Long> modelIds = new HashSet<Long>();
        ThreadCache.remove((Object)"usergroup");
        Set<Long> groupIds = UserDistributeServiceHelper.queryAllGroupByUserId(Long.parseLong(userId));
        groupIds.add(Long.valueOf(userId));
        QFilter filter = new QFilter("modelpermentry.eusers", "in", (Object)groupIds.toArray());
        if (application != null) {
            if (application == ApplicationTypeEnum.RPT) {
                filter.and(new QFilter("model.reporttype", "in", (Object)new String[]{ApplicationTypeEnum.RPT.index, ApplicationTypeEnum.CM.index, ApplicationTypeEnum.PUB.index}));
            } else if (application == ApplicationTypeEnum.BGBD) {
                QFilter bgbd = new QFilter("model.reporttype", "=", (Object)ApplicationTypeEnum.EB.index);
                bgbd.or("model.reporttype", "=", (Object)ApplicationTypeEnum.BGMD.index);
                filter.and(bgbd);
            } else {
                filter.and(new QFilter("model.reporttype", "=", (Object)application.index));
            }
        }
        QFilter[] filters = MemberPermHelper.getRptModelQFilter(filter);
        QueryServiceHelper.query((String)"bcm_modelperm", (String)"model", (QFilter[])filters).forEach(p -> modelIds.add(p.getLong("model")));
        return modelIds;
    }

    public static boolean isModelManager(Long modelId) {
        Set<Long> ids = MemberPermHelper.getLimitedModelListByUser();
        return ids.contains(modelId);
    }

    public static String genUniqueLongKey(Long ... strings) {
        StringBuilder key = new StringBuilder();
        key.append(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            key.append(',');
            key.append(strings[i]);
        }
        return key.toString();
    }

    public static boolean ifUserHasRootPermByModel(long userId, String modelId) {
        return (Boolean)ThreadCache.get((Object)Joiner.on((char)'-').join((Object)modelId, (Object)userId, new Object[]{"check_admin"}), () -> MemberPermHelper.ifUserHasRootPermByModelFromDb(userId, modelId));
    }

    public static Set<Long> checkUsersIsAdmin(Set<Long> userId, long modelId) {
        return (Set)ThreadCache.get((Object)Joiner.on((char)'-').join((Object)modelId, userId, new Object[]{"check_admin_by_users"}), () -> MemberPermHelper.checkUsersIsAdminFromDb(userId, modelId));
    }

    private static boolean ifUserHasRootPermByModelFromDb(long userId, String modelId) {
        MemberPermSpreadLogic memberPermSpreadLogic = new MemberPermSpreadLogic();
        return memberPermSpreadLogic.ifUserHasRootPermByModelFromDb(userId, modelId);
    }

    private static Set<Long> checkUsersIsAdminFromDb(Set<Long> userIds, long modelId) {
        MemberPermSpreadLogic memberPermSpreadLogic = new MemberPermSpreadLogic();
        return memberPermSpreadLogic.checkUsersIsAdmin(userIds, modelId);
    }

    public static Set<Long> getManagersByModel(Long modelId) {
        HashSet<Long> userIds = new HashSet<Long>();
        HashSet userGroup = new HashSet();
        QueryServiceHelper.query((String)"bcm_modelperm", (String)"modelpermentry.eusers as user,modelpermentry.etype as usertype", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)}).forEach(obj -> {
            userIds.add(obj.getLong("user"));
            if (!obj.getString(USERTYPE).equals("bos_user")) {
                userGroup.add(obj.getLong("user"));
            }
        });
        if (!userGroup.isEmpty()) {
            QueryServiceHelper.query((String)"bos_usergroupstaff", (String)"user", (QFilter[])new QFilter[]{new QFilter("usergroup", "in", userGroup)}).forEach(obj -> userIds.add(obj.getLong("user")));
        }
        return userIds;
    }

    @SDKMark(description="")
    public static void checkEntityMemberPerm(long pid, long orgId, long modelId, long dimensionId) {
        boolean hasPerm = MemberPermHelper.checkHasEntityMemberPerm(pid, orgId, modelId, dimensionId);
        if (!hasPerm) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\uff01", (String)"MemberPermHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    private static Boolean checkHasEntityMemberPerm(long pid, long orgId, long modelId, long dimensionId) {
        boolean boolParam = (Boolean)ThreadCache.get((Object)("CM021_" + modelId), () -> ConfigServiceHelper.getBoolParam(modelId, ConfigEnum.CM021.getNumber()));
        Set<Object> exceptOrgs = new HashSet(8);
        if (boolParam) {
            exceptOrgs = MemberPermHelper.getExceptOrgs(modelId);
        }
        String parentNumber = null;
        String orgNumber = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId).getNumber();
        if (pid != 0L) {
            parentNumber = MemberReader.findEntityMemberById((Long)modelId, (Long)pid).getNumber();
        }
        if (StringUtils.isNotEmpty(parentNumber) && !"Entity".equals(parentNumber) && boolParam && !exceptOrgs.contains(orgNumber)) {
            return MemberPermHelper.checkMemberHasperm(DimEntityNumEnum.ENTITY.getEntityNum(), pid, modelId, dimensionId);
        }
        return MemberPermHelper.checkMemberHasperm(DimEntityNumEnum.ENTITY.getEntityNum(), orgId, modelId, dimensionId);
    }

    public static Set<String> getExceptOrgs(Long modelId) {
        return (Set)ThreadCache.get((Object)(modelId + "exceptOrgs"), () -> {
            HashSet allEntityNumberSet = new HashSet(16);
            JSONArray entryentity = (JSONArray)ParamSettingServiceHelper.getJsonChildKey((long)modelId, (String)"CM021", (String)"entryentity");
            if (entryentity != null) {
                entryentity.forEach(e -> {
                    JSONObject p = (JSONObject)e;
                    IDNumberTreeNode entity = MemberReader.findEntityMemberById((Long)modelId, (Long)p.getLong("entity"));
                    Set<String> entitySet = QueryMemberDetailsHelper.queryMemberNumbersByRange("bcm_entitymembertree", entity.getId(), entity.getNumber(), p.getInteger("rangevalue"), String.valueOf(modelId), DetailTypeEnum.MEMBERPERM);
                    allEntityNumberSet.addAll(entitySet);
                });
            }
            return allEntityNumberSet;
        });
    }

    public static Set<String> getExceptOrgs(Long modelId, String configNum) {
        return (Set)ThreadCache.get((Object)(modelId + "exceptOrgs"), () -> {
            HashSet allEntityNumberSet = new HashSet(16);
            JSONArray entryentity = (JSONArray)ParamSettingServiceHelper.getJsonChildKey((long)modelId, (String)configNum, (String)"entryentity");
            if (entryentity != null) {
                entryentity.forEach(e -> {
                    JSONObject p = (JSONObject)e;
                    IDNumberTreeNode entity = MemberReader.findEntityMemberById((Long)modelId, (Long)p.getLong("entity"));
                    Set<String> entitySet = QueryMemberDetailsHelper.queryMemberNumbersByRange("bcm_entitymembertree", entity.getId(), entity.getNumber(), p.getInteger("rangevalue"), String.valueOf(modelId), DetailTypeEnum.MEMBERPERM);
                    allEntityNumberSet.addAll(entitySet);
                });
            }
            return allEntityNumberSet;
        });
    }

    @Deprecated
    public static Boolean checkMemberHasperm(String entityName, long entityId, long modelId, long dimensionId) {
        return PermissionServiceImpl.getInstance(modelId).isAllWritePerm(dimensionId, entityName, Collections.singletonList(entityId));
    }

    public static boolean isModelAdmin(Long modelId) {
        Set<Long> modelIds = MemberPermHelper.getLimitedModelListByUser();
        return modelIds.contains(modelId);
    }

    public static boolean isFidmModelAdmin(Long modelId, String app) {
        return MemberPermHelper.isDiscModelAdmin(modelId, app);
    }

    public static boolean isDiscModelSuperAdmin(String appType) {
        MemberPermSpreadLogic memberPermSpreadLogic = new MemberPermSpreadLogic();
        return memberPermSpreadLogic.getFidmModelSuperAdmin(appType);
    }

    public static Set<Long> getFidmModelAdmin() {
        return MemberPermHelper.getDisModelAdmin(ApplicationTypeEnum.FIDM.getAppnum());
    }

    public static boolean isDiscModelAdmin(Long modelId, String appType) {
        long userId = RequestContext.get().getCurrUserId();
        Set<Long> groupIds = UserDistributeServiceHelper.queryAllGroupByUserId(userId);
        groupIds.add(userId);
        QFilter userFilter = new QFilter("modelpermentry.eusers", "in", (Object)groupIds.toArray());
        userFilter.and(new QFilter("app", "=", (Object)appType));
        QFilter modelFilter = new QFilter("fidmmodel.id", "=", (Object)modelId);
        MemberPermSpreadLogic memberPermSpreadLogic = new MemberPermSpreadLogic();
        return memberPermSpreadLogic.getFidmModelAdmin(new QFilter[]{userFilter, modelFilter}).size() > 0;
    }

    public static Set<Long> getDisModelAdmin(String appNumber) {
        long userId = RequestContext.get().getCurrUserId();
        Set<Long> groupIds = UserDistributeServiceHelper.queryAllGroupByUserId(userId);
        groupIds.add(userId);
        QFilter userFilter = new QFilter("modelpermentry.eusers", "in", (Object)groupIds.toArray());
        userFilter.and(new QFilter("app", "=", (Object)appNumber));
        MemberPermSpreadLogic memberPermSpreadLogic = new MemberPermSpreadLogic();
        return memberPermSpreadLogic.getFidmModelAdmin(new QFilter[]{userFilter}).stream().filter(t -> t.getLong("fidmmodel.id") != 0L).map(t -> t.getLong("fidmmodel.id")).collect(Collectors.toSet());
    }

    public static DynamicObjectCollection getDiscModelAdmin(Set<Long> modelIds, String appType) {
        MemberPermSpreadLogic memberPermSpreadLogic = new MemberPermSpreadLogic();
        return memberPermSpreadLogic.getDiscModelAdmin(modelIds, appType);
    }

    public static Set<String> getRolesByUIdMId(Long pUserId, Long pModelId) {
        return MemberPermHelper.getService().getRoles(pUserId, pModelId);
    }
}

