/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.exchangeRate.ExchageRateServiceHelper;
import kd.fi.bcm.business.permission.UserDistributeServiceHelper;
import kd.fi.bcm.business.permission.perm.PermCacheKey;
import kd.fi.bcm.business.permission.perm.PermPackageList;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.util.dynamicobject.DynamicObjectCollectionUtil;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.ModelStatusEnum;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.common.enums.Permission.UserTypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;

public class MemberPermSpreadLogic {
    private final Long DEFAULT_COPY_VALUE = 0L;
    public static final String ID = "id";
    public static final String NUMBER = "number";
    public static final String MODEL = "model";
    public static final String MODEL_PERM_ENTRY_EUSERS_ID = "modelpermentry.eusers.id";
    public static final String ADMIN_BY_USER_FIELD = "id,modelpermentry.eusers.id,modelpermentry.etype";
    public static final String ISGALAXYSYSTEM = "isGalaxySystem";
    public static final String ROLEADMINBCM = "Role-Admin_bcm";
    public static final String ROLEADMINRPT = "Role-Admin_rpt";
    public static final String ROLEADMINFIDM = "Role-Admin_fidm";
    public static final String ROLEADMINFAR = "Role-Admin_far";
    private static final String SEPARATOR = ";";
    private static final String USER = "user";
    private static final String ORG = "org";
    private static final String DIMTYPE = "dimtype";
    private static final String DIM_BCM_MODEL = "DIM_BCM_MODEL";

    private void addPermClass(Set<Long> allOrgIds, Map<Long, Integer> memberPerm, Object modelId, String entityName) {
        ArrayListMultimap<String, Long> map = PermClassEntityHelper.getPermissionMapBatch(entityName, String.valueOf(modelId), RequestContext.get().getUserId());
        this.permCalssHandler(allOrgIds, memberPerm, map);
    }

    private void permCalssHandler(Set<Long> allOrgIds, Map<Long, Integer> memberPerm, ArrayListMultimap<String, Long> map) {
        for (String key : map.keySet()) {
            List ids = map.get((Object)key);
            if ("1".equals(key)) {
                ids.stream().forEach(id -> {
                    Integer value;
                    if (allOrgIds.contains(id) && ((value = (Integer)memberPerm.get(id)) == null || value < 3)) {
                        memberPerm.put((Long)id, 3);
                    }
                });
                continue;
            }
            if ("2".equals(key)) {
                ids.stream().forEach(id -> {
                    Integer value;
                    if (allOrgIds.contains(id) && ((value = (Integer)memberPerm.get(id)) == null || value < 2)) {
                        memberPerm.put((Long)id, 2);
                    }
                });
                continue;
            }
            if (!"3".equals(key)) continue;
            ids.stream().forEach(id -> {
                Integer value;
                if (allOrgIds.contains(id) && (value = (Integer)memberPerm.get(id)) == null) {
                    memberPerm.put((Long)id, 1);
                }
            });
        }
    }

    public Set<String> getMembersByPermType(Object dimensionId, PermEnum type) {
        DynamicObject dim = BusinessDataServiceHelper.loadSingleFromCache((Object)dimensionId, (String)"bcm_dimension", (String)"model,membermodel,isuseddataperm");
        String dimEntityName = dim.getString("membermodel");
        DynamicObjectCollection doc = this.getAllMemberPerms(dimEntityName, dimensionId);
        int dPermValue = dim.getInt("isuseddataperm");
        HashSet<String> numbers = new HashSet<String>();
        if (dPermValue == type.getValue()) {
            Collection<DynamicObject> doc2 = this.getAllMemberDatas(dimEntityName, dimensionId);
            doc2.forEach(p -> numbers.add(p.getString(NUMBER)));
        }
        doc.forEach(p -> {
            if (p.getInt("permission") == type.getValue()) {
                numbers.add(p.getString(NUMBER));
            }
        });
        return numbers;
    }

    Set<Long> getNoPermtMembers(Object dimensionId) {
        DynamicObject dimension = QueryDimensionServiceHelper.getMsgByDimId(dimensionId);
        if (this.isModelManager(dimension.getLong(MODEL))) {
            return new HashSet<Long>();
        }
        String dimEntityName = dimension.getString("membermodel");
        DynamicObjectCollection doc = this.getAllMemberPerms(dimEntityName, dimensionId);
        int dPermValue = this.getDefaultPermValue(dimensionId);
        HashSet haveIds = new HashSet();
        HashSet flag = new HashSet();
        HashSet<Long> ids = new HashSet<Long>();
        doc.forEach(p -> {
            if (!StorageTypeEnum.isShare((String)p.getString("storagetype"))) {
                if (p.getBoolean("iscustomprop")) {
                    flag.addAll(QueryMemberDetailsHelper.getMemberIdsByDefinedRange(dimension.getString("membermodel"), p.getLong("member.id"), p.getString(NUMBER), p.getInt("range"), p.getString("model.id"), DetailTypeEnum.MEMBERPERM));
                } else {
                    flag.addAll(QueryMemberDetailsHelper.queryMemberIdsByRange(dimension.getString("membermodel"), p.getLong("member.id"), p.getInt("range"), p.getString("model.id"), DetailTypeEnum.MEMBERPERM));
                }
            }
            if (p.getInt("permission") == PermEnum.NOPERM.getValue()) {
                ids.addAll(flag);
            }
            haveIds.addAll(flag);
            flag.clear();
        });
        if (dPermValue == PermEnum.NOPERM.getValue()) {
            Collection<DynamicObject> doc2 = this.getAllMemberDatas(dimEntityName, dimensionId);
            doc2.forEach(p -> {
                long mid;
                if (!StorageTypeEnum.isShare((String)p.getString("storagetype")) && !haveIds.contains(mid = p.getLong(ID))) {
                    ids.add(mid);
                }
            });
        }
        return ids;
    }

    Set<Long> getNoPermtMembers(String dimensionType, Object modelId) {
        if (this.isModelManager(Long.valueOf(String.valueOf(modelId)))) {
            return new HashSet<Long>();
        }
        QFilter filter1 = new QFilter("membermodel", "=", (Object)dimensionType);
        QFilter filter2 = new QFilter(MODEL, "=", (Object)LongUtil.toLong((Object)modelId));
        long dimensionId = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)ID, (QFilter[])new QFilter[]{filter1, filter2}).getLong(ID);
        DynamicObjectCollection doc = this.getAllMemberPerms(dimensionType, dimensionId);
        int dPermValue = this.getDefaultPermValue(dimensionId);
        HashSet haveIds = new HashSet();
        HashSet flag = new HashSet();
        HashSet<Long> ids = new HashSet<Long>();
        doc.forEach(p -> {
            if (!StorageTypeEnum.isShare((String)p.getString("storagetype"))) {
                if (p.getBoolean("iscustomprop")) {
                    flag.addAll(QueryMemberDetailsHelper.getMemberIdsByDefinedRange(dimensionType, p.getLong("member.id"), p.getString(NUMBER), p.getInt("range"), p.getString("model.id"), DetailTypeEnum.MEMBERPERM));
                } else {
                    flag.addAll(QueryMemberDetailsHelper.queryMemberIdsByRange(dimensionType, p.getLong("member.id"), p.getInt("range"), p.getString("model.id"), DetailTypeEnum.MEMBERPERM));
                }
            }
            if (p.getInt("permission") == PermEnum.NOPERM.getValue()) {
                ids.addAll(flag);
            }
            haveIds.addAll(flag);
            flag.clear();
        });
        ArrayListMultimap<String, Long> map = PermClassEntityHelper.getPermissionMapBatch(dimensionType, String.valueOf(modelId), RequestContext.get().getUserId());
        List noPerms = map.get((Object)"1");
        if (!CollectionUtils.isEmpty((Collection)noPerms)) {
            haveIds.addAll(noPerms);
            ids.addAll(noPerms);
        }
        if (dPermValue == PermEnum.NOPERM.getValue()) {
            Collection<DynamicObject> doc2 = this.getAllMemberDatas(dimensionType, dimensionId);
            doc2.forEach(p -> {
                long mid;
                if (!StorageTypeEnum.isShare((String)p.getString("storagetype")) && !haveIds.contains(mid = p.getLong(ID)) && this.havePermclass(map, mid)) {
                    ids.add(mid);
                }
            });
        }
        return ids;
    }

    public Set<Long> getNoPermtReanOnlyMembers(String dimensionType, Object modelId) {
        if (this.isModelManager(Long.valueOf(String.valueOf(modelId)))) {
            return new HashSet<Long>();
        }
        QFilter filter1 = new QFilter("membermodel", "=", (Object)dimensionType);
        QFilter filter2 = new QFilter(MODEL, "=", (Object)LongUtil.toLong((Object)modelId));
        long dimensionId = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)ID, (QFilter[])new QFilter[]{filter1, filter2}).getLong(ID);
        DynamicObjectCollection doc = this.getAllMemberPerms(dimensionType, dimensionId);
        int dPermValue = this.getDefaultPermValue(dimensionId);
        HashSet haveIds = new HashSet();
        HashSet flag = new HashSet();
        HashSet<Long> ids = new HashSet<Long>();
        doc.forEach(p -> {
            if (!StorageTypeEnum.isShare((String)p.getString("storagetype"))) {
                if (p.getBoolean("iscustomprop")) {
                    flag.addAll(QueryMemberDetailsHelper.getMemberIdsByDefinedRange(dimensionType, p.getLong("member.id"), p.getString(NUMBER), p.getInt("range"), p.getString("model.id"), DetailTypeEnum.MEMBERPERM));
                } else {
                    flag.addAll(QueryMemberDetailsHelper.queryMemberIdsByRange(dimensionType, p.getLong("member.id"), p.getInt("range"), p.getString("model.id"), DetailTypeEnum.MEMBERPERM));
                }
            }
            if (p.getInt("permission") == PermEnum.NOPERM.getValue() || p.getInt("permission") == PermEnum.READONLY.getValue()) {
                ids.addAll(flag);
            }
            haveIds.addAll(flag);
            flag.clear();
        });
        ArrayListMultimap<String, Long> map = PermClassEntityHelper.getPermissionMapBatch(dimensionType, String.valueOf(modelId), RequestContext.get().getUserId());
        List noPerms = map.get((Object)"1");
        noPerms.addAll(map.get((Object)"2"));
        if (!CollectionUtils.isEmpty((Collection)noPerms)) {
            haveIds.addAll(noPerms);
            ids.addAll(noPerms);
        }
        if (dPermValue == PermEnum.NOPERM.getValue() || dPermValue == PermEnum.READONLY.getValue()) {
            Collection<DynamicObject> doc2 = this.getAllMemberDatas(dimensionType, dimensionId);
            doc2.forEach(p -> {
                long mid;
                if (!StorageTypeEnum.isShare((String)p.getString("storagetype")) && !haveIds.contains(mid = p.getLong(ID)) && this.havePermclass(map, mid)) {
                    ids.add(mid);
                }
            });
        }
        return ids;
    }

    Set<Long> getNoPermtMembersIds(String dimensionType, Object modelId) {
        if (modelId == null || this.isModelManager(LongUtil.toLong((Object)String.valueOf(modelId)))) {
            return new HashSet<Long>();
        }
        QFilter filter1 = new QFilter("membermodel", "=", (Object)dimensionType);
        QFilter filter2 = new QFilter(MODEL, "=", (Object)LongUtil.toLong((Object)modelId));
        long dimensionId = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)ID, (QFilter[])new QFilter[]{filter1, filter2}).getLong(ID);
        Map<Long, Integer> permMap = this.getMemberPermission("bcm_entitymembertree", dimensionId, LongUtil.toLong((Object)modelId));
        HashSet<Long> noPermsId = new HashSet<Long>(16);
        permMap.forEach((k, v) -> {
            if (v.intValue() == PermEnum.NOPERM.getValue()) {
                noPermsId.add((Long)k);
            }
        });
        return noPermsId;
    }

    private boolean havePermclass(ArrayListMultimap<String, Long> map, long mid) {
        boolean flag = true;
        List read = map.get((Object)"2");
        List write = map.get((Object)"3");
        if (!CollectionUtils.isEmpty((Collection)read) && read.contains(mid)) {
            flag = false;
        }
        if (!CollectionUtils.isEmpty((Collection)write) && write.contains(mid)) {
            flag = false;
        }
        return flag;
    }

    Map<Long, Integer> getMemberPermission(String entityName, long dimensionId, Object modelid) {
        return this.getMemberPermission(entityName, dimensionId, modelid, null);
    }

    Map<Long, Integer> getMemberPermission(String entityName, long dimensionId, Object modelid, Long loginUserId) {
        DynamicObjectCollection doc = loginUserId == null ? this.getAllMemberPerms(entityName, dimensionId) : this.getAllMemberPerms(entityName, dimensionId, loginUserId);
        Map<Long, Integer> memberPerm = this.buildMemberPerm((List<DynamicObject>)doc, entityName, modelid);
        int permValue = this.getDefaultPermValue(dimensionId);
        this.asignMemberPerm(entityName, memberPerm, permValue, dimensionId, modelid);
        return memberPerm;
    }

    public Map<Long, PermEnum> getPermByMemberIds(String entityName, Object modelId, Set<Long> memberIds, long dimensionId) {
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)memberIds.size());
        Collection allNodeByDimNum = MemberReader.getAllNodeByDimNum((String)MemberReader.getDimensionNumById((long)dimensionId), (String)MemberReader.findModelNumberById((Object)modelId));
        List<IDNumberTreeNode> nodes = allNodeByDimNum.stream().filter(t -> memberIds.contains(t.getId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(nodes)) {
            memberIds.forEach(id -> returnMap.put(id, PermEnum.NOPERM));
            return returnMap;
        }
        Map<Long, Integer> memberPerm = this.getAllDistributeRecords(entityName, modelId, dimensionId, nodes);
        this.buildReturnMap(entityName, nodes, dimensionId, returnMap, memberPerm);
        return returnMap;
    }

    private Map<Long, Integer> getAllDistributeRecords(String entityName, Object modelId, long dimId, List<IDNumberTreeNode> nodes) {
        Map<Long, Integer> memberPerm = this.getDistributeMemberPerm(entityName, dimId, modelId, RequestContext.get().getCurrUserId());
        Set<Long> baseIds = nodes.stream().map(t -> this.DEFAULT_COPY_VALUE.equals(t.getCopyfromId()) ? t.getId() : t.getCopyfromId()).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(baseIds)) {
            return memberPerm;
        }
        DynamicObject[] permClass = PermClassEntityHelper.getPermClassList(entityName, baseIds, String.valueOf(modelId));
        ArrayListMultimap<String, Long> permMapBatch = PermClassEntityHelper.getPermMapBatch(modelId, Arrays.asList(permClass), entityName);
        this.permCalssHandler(baseIds, memberPerm, permMapBatch);
        return memberPerm;
    }

    private void buildReturnMap(String entityName, List<IDNumberTreeNode> members, long dimensionId, Map<Long, PermEnum> returnMap, Map<Long, Integer> memberPerm) {
        int defaultPermValue = this.getDefaultPermValue(dimensionId);
        for (IDNumberTreeNode member : members) {
            if (this.isRate(entityName, member)) {
                returnMap.put(member.getId(), PermEnum.READWRITE);
                continue;
            }
            Long id = Objects.equals(member.getCopyfromId(), this.DEFAULT_COPY_VALUE) ? member.getId() : member.getCopyfromId();
            Integer permValue = Optional.ofNullable(memberPerm.get(id)).orElse(defaultPermValue);
            returnMap.put(member.getId(), PermEnum.getPermTypeByVal((int)permValue));
        }
    }

    private boolean isRate(String entityName, IDNumberTreeNode member) {
        boolean isAcct = entityName.equals(DimEntityNumEnum.ACCOUNT.getEntityNum());
        boolean isRate = isAcct && member.getNumber().equals("ExchangeRate") || member.getParent() != null && member.getParent().getNumber().equals("ExchangeRate");
        return isRate;
    }

    private Map<Long, Integer> getAllDistributePerm(String entityName, long dimensionId, Object modelId, Collection<IDNumberTreeNode> dyns, long userId) {
        return (Map)ThreadCache.get((Object)Joiner.on((char)'-').join((Object)entityName, (Object)dimensionId, new Object[]{modelId, "all_distribute_perm"}), () -> {
            Map<Long, Integer> memberPerm = this.getDistributeMemberPerm(entityName, dimensionId, modelId, userId);
            Set<Long> orgIds = dyns.stream().map(IDNumberTreeNode::getId).collect(Collectors.toSet());
            this.addPermClass(orgIds, memberPerm, modelId, entityName);
            return memberPerm;
        });
    }

    public Map<Long, Integer> getDistributeMemberPerm(String entityName, long dimensionId, Object modelId, long loginUserId) {
        return (Map)ThreadCache.get((Object)Joiner.on((char)'-').join((Object)entityName, (Object)dimensionId, new Object[]{modelId, PermCacheKey.DISTRIBUTE_MEMBER_PERM}), () -> {
            DynamicObjectCollection doc = this.getAllMemberPerms(entityName, dimensionId, loginUserId);
            return this.buildMemberPerm((List<DynamicObject>)doc, entityName, modelId);
        });
    }

    public Map<Integer, Set<Long>> getCommonPermissions(String entityName, long dimensionId, Object modelId, List<PermEnum> permEnums, long userId) {
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)16);
        for (PermEnum permEnum : permEnums) {
            returnMap.put(permEnum.getValue(), Sets.newHashSetWithExpectedSize((int)16));
        }
        boolean isAdmin = this.ifUserHasRootPermByModel(userId, String.valueOf(modelId));
        if (isAdmin && !permEnums.contains(PermEnum.READWRITE)) {
            return returnMap;
        }
        Collection dyns = MemberReader.getAllNodeByDimNum((String)MemberReader.getDimensionNumById((long)dimensionId), (String)MemberReader.findModelNumberById((Object)modelId));
        if (isAdmin) {
            returnMap.put(PermEnum.READWRITE.getValue(), dyns.stream().map(IDNumberTreeNode::getId).collect(Collectors.toSet()));
            return returnMap;
        }
        Map<Long, Integer> memberPerm = this.getAllDistributePerm(entityName, dimensionId, modelId, dyns, userId);
        int defPermValue = this.getDefaultPermValue(dimensionId);
        this.buildReturnMap(entityName, returnMap, dyns, memberPerm, defPermValue);
        return returnMap;
    }

    private void buildReturnMap(String entityName, Map<Integer, Set<Long>> returnMap, Collection<IDNumberTreeNode> dyns, Map<Long, Integer> memberPerm, int defPermValue) {
        for (IDNumberTreeNode dyn : dyns) {
            Integer perm;
            boolean isRate = this.isRate(entityName, dyn);
            if (isRate) {
                if (!returnMap.containsKey(PermEnum.READWRITE.getValue())) continue;
                returnMap.computeIfPresent(PermEnum.READWRITE.getValue(), (k, v) -> {
                    v.add(dyn.getId());
                    return v;
                });
                continue;
            }
            Integer n = perm = Objects.equals(dyn.getCopyfromId(), this.DEFAULT_COPY_VALUE) ? memberPerm.get(dyn.getId()) : memberPerm.get(dyn.getCopyfromId());
            if (Objects.nonNull(perm)) {
                if (!returnMap.containsKey(perm)) continue;
                returnMap.computeIfPresent(perm, (k, v) -> {
                    v.add(dyn.getId());
                    return v;
                });
                continue;
            }
            if (!returnMap.containsKey(defPermValue)) continue;
            returnMap.computeIfPresent(defPermValue, (k, v) -> {
                v.add(dyn.getId());
                return v;
            });
        }
    }

    private void asignMemberPerm(String entityName, Map<Long, Integer> memberPerm, int defPermValue, long dimensionId, Object modelid) {
        Collection dyns = MemberReader.getAllNodeByDimNum((String)MemberReader.getDimensionNumById((long)dimensionId), (String)MemberReader.findModelNumberById((Object)modelid));
        Set<Long> orgIds = dyns.stream().map(dyn -> dyn.getId()).collect(Collectors.toSet());
        this.addPermClass(orgIds, memberPerm, modelid, entityName);
        for (IDNumberTreeNode dyn2 : dyns) {
            boolean isRate = this.isRate(entityName, dyn2);
            if (isRate) {
                memberPerm.put(dyn2.getId(), 1);
                continue;
            }
            Long baseId = dyn2.getCopyfromId() != 0L ? dyn2.getCopyfromId() : dyn2.getId();
            memberPerm.put(dyn2.getId(), memberPerm.getOrDefault(baseId, defPermValue));
        }
    }

    public Map<Long, Integer> buildMemberPerm(List<DynamicObject> doc, String entityName, Object modelid) {
        HashMap<Long, Integer> memberPerm = new HashMap<Long, Integer>();
        Set<Object> allOrgIds = new HashSet();
        for (DynamicObject dd : doc) {
            long memberId = dd.getLong("member.id");
            int range = dd.getInt("range");
            int permission = dd.getInt("permission");
            boolean isCus = dd.getBoolean("iscustomprop");
            String number = dd.getString(NUMBER);
            allOrgIds = isCus ? QueryMemberDetailsHelper.getMemberIdsByDefinedRange(entityName, memberId, number, range, String.valueOf(modelid), DetailTypeEnum.MEMBERPERM) : ("bcm_structofextend".equals(entityName) ? QueryMemberDetailsHelper.queryMemberIdsByRangeOfExt(entityName, memberId, range, String.valueOf(modelid), DetailTypeEnum.MEMBERPERM) : QueryMemberDetailsHelper.queryMemberIdsByRange(entityName, memberId, range, String.valueOf(modelid), DetailTypeEnum.MEMBERPERM));
            if ("bcm_entitymembertree".equals(entityName)) {
                allOrgIds = this.getOrgRangeBaseMember(allOrgIds, modelid);
            }
            this.putData2Map(allOrgIds, permission, memberPerm);
        }
        return memberPerm;
    }

    private Set<Long> getOrgRangeBaseMember(Set<Long> allOrgIds, Object modelid) {
        return MemberReader.change2BaseMember((long)Long.parseLong(modelid.toString()), (String)"bcm_entitymembertree", allOrgIds);
    }

    public int getDefaultPermValue(Object dimensionId) {
        return (Integer)ThreadCache.get((Object)Joiner.on((char)'_').join(dimensionId, (Object)"default_perm", new Object[0]), () -> this.getDefaultPermValueFormDb(dimensionId));
    }

    private int getDefaultPermValueFormDb(Object dimensionId) {
        DynamicObject dy;
        if (dimensionId instanceof String) {
            dimensionId = Long.valueOf(dimensionId.toString());
        }
        return (dy = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"isuseddataperm", (QFilter[])new QFilter[]{new QFilter(ID, "=", dimensionId)})) != null ? dy.getInt("isuseddataperm") : 1;
    }

    public int getDefaultPermValue(long modelId, long dimensionId) {
        return (Integer)((Map)GlobalCacheServiceHelper.getOrLoadNodeFixKey((String)("getDefaultPermValue" + modelId), () -> {
            HashMap map = new HashMap(16);
            QueryServiceHelper.query((String)"bcm_dimension", (String)"id,isuseddataperm", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)modelId)}).forEach(e -> map.put(e.getLong(ID), e.getInt("isuseddataperm")));
            return map;
        })).get(dimensionId);
    }

    private Collection<DynamicObject> getAllMemberDatas(String entityName, Object dimensionId) {
        QFilter filter = new QFilter("dimension", "=", dimensionId);
        ExchageRateServiceHelper.delExchangeRatePlanFilter(filter, entityName);
        return BusinessDataServiceHelper.loadFromCache((String)entityName, (String)"id,number,storagetype,member.id", (QFilter[])new QFilter[]{filter}).values();
    }

    private DynamicObjectCollection getAllMemberPerms(String entityName, Object dimensionId) {
        long loginUserId = Long.parseLong(RequestContext.get().getUserId());
        return this.getAllMemberPerms(entityName, dimensionId, loginUserId);
    }

    public DynamicObjectCollection getFidmModelAdmin(QFilter[] filters) {
        List filterVal = Arrays.stream(filters).map(QFilter::getValue).collect(Collectors.toList());
        return (DynamicObjectCollection)ThreadCache.get((Object)Joiner.on((char)'-').join(filterVal, (Object)"fidm_admin", new Object[0]), () -> QueryServiceHelper.query((String)"bcm_modelperm", (String)"fidmmodel.id", (QFilter[])filters));
    }

    public boolean getFidmModelSuperAdmin(String application) {
        DynamicObject[] dynamicObjects;
        DynamicObject managerRole = null;
        if (ApplicationTypeEnum.FIDM.appnum.equals(application)) {
            managerRole = BusinessDataServiceHelper.loadSingle((String)"bcm_perm_role", (String)"id,enable,bizdomain", (QFilter[])new QFilter(NUMBER, "=", (Object)ROLEADMINFIDM).and("enable", "=", (Object)true).toArray());
        } else if (ApplicationTypeEnum.FAR.appnum.equals(application)) {
            managerRole = BusinessDataServiceHelper.loadSingle((String)"bcm_perm_role", (String)"id,enable,bizdomain", (QFilter[])new QFilter(NUMBER, "=", (Object)ROLEADMINFAR).and("enable", "=", (Object)true).toArray());
        }
        if (managerRole == null) {
            return false;
        }
        RequestContext tx = RequestContext.get();
        long userId = Long.parseLong(tx.getUserId());
        String id = managerRole.getString(ID);
        return StringUtils.isNotEmpty((CharSequence)id) && (dynamicObjects = BusinessDataServiceHelper.load((String)"perm_userrole", (String)USER, (QFilter[])new QFilter("role", "=", (Object)id).and(new QFilter(USER, "=", (Object)userId)).toArray())) != null && dynamicObjects.length > 0;
    }

    private DynamicObjectCollection getAllMemberPerms(String entityName, Object dimensionId, long loginUserId) {
        Set<Long> groupIds = UserDistributeServiceHelper.queryAllGroupByUserId(loginUserId);
        groupIds.add(loginUserId);
        QFilter filter1 = new QFilter("membertype", "=", (Object)entityName);
        QFilter filter2 = new QFilter("dimension", "=", (Object)LongUtil.toLong((Object)dimensionId));
        QFilter filter3 = new QFilter("users", "in", (Object)groupIds.toArray());
        QFilter[] filters = new QFilter[]{filter1, filter2, filter3};
        return this.getAllMemberPerms(entityName, filters);
    }

    public DynamicObjectCollection getAllMemberPerms(String entityName, QFilter[] filters) {
        String selectFields = "membertype,model.id,member,member.id,member.number as number,member.storagetype as storagetype,range,permission,iscustomprop,users,usertype";
        DynamicObjectCollection doc = new DynamicObjectCollection();
        doc.addAll((Collection)QueryServiceHelper.query((String)"bcm_memberperm", (String)selectFields, (QFilter[])filters));
        HashMap numbers = new HashMap();
        doc.forEach(d -> numbers.put(d.getLong("member"), null));
        Map mems = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)"id,number", (QFilter[])new QFilter[]{new QFilter(ID, "in", numbers.keySet())});
        Map pros = BusinessDataServiceHelper.loadFromCache((String)"bcm_definedpropertyvalue", (String)"id,number", (QFilter[])new QFilter[]{new QFilter(ID, "in", numbers.keySet())});
        mems.values().forEach(m -> numbers.put(m.getLong(ID), m.getString(NUMBER)));
        pros.values().forEach(m -> numbers.put(m.getLong(ID), m.getString(NUMBER)));
        doc.forEach(d -> {
            d.set(NUMBER, numbers.get(d.getLong("member")));
            d.set("member.id", d.get("member"));
        });
        return doc;
    }

    public DynamicObject[] getUserDispPerms(Object dimensionId, long userId) {
        Set<Long> groupIds = UserDistributeServiceHelper.queryAllGroupByUserId(userId);
        groupIds.add(userId);
        String selectFields = "membertype,member,member.id,member.number,member.longnumber,range,permission,iscustomprop,id";
        QFilter filter2 = new QFilter("dimension", "=", dimensionId);
        QFilter filter3 = new QFilter("users", "in", (Object)groupIds.toArray());
        QFilter[] filters = new QFilter[]{filter2, filter3};
        DynamicObjectCollection allPerm = (DynamicObjectCollection)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)("bcm_memberperm_" + dimensionId + "_" + groupIds.toString()), () -> QueryServiceHelper.query((String)"bcm_memberperm", (String)selectFields, (QFilter[])filters, null));
        DynamicObject[] allPerms = new DynamicObject[allPerm.size()];
        ArrayList<Object> ids = new ArrayList<Object>();
        HashMap cusDynaMap = new HashMap();
        int i = 0;
        for (DynamicObject d : allPerm) {
            d.set("member.id", d.get("member"));
            if (d.getBoolean("iscustomprop")) {
                ids.add(d.get(ID));
            }
            allPerms[i++] = d;
        }
        if (!ids.isEmpty()) {
            DynamicObjectCollection cusDynas = QueryServiceHelper.query((String)"bcm_memberperm", (String)"id,member", (QFilter[])new QFilter[]{new QFilter(ID, "in", (Object)ids.toArray())});
            ids.clear();
            HashMap perm2CusMap = new HashMap();
            cusDynas.forEach(e -> {
                ids.add(e.get("member"));
                perm2CusMap.put(e.get(ID), e.get("member"));
            });
            if (!ids.isEmpty()) {
                ORM orm = ORM.create();
                cusDynas = QueryServiceHelper.query((String)"bcm_definedpropertyvalue", (String)"id,longnumber,number", (QFilter[])new QFilter[]{new QFilter(ID, "in", (Object)ids.toArray())});
                cusDynas.forEach(e -> cusDynaMap.put(e.get(ID), e));
                for (DynamicObject d : allPerms) {
                    DynamicObject cusDyna;
                    if (!perm2CusMap.containsKey(d.get(ID)) || (cusDyna = (DynamicObject)cusDynaMap.get(perm2CusMap.get(d.get(ID)))) == null) continue;
                    d.set("member.id", cusDyna.get(ID));
                    d.set("member.number", cusDyna.get(NUMBER));
                    d.set("member.longnumber", cusDyna.get("longnumber"));
                }
            }
        }
        return allPerms;
    }

    private void putData2Map(Set<Long> ids, int permission, Map<Long, Integer> memberPerm) {
        ids.forEach(p -> {
            Integer value = memberPerm.put((Long)p, permission);
            if (value != null) {
                memberPerm.put((Long)p, value > permission ? value : permission);
            }
        });
        ids.clear();
    }

    boolean memberCanShow(Object memberId, PermPackageList perms, Map<Long, List<Long>> relationMap) {
        if (memberId == null || perms == null) {
            return false;
        }
        PermEnum permEnum = perms.getPermEnum(LongUtil.toLong((Object)memberId));
        if (permEnum == null) {
            return false;
        }
        if (permEnum.getValue() < PermEnum.NOPERM.getValue()) {
            return true;
        }
        if (relationMap.get(memberId) != null) {
            for (long id : relationMap.get(memberId)) {
                if (!this.memberCanShow(id, perms, relationMap)) continue;
                return true;
            }
        }
        return false;
    }

    Map<Long, List<Long>> BuildPCRelation(DynamicObjectCollection doc) {
        HashMap<Long, List<Long>> relationMap = new HashMap<Long, List<Long>>();
        doc.forEach(p -> {
            long parentId;
            long id = p.getLong(ID);
            long l = parentId = p.get("parent") instanceof DynamicObject ? p.getLong("parent_id") : p.getLong("parent");
            if (relationMap.get(parentId) != null) {
                ((List)relationMap.get(parentId)).add(id);
            } else {
                ArrayList<Long> children = new ArrayList<Long>();
                children.add(id);
                relationMap.put(parentId, children);
            }
        });
        return relationMap;
    }

    Map<Long, List<Long>> BuildPCRelation(List<Map<String, String>> treeList) {
        HashMap<Long, List<Long>> relationMap = new HashMap<Long, List<Long>>();
        treeList.forEach(p -> {
            long id = Long.parseLong((String)p.get(ID));
            long parentId = Long.parseLong((String)p.get("parentid"));
            if (relationMap.get(parentId) != null) {
                ((List)relationMap.get(parentId)).add(id);
            } else {
                ArrayList<Long> children = new ArrayList<Long>();
                children.add(id);
                relationMap.put(parentId, children);
            }
        });
        return relationMap;
    }

    Map<Long, List<Long>> getPCRelationByEntity(String entityName, Object dimensionId) {
        QFilter filter = new QFilter("dimension", "=", dimensionId);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)entityName, (String)"id,parent", (QFilter[])new QFilter[]{filter});
        return this.BuildPCRelation(doc);
    }

    Map<Long, Integer> getCslMemberPermission(String entityName, Long modelid, DynamicObjectCollection queryNodes) {
        HashMap<Long, Integer> permMap = new HashMap<Long, Integer>();
        Map<Long, DynamicObject> cslMap = queryNodes.stream().collect(Collectors.toMap(x -> x.getLong(ID), x -> x));
        this.addPermClass(cslMap.keySet(), permMap, modelid, entityName);
        boolean adminUserBol = this.ifUserHasRootPermByModel(Long.parseLong(RequestContext.get().getUserId()), modelid.toString());
        if (adminUserBol) {
            permMap.forEach((k, v) -> permMap.put((Long)k, 1));
        }
        return permMap;
    }

    public DynamicObjectCollection getDiscModelAdmin(Set<Long> modelIds, String appType) {
        String fields = "fidmmodel.id,username";
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bcm_modelperm", (String)fields, (QFilter[])new QFilter[]{new QFilter("fidmmodel.id", "in", modelIds).and(new QFilter("app", "=", (Object)appType))});
        return dynamicObjectCollection;
    }

    public boolean isModelManager(Long modelId) {
        Set<Long> ids = this.getLimitedModelListByUser();
        return ids.contains(modelId);
    }

    public Set<Long> getLimitedModelListByUser() {
        return this.getLimitedModelListByUser(null);
    }

    public Set<Long> getLimitedModelListByUser(ApplicationTypeEnum application) {
        return this.getLimitedModelListByUser(application, false, true);
    }

    public Set<Long> getLimitedModelListByUser(ApplicationTypeEnum application, Boolean ifCheckManager, Boolean isCheckStatus) {
        RequestContext tx = RequestContext.get();
        long userId = Long.parseLong(tx.getUserId());
        return (Set)ThreadCache.get((Object)("limit_model_" + userId + application + ifCheckManager + isCheckStatus), () -> {
            DynamicObjectCollection dys;
            Set<Object> modelIds = new HashSet();
            Set<Long> groupIds = UserDistributeServiceHelper.queryAllGroupByUserId(userId);
            groupIds.add(userId);
            QFilter filter = new QFilter("modelpermentry.eusers", "in", (Object)groupIds.toArray());
            if (application != null) {
                filter = this.getIsManagerQFilter(application, ifCheckManager, filter);
                if (application == ApplicationTypeEnum.RPT) {
                    filter.and(new QFilter("model.reporttype", "in", (Object)new String[]{ApplicationTypeEnum.RPT.index, ApplicationTypeEnum.CM.index, ApplicationTypeEnum.PUB.index}));
                } else if (application == ApplicationTypeEnum.DI) {
                    filter.and(new QFilter("model.reporttype", "=", (Object)ApplicationTypeEnum.CM.index));
                } else if (application == ApplicationTypeEnum.BGMD) {
                    filter.and(new QFilter("model.reporttype", "in", (Object)new String[]{ApplicationTypeEnum.BGMD.index, ApplicationTypeEnum.EB.index, "6"}));
                } else if (application != ApplicationTypeEnum.BGBD) {
                    filter.and(new QFilter("model.reporttype", "=", (Object)application.index));
                }
                if (isCheckStatus.booleanValue()) {
                    filter.and(new QFilter("model.status", "=", (Object)ModelStatusEnum.AUDIT.getValue()));
                }
            }
            QFilter[] filters = this.getRptModelQFilter(filter);
            String entityname = "bcm_modelperm";
            if (application == ApplicationTypeEnum.BGMD) {
                entityname = "epm_modelperm";
            }
            if (!CollectionUtils.isEmpty((Collection)(dys = QueryServiceHelper.query((String)entityname, (String)"model.id", (QFilter[])filters)))) {
                modelIds = dys.stream().filter(dy -> dy.getLong("model.id") != 0L).map(dy -> dy.getLong("model.id")).collect(Collectors.toSet());
            }
            return modelIds;
        });
    }

    public QFilter getIsManagerQFilter(ApplicationTypeEnum application, Boolean ifCheckManager, QFilter filter) {
        if (ifCheckManager != null && ifCheckManager.booleanValue() && this.isManager(application)) {
            filter = new QFilter("modelpermentry.eusers", ">", (Object)0L);
        }
        return filter;
    }

    private QFilter[] getRptModelQFilter(QFilter filter) {
        return new QFilter[]{filter};
    }

    public boolean isManager(ApplicationTypeEnum application, String formId) {
        if ("bcm_modelperm_manager".equals(formId) || "report_modelperm_manager".equals(formId)) {
            return this.isManager(application);
        }
        return false;
    }

    public boolean isManager(ApplicationTypeEnum application) {
        DynamicObject managerRole = null;
        if (ApplicationTypeEnum.CM == application) {
            managerRole = BusinessDataServiceHelper.loadSingle((String)"bcm_perm_role", (String)"id,enable,bizdomain", (QFilter[])new QFilter(NUMBER, "=", (Object)ROLEADMINBCM).and("enable", "=", (Object)true).toArray());
        } else if (ApplicationTypeEnum.RPT == application) {
            managerRole = BusinessDataServiceHelper.loadSingle((String)"bcm_perm_role", (String)"id,enable,bizdomain", (QFilter[])new QFilter(NUMBER, "=", (Object)ROLEADMINRPT).and("enable", "=", (Object)true).toArray());
        }
        if (managerRole == null) {
            return false;
        }
        RequestContext tx = RequestContext.get();
        long userId = Long.parseLong(tx.getUserId());
        String id = managerRole.getString(ID);
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            boolean existUser = QueryServiceHelper.exists((String)"perm_userrole", (QFilter[])new QFilter("role", "=", (Object)id).and(new QFilter(USER, "=", (Object)userId)).toArray());
            return existUser;
        }
        return false;
    }

    public boolean ifUserHasRootPermByModel(long userId, String modelId) {
        return (Boolean)ThreadCache.get((Object)Joiner.on((char)'-').join((Object)modelId, (Object)userId, new Object[]{"check_admin"}), () -> this.ifUserHasRootPermByModelFromDb(userId, modelId));
    }

    public boolean ifUserHasRootPermByModelFromDb(long userId, String modelId) {
        String isGalaxySystem = System.getProperty(ISGALAXYSYSTEM);
        if (isGalaxySystem != null && isGalaxySystem.equalsIgnoreCase("true")) {
            return false;
        }
        Set<Long> groupIds = UserDistributeServiceHelper.queryAllGroupByUserId(userId);
        groupIds.add(userId);
        QFilter filter1 = new QFilter(MODEL, "=", (Object)ConvertUtil.convertStrToLong(modelId));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"MemberPermSpreadLogic.ifUserHasRootPermByModel", (String)"bcm_modelperm", (String)"id,modelpermentry.eusers.id", (QFilter[])new QFilter[]{filter1}, null);){
            for (Row row : ds) {
                if (!groupIds.contains(row.getLong(MODEL_PERM_ENTRY_EUSERS_ID))) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public Set<Long> checkUsersIsAdmin(Set<Long> userIds, long modelId) {
        Set<Long> longs;
        List<DynamicObject> userGrps;
        String isGalaxySystem = System.getProperty(ISGALAXYSYSTEM);
        if (isGalaxySystem != null && isGalaxySystem.equalsIgnoreCase(Boolean.TRUE.toString())) {
            Collections.emptySet();
        }
        QFBuilder qfBuilder = new QFBuilder(MODEL, "=", (Object)modelId);
        qfBuilder.and("fidmmodel", "=", (Object)0L);
        Map<Object, List<DynamicObject>> collect = QueryServiceHelper.query((String)"bcm_modelperm", (String)ADMIN_BY_USER_FIELD, (QFilter[])qfBuilder.toArray()).stream().collect(Collectors.groupingBy(t -> t.getString("modelpermentry.etype")));
        HashSet res = Sets.newHashSetWithExpectedSize((int)16);
        List<DynamicObject> users = collect.get(UserTypeEnum.USER.getName());
        Set uIds = null;
        if (!CollectionUtils.isEmpty(users)) {
            uIds = users.stream().map(t -> t.getLong(MODEL_PERM_ENTRY_EUSERS_ID)).collect(Collectors.toSet());
            res.addAll(uIds);
        }
        if (!CollectionUtils.isEmpty(userGrps = collect.get(UserTypeEnum.USERGROUP.getName())) && !CollectionUtils.isEmpty(longs = UserDistributeServiceHelper.queryAllGroupByUserId(userGrps.stream().map(t -> t.getLong(MODEL_PERM_ENTRY_EUSERS_ID)).collect(Collectors.toSet())))) {
            res.addAll(longs);
        }
        return res;
    }

    public Map<String, Set<Long>> getHasPermByNumber(Long modelId, String entityName, String dimNum, List<String> numbers) {
        HashMap returnMap = Maps.newHashMap();
        HashSet emptySet = Sets.newHashSet();
        HashMap numberIdMap = Maps.newHashMap();
        this.buildNumberMap(modelId, dimNum, numbers, numberIdMap);
        if (CollectionUtils.isEmpty((Map)numberIdMap)) {
            return returnMap;
        }
        HashMap permClassMap = Maps.newHashMap();
        HashSet groupIds = Sets.newHashSet();
        Map<Long, List<DynamicObject>> authRecords = this.getDataAuthRecord(modelId, entityName, numberIdMap.values(), groupIds, permClassMap);
        QFBuilder qfBuilder = new QFBuilder(MODEL, "=", (Object)modelId);
        qfBuilder.and(new QFilter("membertype", "=", (Object)entityName));
        DynamicObjectCollection allMemberPerms = (DynamicObjectCollection)ThreadCache.get((Object)Joiner.on((char)'-').join((Object)entityName, (Object)modelId, new Object[]{"single_dim_distribe_perm"}), () -> this.getAllMemberPerms(entityName, qfBuilder.toArray()));
        groupIds.addAll(allMemberPerms.stream().filter(t -> UserTypeEnum.USERGROUP.getName().equals(t.getString("usertype"))).map(t -> t.getLong("users")).collect(Collectors.toSet()));
        Set<Long> hasFunPermIds = this.getPermUserIdByModelId(modelId);
        Map<Long, Set<Long>> groupMap = this.buildUserGroupUserMap(groupIds);
        for (Map.Entry entry : numberIdMap.entrySet()) {
            HashMap noPermMap = Maps.newHashMap();
            HashMap hasPermMap = Maps.newHashMap();
            List<DynamicObject> records = authRecords.get(entry.getValue());
            if (permClassMap.get(entry.getValue()) != null && CollectionUtils.isEmpty(records)) {
                returnMap.put(entry.getKey(), emptySet);
                continue;
            }
            this.dataAuthHandler(noPermMap, hasPermMap, records);
            this.memberPermHandler(modelId, entityName, (Long)entry.getValue(), noPermMap, hasPermMap, allMemberPerms);
            Set noPermIds = noPermMap.getOrDefault(UserTypeEnum.USER.getName(), emptySet);
            Set hasPermIds = hasPermMap.getOrDefault(UserTypeEnum.USER.getName(), emptySet);
            for (Long groupId : (Set)noPermMap.getOrDefault(UserTypeEnum.USERGROUP.getName(), emptySet)) {
                noPermIds.addAll((Collection)groupMap.getOrDefault(groupId, emptySet));
            }
            for (Long groupId : (Set)hasPermMap.getOrDefault(UserTypeEnum.USERGROUP.getName(), emptySet)) {
                hasPermIds.addAll((Collection)groupMap.getOrDefault(groupId, emptySet));
            }
            hasPermIds.removeAll(noPermIds);
            hasPermIds.retainAll(hasFunPermIds);
            returnMap.put(entry.getKey(), hasPermIds);
        }
        return returnMap;
    }

    private void buildNumberMap(Long modelId, String dimNum, List<String> numbers, Map<String, Long> numberIdMap) {
        for (String number : numbers) {
            IDNumberTreeNode memberByNumber = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelId), (String)dimNum, (String)number);
            if (Objects.equals(IDNumberTreeNode.NotFoundTreeNode, memberByNumber)) continue;
            numberIdMap.put(number, memberByNumber.getId());
        }
    }

    private void memberPermHandler(Long modelId, String entityName, Long memberId, Map<String, Set<Long>> noPermMap, Map<String, Set<Long>> hasPermMap, DynamicObjectCollection allMemberPerms) {
        Map<String, List<DynamicObject>> map = allMemberPerms.stream().collect(Collectors.groupingBy(memberPerm -> new StringJoiner(SEPARATOR).add(memberPerm.getString("usertype")).add(memberPerm.getString("users")).toString()));
        for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
            Map permMap;
            Integer perm;
            String[] split = entry.getKey().split(SEPARATOR);
            if (split.length < 2) continue;
            Long userId = LongUtil.toLong((Object)split[1]);
            String userType = split[0];
            Set<Long> noPermIds = noPermMap.get(userType);
            if (!CollectionUtils.isEmpty(noPermIds) && noPermIds.contains(userId) || (perm = (Integer)(permMap = (Map)ThreadCache.get((Object)Joiner.on((char)'-').join((Object)entry.getKey(), (Object)entityName, new Object[]{modelId, "build_perm_map"}), () -> this.buildMemberPerm((List)entry.getValue(), entityName, modelId))).get(memberId)) == null) continue;
            if (perm.intValue() == PermEnum.READWRITE.getValue()) {
                hasPermMap.computeIfAbsent(userType, k -> new HashSet()).add(userId);
                continue;
            }
            noPermMap.computeIfAbsent(userType, k -> new HashSet()).add(userId);
        }
    }

    private void dataAuthHandler(Map<String, Set<Long>> noPermMap, Map<String, Set<Long>> hasPermMap, List<DynamicObject> authRecords) {
        if (CollectionUtils.isEmpty(authRecords)) {
            return;
        }
        authRecords.forEach(auth -> {
            long users = auth.getLong("users");
            int perm = auth.getInt("data_auth");
            String userType = auth.getString("usertype");
            perm = 4 - perm;
            if (PermEnum.READWRITE.getValue() == perm) {
                hasPermMap.computeIfAbsent(userType, k -> new HashSet()).add(users);
            } else {
                noPermMap.computeIfAbsent(userType, k -> new HashSet()).add(users);
            }
        });
    }

    private Map<Long, List<DynamicObject>> getDataAuthRecord(Long modelId, String entityName, Collection<Long> memberIds, Set<Long> groupIds, Map<Long, Long> permClassMap) {
        QFBuilder qfBuilder = new QFBuilder(MODEL, "=", (Object)modelId);
        qfBuilder.and(new QFilter("entityname", "=", (Object)entityName));
        qfBuilder.and(new QFilter("entityid", "in", memberIds));
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_permclass_entity", (String)"entityid,permclass.id", (QFilter[])qfBuilder.toArray());
        if (CollectionUtils.isEmpty((Collection)dys)) {
            return Collections.emptyMap();
        }
        permClassMap.putAll(dys.stream().collect(Collectors.toMap(t -> t.getLong("entityid"), t -> t.getLong("permclass.id"), (t1, t2) -> t2)));
        QFBuilder qfBuilder2 = new QFBuilder(MODEL, "=", (Object)modelId);
        qfBuilder2.and(new QFilter("authclass", "in", permClassMap.values()));
        String selectFields = "users,usertype,authclass,data_auth";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_auth_info", (String)selectFields, (QFilter[])qfBuilder2.toArray());
        Map<Long, List<DynamicObject>> authclass = query.stream().collect(Collectors.groupingBy(t -> t.getLong("authclass")));
        groupIds.addAll(query.stream().filter(t -> UserTypeEnum.USERGROUP.getName().equals(t.getString("usertype"))).map(t -> t.getLong("users")).collect(Collectors.toSet()));
        HashMap maps = Maps.newHashMapWithExpectedSize((int)permClassMap.size());
        for (Map.Entry<Long, Long> entry : permClassMap.entrySet()) {
            maps.put(entry.getKey(), authclass.getOrDefault(entry.getValue(), Lists.newArrayList()));
        }
        return maps;
    }

    private Map<Long, Set<Long>> buildUserGroupUserMap(Set<Long> groupIds) {
        String selectFields = "user.id,usergroup.id";
        DynamicObjectCollection usergroup = QueryServiceHelper.query((String)"bos_usergroupstaff", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("usergroup", "in", groupIds)});
        return usergroup.stream().collect(Collectors.groupingBy(t -> t.getLong("usergroup.id"), Collectors.mapping(dy -> dy.getLong("user.id"), Collectors.toSet())));
    }

    private Set<Long> getPermUserIdByModelId(Long modelid) {
        QFBuilder qb = new QFBuilder(ORG, "=", (Object)modelid);
        qb.add(new QFilter(DIMTYPE, "=", (Object)DIM_BCM_MODEL));
        String selectField = "org,user";
        DynamicObjectCollection records = QueryServiceHelper.query((String)"perm_userperm", (String)selectField, (QFilter[])qb.toArray());
        QFBuilder qfBuilder = new QFBuilder(ORG, "=", (Object)modelid);
        DynamicObjectCollection roleUser = QueryServiceHelper.query((String)"perm_userrole", (String)selectField, (QFilter[])qfBuilder.toArray());
        Set<Object> ids = DynamicObjectCollectionUtil.getFieldSet(records, USER);
        ids.addAll(DynamicObjectCollectionUtil.getFieldSet(roleUser, USER));
        return ids.stream().map(LongUtil::toLong).collect(Collectors.toSet());
    }
}

