/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.exception.KDBizException;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexFactory;
import kd.fi.bcm.common.FiBcmErrorCode;

public class MutexServiceHelper {
    public static final String MUTEX_DATAOBJID = "dataObjId";
    public static final String MUTEX_GROUPID = "groupId";
    public static final String MUTEX_ENTITYKEY = "entityKey";
    public static final String MUTEX_OPERATIONKEY = "operationKey";

    public static Map<String, Boolean> batchRequest(Set<String> keys, String entityKey, String opKey) {
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(16);
        String group = "op_" + opKey;
        ArrayList mutexRequireList = new ArrayList(keys.size());
        for (String key : keys) {
            HashMap<String, String> requireParam = new HashMap<String, String>();
            requireParam.put(MUTEX_DATAOBJID, key);
            requireParam.put(MUTEX_GROUPID, group);
            requireParam.put(MUTEX_ENTITYKEY, entityKey);
            requireParam.put(MUTEX_OPERATIONKEY, opKey);
            mutexRequireList.add(requireParam);
            if (mutexRequireList.size() <= 800) continue;
            try {
                DataMutex dataMutex = MutexFactory.createDataMutex();
                Throwable throwable = null;
                try {
                    resultMap.putAll(dataMutex.batchrequire(mutexRequireList));
                    mutexRequireList.clear();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dataMutex == null) continue;
                    if (throwable != null) {
                        try {
                            dataMutex.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dataMutex.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("accure IOException when closing data mutex!", e);
            }
        }
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            resultMap.putAll(dataMutex.batchrequire(mutexRequireList));
        }
        catch (IOException e) {
            throw new RuntimeException("accure IOException when closing data mutex!", e);
        }
        return resultMap;
    }

    public static Map<String, Boolean> batchRelease(List<String> ids, String entityKey, String opKey) {
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(16);
        String group = "op_" + opKey;
        ArrayList mutexRequireList = new ArrayList(ids.size());
        for (int index = 0; index < ids.size(); ++index) {
            HashMap<String, String> requireParam = new HashMap<String, String>();
            requireParam.put(MUTEX_DATAOBJID, ids.get(index));
            requireParam.put(MUTEX_GROUPID, group);
            requireParam.put(MUTEX_ENTITYKEY, entityKey);
            requireParam.put(MUTEX_OPERATIONKEY, opKey);
            mutexRequireList.add(requireParam);
            if (mutexRequireList.size() <= 800) continue;
            try (DataMutex dataMutex = MutexFactory.createDataMutex();){
                resultMap.putAll(dataMutex.batchRelease(mutexRequireList));
                mutexRequireList.clear();
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("accure IOException when closing data mutex!", e);
            }
        }
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            resultMap.putAll(dataMutex.batchRelease(mutexRequireList));
        }
        catch (IOException e) {
            throw new RuntimeException("accure IOException when closing data mutex!", e);
        }
        return resultMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean request(String id, String entityKey, String opKey) {
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            boolean bl = dataMutex.require(id, "op_" + opKey, entityKey, opKey, true);
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException("accure IOException when closing data mutex!", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean release(String id, String entityKey, String operationKey) {
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            boolean bl = dataMutex.release(id, entityKey, operationKey);
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException("accure IOException when closing data mutex!", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getLockInfo(String id, String entityKey, String opKey) {
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            Map map = dataMutex.getLockInfo(id, "op_" + opKey, entityKey);
            return map;
        }
        catch (IOException e) {
            throw new RuntimeException("accure IOException when closing data mutex!", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean forceRelease(String id, String entityKey, String operationKey) {
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            boolean bl = dataMutex.forcerelease(id, entityKey, operationKey);
            return bl;
        }
        catch (IOException e) {
            throw new KDBizException((Throwable)e, FiBcmErrorCode.create((String)"fi.bcm.forceReleaseLockFailed"), new Object[]{id, entityKey, operationKey});
        }
    }
}

