/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.business.task.MyTaskServiceHelper;
import kd.fi.bcm.business.util.TemplateDistributionOrgUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.enums.TaskStatusEnum;
import kd.fi.bcm.common.enums.TaskTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.PeriodUtils;

public class MyTaskStatusHelper {
    public static final String COMPLETE_KEY = "itemmark";
    public static final String UNCOMPLETE_KEY = "itemunmark";

    public static void refreshTaskStatusRecord4Model(String model) {
        String selectFields = "template";
        QFilter modelFilter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)model));
        QFilter[] filters = new QFilter[]{modelFilter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_distributionentity", (String)selectFields, (QFilter[])filters);
        if (dcs == null || dcs.size() <= 0) {
            return;
        }
        HashSet<Long> templetes = new HashSet<Long>();
        Long[] templeteids = new Long[]{};
        for (DynamicObject doc : dcs) {
            templetes.add(doc.getLong("template"));
        }
        templeteids = templetes.toArray(templeteids);
        MyTaskStatusHelper.refreshTaskStatusRecord4TempleteID(templeteids);
    }

    public static void refreshTaskStatusRecord4TempleteID(Long[] templateids) {
        StringBuilder query4Task = new StringBuilder();
        query4Task.append("select distinct fid from t_bcm_taskdisptem where ftemplateId in  (").append(MyTaskStatusHelper.genUniqueLongKey(templateids)).append(')');
        HashSet<Long> taskids = new HashSet<Long>();
        try (DataSet result = DB.queryDataSet((String)"MyTaskStatusHelper", (DBRoute)BCMConstant.DBROUTE, (String)query4Task.toString(), null);){
            for (Row memberRow : result) {
                Long id = memberRow.getLong("fid");
                taskids.add(id);
            }
        }
        MyTaskStatusHelper.refreshTaskStatusRecord4TaskId(taskids, true);
    }

    public static void refreshTaskStatusRecord4OrgIDs(Long[] orgIds) {
        DBRoute dbRoute = new DBRoute("bcm");
        StringBuilder query4Task = new StringBuilder();
        query4Task.append("select distinct freporttaskid from t_bcm_taskstatus where fentityId in  (").append(MyTaskStatusHelper.genUniqueLongKey(orgIds)).append(')');
        HashSet<Long> taskids = new HashSet<Long>();
        try (DataSet result = DB.queryDataSet((String)"MyTaskStatusHelper", (DBRoute)dbRoute, (String)query4Task.toString(), null);){
            for (Row memberRow : result) {
                Long id = memberRow.getLong("freporttaskid");
                taskids.add(id);
            }
        }
        MyTaskStatusHelper.refreshTaskStatusRecord4TaskId(taskids, false);
    }

    public static void refreshTaskStatusRecord(DynamicObject[] tasks) {
        HashSet<Long> taskids = new HashSet<Long>(tasks.length);
        for (DynamicObject task : tasks) {
            Long id = task.getLong("id");
            taskids.add(id);
        }
        MyTaskStatusHelper.refreshTaskStatusRecord4TaskId(taskids, false);
    }

    public static void refreshTaskStatusRecord(DynamicObjectCollection tasks) {
        HashSet<Long> taskids = new HashSet<Long>();
        for (DynamicObject task : tasks) {
            Long id = task.getLong("id");
            taskids.add(id);
        }
        MyTaskStatusHelper.refreshTaskStatusRecord4TaskId(taskids, false);
    }

    /*
     * WARNING - void declaration
     */
    private static void refreshTaskStatusRecord4TaskId(Set<Long> taskids, boolean isHold) {
        String org;
        final ArrayList deleteStatus = new ArrayList();
        ArrayList<String> addTempleStatus = new ArrayList<String>();
        ArrayList<String> sourceKey4Temple = new ArrayList<String>();
        QFilter filter = new QFilter("id", "in", taskids);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject[] taskColl = BusinessDataServiceHelper.load((String)"bcm_taskconfig", (String)"id,model,tasktype,taskcatalog,templates.template", (QFilter[])filters);
        HashMap<Long, Set> tempId2Tasks = new HashMap<Long, Set>();
        HashMap<String, Set> model2TempIdMap = new HashMap<String, Set>();
        HashMap<Long, DynamicObject> taskcataParams = new HashMap<Long, DynamicObject>();
        HashMap<Object, Long> taskCatalogMap = new HashMap<Object, Long>();
        for (DynamicObject task : taskColl) {
            Long taskId = task.getLong("id");
            String taskType = task.getString("tasktype");
            if (!taskType.equals(String.valueOf(TaskTypeEnum.REPORT.getValue())) && !taskType.equals(String.valueOf(TaskTypeEnum.UNFITASK.getValue()))) continue;
            long taskCatalogId = task.getDynamicObject("taskcatalog").getLong("id");
            taskCatalogMap.put(taskId, taskCatalogId);
            DynamicObjectCollection templates = task.getDynamicObjectCollection("templates");
            String string = task.getString("model.id");
            Iterator iterator = templates.iterator();
            while (iterator.hasNext()) {
                DynamicObject template = (DynamicObject)iterator.next();
                Set tempIdSet = model2TempIdMap.computeIfAbsent(string, key -> new HashSet());
                Long tmpId = template.getLong("template.id");
                tempIdSet.add(tmpId);
                Set set = tempId2Tasks.computeIfAbsent(tmpId, key -> new HashSet());
                set.add(taskId);
            }
        }
        String paramFields = MyTaskServiceHelper.getTaskParamMemAndDimSelector();
        QFilter rootfilter = new QFilter("taskcatalog", "in", taskCatalogMap.values());
        QFilter[] paramsFilter = new QFilter[]{rootfilter};
        DynamicObjectCollection params = QueryServiceHelper.query((String)"bcm_taskparam", (String)paramFields, (QFilter[])paramsFilter);
        for (DynamicObject param : params) {
            taskcataParams.put(param.getLong("taskcatalog"), param);
        }
        QFilter rootNumberfilter = new QFilter("number", "=", (Object)"root");
        QFilter[] rootfilters = new QFilter[]{rootfilter, rootNumberfilter};
        DynamicObjectCollection rootTasks = QueryServiceHelper.query((String)"bcm_taskconfig", (String)"id,taskcatalog", (QFilter[])rootfilters);
        HashMap<Long, Long> taskCatalogRootMap = new HashMap<Long, Long>();
        for (DynamicObject dynamicObject : rootTasks) {
            taskCatalogRootMap.put(dynamicObject.getLong("taskcatalog"), dynamicObject.getLong("id"));
        }
        for (Map.Entry entry : model2TempIdMap.entrySet()) {
            Long modelId = Long.valueOf((String)entry.getKey());
            Map<Long, Set<Long>> tempId2Orgs = TemplateDistributionOrgUtil.getTemplate2OrgMapOfDispense(modelId, (Set)entry.getValue());
            Iterator orgSet = new HashSet();
            for (Set set : tempId2Orgs.values()) {
                orgSet.addAll(set);
            }
            DynamicObjectCollection orgCyColl = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,currencychangerds.currencyexpdate,currencychangerds.currencyrds.number", (QFilter[])new QFilter[]{new QFilter("id", "in", orgSet)});
            HashSet<String> hashSet = new HashSet<String>();
            HashMap<Long, HashMap<Long, String>> oCyOuterMap = new HashMap<Long, HashMap<Long, String>>();
            HashMap<Long, String> oCyMap = new HashMap<Long, String>();
            for (DynamicObject orgCy : orgCyColl) {
                long orgId = orgCy.getLong("id");
                String currencyNum = orgCy.getString("currencychangerds.currencyrds.number");
                hashSet.add(currencyNum);
                Timestamp expdate = (Timestamp)orgCy.get("currencychangerds.currencyexpdate");
                if (expdate != null) {
                    HashMap<Long, String> oCyInnerMap = (HashMap<Long, String>)oCyOuterMap.get(orgId);
                    if (oCyInnerMap == null) {
                        oCyInnerMap = new HashMap<Long, String>();
                        oCyOuterMap.put(orgId, oCyInnerMap);
                    }
                    oCyInnerMap.put(expdate.getTime(), currencyNum);
                    continue;
                }
                oCyMap.put(orgId, currencyNum);
            }
            DynamicObjectCollection currencyDyColl = QueryServiceHelper.query((String)"bcm_currencymembertree", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", hashSet), new QFilter("model", "=", (Object)modelId)});
            HashMap<String, Long> orgCyMap = new HashMap<String, Long>();
            for (DynamicObject cy : currencyDyColl) {
                orgCyMap.put(cy.getString("number"), cy.getLong("id"));
            }
            for (Map.Entry<Long, Set<Long>> id2Org : tempId2Orgs.entrySet()) {
                Set taskIds = (Set)tempId2Tasks.get(id2Org.getKey());
                for (Long taskId : taskIds) {
                    String rootId = String.valueOf(taskCatalogRootMap.get(taskCatalogMap.get(taskId)));
                    for (Long orgId : id2Org.getValue()) {
                        DynamicObject param = (DynamicObject)taskcataParams.get(taskCatalogMap.get(taskId));
                        if (param == null) continue;
                        Long yearL = param.getLong("year");
                        Long periodL = param.getLong("period");
                        String period = String.valueOf(periodL);
                        String scenario = String.valueOf(param.getLong("scenario"));
                        String fy = String.valueOf(yearL);
                        Long currencyid = param.getLong("currency");
                        if ("EC".equals(param.getString("currency.number"))) {
                            String currencyNum;
                            Long curId;
                            boolean idSeted = false;
                            Long periodTime = PeriodUtils.getPeriodLastDate((Long)yearL, (Long)periodL).getTime();
                            Map oCyInnerMap = (Map)oCyOuterMap.get(orgId);
                            if (oCyInnerMap != null && (curId = (Long)orgCyMap.get(currencyNum = (String)oCyInnerMap.get(periodTime))) != null) {
                                currencyid = curId;
                                idSeted = true;
                            }
                            if (!idSeted && (curId = (Long)orgCyMap.get(currencyNum = (String)oCyMap.get(orgId))) != null) {
                                currencyid = curId;
                            }
                        }
                        sourceKey4Temple.add(MyTaskStatusHelper.genUniqueKey(taskId.toString(), id2Org.getKey().toString(), orgId.toString(), rootId, fy, period, currencyid.toString(), scenario, modelId.toString()));
                    }
                }
            }
        }
        QFilter statusfilter = new QFilter("reporttask", "in", taskids);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        QFilter[] statusfilters = new QFilter[]{statusfilter};
        DynamicObjectCollection statusColl = QueryServiceHelper.query((String)"bcm_taskstatus", (String)"id, entity,reporttask,template,root,fy,period,currency,scenario,model,reportstatus", (QFilter[])statusfilters);
        for (DynamicObject status : statusColl) {
            String string = status.getString("id");
            String rootId = status.getString("root");
            String taskId = status.getString("reporttask");
            String fy = status.getString("fy");
            String period = status.getString("period");
            String modelId = status.getString("model");
            String currencyId = status.getString("currency");
            org = status.getString("entity");
            String templeId = status.getString("template");
            String scenario = status.getString("scenario");
            String reportStatus = status.getString("reportstatus");
            if (isHold && !ReportStatusEnum.UNWEAVE.status().equals(reportStatus)) {
                hashMap.put(MyTaskStatusHelper.genUniqueKey(taskId, templeId, org, rootId, fy, period, currencyId, scenario, modelId), "1");
                continue;
            }
            hashMap.put(MyTaskStatusHelper.genUniqueKey(taskId, templeId, org, rootId, fy, period, currencyId, scenario, modelId), string);
        }
        for (String source : sourceKey4Temple) {
            if (hashMap.containsKey(source)) {
                hashMap.put(source, "1");
                continue;
            }
            addTempleStatus.add(source);
        }
        hashMap.forEach(new BiConsumer<String, String>(){

            @Override
            public void accept(String t, String u) {
                if (!"1".equals(u)) {
                    deleteStatus.add(u);
                }
            }
        });
        HashMap<String, String> filterToStatuss = new HashMap<String, String>();
        if (addTempleStatus.size() > 0) {
            String[] insertValues = ((String)addTempleStatus.get(0)).split(",");
            QFilter qFilter = new QFilter("fyear", "=", (Object)Long.valueOf(insertValues[4]));
            QFilter periodFilter = new QFilter("period", "=", (Object)Long.valueOf(insertValues[5]));
            QFilter scenarioFilter = new QFilter("scene", "=", (Object)Long.valueOf(insertValues[7]));
            QFilter modelFilter = new QFilter("model", "=", (Object)Long.valueOf(insertValues[8]));
            QFilter[] reportfilters = new QFilter[]{modelFilter, scenarioFilter, qFilter, periodFilter};
            DynamicObjectCollection reports = QueryServiceHelper.query((String)"bcm_reportentity", (String)"template.id,entity.id,fyear.id,period.id,currency.id,scene.id,model.id,reportstatus", (QFilter[])reportfilters);
            for (DynamicObject report : reports) {
                StringBuilder sb = new StringBuilder();
                sb.append(report.getString("template.id")).append('|').append(report.getString("entity.id")).append('|').append(report.getString("fyear.id")).append('|').append(report.getString("period.id")).append('|').append(report.getString("currency.id")).append('|').append(report.getString("scene.id")).append('|').append(report.getString("model.id"));
                filterToStatuss.put(sb.toString(), report.getString("reportstatus"));
            }
        }
        Object[] taskStatusColl = new DynamicObject[addTempleStatus.size()];
        boolean bl = false;
        for (String key2 : addTempleStatus) {
            void var26_43;
            String[] insertValues = key2.split(",");
            DynamicObject taskStatus = BusinessDataServiceHelper.newDynamicObject((String)"bcm_taskstatus");
            DynamicObject task = BusinessDataServiceHelper.newDynamicObject((String)"bcm_taskconfig");
            task.set("id", (Object)insertValues[0]);
            DynamicObject temple = BusinessDataServiceHelper.newDynamicObject((String)"bcm_templateentity");
            temple.set("id", (Object)insertValues[1]);
            org = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymembertree");
            org.set("id", (Object)insertValues[2]);
            DynamicObject rootTask = BusinessDataServiceHelper.newDynamicObject((String)"bcm_taskconfig");
            rootTask.set("id", (Object)insertValues[3]);
            DynamicObject fy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_fymembertree");
            fy.set("id", (Object)insertValues[4]);
            DynamicObject period = BusinessDataServiceHelper.newDynamicObject((String)"bcm_periodmembertree");
            period.set("id", (Object)insertValues[5]);
            DynamicObject currency = BusinessDataServiceHelper.newDynamicObject((String)"bcm_currencymembertree");
            currency.set("id", (Object)insertValues[6]);
            DynamicObject scenario = BusinessDataServiceHelper.newDynamicObject((String)"bcm_scenemembertree");
            scenario.set("id", (Object)insertValues[7]);
            DynamicObject model = BusinessDataServiceHelper.newDynamicObject((String)"bcm_model");
            model.set("id", (Object)insertValues[8]);
            taskStatus.set("reporttask", (Object)task);
            taskStatus.set("template", (Object)temple);
            taskStatus.set("entity", (Object)org);
            taskStatus.set("tasktype", (Object)TaskTypeEnum.REPORT_UNIT.getValue());
            taskStatus.set("root", (Object)rootTask);
            taskStatus.set("fy", (Object)fy);
            taskStatus.set("period", (Object)period);
            taskStatus.set("scenario", (Object)scenario);
            taskStatus.set("currency", (Object)currency);
            taskStatus.set("model", (Object)model);
            String reportKey = insertValues[1] + "|" + insertValues[2] + "|" + insertValues[4] + "|" + insertValues[5] + "|" + insertValues[6] + "|" + insertValues[7] + "|" + insertValues[8];
            String reportStatus = ReportStatusEnum.UNWEAVE.status();
            if (filterToStatuss != null && filterToStatuss.get(reportKey) != null) {
                reportStatus = (String)filterToStatuss.get(reportKey);
            }
            taskStatus.set("reportstatus", (Object)reportStatus);
            String status = TaskStatusEnum.UNDO.index;
            taskStatus.set("taskstatus", (Object)status);
            taskStatusColl[var26_43] = taskStatus;
            ++var26_43;
        }
        if (taskStatusColl.length > 0) {
            BusinessDataWriter.save((IDataEntityType)taskStatusColl[0].getDynamicObjectType(), (Object[])taskStatusColl);
        }
        DynamicObject taskStatus = BusinessDataServiceHelper.newDynamicObject((String)"bcm_taskstatus");
        BusinessDataServiceHelper.delete((IDataEntityType)taskStatus.getDynamicObjectType(), (Object[])deleteStatus.toArray());
    }

    public static void synchronizeTaskStatus(DynamicObject[] reports, boolean isDelete) {
        Object[] ids = new Long[reports.length];
        for (int i = 0; i < reports.length; ++i) {
            ids[i] = reports[i].getLong("id");
        }
        MyTaskStatusHelper.synchronizeTaskStatusForPK(ids, isDelete);
    }

    public static void synchronizeTaskStatusForPK(Object[] ids, boolean isDelete) {
        DBRoute dbRoute = new DBRoute("bcm");
        StringBuilder sycSql = new StringBuilder();
        sycSql.append("update t_bcm_taskstatus set freportstatus=? where fentityid=? and ftemplateid=? and fmodelid=? and ffyid=? and fperiodid=? and fcurrencyid= ? and fscenarioid=?");
        String selectFields = "id,model,fyear,period,entity,template,reportstatus,currency,scene";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (Object id : ids) {
            QFilter idFilter = new QFilter("id", "=", id);
            QFilter[] filters = new QFilter[]{idFilter};
            DynamicObject report = QueryServiceHelper.queryOne((String)"bcm_reportentity", (String)selectFields, (QFilter[])filters);
            if (report == null) continue;
            Object[] params = new Object[8];
            Long modelid = report.getLong("model");
            Long fyearid = report.getLong("fyear");
            Long periodid = report.getLong("period");
            Long entityid = report.getLong("entity");
            Long templateid = report.getLong("template");
            Long currencyid = report.getLong("currency");
            Long sceneid = report.getLong("scene");
            if (isDelete) {
                params[0] = ReportStatusEnum.UNWEAVE.status();
            } else {
                String reportStatus = report.getString("reportstatus");
                params[0] = reportStatus;
            }
            params[1] = entityid;
            params[2] = templateid;
            params[3] = modelid;
            params[4] = fyearid;
            params[5] = periodid;
            params[6] = currencyid;
            params[7] = sceneid;
            paramsList.add(params);
        }
        if (paramsList.size() > 0) {
            DB.executeBatch((DBRoute)dbRoute, (String)sycSql.toString(), paramsList);
        }
    }

    public static void deleteTaskStatusRecord(QFilter[] filters) {
        DeleteServiceHelper.delete((String)"bcm_taskstatus", (QFilter[])filters);
    }

    public static java.util.Date completeOrUndo(String key, Long[] taskStatusIds) {
        DBRoute dbRoute = new DBRoute("bcm");
        RequestContext tx = RequestContext.get();
        Object[] taskParams = new Object[3];
        StringBuilder updateTaskSql = new StringBuilder();
        updateTaskSql.append("update t_bcm_taskstatus set ftaskstatus=?,fmodifytime=?,fmodifierid=? where fid in (").append(MyTaskStatusHelper.genUniqueLongKey(taskStatusIds)).append(')');
        taskParams[0] = key.equals(COMPLETE_KEY) ? TaskStatusEnum.COMPLETE.index : TaskStatusEnum.UNDO.index;
        taskParams[1] = new Date(TimeServiceHelper.now().getTime());
        taskParams[2] = Long.valueOf(tx.getUserId());
        DB.execute((DBRoute)dbRoute, (String)updateTaskSql.toString(), (Object[])taskParams);
        StringBuilder updateReportStatus = new StringBuilder();
        Object[] reportParams = new Object[1];
        if (key.equals(COMPLETE_KEY)) {
            updateReportStatus.append("update t_bcm_taskstatus set freportstatus=? where fid in (").append(MyTaskStatusHelper.genUniqueLongKey(taskStatusIds)).append(") and (freportstatus ='").append(ReportStatusEnum.UNWEAVE.status()).append("' or freportstatus ='").append(ReportStatusEnum.WEAVING.status()).append("' or freportstatus ='").append(ReportStatusEnum.BACK.status()).append("')");
            reportParams[0] = ReportStatusEnum.COMPLETE.status();
        } else {
            updateReportStatus.append("update t_bcm_taskstatus set freportstatus=? where fid in (").append(MyTaskStatusHelper.genUniqueLongKey(taskStatusIds)).append(") and freportstatus ='").append(ReportStatusEnum.COMPLETE.status()).append('\'');
            reportParams[0] = ReportStatusEnum.WEAVING.status();
        }
        DB.execute((DBRoute)dbRoute, (String)updateReportStatus.toString(), (Object[])reportParams);
        String reportStatus = ReportStatusEnum.COMPLETE.status();
        StringBuilder sycSql = new StringBuilder();
        if (key.equals(COMPLETE_KEY)) {
            sycSql.append("update t_bcm_report set freportstatus=?,fcompletetime=?,fcompleterid=? where fentityid=? and ftemplateid=? and fmodelid=? and ffyid=? and fperiodid=? and fcurrencyid = ? and fsceneid = ? and (freportstatus ='").append(ReportStatusEnum.UNWEAVE.status()).append('\'').append(" or freportstatus ='").append(ReportStatusEnum.WEAVING.status()).append('\'').append(" or freportstatus ='").append(ReportStatusEnum.BACK.status()).append("')");
        } else {
            sycSql.append("update t_bcm_report set freportstatus=?,fcompletetime=?,fcompleterid=? where fentityid=? and ftemplateid=? and fmodelid=? and ffyid=? and fperiodid=? and fcurrencyid = ? and fsceneid = ? and freportstatus ='").append(ReportStatusEnum.COMPLETE.status()).append('\'');
            reportStatus = ReportStatusEnum.WEAVING.status();
        }
        String selectFields = "id,model,fy,period,entity,template,currency,scenario,reportstatus,taskstatus";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        QFilter idsFilter = new QFilter("id", "in", (Object)taskStatusIds);
        QFilter[] filters = new QFilter[]{idsFilter};
        DynamicObjectCollection taskStatusList = QueryServiceHelper.query((String)"bcm_taskstatus", (String)selectFields, (QFilter[])filters, (String)"");
        for (DynamicObject taskStatus : taskStatusList) {
            Object[] paramsRp = new Object[10];
            Long modelid = taskStatus.getLong("model");
            Long fyearid = taskStatus.getLong("fy");
            Long periodid = taskStatus.getLong("period");
            Long entityid = taskStatus.getLong("entity");
            Long templateid = taskStatus.getLong("template");
            Long currencyid = taskStatus.getLong("currency");
            Long scenarioid = taskStatus.getLong("scenario");
            paramsRp[0] = reportStatus;
            if (key.equals(COMPLETE_KEY) || key.equals(UNCOMPLETE_KEY)) {
                taskParams[1] = new Date(TimeServiceHelper.now().getTime());
                paramsRp[2] = Long.valueOf(tx.getUserId());
            } else {
                paramsRp[1] = null;
                paramsRp[2] = 0L;
            }
            paramsRp[3] = entityid;
            paramsRp[4] = templateid;
            paramsRp[5] = modelid;
            paramsRp[6] = fyearid;
            paramsRp[7] = periodid;
            paramsRp[8] = currencyid;
            paramsRp[9] = scenarioid;
            paramsList.add(paramsRp);
        }
        if (paramsList.size() > 0) {
            DB.executeBatch((DBRoute)dbRoute, (String)sycSql.toString(), paramsList);
        }
        return TimeServiceHelper.now();
    }

    public static void completeOrUndo4Report(String key, Long[] reportIds, boolean changereportstatus) {
        DBRoute dbRoute = new DBRoute("bcm");
        RequestContext tx = RequestContext.get();
        Long userId = Long.valueOf(tx.getUserId());
        ArrayList<Object[]> paramsStatusList = new ArrayList<Object[]>();
        ArrayList<Object[]> reportStatusList = new ArrayList<Object[]>();
        StringBuilder updateTaskSql = new StringBuilder();
        updateTaskSql.append("update t_bcm_taskstatus set ftaskstatus=?,fmodifytime=?,fmodifierid=? where fid =?");
        StringBuilder updateReportStatus = new StringBuilder();
        String taskStatus = TaskStatusEnum.COMPLETE.index;
        String reportStatus = ReportStatusEnum.COMPLETE.status();
        if (key.equals(COMPLETE_KEY)) {
            updateReportStatus.append("update t_bcm_taskstatus set freportstatus=? where fid = ?").append(" and (freportstatus ='").append(ReportStatusEnum.UNWEAVE.status()).append("' or freportstatus ='").append(ReportStatusEnum.WEAVING.status()).append("' or freportstatus ='").append(ReportStatusEnum.BACK.status()).append("')");
        } else {
            updateReportStatus.append("update t_bcm_taskstatus set freportstatus=? where fid = ?").append(" and freportstatus ='").append(ReportStatusEnum.COMPLETE.status()).append('\'');
            taskStatus = TaskStatusEnum.UNDO.index;
            reportStatus = ReportStatusEnum.WEAVING.status();
        }
        for (Long reportId : reportIds) {
            DynamicObject dyreport = QueryServiceHelper.queryOne((String)"bcm_reportentity", (String)"model.id,fyear.id,period.id,entity.id,currency.id,scene.id,template.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reportId)});
            QFilter qf1 = new QFilter("model", "=", (Object)dyreport.getLong("model.id"));
            QFilter qf2 = new QFilter("fy", "=", (Object)dyreport.getLong("fyear.id"));
            QFilter qf3 = new QFilter("period", "=", (Object)dyreport.getLong("period.id"));
            QFilter qf4 = new QFilter("entity", "=", (Object)dyreport.getLong("entity.id"));
            QFilter qf5 = new QFilter("template", "=", (Object)dyreport.getLong("template.id"));
            QFilter qf7 = new QFilter("scenario", "=", (Object)dyreport.getLong("scene.id"));
            QFilter[] qfs = new QFilter[]{qf1, qf2, qf3, qf4, qf5, qf7};
            DynamicObject taskStatusDy = QueryServiceHelper.queryOne((String)"bcm_taskstatus", (String)"id", (QFilter[])qfs);
            Object[] taskParams = new Object[4];
            Object[] reportParams = new Object[2];
            if (taskStatusDy == null) continue;
            taskParams[0] = taskStatus;
            taskParams[1] = new Date(TimeServiceHelper.now().getTime());
            taskParams[2] = userId;
            taskParams[3] = taskStatusDy.getLong("id");
            reportParams[0] = reportStatus;
            reportParams[1] = taskStatusDy.getLong("id");
            paramsStatusList.add(taskParams);
            reportStatusList.add(reportParams);
        }
        if (paramsStatusList.size() > 0) {
            DB.executeBatch((DBRoute)dbRoute, (String)updateTaskSql.toString(), paramsStatusList);
        }
        if (reportStatusList.size() > 0) {
            DB.executeBatch((DBRoute)dbRoute, (String)updateReportStatus.toString(), reportStatusList);
        }
        if (changereportstatus) {
            StringBuffer sycSql = new StringBuffer();
            if (key.equals(COMPLETE_KEY)) {
                sycSql.append("update t_bcm_report set freportstatus=?,fcompletetime=?,fcompleterid=? where fid = ? and (freportstatus ='").append(ReportStatusEnum.UNWEAVE.status()).append('\'').append(" or freportstatus ='").append(ReportStatusEnum.WEAVING.status()).append("' or freportstatus ='").append(ReportStatusEnum.BACK.status()).append("')");
            } else {
                sycSql.append("update t_bcm_report set freportstatus=?,fcompletetime=?,fcompleterid=? where fid = ? and freportstatus ='").append(ReportStatusEnum.COMPLETE.status()).append('\'');
            }
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(reportIds.length);
            for (Long reportId : reportIds) {
                Object[] paramsRp = new Object[4];
                paramsRp[0] = reportStatus;
                if (key.equals(COMPLETE_KEY)) {
                    paramsRp[1] = new Date(TimeServiceHelper.now().getTime());
                    paramsRp[2] = Long.valueOf(tx.getUserId());
                } else {
                    paramsRp[1] = null;
                    paramsRp[2] = 0L;
                }
                paramsRp[3] = reportId;
                paramsList.add(paramsRp);
            }
            if (paramsList.size() > 0) {
                DB.executeBatch((DBRoute)dbRoute, (String)sycSql.toString(), paramsList);
            }
        }
    }

    private static String genUniqueKey(String ... strings) {
        StringBuilder key = new StringBuilder();
        key.append(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            key.append(',');
            key.append(strings[i]);
        }
        return key.toString();
    }

    public static String genUniqueLongKey(Long ... strings) {
        StringBuilder key = new StringBuilder();
        key.append(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            key.append(',');
            key.append(strings[i]);
        }
        return key.toString();
    }
}

