/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.olap.dataSources.OlapConnection;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import org.apache.commons.beanutils.MethodUtils;

class OlapSandBoxConnection
implements AutoCloseable {
    private static final WatchLogger logger = BcmLogFactory.getWatchLogInstance(OlapSandBoxConnection.class);
    private OlapConnection olapConnection;
    private AutoCloseable sandBoxConnection;

    OlapSandBoxConnection() {
    }

    public void initOlapConnection(OlapConnection conn) {
        if (this.olapConnection == null) {
            this.olapConnection = conn;
            this.olapConnection.Open();
            this.sandBoxConnection = this.createSandbox();
            this.checkSandboxEnv();
        }
    }

    public AutoCloseable createSandbox() {
        try {
            return (AutoCloseable)MethodUtils.invokeMethod((Object)this.olapConnection, (String)"createSandbox", null);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6c99\u7bb1\u73af\u5883\u672a\u5f00\u542f\uff0c\u8bf7\u68c0\u67e5\u591a\u7ef4\u5e93\u5ba2\u6237\u7aef\u7248\u672c\u3002", (String)"OlapSandBoxContext_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    public boolean isSandboxEnv() {
        try {
            return (Boolean)MethodUtils.invokeMethod((Object)this.olapConnection, (String)"isSandboxEnv", null);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6c99\u7bb1\u73af\u5883\u672a\u5f00\u542f\uff0c\u8bf7\u68c0\u67e5\u591a\u7ef4\u5e93\u5ba2\u6237\u7aef\u7248\u672c\u3002", (String)"OlapSandBoxContext_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    public OlapConnection getOlapConnection() {
        this.checkSandboxEnv();
        return this.olapConnection;
    }

    private void checkSandboxEnv() {
        if (!this.isSandboxEnv()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6c99\u7bb1\u73af\u5883\u88ab\u610f\u5916\u5173\u95ed\u6216\u8005\u5f00\u542f\u5931\u8d25\u3002", (String)"OlapSandBoxContext_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    @Override
    public void close() {
        try {
            this.sandBoxConnection.close();
            this.olapConnection.Close();
        }
        catch (Throwable t) {
            logger.error(ResManager.loadKDString((String)"\u6c99\u7bb1\u94fe\u63a5\u5173\u95ed\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff1a", (String)"OlapSandBoxContext_3", (String)"fi-bcm-business", (Object[])new Object[0]), t);
        }
    }
}

